/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editor.JournalHttpServletResponseWrapper;
import jp.ossc.nimbus.service.journal.editor.JournalServletResponseWrapper;
import jp.ossc.tstruts.common.InvocationContext;
import jp.ossc.tstruts.config.SystemConfig;
import jp.ossc.tstruts.util.MyServiceUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessJournalFilter
implements Filter {
    protected static final Log log = LogFactory.getLog((Class)(class$jp$ossc$tstruts$util$AccessJournalFilter == null ? (class$jp$ossc$tstruts$util$AccessJournalFilter = AccessJournalFilter.class$("jp.ossc.tstruts.util.AccessJournalFilter")) : class$jp$ossc$tstruts$util$AccessJournalFilter));
    protected static final String JOURNAL_NAME = "AccessJournal";
    protected static final String PARAM_NAME_WRAPPED_RESPONSE = "wrappedResponse";
    protected static final String PARAM_NAME_BUFFERED_OUTPUT = "bufferedOutput";
    protected static final String ACCESS_JOURNAL_KEY = "Access";
    protected static final String REQUEST_JOURNAL_KEY = "Request";
    protected static final String RESPONSE_JOURNAL_KEY = "Response";
    protected static final String SERVLET_REQUEST_JOURNAL_KEY = "ServletRequest";
    protected static final String SERVLET_RESPONSE_JOURNAL_KEY = "ServletResponse";
    protected ServletContext context;
    protected boolean isResponseWrapped;
    protected boolean isBufferedOutput;
    public static final String ACCESS_JOURNAL_RECORDED = "jp.ossc.tstruts.util.AccessJournal.Recorded";
    static /* synthetic */ Class class$jp$ossc$tstruts$util$AccessJournalFilter;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        String isResponseWrappedStr = filterConfig.getInitParameter(PARAM_NAME_WRAPPED_RESPONSE);
        this.isResponseWrapped = Boolean.valueOf(isResponseWrappedStr);
        String isBufferedOutputStr = filterConfig.getInitParameter(PARAM_NAME_BUFFERED_OUTPUT);
        this.isBufferedOutput = Boolean.valueOf(isBufferedOutputStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        JournalServletResponseWrapper responsew;
        String recorded;
        SystemConfig config = (SystemConfig)this.context.getAttribute("jp.ossc.tstruts.config.SystemConfig");
        config.setLocal();
        InvocationContext invokeContext = (InvocationContext)request.getAttribute("InvocationContext");
        if (invokeContext == null) {
            try {
                invokeContext = config.createInvocationContext();
                request.setAttribute("InvocationContext", (Object)invokeContext);
            }
            catch (Exception e) {
                log.fatal((Object)"Failed to create InvocationContext", (Throwable)e);
            }
        }
        if ((recorded = (String)request.getAttribute(ACCESS_JOURNAL_RECORDED)) != null) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(ACCESS_JOURNAL_RECORDED, (Object)"recorded");
        Journal journal = (Journal)MyServiceUtil.getServiceObjectBySystemConfigProperty(JOURNAL_NAME);
        String requestId = "none";
        if (journal != null) {
            journal.startJournal(ACCESS_JOURNAL_KEY);
            if (invokeContext != null) {
                requestId = invokeContext.getRequestID();
                journal.setRequestId(requestId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("StartJournal. RequestId:" + requestId));
            }
            journal.addStartStep(REQUEST_JOURNAL_KEY);
            journal.addInfo(SERVLET_REQUEST_JOURNAL_KEY, (Object)request);
        }
        ServletResponse res = null;
        if (this.isResponseWrapped) {
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                JournalHttpServletResponseWrapper responsew2 = new JournalHttpServletResponseWrapper(httpResponse);
                responsew2.setBufferedOutput(this.isBufferedOutput);
                res = responsew2;
            } else {
                responsew = new JournalServletResponseWrapper(response);
                responsew.setBufferedOutput(this.isBufferedOutput);
                res = responsew;
            }
        } else {
            res = response;
        }
        try {
            chain.doFilter(request, res);
        }
        finally {
            if (journal != null) {
                journal.addEndStep();
                journal.addStartStep(RESPONSE_JOURNAL_KEY);
                journal.addInfo(SERVLET_RESPONSE_JOURNAL_KEY, (Object)res);
            }
            try {
                if (this.isResponseWrapped && this.isBufferedOutput) {
                    if (res instanceof JournalHttpServletResponseWrapper) {
                        responsew = (JournalHttpServletResponseWrapper)res;
                        responsew.flush();
                    } else {
                        responsew = (JournalServletResponseWrapper)res;
                        responsew.flush();
                    }
                }
            }
            finally {
                if (journal != null) {
                    journal.addEndStep();
                    journal.endJournal();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("EndJournal RequestId:" + requestId));
                    }
                }
            }
        }
    }

    public void destroy() {
        this.context = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

