/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.config;

import java.lang.reflect.Array;
import org.apache.commons.beanutils.ConvertUtils;

public class UserProfilePropertyConfig {
    private String name = null;
    private String type = null;
    private boolean indexed = false;
    private int size = 0;
    private Class typeClass = null;
    private Class indexedComponentClass = null;
    private String defaultValueString = null;
    private String defaultValueKey = null;
    private boolean configured = false;
    static /* synthetic */ Class class$java$lang$String;

    public UserProfilePropertyConfig() {
    }

    public UserProfilePropertyConfig(String name, String type, int size) throws ClassNotFoundException {
        this.setName(name);
        this.setType(type);
        this.setSize(size);
    }

    public UserProfilePropertyConfig(String name, String type, int size, String defaultString) throws ClassNotFoundException {
        this(name, type, size);
        this.setDefault(defaultString);
    }

    public UserProfilePropertyConfig(String name, String type, int size, String defaultString, String defaultKey) throws ClassNotFoundException {
        this(name, type, size, defaultString);
        this.setDefaultFromResource(defaultKey);
    }

    public void setName(String name) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) throws ClassNotFoundException {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Class getTypeClass() throws ClassNotFoundException {
        if (this.typeClass != null) {
            return this.typeClass;
        }
        String baseType = this.getType();
        if (baseType.endsWith("[]")) {
            baseType = baseType.substring(0, baseType.length() - 2);
            this.indexed = true;
        }
        Class baseClass = null;
        if (baseType.equals("boolean")) {
            baseClass = Boolean.TYPE;
        } else if (baseType.equals("byte")) {
            baseClass = Byte.TYPE;
        } else if (baseType.equals("char")) {
            baseClass = Character.TYPE;
        } else if (baseType.equals("double")) {
            baseClass = Double.TYPE;
        } else if (baseType.equals("float")) {
            baseClass = Float.TYPE;
        } else if (baseType.equals("int")) {
            baseClass = Integer.TYPE;
        } else if (baseType.equals("long")) {
            baseClass = Long.TYPE;
        } else if (baseType.equals("short")) {
            baseClass = Short.TYPE;
        } else if (baseType.equals("String")) {
            baseClass = class$java$lang$String == null ? (class$java$lang$String = UserProfilePropertyConfig.class$("java.lang.String")) : class$java$lang$String;
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            baseClass = classLoader.loadClass(baseType);
        }
        if (this.indexed) {
            this.indexedComponentClass = baseClass;
            this.typeClass = Array.newInstance(this.indexedComponentClass, 0).getClass();
        } else {
            this.indexedComponentClass = null;
            this.typeClass = baseClass;
        }
        return this.typeClass;
    }

    public Class getIndexedComponentTypeClass() throws ClassNotFoundException {
        this.getTypeClass();
        return this.indexedComponentClass;
    }

    public void setDefault(String value) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.defaultValueString = value;
    }

    public String getDefault() {
        return this.defaultValueString;
    }

    public void setDefaultFromResource(String key) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.defaultValueKey = key;
    }

    public String getDefaultFromResource() {
        return this.defaultValueKey;
    }

    public Object convertInitialValue(String stringValue) throws ClassNotFoundException {
        if (this.isIndexed()) {
            Object array = Array.newInstance(this.indexedComponentClass, this.size);
            if (stringValue != null) {
                Object values = ConvertUtils.convert((String)stringValue, (Class)this.getTypeClass());
                System.arraycopy(values, 0, array, 0, Math.min(Array.getLength(values), Array.getLength(array)));
            }
            return array;
        }
        if (stringValue != null) {
            return ConvertUtils.convert((String)stringValue, (Class)this.getTypeClass());
        }
        Class type = this.getTypeClass();
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return new Boolean(false);
        }
        if (type == Byte.TYPE) {
            return new Byte(0);
        }
        if (type == Character.TYPE) {
            return new Character('\u0000');
        }
        if (type == Double.TYPE) {
            return new Double(0.0);
        }
        if (type == Float.TYPE) {
            return new Float(0.0f);
        }
        if (type == Integer.TYPE) {
            return new Integer(0);
        }
        if (type == Long.TYPE) {
            return new Long(0L);
        }
        if (type == Short.TYPE) {
            return new Short(0);
        }
        return null;
    }

    public Object convert(String value) throws ClassNotFoundException {
        if (this.isIndexed()) {
            this.getTypeClass();
            return ConvertUtils.convert((String)value, (Class)this.indexedComponentClass);
        }
        return ConvertUtils.convert((String)value, (Class)this.getTypeClass());
    }

    public int getSize() {
        if (!this.indexed) {
            return 0;
        }
        return this.size;
    }

    public void setSize(int size) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.size = size;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void freeze() {
        this.configured = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

