/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.config;

import java.lang.reflect.Array;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.tstruts.auth.UserProfileInitializer;
import jp.ossc.tstruts.common.DynaUserProfile;
import jp.ossc.tstruts.common.DynaUserProfileClass;
import jp.ossc.tstruts.config.JDBCInitializerConfig;
import jp.ossc.tstruts.config.UserProfileFactory;
import jp.ossc.tstruts.config.UserProfilePropertyConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.RequestUtils;

public class UserProfileConfig {
    private static final Log log = LogFactory.getLog((Class)(class$jp$ossc$tstruts$config$UserProfileConfig == null ? (class$jp$ossc$tstruts$config$UserProfileConfig = UserProfileConfig.class$("jp.ossc.tstruts.config.UserProfileConfig")) : class$jp$ossc$tstruts$config$UserProfileConfig));
    private UserProfilePropertyConfig[] properties = new UserProfilePropertyConfig[0];
    private String className = "jp.ossc.tstruts.common.DynaUserProfile";
    private String factoryClassName = "jp.ossc.tstruts.config.UserProfileFactoryImpl";
    private Class userProfileClass = null;
    private DynaUserProfileClass dynaClass = null;
    private boolean dynamic = true;
    private String initializerClassName = "jp.ossc.tstruts.auth.DefaultJDBCInitializer";
    private JDBCInitializerConfig jdbcInitializerConfig = null;
    private UserProfileInitializer initializer = null;
    private boolean initializerInitialized = false;
    private boolean configured = false;
    static /* synthetic */ Class class$jp$ossc$tstruts$config$UserProfileConfig;
    static /* synthetic */ Class class$jp$ossc$tstruts$common$DynaUserProfile;

    public UserProfileConfig() {
    }

    public UserProfileConfig(String className, String initializerClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.setClassName(className);
        this.setInitializerClassName(initializerClassName);
    }

    public void addProperty(UserProfilePropertyConfig property) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        int i = 0;
        while (i < this.properties.length) {
            if (this.properties[i].getName().equals(property.getName())) {
                throw new IllegalArgumentException("Property " + property.getName() + "already defined");
            }
            ++i;
        }
        UserProfilePropertyConfig[] newProperties = new UserProfilePropertyConfig[this.properties.length + 1];
        System.arraycopy(this.properties, 0, newProperties, 0, this.properties.length);
        newProperties[this.properties.length] = property;
        this.properties = newProperties;
    }

    public UserProfilePropertyConfig[] getProperties() {
        return this.properties;
    }

    public UserProfilePropertyConfig findProperty(String name) {
        int i = 0;
        while (i < this.properties.length) {
            if (this.properties[i].getName().equals(name)) {
                return this.properties[i];
            }
            ++i;
        }
        return null;
    }

    public void setClassName(String className) throws ClassNotFoundException {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.className = className;
        this.userProfileClass = Class.forName(className);
        this.dynamic = (class$jp$ossc$tstruts$common$DynaUserProfile == null ? (class$jp$ossc$tstruts$common$DynaUserProfile = UserProfileConfig.class$("jp.ossc.tstruts.common.DynaUserProfile")) : class$jp$ossc$tstruts$common$DynaUserProfile).isAssignableFrom(this.userProfileClass);
    }

    public String getClassName() {
        return this.className;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public void setFactoryClassName(String string) {
        this.factoryClassName = string;
    }

    public void setInitializerClassName(String initializerClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.initializerClassName = initializerClassName;
        UserProfileInitializer userProfileInitializer = (UserProfileInitializer)RequestUtils.applicationInstance((String)this.getInitializerClassName());
    }

    public String getInitializerClassName() {
        return this.initializerClassName;
    }

    public void setJDBCInitializerConfig(JDBCInitializerConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.jdbcInitializerConfig = config;
    }

    public JDBCInitializerConfig getJDBCInitializerConfig() {
        return this.jdbcInitializerConfig;
    }

    public boolean isDynamic() throws ClassNotFoundException {
        if (this.userProfileClass == null) {
            this.setClassName(this.className);
        }
        return this.dynamic;
    }

    public Object createDefaultUserProfile(HttpServletRequest request) {
        Object profile = this.createUserProfile();
        if (profile == null) {
            return null;
        }
        UserProfileInitializer initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        initializer.initializeDefault(profile, request);
        return profile;
    }

    public Object createAuthenticatedUserProfile(Principal principal, HttpServletRequest request) {
        Object profile = this.createUserProfile();
        if (profile == null) {
            return null;
        }
        UserProfileInitializer initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        initializer.initializeAuthorized(profile, principal, request);
        return profile;
    }

    public UserProfileInitializer getInitializer() {
        try {
            if (this.initializer == null) {
                this.initializer = (UserProfileInitializer)RequestUtils.applicationInstance((String)this.getInitializerClassName());
                this.initializer.initialize(this);
            }
        }
        catch (Exception e) {
            String msg = "Failed to initialize UserProfile initializer[" + this.getInitializerClassName() + "].";
            log.fatal((Object)msg, (Throwable)e);
            return null;
        }
        return this.initializer;
    }

    public void initialize() {
        if (this.jdbcInitializerConfig != null) {
            this.jdbcInitializerConfig.initialize(this);
        }
    }

    protected Object createUserProfile() {
        try {
            if (this.isDynamic()) {
                DynaUserProfileClass dynaClass = this.getDynaClass();
                if (dynaClass == null) {
                    return null;
                }
                DynaUserProfile instance = (DynaUserProfile)dynaClass.newInstance();
                UserProfilePropertyConfig[] properties = this.getProperties();
                int i = 0;
                while (i < properties.length) {
                    if (properties[i].isIndexed()) {
                        Object array = Array.newInstance(properties[i].getIndexedComponentTypeClass(), properties[i].getSize());
                        instance.set(properties[i].getName(), array);
                    }
                    ++i;
                }
                return instance;
            }
            UserProfileFactory factory = (UserProfileFactory)Class.forName(this.getFactoryClassName()).newInstance();
            return factory.createUserProfile(this.getClassName());
        }
        catch (Exception e) {
            String msg = "Specified UserProfile class is not instantiated.";
            log.fatal((Object)msg, (Throwable)e);
            return null;
        }
    }

    protected DynaUserProfileClass getDynaClass() {
        if (this.dynaClass != null) {
            return this.dynaClass;
        }
        try {
            this.dynaClass = new DynaUserProfileClass(this);
        }
        catch (ClassNotFoundException e) {
            String msg = "Failed to load UserProfile's property class.";
            log.fatal((Object)msg, (Throwable)e);
            return null;
        }
        return this.dynaClass;
    }

    public void freeze() {
        this.configured = true;
        if (this.jdbcInitializerConfig != null) {
            this.jdbcInitializerConfig.freeze();
        }
        int i = 0;
        while (i < this.properties.length) {
            this.properties[i].freeze();
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

