/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.UnavailableException;
import jp.ossc.tstruts.config.TileDefinitionConfig;

public class TilesDefinitionsConfig
implements Serializable {
    private TileDefinitionConfig[] definitions = new TileDefinitionConfig[0];
    private Map defMap = new HashMap();
    private boolean configured = false;

    public void addDefinition(TileDefinitionConfig def) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        TileDefinitionConfig[] newArray = new TileDefinitionConfig[this.definitions.length + 1];
        System.arraycopy(this.definitions, 0, newArray, 0, this.definitions.length);
        newArray[this.definitions.length] = def;
        this.definitions = newArray;
        this.defMap.put(def.getName(), def);
    }

    public void addAll(TilesDefinitionsConfig another) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        TileDefinitionConfig[] newArray = new TileDefinitionConfig[this.definitions.length + another.definitions.length];
        System.arraycopy(this.definitions, 0, newArray, 0, this.definitions.length);
        System.arraycopy(another.definitions, 0, newArray, this.definitions.length, another.definitions.length);
        this.definitions = newArray;
        this.defMap.putAll(another.defMap);
    }

    public TileDefinitionConfig[] getDefinitions() {
        return this.definitions;
    }

    public void freeze() {
        this.configured = true;
    }

    public void processTilesExtentions() throws UnavailableException {
        int i = 0;
        while (i < this.definitions.length) {
            this.definitions[i].processTileExtention(this, new LinkedList());
            ++i;
        }
    }

    public TileDefinitionConfig findTileConfig(String name) {
        return (TileDefinitionConfig)this.defMap.get(name);
    }
}

