/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.config;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import jp.ossc.nimbus.util.CsvArrayList;
import jp.ossc.tstruts.config.TilePropertyConfig;

public abstract class TilePutConfigBase {
    private static final String C_SEPT_DEPENDS = ",";
    protected String value;
    protected String name;
    protected TilePropertyConfig[] properties = new TilePropertyConfig[0];
    protected TilePutConfigBase parent = null;
    protected boolean configured = false;
    protected List depends;
    protected ThreadLocal _prefetchResponse = new ThreadLocal();

    public void addPropertyConfig(TilePropertyConfig param) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        TilePropertyConfig[] newParams = new TilePropertyConfig[this.properties.length + 1];
        System.arraycopy(this.properties, 0, newParams, 0, this.properties.length);
        newParams[this.properties.length] = param;
        this.properties = newParams;
    }

    public TilePropertyConfig[] getPropertyConfigs() {
        return this.properties;
    }

    public TilePropertyConfig findPropertyConfig(String name) {
        int i = 0;
        while (i < this.properties.length) {
            if (this.properties[i].getName().equals(name)) {
                return this.properties[i];
            }
            ++i;
        }
        return null;
    }

    public TilePutConfigBase getParent() {
        return this.parent;
    }

    public void setParent(TilePutConfigBase parent) {
        this.parent = parent;
    }

    public void freeze() {
        this.configured = true;
        int i = 0;
        while (i < this.properties.length) {
            this.properties[i].freeze();
            ++i;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.value = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = string;
    }

    public void init() {
        this._prefetchResponse.set(null);
    }

    public void makeResponse(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException, IOException {
        String ret = this.doRequest(request, response, servletContext);
        this._prefetchResponse.set(ret);
    }

    protected abstract String doRequest(HttpServletRequest var1, HttpServletResponse var2, ServletContext var3) throws ServletException, IOException;

    public String getResponseString() {
        return (String)this._prefetchResponse.get();
    }

    public String createContent(PageContext pageContext) throws JspException, ServletException, IOException {
        return this.getResponseString();
    }

    public void setDepends(String argDepends) {
        CsvArrayList tmpList = new CsvArrayList();
        if (argDepends == null || argDepends.length() == 0) {
            return;
        }
        tmpList.split(argDepends, C_SEPT_DEPENDS);
        this.depends = tmpList;
    }

    public List getDependsList() {
        return this.depends;
    }

    public String toString() {
        return this.getName();
    }

    public void setDependsList(List argDependsList) {
        this.depends = argDependsList;
    }
}

