/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.config;

import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.BeanUtils;

public class TilePropertyConfig
implements Serializable {
    private String name;
    private String value;
    private String parameter;
    private String beanName;
    private String property;
    private String scope;
    private boolean configured = false;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.value = string;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.beanName = string;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.parameter = string;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.property = string;
    }

    public void freeze() {
        this.configured = true;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.scope = string;
    }

    public Object eval(PageContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        if (this.parameter != null) {
            return request.getParameter(this.parameter);
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.beanName != null) {
            Object bean = context.findAttribute(this.beanName);
            if (this.property == null) {
                return bean;
            }
            try {
                return BeanUtils.getProperty((Object)bean, (String)this.property);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object eval(ServletContext servletContext, HttpServletRequest request) {
        if (this.parameter != null) {
            return request.getParameter(this.parameter);
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.beanName != null) {
            Object bean = null;
            bean = request.getAttribute(this.beanName);
            if (bean == null) {
                HttpSession session = request.getSession(false);
                bean = session.getAttribute(this.beanName);
            }
            if (bean == null) {
                bean = servletContext.getAttribute(this.beanName);
            }
            if (this.property == null) {
                return bean;
            }
            try {
                return BeanUtils.getProperty((Object)bean, (String)this.property);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

