/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.tstruts.common.InvocationContext;
import jp.ossc.tstruts.util.MyServiceUtil;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionForm;

public class InvocationContextImpl
implements InvocationContext,
Serializable,
Cloneable {
    protected static final String SEQUENCE_NAME = "RequestIDSequence";
    private final Map map = new HashMap();
    private final Map requestAttributes = new HashMap();
    private final Map requestParams = new HashMap();
    private final Map httpHeaders = new HashMap();
    private final Map errors = new HashMap();
    private transient boolean isLocal;
    private String requestID;
    private Object userProfile;
    private ActionForm actionForm;
    private String forwardName;

    public InvocationContextImpl() {
        this(true);
    }

    private InvocationContextImpl(boolean isNew) {
        if (isNew) {
            Sequence sequence = (Sequence)MyServiceUtil.getServiceObjectBySystemConfigProperty(SEQUENCE_NAME);
            this.setRequestID(sequence.increment());
        }
        this.isLocal = true;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public void setRequestID(String requestID) {
        this.requestID = requestID;
    }

    public Object getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(Object profile) {
        this.userProfile = profile;
    }

    public ActionForm getActionForm() {
        return this.actionForm;
    }

    public void setActionForm(ActionForm form) {
        this.actionForm = form;
    }

    public void setAttribute(String name, Object value) {
        if (value instanceof Serializable) {
            this.map.put(name, value);
        }
    }

    public Object getAttribute(String name) {
        return this.map.get(name);
    }

    public Iterator getAttributeNames() {
        return new HashSet(this.map.keySet()).iterator();
    }

    public void removeAttribute(String name) {
        this.map.remove(name);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public void addError(String key, ActionError error) {
        this.errors.put(key, error);
    }

    public ActionError getError(String key) {
        return (ActionError)this.errors.get(key);
    }

    public String[] getErrorKeys() {
        return this.errors.keySet().toArray(new String[this.errors.size()]);
    }

    public ActionError[] getErrors() {
        return this.errors.values().toArray(new ActionError[this.errors.size()]);
    }

    public void setForwardName(String forward) {
        this.forwardName = forward;
    }

    public String getForwardName() {
        return this.forwardName;
    }

    public String getServletRequestParameter(String name) {
        String[] values = this.getServletRequestParameterValues(name);
        return values != null && values.length != 0 ? values[0] : null;
    }

    public String[] getServletRequestParameterValues(String name) {
        return (String[])this.requestParams.get(name);
    }

    public Object getServletRequestAttribute(String name) {
        return this.requestAttributes.get(name);
    }

    public void setServletRequestAttribute(String name, Object value) {
        if (value instanceof Serializable) {
            this.requestAttributes.put(name, value);
        }
    }

    public String getServletRequestHeader(String name) {
        Enumeration enumeration = this.getServletRequestHeaders(name);
        return enumeration.hasMoreElements() ? (String)enumeration.nextElement() : null;
    }

    public Enumeration getServletRequestHeaders(String name) {
        return (Enumeration)this.httpHeaders.get(name);
    }

    public void bridgeFromServletRequest(HttpServletRequest request) {
    }

    public void bridgeToServletRequest(HttpServletRequest request) {
        Iterator keys = this.requestAttributes.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            request.setAttribute(key, this.requestAttributes.get(key));
        }
    }

    public Object clone() {
        InvocationContextImpl ctx = new InvocationContextImpl(false);
        ctx.setRequestID(this.requestID);
        ctx.setActionForm(this.actionForm);
        ctx.setUserProfile(this.userProfile);
        ctx.map.putAll(this.map);
        ctx.requestAttributes.putAll(this.requestAttributes);
        ctx.requestParams.putAll(this.requestParams);
        ctx.httpHeaders.putAll(this.httpHeaders);
        ctx.isLocal = this.isLocal;
        ctx.setForwardName(this.forwardName);
        ctx.errors.putAll(this.errors);
        return ctx;
    }

    public void reset() {
        this.actionForm = null;
        this.errors.clear();
        this.forwardName = null;
        this.httpHeaders.clear();
        this.requestAttributes.clear();
        this.requestParams.clear();
        this.userProfile = null;
    }
}

