/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.FactoryService;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameRef;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.tstruts.cache.ActionCache;
import jp.ossc.tstruts.cache.CacheEntry;
import jp.ossc.tstruts.cache.CacheEntryImpl;
import jp.ossc.tstruts.cache.CacheKey;
import jp.ossc.tstruts.cache.CacheKeyImpl;

public class DefaultActionCacheService
extends ServiceBase
implements ActionCache {
    protected ServiceName defaultCacheServiceName = null;
    protected Cache defaultCacheService = null;
    protected ServiceName cacheFactoryServiceName = null;
    protected ServiceNameRef[] predefinedCacheNames = null;
    protected List generatedCaches = new ArrayList();
    protected Map caches = new HashMap();

    public void setDefaultCacheServiceName(ServiceName name) {
        this.defaultCacheServiceName = name;
    }

    public ServiceName getDefaultCacheServiceName() {
        return this.defaultCacheServiceName;
    }

    public ServiceName getCacheFactoryServiceName() {
        return this.cacheFactoryServiceName;
    }

    public void setCacheFactoryServiceName(ServiceName name) {
        this.cacheFactoryServiceName = name;
    }

    public void setCacheServiceNameReferences(ServiceNameRef[] refs) {
        this.predefinedCacheNames = refs;
    }

    public ServiceNameRef[] getCacheServiceNameReferences() {
        return this.predefinedCacheNames;
    }

    public void startService() throws Exception {
        Service service;
        if (this.cacheFactoryServiceName != null && !((service = ServiceManagerFactory.getService((ServiceName)this.cacheFactoryServiceName)) instanceof FactoryService)) {
            throw new DeploymentException("Specified cacheFactoryServiceName '" + this.cacheFactoryServiceName + "' is not FactoryService");
        }
        if (this.defaultCacheServiceName != null) {
            this.defaultCacheService = (Cache)ServiceManagerFactory.getService((ServiceName)this.defaultCacheServiceName);
        }
        if (this.predefinedCacheNames == null) {
            return;
        }
        int i = 0;
        while (i < this.predefinedCacheNames.length) {
            this.caches.put(this.predefinedCacheNames[i].getReferenceServiceName(), ServiceManagerFactory.getServiceObject((ServiceName)this.predefinedCacheNames[i].getServiceName()));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        Map map = this.caches;
        synchronized (map) {
            this.caches.clear();
        }
        this.defaultCacheService = null;
        List list = this.generatedCaches;
        synchronized (list) {
            Iterator iter = this.generatedCaches.iterator();
            while (iter.hasNext()) {
                Service service = (Service)iter.next();
                service.stop();
                service.destroy();
            }
            this.generatedCaches.clear();
        }
    }

    public void destroyService() throws Exception {
        this.cacheFactoryServiceName = null;
        this.defaultCacheServiceName = null;
        this.predefinedCacheNames = null;
    }

    public CacheEntry createNewEntry() {
        return new CacheEntryImpl();
    }

    public CacheKey createNewKey(String path) {
        return new CacheKeyImpl(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry get(CacheKey key) {
        Cache cache;
        String path = key.getPath();
        if (key.getKeyLength() == 0) {
            if (this.defaultCacheService == null) {
                return null;
            }
            return (CacheEntry)this.defaultCacheService.get((Object)path);
        }
        Map map = this.caches;
        synchronized (map) {
            cache = (Cache)this.caches.get(path);
        }
        if (cache == null) {
            return null;
        }
        return (CacheEntry)cache.get((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(CacheKey key, CacheEntry entry) {
        Cache cache;
        String path = key.getPath();
        if (key.getKeyLength() == 0) {
            if (this.defaultCacheService == null) {
                return;
            }
            this.defaultCacheService.insert((Object)key, (Object)entry);
            return;
        }
        Map map = this.caches;
        synchronized (map) {
            cache = (Cache)this.caches.get(path);
            if (cache == null && this.cacheFactoryServiceName != null) {
                cache = (Cache)ServiceManagerFactory.getServiceObject((ServiceName)this.cacheFactoryServiceName);
                this.caches.put(path, cache);
            }
        }
        if (cache != null) {
            cache.insert((Object)key, (Object)entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String path) {
        if (this.defaultCacheService != null) {
            this.defaultCacheService.remove((Object)path);
        }
        Cache cache = null;
        Map map = this.caches;
        synchronized (map) {
            cache = (Cache)this.caches.get(path);
        }
        if (cache == null) {
            return;
        }
        cache.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CacheKey key) {
        if (key.getKeyLength() == 0) {
            this.remove(key.getPath());
            return;
        }
        Cache cache = null;
        Map map = this.caches;
        synchronized (map) {
            cache = (Cache)this.caches.get(key.getPath());
        }
        if (cache == null) {
            return;
        }
        cache.remove((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        if (this.defaultCacheService != null) {
            this.defaultCacheService.flush();
        }
        Map map = this.caches;
        synchronized (map) {
            Iterator iter = this.caches.values().iterator();
            while (iter.hasNext()) {
                Cache cache = (Cache)iter.next();
                cache.flush();
            }
        }
    }
}

