/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.cache;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.ossc.tstruts.cache.CacheKey;
import jp.ossc.tstruts.cache.CacheKeyEntry;

public class CacheKeyImpl
implements CacheKey {
    private String path = null;
    private List keysList = null;
    private CacheKeyEntry[] sortedKeys = null;
    private String combined = null;
    private int hashCode;

    public CacheKeyImpl(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void addKey(String name, String value) {
        this.sortedKeys = null;
        this.combined = null;
        CacheKeyEntry entry = new CacheKeyEntry(name, value);
        if (this.keysList == null) {
            this.keysList = new LinkedList();
        }
        this.keysList.add(entry);
    }

    public int getKeyLength() {
        if (this.keysList == null) {
            return 0;
        }
        return this.keysList.size();
    }

    public CacheKeyEntry[] getKeyEntries() {
        if (this.sortedKeys != null) {
            return this.sortedKeys;
        }
        if (this.keysList == null) {
            this.sortedKeys = new CacheKeyEntry[0];
        } else {
            Collections.sort(this.keysList);
            this.sortedKeys = this.keysList.toArray(new CacheKeyEntry[this.keysList.size()]);
        }
        return this.sortedKeys;
    }

    public CacheKeyEntry getKeyEntry(String name) {
        if (this.keysList == null) {
            return null;
        }
        Iterator iter = this.keysList.iterator();
        while (iter.hasNext()) {
            CacheKeyEntry key = (CacheKeyEntry)iter.next();
            if (!key.name.equals(name)) continue;
            return key;
        }
        return null;
    }

    public boolean equals(Object obj) {
        CacheKeyImpl another = (CacheKeyImpl)obj;
        return this.internalToString().equals(another.internalToString());
    }

    public int hashCode() {
        this.internalToString();
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CacheKey[");
        buf.append(this.internalToString());
        buf.append(']');
        return buf.toString();
    }

    protected String internalToString() {
        if (this.combined != null) {
            return this.combined;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.path);
        buf.append(',');
        CacheKeyEntry[] entries = this.getKeyEntries();
        int i = 0;
        while (i < entries.length) {
            buf.append(entries[i].name);
            if (entries[i].value != null) {
                buf.append('=');
                buf.append(entries[i].value);
            }
            if (i < entries.length - 1) {
                buf.append(',');
            }
            ++i;
        }
        this.combined = buf.toString();
        this.hashCode = this.combined.hashCode();
        return this.combined;
    }
}

