/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.auth;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.ossc.tstruts.config.UserProfileConfig;
import jp.ossc.tstruts.util.MyRequestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.RequestUtils;

public class UserProfileFilter
implements Filter {
    private static final Log log = LogFactory.getLog((Class)(class$jp$ossc$tstruts$auth$UserProfileFilter == null ? (class$jp$ossc$tstruts$auth$UserProfileFilter = UserProfileFilter.class$("jp.ossc.tstruts.auth.UserProfileFilter")) : class$jp$ossc$tstruts$auth$UserProfileFilter));
    private ServletContext context = null;
    static /* synthetic */ Class class$jp$ossc$tstruts$auth$UserProfileFilter;

    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (request.getAttribute("USER_PROFILE") != null) {
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            log.debug((Object)"The request doesn't have HttpSession.");
            Principal principal = httpRequest.getUserPrincipal();
            UserProfileConfig factory = MyRequestUtil.getRootModuleConfig(this.context).getUserProfileConfig();
            if (factory == null) {
                log.debug((Object)"UserProfile is not configured.");
                chain.doFilter(request, response);
                return;
            }
            if (request.getAttribute("org.apache.struts.action.MODULE") == null) {
                RequestUtils.selectModule((HttpServletRequest)httpRequest, (ServletContext)this.context);
            }
            if (principal == null) {
                log.debug((Object)"Request user is not authenticated. Create default UserProfile.");
                Object profile = factory.createDefaultUserProfile(httpRequest);
                httpRequest.setAttribute("USER_PROFILE", profile);
                chain.doFilter(request, response);
                return;
            }
            log.debug((Object)"Request user is authenticated. Create user specific UserProfile.");
            Object profile = factory.createAuthenticatedUserProfile(principal, httpRequest);
            session = httpRequest.getSession(true);
            session.setAttribute("USER_PROFILE", profile);
            httpRequest.setAttribute("USER_PROFILE", profile);
            chain.doFilter(request, response);
            return;
        }
        log.debug((Object)"The request has HttpSession.");
        Object profile = session.getAttribute("USER_PROFILE");
        if (profile == null) {
            Principal principal;
            log.debug((Object)"The request doesn't have UserProfile.");
            UserProfileConfig factory = MyRequestUtil.getRootModuleConfig(this.context).getUserProfileConfig();
            if (factory == null) {
                log.debug((Object)"UserProfile is not configured.");
                chain.doFilter(request, response);
                return;
            }
            if (request.getAttribute("org.apache.struts.action.MODULE") == null) {
                RequestUtils.selectModule((HttpServletRequest)httpRequest, (ServletContext)this.context);
            }
            if ((principal = httpRequest.getUserPrincipal()) != null) {
                log.debug((Object)"Request user is authenticated. Create user specific UserProfile.");
                profile = factory.createAuthenticatedUserProfile(principal, httpRequest);
                session.setAttribute("USER_PROFILE", profile);
            } else {
                log.debug((Object)"Request user is not authenticated. Create default UserProfile.");
                profile = factory.createDefaultUserProfile(httpRequest);
            }
        } else {
            log.debug((Object)"Request has UserProfile.");
        }
        httpRequest.setAttribute("USER_PROFILE", profile);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

