/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.auth;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.deploy.LoginConfig;

public class DirectFormAuthenticator
extends FormAuthenticator {
    public static final String REQUEST_URI_PARAMETER_NAME = "jp.ossc.tstruts.auth.RequestURI";

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        boolean isLoginAction;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        String contextPath = hreq.getContextPath();
        String requestURI = request.getDecodedRequestURI();
        boolean bl = isLoginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
        if (isLoginAction && !this.matchRequest(request)) {
            HttpServletResponse hres = (HttpServletResponse)response.getResponse();
            requestURI = hreq.getParameter(REQUEST_URI_PARAMETER_NAME);
            if (requestURI != null) {
                Principal principal;
                Realm realm = ((AuthenticatorBase)this).context.getRealm();
                String userName = hreq.getParameter("j_username");
                String password = hreq.getParameter("j_password");
                if (((AuthenticatorBase)this).debug >= 1) {
                    this.log("Authenticating username '" + userName + '\'');
                }
                if ((principal = realm.authenticate(userName, password)) == null) {
                    String errorURI = contextPath + config.getErrorPage();
                    if (((AuthenticatorBase)this).debug >= 1) {
                        this.log("Redirect to error page '" + errorURI + '\'');
                    }
                    hres.sendRedirect(hres.encodeRedirectURL(errorURI));
                    return false;
                }
                if (((AuthenticatorBase)this).debug >= 1) {
                    this.log("Authentication of '" + userName + "' was successful");
                }
                Session session = this.getSession(request, true);
                session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
                if (!((AuthenticatorBase)this).cache) {
                    session.setNote("org.apache.catalina.session.USERNAME", (Object)userName);
                    session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
                }
                hres.sendRedirect(hres.encodeRedirectURL(contextPath + requestURI));
                return true;
            }
        }
        return super.authenticate(request, response, config);
    }
}

