/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.auth;

import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import jp.ossc.tstruts.auth.DefaultInitializer;
import jp.ossc.tstruts.config.JDBCInitializerConfig;
import jp.ossc.tstruts.config.JDBCInitializerMappingConfig;
import jp.ossc.tstruts.config.UserProfileConfig;
import jp.ossc.tstruts.config.UserProfilePropertyConfig;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;

public class DefaultJDBCInitializer
extends DefaultInitializer {
    private static final Log log = LogFactory.getLog((Class)(class$jp$ossc$tstruts$auth$DefaultJDBCInitializer == null ? (class$jp$ossc$tstruts$auth$DefaultJDBCInitializer = DefaultJDBCInitializer.class$("jp.ossc.tstruts.auth.DefaultJDBCInitializer")) : class$jp$ossc$tstruts$auth$DefaultJDBCInitializer));
    private DataSource datasource = null;
    private JDBCInitializerConfig jdbcConfig = null;
    static /* synthetic */ Class class$jp$ossc$tstruts$auth$DefaultJDBCInitializer;

    public void initialize(UserProfileConfig config) throws Exception {
        super.initialize(config);
        this.jdbcConfig = config.getJDBCInitializerConfig();
        InitialContext ctx = new InitialContext();
        this.datasource = (DataSource)ctx.lookup(this.jdbcConfig.getDsJndiName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeAuthorized(Object userProfile, Principal principal, HttpServletRequest request) {
        Connection con = null;
        Statement stmt = null;
        try {
            BeanUtils.setProperty((Object)userProfile, (String)"authenticated", (Object)"true");
            con = this.getConnection();
            stmt = con.prepareStatement(this.jdbcConfig.getQuery());
            stmt.setString(1, principal.getName());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                String msg = "User[" + principal.getName() + "]'s profile is not found.";
                log.error((Object)msg);
                return;
            }
            JDBCInitializerMappingConfig[] mappings = this.getJdbcConfig().getMappings();
            int i = 0;
            while (i < mappings.length) {
                String str = rs.getString(mappings[i].getColumn());
                String name = mappings[i].getProperty();
                UserProfilePropertyConfig propertyConfig = mappings[i].getAssociatedProperty();
                if (propertyConfig == null) {
                    BeanUtils.setProperty((Object)userProfile, (String)name, (Object)str);
                } else {
                    Object value = propertyConfig.convert(str);
                    BeanUtils.setProperty((Object)userProfile, (String)name, (Object)value);
                }
                ++i;
            }
        }
        catch (Exception e) {
            String msg = "Failed to lookup UserProfile for user '" + principal.getName() + "'.";
            log.error((Object)msg, (Throwable)e);
        }
        finally {
            String msg;
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    msg = "Failed to close database statement.";
                    log.error((Object)msg, (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    msg = "Failed to close database connection.";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
        UserProfilePropertyConfig[] unmappedProperties = this.getJdbcConfig().getUnmappedPropertyConfig();
        if (unmappedProperties.length == 0) {
            return;
        }
        MessageResources resource = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        HttpSession session = request.getSession(false);
        Locale locale = null;
        if (session != null) {
            locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        int i = 0;
        while (i < unmappedProperties.length) {
            this.setProperty(userProfile, resource, locale, unmappedProperties[i]);
            ++i;
        }
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public JDBCInitializerConfig getJdbcConfig() {
        return this.jdbcConfig;
    }

    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

