/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.action.ejb.facade;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.tstruts.action.ejb.BusinessException;
import jp.ossc.tstruts.action.ejb.BusinessGroupNotFoundException;
import jp.ossc.tstruts.action.ejb.BusinessNotFoundException;
import jp.ossc.tstruts.action.ejb.BusinessSystemException;
import jp.ossc.tstruts.action.ejb.business.Business;
import jp.ossc.tstruts.action.ejb.facade.BusinessGroup;
import jp.ossc.tstruts.common.InvocationContext;

public class BusinessGroupBean
implements SessionBean {
    private static final String JAVA_ENV_KEY = "java:comp/env";
    private static final String GROUP_ENV_KEY = "group-name";
    private static final String SERVICE_PATH_ENV_KEY = "service-path";
    private static final String DEFAULT_GROUP_NAME = "default";
    private SessionContext sessionContext;
    private String groupName;
    private String servicePath;

    public String getGroupName() {
        return this.groupName;
    }

    public InvocationContext doBusiness(String name, InvocationContext context) throws BusinessException, BusinessSystemException {
        ServiceManager manager = ServiceManagerFactory.findManager((String)this.groupName);
        if (manager == null) {
            throw new BusinessGroupNotFoundException(this.groupName);
        }
        Business business = null;
        try {
            business = (Business)manager.getServiceObject(name);
        }
        catch (ServiceNotFoundException e) {
            throw new BusinessNotFoundException(this.groupName, name);
        }
        business.setBusinessGroup((BusinessGroup)this.getEJBObject());
        return business.work(context);
    }

    public void setSessionContext(SessionContext context) throws EJBException, RemoteException {
        this.sessionContext = context;
    }

    public SessionContext getSessionContext() {
        if (this.sessionContext == null) {
            throw new IllegalStateException("session context is invalid");
        }
        return this.sessionContext;
    }

    public EJBContext getEJBContext() {
        return this.getSessionContext();
    }

    public EJBObject getEJBObject() {
        return this.getSessionContext().getEJBObject();
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
        ServiceManager manager;
        if (this.servicePath != null && (manager = ServiceManagerFactory.findManager((String)this.groupName)) != null) {
            manager.stop();
            manager.destroy();
        }
    }

    public void ejbCreate() throws EJBException, RemoteException {
        this.groupName = BusinessGroupBean.getEnvProperty(GROUP_ENV_KEY, DEFAULT_GROUP_NAME);
        this.servicePath = BusinessGroupBean.getEnvProperty(SERVICE_PATH_ENV_KEY);
        if (this.servicePath != null) {
            URL serviceURL = this.getClass().getClassLoader().getResource(this.servicePath);
            ServiceManagerFactory.loadManager((URL)serviceURL);
            ServiceManager manager = ServiceManagerFactory.findManager((String)this.groupName);
            if (manager != null) {
                Iterator businesses = manager.serviceObjectSet().iterator();
                while (businesses.hasNext()) {
                    Object obj = businesses.next();
                    if (!(obj instanceof Business)) continue;
                    Business business = (Business)obj;
                    business.setBusinessGroup((BusinessGroup)this.getEJBObject());
                    business.setEJBContext(this.getEJBContext());
                }
            }
        }
    }

    private static String getEnvProperty(String name) {
        String value = null;
        try {
            InitialContext context = new InitialContext();
            Context env = (Context)context.lookup(JAVA_ENV_KEY);
            value = (String)env.lookup(name);
        }
        catch (NamingException e) {}
        return value;
    }

    private static String getEnvProperty(String name, String defaultValue) {
        String value = BusinessGroupBean.getEnvProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

