/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.action.ejb.business;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.tstruts.action.ejb.business.InvocationContextJournalEditorMBean;
import jp.ossc.tstruts.common.InvocationContext;

public class InvocationContextJournalEditor
extends BlockJournalEditorServiceBase
implements InvocationContextJournalEditorMBean,
Serializable {
    private static final String DEFAULT_SECRET_STRING = "******";
    private static final String ATTRIBUTE_SEPARATOR = " = ";
    private static final String HEADER = "[InvocationContext]";
    private static final String REQUEST_ID_HEADER = "Request ID : ";
    private static final String USER_PROFILE_HEADER = "UserProfile : ";
    private static final String ACTION_FORM_HEADER = "ActionForm : ";
    private static final String ATTRIBUTES_HEADER = "Attributes : ";
    private static final String ERRORS_HEADER = "Errors : ";
    private static final String FORWARD_NAME_HEADER = "Forward Name : ";
    private boolean isOutputRequestId = true;
    private boolean isOutputUserProfile = true;
    private boolean isOutputActionForm = true;
    private boolean isOutputAttributes = true;
    private boolean isOutputErrors = true;
    private boolean isOutputForwardName = true;
    private String secretString = "******";
    private String[] secretAttributes;
    protected Set secretAttributeSet;
    private String[] enabledAttributes;
    protected Set enabledAttributeSet;

    public InvocationContextJournalEditor() {
        this.setHeader(HEADER);
    }

    public void setSecretString(String str) {
        this.secretString = str;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public void setSecretAttributes(String[] names) {
        this.secretAttributes = names;
    }

    public String[] getSecretAttributes() {
        return this.secretAttributes;
    }

    public void setOutputRequestId(boolean isOutput) {
        this.isOutputRequestId = isOutput;
    }

    public boolean isOutputRequestId() {
        return this.isOutputRequestId;
    }

    public void setOutputUserProfile(boolean isOutput) {
        this.isOutputUserProfile = isOutput;
    }

    public boolean isOutputUserProfile() {
        return this.isOutputUserProfile;
    }

    public void setOutputActionForm(boolean isOutput) {
        this.isOutputActionForm = isOutput;
    }

    public boolean isOutputActionForm() {
        return this.isOutputActionForm;
    }

    public void setOutputAttributes(boolean isOutput) {
        this.isOutputAttributes = isOutput;
    }

    public boolean isOutputAttributes() {
        return this.isOutputAttributes;
    }

    public void setOutputErrors(boolean isOutput) {
        this.isOutputErrors = isOutput;
    }

    public boolean isOutputErrors() {
        return this.isOutputErrors;
    }

    public void setOutputForwardName(boolean isOutput) {
        this.isOutputForwardName = isOutput;
    }

    public boolean isOutputForwardName() {
        return this.isOutputForwardName;
    }

    public void setEnabledAttributes(String[] names) {
        this.enabledAttributes = names;
    }

    public String[] getEnabledAttributes() {
        return this.enabledAttributes;
    }

    public void createService() {
        this.secretAttributeSet = new HashSet();
        this.enabledAttributeSet = new HashSet();
    }

    public void startService() {
        int i;
        if (this.secretAttributes != null) {
            i = 0;
            while (i < this.secretAttributes.length) {
                this.secretAttributeSet.add(this.secretAttributes[i]);
                ++i;
            }
        }
        if (this.enabledAttributes != null) {
            i = 0;
            while (i < this.enabledAttributes.length) {
                this.enabledAttributeSet.add(this.enabledAttributes[i]);
                ++i;
            }
        }
    }

    public void stopService() {
        this.secretAttributeSet.clear();
        this.enabledAttributeSet.clear();
    }

    public void destroyService() {
        this.secretAttributeSet = null;
        this.enabledAttributeSet = null;
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        InvocationContext context = (InvocationContext)value;
        boolean isMake = false;
        if (this.isOutputRequestId()) {
            this.makeRequestIdFormat(finder, key, context, buf);
            isMake = true;
        }
        if (this.isOutputUserProfile()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeUserProfileFormat(finder, key, context, buf);
            isMake = true;
        }
        if (this.isOutputActionForm()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeActionFormFormat(finder, key, context, buf);
            isMake = true;
        }
        if (this.isOutputAttributes()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeAttributesFormat(finder, key, context, buf);
            isMake = true;
        }
        if (this.isOutputErrors()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeErrorsFormat(finder, key, context, buf);
            isMake = true;
        }
        if (this.isOutputForwardName()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeForwardNameFormat(finder, key, context, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeRequestIdFormat(EditorFinder finder, Object key, InvocationContext context, StringBuffer buf) {
        return buf.append(REQUEST_ID_HEADER).append(context.getRequestID());
    }

    protected StringBuffer makeUserProfileFormat(EditorFinder finder, Object key, InvocationContext context, StringBuffer buf) {
        buf.append(USER_PROFILE_HEADER);
        return this.makeObjectFormat(finder, key, context.getUserProfile(), buf);
    }

    protected StringBuffer makeActionFormFormat(EditorFinder finder, Object key, InvocationContext context, StringBuffer buf) {
        buf.append(ACTION_FORM_HEADER);
        return this.makeObjectFormat(finder, key, context.getActionForm(), buf);
    }

    protected StringBuffer makeAttributesFormat(EditorFinder finder, Object key, InvocationContext context, StringBuffer buf) {
        buf.append(ATTRIBUTES_HEADER);
        Iterator attrNames = context.getAttributeNames();
        if (!attrNames.hasNext()) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        while (attrNames.hasNext()) {
            String name = (String)attrNames.next();
            if (!this.enabledAttributeSet.isEmpty() && !this.enabledAttributeSet.contains(name)) continue;
            subBuf.append(name);
            subBuf.append(ATTRIBUTE_SEPARATOR);
            if (this.secretAttributeSet.contains(name)) {
                subBuf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, key, context.getAttribute(name), subBuf);
            }
            if (!attrNames.hasNext()) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeErrorsFormat(EditorFinder finder, Object key, InvocationContext context, StringBuffer buf) {
        buf.append(ERRORS_HEADER);
        String[] errorKeys = context.getErrorKeys();
        if (errorKeys == null || errorKeys.length == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        int i = 0;
        int max = errorKeys.length;
        while (i < max) {
            this.makeObjectFormat(finder, key, context.getError(errorKeys[i]), subBuf);
            if (i != max - 1) {
                subBuf.append(this.getLineSeparator());
            }
            ++i;
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeForwardNameFormat(EditorFinder finder, Object key, InvocationContext context, StringBuffer buf) {
        return buf.append(FORWARD_NAME_HEADER).append(context.getForwardName());
    }
}

