/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts.action.ejb;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceName;

public class ServiceNameReference
extends ServiceBase
implements Map,
Serializable {
    public static final String SERVICE_NAME = "ServiceNameRef";
    private ServiceNameEditor editor;
    private Map refNameMap = Collections.synchronizedMap(new HashMap());
    private Map refNameCacheMap;

    public ServiceName getServiceName(String refName) {
        return (ServiceName)this.refNameCacheMap.get(refName);
    }

    public void createService() throws Exception {
        this.editor = new ServiceNameEditor();
        this.editor.setServiceManagerName(this.getServiceManagerName());
        this.refNameCacheMap = new HashMap();
    }

    public void startService() throws Exception {
        Iterator keys = this.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = this.get(key);
            ServiceName serviceName = null;
            if (value == null) continue;
            if (value instanceof ServiceName) {
                serviceName = (ServiceName)value;
            } else if (this.editor != null) {
                String name = value.toString();
                this.editor.setAsText(name);
                serviceName = (ServiceName)this.editor.getValue();
            }
            if (serviceName == null) continue;
            this.refNameCacheMap.put(key, serviceName);
        }
    }

    public void stopService() {
        if (this.refNameCacheMap != null) {
            this.refNameCacheMap.clear();
        }
    }

    public void destroyService() {
        this.editor = null;
        this.refNameCacheMap = null;
        this.refNameMap = null;
    }

    public int size() {
        return this.refNameMap.size();
    }

    public boolean isEmpty() {
        return this.refNameMap.isEmpty();
    }

    public boolean containsKey(Object refName) {
        return this.refNameMap.containsKey(refName);
    }

    public boolean containsValue(Object serviceName) {
        return this.refNameMap.containsValue(serviceName);
    }

    public Object get(Object refName) {
        return this.refNameMap.get(refName);
    }

    public Object put(Object refName, Object serviceName) {
        return this.refNameMap.put(refName, serviceName);
    }

    public Object remove(Object refName) {
        return this.refNameMap.remove(this.name);
    }

    public void putAll(Map map) {
        this.refNameMap.putAll(map);
    }

    public void clear() {
        this.refNameMap.clear();
    }

    public Set keySet() {
        return this.refNameMap.keySet();
    }

    public Collection values() {
        return this.refNameMap.values();
    }

    public Set entrySet() {
        return this.refNameMap.entrySet();
    }
}

