/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.tstruts;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.action.ExtendActionMapping;
import jp.ossc.tstruts.action.forward.ForwardContext;
import jp.ossc.tstruts.action.transaction.TransactionControl;
import jp.ossc.tstruts.cache.ActionCache;
import jp.ossc.tstruts.cache.CacheEntry;
import jp.ossc.tstruts.cache.CacheKey;
import jp.ossc.tstruts.cache.CacheServletResponse;
import jp.ossc.tstruts.common.InvocationContext;
import jp.ossc.tstruts.config.CacheKeyConfig;
import jp.ossc.tstruts.config.ForwardValueConfig;
import jp.ossc.tstruts.config.SelectForwardConfig;
import jp.ossc.tstruts.config.SubModuleConfigImpl;
import jp.ossc.tstruts.config.SystemConfig;
import jp.ossc.tstruts.config.TStrutsActionForward;
import jp.ossc.tstruts.config.TileDefinitionConfig;
import jp.ossc.tstruts.config.TilePutConfigBase;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.jexl.Expression;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class ExtendRequestProcessor
extends RequestProcessor {
    private static final Log log = LogFactory.getLog((Class)(class$jp$ossc$tstruts$ExtendRequestProcessor == null ? (class$jp$ossc$tstruts$ExtendRequestProcessor = ExtendRequestProcessor.class$("jp.ossc.tstruts.ExtendRequestProcessor")) : class$jp$ossc$tstruts$ExtendRequestProcessor));
    public static final String TILES_LOCALE_CACHE_KEY = "jp.ossc.tstruts.tiles.Locale";
    protected ServiceName globalCacheServiceName = null;
    protected ServiceName sessionCacheHolderName = null;
    private SystemConfig systemConfig = null;
    private boolean autoLocale = false;
    private int transactedMax = 0;
    static /* synthetic */ Class class$jp$ossc$tstruts$ExtendRequestProcessor;

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        block6: {
            String t;
            super.init(servlet, config);
            ServletContext context = servlet.getServletContext();
            this.systemConfig = (SystemConfig)context.getAttribute("jp.ossc.tstruts.config.SystemConfig");
            String str = this.systemConfig.getProperty("CacheAutoLocale");
            if (str != null) {
                this.autoLocale = str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("true");
                log.info((Object)("CacheAutoLocale:" + (this.autoLocale ? "enabled" : "disabled")));
            }
            if ((t = context.getInitParameter("transactedMax")) != null) {
                this.transactedMax = Integer.parseInt(t);
                log.debug((Object)("transactedMax value in web.xml : " + this.transactedMax));
            } else {
                log.info((Object)"transactedMax value is not set.");
            }
            try {
                this.globalCacheServiceName = this.systemConfig.getServiceNameProperty(MyGlobals.GLOBAL_ACTION_CACHE_SERVICE_NAME);
                if (this.globalCacheServiceName != null) {
                    ServiceManagerFactory.getServiceObject((ServiceName)this.globalCacheServiceName);
                    break block6;
                }
                log.debug((Object)"Tiles global cache service is not configured.");
            }
            catch (ServiceNotFoundException e) {
                this.globalCacheServiceName = null;
                log.error((Object)"Tiles global cache service is not found.", (Throwable)e);
            }
        }
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.systemConfig.setLocal();
        request = this.processMultipart(request);
        String path = this.processPath(request, response);
        if (path == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing a '" + request.getMethod() + "' for path '" + path + "' req:" + request));
        }
        this.processLocale(request, response);
        this.processContent(request, response);
        this.processNoCache(request, response);
        if (!this.processPreprocess(request, response)) {
            return;
        }
        ActionMapping mapping = this.processMapping(request, response, path);
        if (mapping == null) {
            return;
        }
        if (!this.processRoles(request, response, mapping)) {
            return;
        }
        ActionForm form = this.processActionForm(request, response, mapping);
        this.processPopulate(request, response, form, mapping);
        int cacheType = ((ExtendActionMapping)mapping).getCacheType();
        if (cacheType == 0) {
            if (!this.processValidate(request, response, form, mapping)) {
                return;
            }
            this.processMainProcess(request, response, mapping, form);
            return;
        }
        Object originalResponse = null;
        ActionCache cache = null;
        switch (cacheType) {
            case 1: {
                if (this.globalCacheServiceName == null) break;
                cache = (ActionCache)ServiceManagerFactory.getServiceObject((ServiceName)this.globalCacheServiceName);
                break;
            }
            default: {
                log.error((Object)("Invalid cache type! Action:" + mapping.getPath()));
            }
        }
        if (cache == null) {
            if (!this.processValidate(request, response, form, mapping)) {
                return;
            }
            this.processMainProcess(request, response, mapping, form);
            return;
        }
        String cachePath = this.moduleConfig.getPrefix() + path;
        CacheKey cacheKey = this.createCacheKey(cache, cachePath, request, mapping);
        CacheEntry cacheEntry = cache.get(cacheKey);
        if (cacheEntry != null) {
            response.getWriter().write((String)cacheEntry.getContent());
            response.setContentType(cacheEntry.getContentType());
            if (log.isDebugEnabled()) {
                log.debug((Object)("We use cache for path '" + path + "'"));
            }
            return;
        }
        if (!this.processValidate(request, response, form, mapping)) {
            return;
        }
        CacheServletResponse cacheResponse = new CacheServletResponse(response);
        try {
            this.processMainProcess(request, cacheResponse, mapping, form);
        }
        catch (IOException e) {
            String content = cacheResponse.getContent();
            String contentType = cacheResponse.getContentType();
            if (contentType == null) {
                contentType = "text/html; charset=" + request.getCharacterEncoding();
            }
            log.error((Object)("Exception[" + e.getMessage() + "] occured. Response is not cached."));
            response.getWriter().write(content);
            response.setContentType(contentType);
            throw e;
        }
        String content = cacheResponse.getContent();
        String contentType = cacheResponse.getContentType();
        if (contentType == null) {
            contentType = "text/html; charset=" + request.getCharacterEncoding();
        }
        CacheEntry entry = cache.createNewEntry();
        entry.setContent(content);
        entry.setContentType(contentType);
        entry.setContentDate(System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)("CacheKey is: " + cacheKey));
        }
        if (cacheKey.getKeyEntries().length == 0) {
            cache.put(cacheKey, entry);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Save Cache for path: '" + cachePath + "'."));
            }
        } else {
            cache.put(cacheKey, entry);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Save Cache: Cache-Key '" + cacheKey + "', path '" + cachePath + "'."));
            }
        }
        response.getWriter().write(content);
        response.setContentType(contentType);
    }

    protected void processMainProcess(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping, ActionForm form) throws IOException, ServletException {
        if (!this.processForward(request, response, mapping)) {
            return;
        }
        if (!this.processInclude(request, response, mapping)) {
            return;
        }
        ActionForward forward = this.processAction(request, response, mapping, form);
        this.processForwardConfig(request, response, (ForwardConfig)forward);
    }

    protected ActionForward processAction(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping, ActionForm form) throws IOException, ServletException {
        Action action = this.processActionCreate(request, response, mapping);
        ActionForward forward = null;
        if (action != null) {
            forward = this.processActionPerform(request, response, action, form, mapping);
        }
        if (forward == null) {
            forward = this.processSelectForward(request, response, form, mapping);
        }
        if (forward == null) {
            forward = this.processForwardTest(request, response, form, mapping);
        }
        return forward;
    }

    protected ActionForward processSelectForward(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        MessageResources resources;
        ForwardValueConfig forwardValue;
        ExtendActionMapping exMapping = (ExtendActionMapping)mapping;
        SelectForwardConfig selectForward = exMapping.getSelectForwardConfig();
        if (selectForward == null) {
            return null;
        }
        String o = null;
        try {
            o = BeanUtils.getProperty((Object)form, (String)selectForward.getProperty());
        }
        catch (Exception e) {
            // empty catch block
        }
        String result = null;
        if (o != null) {
            result = o.toString();
        }
        if ((forwardValue = selectForward.findForwardValueConfig(result, resources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE"), request.getLocale())) == null) {
            String prefix = selectForward.getProperty() + ".";
            Iterator i = IteratorUtils.asIterator((Enumeration)request.getParameterNames());
            while (i.hasNext()) {
                String param_name = (String)i.next();
                if (!param_name.startsWith(prefix)) continue;
                result = param_name.substring(prefix.length());
                String[] result_body = StringUtils.split((String)result, (String)".");
                forwardValue = selectForward.findForwardValueConfig(result_body[0], resources, request.getLocale());
            }
        }
        if (forwardValue == null) {
            forwardValue = selectForward.getForwardDefaultConfig();
        }
        if (forwardValue != null) {
            return mapping.findForward(forwardValue.getName());
        }
        return null;
    }

    protected ActionForward processForwardTest(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        ForwardContext context = null;
        ForwardConfig[] forwards = ((ExtendActionMapping)mapping).getForwardConfigs();
        try {
            int i = 0;
            while (i < forwards.length) {
                TStrutsActionForward forward;
                if (forwards[i] instanceof TStrutsActionForward && (forward = (TStrutsActionForward)forwards[i]).getTest() != null) {
                    Expression expr;
                    Object result;
                    if (context == null) {
                        context = new ForwardContext(request, this.getServletContext());
                    }
                    if ((result = (expr = forward.getTestExpr()).evaluate(context)) instanceof Boolean) {
                        if (((Boolean)result).booleanValue()) {
                            return forward;
                        }
                    } else {
                        String str = null;
                        str = result instanceof String ? (String)result : result.toString();
                        if (str.equals("on") || str.equals("yes") || str.equals("1") || str.equals("true")) {
                            return forward;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        return null;
    }

    protected boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) {
        block2: {
            if (request.getAttribute("InvocationContext") != null) break block2;
            try {
                InvocationContext invokeContext = this.systemConfig.createInvocationContext();
                request.setAttribute("InvocationContext", (Object)invokeContext);
            }
            catch (Exception e) {
                log.fatal((Object)"Failed to create InvocationContext", (Throwable)e);
            }
        }
        return super.processPreprocess(request, response);
    }

    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        try {
            log.debug((Object)"processActionPerform() start.");
            ExtendActionMapping exMapping = (ExtendActionMapping)mapping;
            if (exMapping.getTransacted()) {
                TransactionControl tControl = new TransactionControl();
                tControl.checkTransactionId(request, action, mapping);
                tControl.saveTransactionId(request, this.getTransactedMax());
            }
            ActionForward forward = action.execute(mapping, form, request, response);
            return forward;
        }
        catch (Exception e) {
            return this.processException(request, response, e, form, mapping);
        }
    }

    protected boolean processForward(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String path = mapping.getForward();
        if (path == null) {
            return true;
        }
        TStrutsActionForward forward = new TStrutsActionForward(path);
        this.internalForward(request, response, (ForwardConfig)forward);
        return false;
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (forward == null) {
            return;
        }
        this.internalForward(request, response, forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalForward(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws ServletException, IOException {
        boolean topLevelTile;
        TileDefinitionConfig tileDef;
        TilePutConfigBase oldConfig;
        block15: {
            block14: {
                oldConfig = (TilePutConfigBase)request.getAttribute(MyGlobals.TILES_CONFIG_KEY);
                tileDef = ((SubModuleConfigImpl)this.moduleConfig).findTileDefinition(forward.getPath());
                topLevelTile = false;
                try {
                    String path;
                    if (tileDef != null) {
                        ActionErrors errors;
                        TileDefinitionConfig topLevelTileDef = (TileDefinitionConfig)request.getAttribute("TopLevelTile");
                        if (topLevelTileDef == null) {
                            topLevelTile = true;
                            topLevelTileDef = tileDef;
                            request.setAttribute("TopLevelTile", (Object)tileDef);
                            request.setAttribute("ErrorControlKey", (Object)tileDef.getErrorControl());
                        }
                        boolean error = (errors = (ActionErrors)request.getAttribute("org.apache.struts.action.ERROR")) != null && !errors.isEmpty();
                        tileDef.init();
                        tileDef.makeResponse(request, response, this.getServletContext());
                        request.setAttribute(MyGlobals.TILES_CONFIG_KEY, (Object)tileDef);
                        forward = new TStrutsActionForward(tileDef.getPath());
                        if (!error && topLevelTileDef == tileDef) {
                            String errorControl = (String)request.getAttribute("ErrorControlKey");
                            errors = (ActionErrors)request.getAttribute("org.apache.struts.action.ERROR");
                            if (errors != null && !errors.isEmpty() && (errorControl == null || Boolean.valueOf(errorControl).booleanValue())) {
                                this.errorForward(request, response);
                                Object var12_11 = null;
                                if (topLevelTile) {
                                    tileDef.init();
                                }
                                break block14;
                            }
                        }
                    }
                    if (!(path = forward.getPath()).startsWith("/")) {
                        path = RequestUtils.forwardURL((HttpServletRequest)request, (ForwardConfig)forward);
                    }
                    if (forward.getRedirect()) {
                        if (!(response instanceof CacheServletResponse)) {
                            path = request.getContextPath() + path;
                            response.sendRedirect(response.encodeRedirectURL(path));
                        }
                        break block15;
                    }
                    if (response instanceof CacheServletResponse) {
                        this.doInclude(path, request, response);
                        break block15;
                    } else {
                        this.doForward(path, request, response);
                    }
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (topLevelTile) {
                        tileDef.init();
                    }
                    request.setAttribute(MyGlobals.TILES_CONFIG_KEY, (Object)oldConfig);
                    throw throwable;
                }
            }
            request.setAttribute(MyGlobals.TILES_CONFIG_KEY, (Object)oldConfig);
            return;
        }
        Object var12_12 = null;
        if (topLevelTile) {
            tileDef.init();
        }
        request.setAttribute(MyGlobals.TILES_CONFIG_KEY, (Object)oldConfig);
    }

    protected void errorForward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ActionMapping mapping = (ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance");
        String input = mapping.getInput();
        if (input == null || input.length() == 0) {
            return;
        }
        Object forward = null;
        forward = this.moduleConfig.getControllerConfig().getInputForward() ? mapping.findForward(input) : new TStrutsActionForward(input);
        this.internalForward(request, response, (ForwardConfig)forward);
    }

    protected CacheKey createCacheKey(ActionCache cache, String cachePath, HttpServletRequest request, ActionMapping mapping) throws ServletException {
        CacheKey cacheKey = cache.createNewKey(cachePath);
        StringBuffer buf = new StringBuffer();
        CacheKeyConfig[] keyConfigs = ((ExtendActionMapping)mapping).getCacheKeyConfigs();
        int i = 0;
        while (i < keyConfigs.length) {
            String parameter = keyConfigs[i].getParameter();
            if (parameter != null) {
                StringTokenizer t = new StringTokenizer(parameter, ", ");
                while (t.hasMoreTokens()) {
                    String value;
                    String name = t.nextToken();
                    String[] values = request.getParameterValues(name);
                    if (values == null || values.length == 0) {
                        value = null;
                    } else if (values.length == 1) {
                        value = values[0];
                    } else {
                        buf.setLength(0);
                        int j = 0;
                        while (j < values.length) {
                            buf.append(values[j]);
                            if (j + 1 < values.length) {
                                buf.append(',');
                            }
                            ++j;
                        }
                        value = buf.toString();
                    }
                    cacheKey.addKey("P#" + name, value);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Add cacheKey : key=" + name + ", value=" + value));
                }
            } else {
                String beanName = keyConfigs[i].getBeanName();
                String property = keyConfigs[i].getProperty();
                Object bean = request.getAttribute(beanName);
                if (bean == null) {
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        bean = session.getAttribute(beanName);
                    }
                    if (bean == null) {
                        bean = this.getServletContext().getAttribute(beanName);
                    }
                }
                if (bean == null) {
                    throw new ServletException("beanName '" + beanName + "' is not defined.");
                }
                if (property == null) {
                    cacheKey.addKey(beanName, bean.toString());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Add cacheKey : key=" + beanName + ", value=" + bean));
                    }
                } else {
                    StringTokenizer t = new StringTokenizer(property, ", ");
                    while (t.hasMoreTokens()) {
                        String name = t.nextToken();
                        String value = null;
                        try {
                            value = BeanUtils.getProperty((Object)bean, (String)name);
                        }
                        catch (IllegalAccessException e) {
                            throw new ServletException((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new ServletException((Throwable)e);
                        }
                        catch (NoSuchMethodException e) {
                            throw new ServletException("property '" + property + "' is not defined.", (Throwable)e);
                        }
                        String key = "B#" + name;
                        cacheKey.addKey(key, value);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Add cacheKey : key=" + beanName + "#" + name + ", value=" + value));
                    }
                }
            }
            ++i;
        }
        if (this.autoLocale) {
            log.debug((Object)"CacheAutoLocale:on, add locale key.");
            Locale locale = request.getLocale();
            cacheKey.addKey(TILES_LOCALE_CACHE_KEY, locale.toString());
        }
        return cacheKey;
    }

    public int getTransactedMax() {
        return this.transactedMax;
    }

    protected Action processActionCreate(HttpServletRequest arg0, HttpServletResponse arg1, ActionMapping arg2) throws IOException {
        String className = arg2.getType();
        if (className == null) {
            return null;
        }
        return super.processActionCreate(arg0, arg1, arg2);
    }

    protected boolean processValidate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        String input;
        ActionErrors errors;
        if (form == null) {
            return true;
        }
        if (request.getAttribute("org.apache.struts.action.CANCEL") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Cancelled transaction, skipping validation");
            }
            return true;
        }
        if (!mapping.getValidate()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Validating input form properties");
        }
        if ((errors = form.validate(mapping, request)) == null || errors.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  No errors detected, accepting input");
            }
            return true;
        }
        ActionErrors org = (ActionErrors)request.getAttribute("org.apache.struts.action.ERROR");
        if (org == null) {
            request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        } else {
            org.add((ActionMessages)errors);
        }
        if (form.getMultipartRequestHandler() != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Rolling back multipart request");
            }
            form.getMultipartRequestHandler().rollback();
        }
        if ((input = mapping.getInput()) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Validation failed but no input form available");
            }
            response.sendError(500, this.getInternal().getMessage("noInput", (Object)mapping.getPath()));
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Validation failed, returning to '" + input + "'"));
        }
        if (this.moduleConfig.getControllerConfig().getInputForward()) {
            ActionForward forward = mapping.findForward(input);
            this.processForwardConfig(request, response, (ForwardConfig)forward);
        } else if (mapping.getInputForward() != null) {
            ActionForward forward = mapping.getInputForward();
            this.processForwardConfig(request, response, (ForwardConfig)forward);
        } else {
            this.internalModuleRelativeForward(input, request, response);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

