<?php
/************************************************************************
	UebiMiau is a GPL'ed software developed by 
	 - Aldoir Ventura - aldoir@users.sourceforge.net
	 - http://uebimiau.sourceforge.net S Paulo - Brasil
   		
	***********************************************************************
	Version 3.2.0 Upgrades and templates developed by
	 - Todd Henderson - Lead Developer - http://tdah.us 
	 - Dave Rodgers - Developer - http://www.manvel.net 
	 - Laurent (AdNovea) - Developer - http://adnovea.free.fr
	 
	***********************************************************************
	 - Special thanks to the developers at 
	codeworxtech.com, tinymce.moxiecode.com
	telaen.org, phptoys.com, winged.info, ngcoders.com
	without help this project wouldn't be possible 
	
	***********************************************************************
	- File:			process.php
	- Developer: 	Todd Henderson / Mods by Laurent (AdNovea)
	- Date:			November 4, 2008
	- version:		(3.2.0) 1.0
	- Description:  Execute action on message (move, flag, mark)

*************************************************************************/
	require('./inc/inc.php');


	function mail_connect() {
	
		global $UM,$sid,$tid,$lid;
		
		if(!$UM->mail_connect()) { 
			redirect("error.php?lid=$lid&tid=$tid&err=1\r\n"); 
			exit; 
		}
	
		if(!$UM->mail_auth(true)) { 
			redirect("badlogin.php?lid=$lid&tid=$tid&error=".urlencode($UM->mail_error_msg)."\r\n"); 
			exit; 
		}
	}
	
	
	$headers = null;
	$folder_key = base64_encode($folder);
	if(!array_key_exists("headers",$sess)) $sess["headers"] = array();
		
	if(array_key_exists($folder_key,$sess["headers"]))
		$headers = $sess["headers"][$folder_key];
	
	if( !is_array($headers) 
		|| isset($decision)
		|| isset($refr)) {
	
		mail_connect();
	
		$sysmap = $UM->get_system_folders();
		$sysfolders = Array();
		while(list($key,$value) = each($sysmap))
			$sysfolders[] = $value;
	
		$sess["sysmap"] = $sysmap;
		$sess["sysfolders"] = $sysfolders;
		$sess["auth"] = true;
	
		if(!isset($folder) || $folder == "" || strpos($folder,"..") !== false ) {
			$folder = $sess["sysmap"]["inbox"];
			$folder_key = base64_encode($folder);
		}
		
		if(isset($start_pos) && isset($end_pos)) {
	
			for($i=$start_pos;$i<$end_pos;$i++) {

				if(isset(${"msg_$i"})) {
					if ($decision == "delete") {
						$UM->mail_delete_msg($headers[$i],$prefs["save-to-trash"],$prefs["st-only-read"]);
					} elseif ($decision == "spam") {
						$UM->mail_spam_msg($headers[$i],$prefs["save-to-spam"]);	
					} elseif ($decision == "mark") {
						$UM->mail_set_flag($headers[$i],"\\SEEN","+");
					} elseif ($decision == "unmark") {
						$UM->mail_set_flag($headers[$i],"\\SEEN","-");
					} elseif ($decision == "flagmsg") {
						$UM->mail_set_flag($headers[$i],"\\FLAGMSG","+");
					} elseif ($decision == "deflagmsg") {
						$UM->mail_set_flag($headers[$i],"\\FLAGMSG","-");
					} elseif ($decision == "move") {
						$UM->mail_move_msg($headers[$i],$aval_folders);
					} else {
						// Do nothing
					}
					$expunge = true;
				}
			}
	
			if($expunge) {
	
				if ($prefs["save-to-trash"])
					unset($sess["headers"][base64_encode($sess["sysmap"]["trash"])]);
				if ($decision == "move")
					unset($sess["headers"][base64_encode($aval_folders)]);
					
					if ($prefs["save-to-spam"])
					unset($sess["headers"][base64_encode($sess["sysmap"]["spam"])]);
				if ($decision == "move")
					unset($sess["headers"][base64_encode($aval_folders)]);
			  
	
				//some servers, don't hide deleted messages until you don't disconnect
				$SS->Save($sess);
			
				if ($back) {
					$back_to = $start_pos;
				}
			}
	
			unset($sess["headers"][$folder_key]);
	
		} elseif (isset($refr) && array_key_exists("headers",$sess)) {
			unset($sess["headers"][$folder_key]);
		}
		
		$boxes = $UM->mail_list_boxes();
	
		$sess["folders"] = $boxes;
		
		if(!$expunge || !$is_inbox_or_spam) {
			require(PATH_GET_MESSAGES);
			require(PATH_APPLY_FILTERS);
		}
	
		if($require_update) {
			$UM->mail_disconnect();
			mail_connect();
			require(PATH_GET_MESSAGES);
		}
	
		$UM->mail_disconnect();
	}
	
		
	if(!is_array($headers = $sess["headers"][$folder_key])) { 
		redirect("messages.php?lid=$lid&tid=$tid&folder=$folder&pag=$pag\r\n"); 
	} 
	
	array_qsort2($headers,$sortby,$sortorder);
	$sess["headers"][$folder_key] = $headers;
	$SS->Save($sess);
	
	if($check_first_login && !$prefs["first-login"]) {
		$prefs["first-login"] = 1;
		save_prefs($prefs);
		redirect("preferences.php?lid=$lid&tid=$tid&folder=".urlencode($folder));
		exit;
	}
	
	if(!isset($pag) || !is_numeric(trim($pag))) $pag = 1;
	$refreshurl = "messages.php?lid=$lid&tid=$tid&folder=".urlencode($folder)."&pag=$pag";
	
	if (isset($back_to)) {
		if (count($headers) > $back_to) {
			redirect("readmsg.php?lid=$lid&tid=$tid&folder=".urlencode($folder)."&pag=$pag&ix=$back_to");
			exit;
		}
	}
	
	redirect($refreshurl);
	
?>
