using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace genPatt
{
	class mkimg
	{
		Image img;
		const int patw = 8;
		const int path = 8;
		const int marzin = 10;

		public mkimg( Image img )
		{
			this.img = img;
		}

    static public int crc8( byte[] data, int begin, int length )
    {
			int n;
	    int crc = 0xff;
			for ( n=0; n<length; n++ )
	    {
				byte d = data[ n + begin ];
		    int i;
		    for ( i=0; i<8; i++ )
		    {
			    int b = crc & 1;
			    crc = (crc>>1) | ((d & 1)<<7);
			    d >>= 1;
			    if ( b != 0 )
			    {
				    crc ^= 0xb1;
			    }
		    }
	    }
      return crc;
    }
    static public int crc12( byte[] data, int begin, int length )
    {
      int n;
      int crc = 0xfff;
      for ( n = 0; n < length; n++ )
      {
        byte d = data[ n + begin ];
        int i;
        for ( i = 0; i < 8; i++ )
        {
          int b = crc & 1;
          crc = (crc >> 1) | ((d & 1)<<11);
          d >>= 1;
          if ( b != 0 )
          {
            crc ^= 0xf01;
          }
        }
      }
      return crc;
    }
    static public int crc16( byte[] data, int begin, int length )
    {
			int n;
	    int crc = 0xffff;
			for ( n=0; n<length; n++ )
	    {
				byte d = data[ n + begin ];
		    int i;
		    for ( i=0; i<8; i++ )
		    {
			    int b = crc & 1;
			    crc = (crc>>1) | ((d & 1)<<15);
			    d >>= 1;
			    if ( b != 0 )
			    {
				    crc ^= 0x8408;
			    }
		    }
	    }
	    return crc;
	    // 1 0001 0000 0010 0001  ->  1 0000 1000 0001 0001
    }

		void drawFrame()
		{
			Graphics g = Graphics.FromImage( img );
			int w = Math.Min( img.Width, img.Height ) - marzin*2;
			g.FillRectangle( Brushes.White, 0, 0, img.Width, img.Height );
			g.FillRectangle( Brushes.Black, ( img.Width - w ) / 2, ( img.Height - w ) / 2, w, w );
			g.FillRectangle( Brushes.White, ( img.Width - w ) / 2 + w/4, ( img.Height - w ) / 2 + w/4, w/2, w/2 );
		}

		void setBox( int x, int y, int val )
		{
			if ( val == 0 )
				return;
			Graphics g = Graphics.FromImage( img );
			int imgw = Math.Min( img.Width, img.Height ) - marzin*2;
			int boxX = ( img.Width - imgw ) / 2 + imgw / 4;
			int boxY = ( img.Height - imgw ) / 2 + imgw / 4;
			int w = imgw / 2;
			int bitW = (w + patw-1) / patw;
			int bitH = (w + path-1) / path;
			g.FillRectangle(
				Brushes.Black,
				x * w / patw + boxX,
				y * w / path + boxY,
				bitW,
				bitH
			);
		}

		Int64 bitShuffle( Int64 val, int bit1, int bit2 )
		{
			Int64 b1 = ((val & (1L<<bit1)) == 0)? 1 : 0;
			Int64 b2 = ((val & (1L<<bit2)) == 0)? 1 : 0;
			val &= ~((1L<<bit1) | (1L<<bit2));
			val |= (b1<<bit2) | (b2<<bit1);
			return val;
		}

		public void draw( Int64 code, int format )
		{
			// g
			drawFrame();
			// l
			setBox( 0, 0, 1 );
			setBox( 7, 0, 0 );
			setBox( 0, 7, 0 );
			setBox( 7, 7, 0 );

			switch ( format )
			{
			case 0:
				{
					if ( code <= 0  ||  code >= (1L<<44)-1 )
						throw new OverflowException();

          // rbgC^[[u
          Int64 c = 0;
          for ( int i=0,m=0; i < 11; i++ )
          {
            for ( int k = i; k < 44; k += 11, m++ )
            {
              if ( (code & (1L << k)) != 0 )
              {
                c |= 1L << m;
              }
            }
          }
          code = c;

					// codeoCgɕϊ
					// little endian
					byte[] data = new byte[ 6 ];
					for ( int i = 0; i < data.Length; i++ )
					{
						data[ i ] = (byte)( c & 0xff );
						c >>= 8;
					}
					int crc = crc16( data, 0, data.Length );

					// ʎq
					setBox( 1, 0, 0 );

					// f[^
          c = code | (((Int64)crc) << 44);

					for ( int x = 2; x <= 6 ; x++ )
					{
						setBox( x, 0, ((int)c) & 1 );
						c >>= 1;
					}
					for ( int y = 1; y <= 6; y++ )
					{
						for ( int x = 0; x <= 7; x++ )
						{
							setBox( x, y, ( (int)c ) & 1 );
							c >>= 1;
						}
					}
					for ( int x = 1; x <= 7; x++ )
					{
						setBox( x, 7, ((int)c) & 1 );
						c >>= 1;
					}
				}
				break;

			case 1:
				{
					if ( code <= 0  ||  code >= (1L<<32)-1 )
						throw new OverflowException();

          // rbgC^[[u
          Int64 c = 0;
          int m = 0;
          for ( int i = 0; i < 8; i++ )
          {
            for ( int k = i; k < 32; k += 8, m++ )
            {
              if ( (code & (1L << k)) != 0 )
              {
                c |= 1L << m;
              }
            }
          }
					c = (( ((c>>16)<<16) ) << 1) | (((code >> 32) & 1) << 16) | (c & 0xffff);
					c = (( ((c>>8)<<8) ) << 1)   | (((code >> 33) & 1) << 8)  | (c & 0xff);
					code = c;

          // codeoCgɕϊ
					// little endian
					byte[] data = new byte[ 5 ];
					for ( int i = 0; i < data.Length; i++ )
					{
						data[ i ] = (byte)( c & 0xff );
						c >>= 8;
					}
					int crc = crc12( data, 0, data.Length );
					int v;
					int oddp;

					// ʎq
					setBox( 1, 0, 1 );

					// 0s    bit0 peBA(1) bit1 ID         bit2`5 f[^  bit6 peB킹  bit7 0
					// 0`6s bit0 peBA    bit1`6 f[^  bit7 CRC-6
					// 7s    bit0 0            bit1`7 peBB

					// f[^
          c = code | (((Int64)crc) << 34);
          Int64 c2 = c;

					oddp = 1;
					for ( int x = 2; x <= 5; x++ )
					{
						v = ((int)c) & 1;
						setBox( x, 0, v );
						oddp ^= v;
						c >>= 1;
					}
					int bitZ = (oddp == 0)?1:0;
					setBox( 6, 0, bitZ );	// peB킹

					for ( int y = 1; y <= 6; y++ )
					{
						oddp = 0;
						for ( int x = 1; x <= 7; x++ )
						{
							v = ( (int)c ) & 1;
							setBox( x, y, v );
							oddp ^= v;
							c >>= 1;
						}
						// peBA
						setBox( 0, y, oddp );
					}

					// ݂
					setBox( 0, 7, 0 );

					// peBB ID,f[^
					c = c2;
					oddp = 1;
					for ( int y=1; y<=6; y++ )
					{
						oddp ^= ((c & (1L<<(4 + 7*(y-1)))) != 0) ? 1 : 0;
					}
					setBox( 1, 7, oddp );
					for ( int x = 1; x <= 7; x++ )
					{
						switch ( x )
						{
						case 0:
							oddp = 1;
							break;
						case 6:
							oddp = bitZ;
							break;
						case 7:
							oddp = 0;
							break;
						default:
							oddp = ((c & (1L<<(x-2))) != 0) ? 1 : 0;
							break;
						}
						for ( int y=1; y<=6; y++ )
						{
							oddp ^= ((c & (1L<<(5 + (x-2) + 7*(y-1)))) != 0) ? 1 : 0;
						}
						setBox( x, 7, oddp );
					}
				}
				break;
			}
			
			Graphics.FromImage( img ).Flush();
		}
	}
}
