/////////////////////////////////////////////////////////////////////////////
// HighlightMgr_cbl.h CHighlightMgr_cbl饹Υץơ
// 
/////////////////////////////////////////////////////////////////////////////

#if !defined( HIGHLIGHTMGR_CBL_H_INCLUDED_ )
#define HIGHLIGHTMGR_CBL_H_INCLUDED_

#include "../KeywordFinder.h"
#include "../KeywordList.h"

using namespace std;

namespace NLangExt {

namespace NLangExt_cbl {

///////////////////////////////////////////////////////////////////////////
// CProgPtr COBOLץΥɤΥݥȡӹʸǤȽ

/*
ͳˡξ
Ƭκ6ʸޤǤοϰϢֹȸʤ
ϢֹʹߤǡǽζǤʤʸ*⤷/ǤäԤȸʤ
*>ԤޤǤϹȸʤ

ϥ֥륯ơ󤪤ӥ󥰥륯ơȤ롣
*/

// ߥݥȤƤʸμ򼨤
enum CURCHARTYPE {
	CCT_ALPHANUMERIC	= 0x01,
	CCT_KEYWORD			= 0x02,
	CCT_COMENT			= 0x03,
	CCT_SEQUENCE_NUMBER	= 0x04,
	CCT_STRING			= 0x05,
	CCT_OTHER			= 0x06,
	CCT_NULL			= 0x07
};

// cե٥åȤݤȽǤ
template< typename T_Char >
bool IsAlphaNumeric( T_Char c )
{
#if LANGEXT_IS_ASCII
	return (
		c >= T_Char( 'A' ) && c <= T_Char( 'Z' ) ||
		c >= T_Char( 'a' ) && c <= T_Char( 'z' ) ||
		c >= T_Char( '0' ) && c <= T_Char( '9' ) ||
		c == T_Char( '-' )
	);
#else
	const char *p = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-0123456789";
	while ( (*p) ) {
		if ( T_Char( (*p) ) == c ) return true;
		++p;
	}
	return false;
#endif
}

// cݤȽǤ
template < typename T_Char >
bool IsNumeric( T_Char c )
{
	const char *p = "0123456789";
	while ( (*p) ) {
		if ( T_Char( (*p) ) == c ) return true;
		++p;
	}
	return false;
}

///////////////////////////////////////////////////////////////////////////
// CHighlightMgr COBOLץιʸĴɽԤ

template < typename T_Char, typename T_TxtPtr, typename T_CBPtr >
class CHighlightMgr_cbl
{
public:
	CHighlightMgr_cbl(){};
	virtual ~CHighlightMgr_cbl(){};

	// 
	bool Initialize( const char *pKeywordListName )
	{
		return KeywordList.Initialize( pKeywordListName, false );
	};

	// Ƥο򹹿
	// pSTxtϹƬݥȤƤꡢpETxtϹݥȤƤΤȲꤹ
	void FullUpdate( T_TxtPtr pSTxt, T_TxtPtr pETxt, T_CBPtr pSCB ) const
	{
		if ( pSTxt == pETxt ) return ;	// ƥĹ0ʤФϤʤ
		PartryUpdate( pSTxt, pETxt, pSCB );
	};

	// ѹȼ
	void UpdateWidthChange(
		T_TxtPtr pSTxt,		// ƥȻü
		T_TxtPtr pETxt,		// ƥü
		T_TxtPtr pUpdateSPosTxt,	// ѹϰ
		T_CBPtr pUpdateSPosCB,		// ѹϰ֤Υ顼Хåե
		T_TxtPtr pUpdateEPosTxt		// ѹλ
		) const
	{
		// öäƤ顢ʤ
		// ϰ֤ϡѹϰ֤ԤιƬ
		// λ֤ϡѹ̰֤ΤԤι

		if ( pSTxt == pETxt ) return ;	// ƥĹ0ʤФϤʤ

		// ѹϰ֤Ƭޤǰư롣
		if ( !( pUpdateSPosTxt == pSTxt ) && (*pUpdateSPosTxt) == T_Char( '\n' ) ) {
			--pUpdateSPosTxt;	// ϰ֤ԥɾˤäϡ
			--pUpdateSPosCB;	// ιԤιƬޤǰưɬפ
		}
		while ( !( pUpdateSPosTxt == pSTxt ) && !( (*pUpdateSPosTxt) == T_Char( '\n' ) ) ) {
			--pUpdateSPosTxt;	// βԥɤޤǰư롣
			--pUpdateSPosCB;
		}
		if ( (*pUpdateSPosTxt) == T_Char( '\n' ) && !( pUpdateSPosTxt == pETxt ) ) {
			++pUpdateSPosTxt;	// ȯԥɤμʸذư
			++pUpdateSPosCB;
		}
		if ( pUpdateSPosTxt == pETxt ) {
			--pUpdateSPosTxt;
			--pUpdateSPosCB;
		}

		// ѹλ֤ޤǰư
		while ( !( pUpdateEPosTxt == pETxt ) && !( (*pUpdateEPosTxt) == T_Char( '\n' ) ) ) {
			++pUpdateEPosTxt;
		}
		if ( !( pUpdateEPosTxt == pETxt ) )
			++pUpdateEPosTxt;

		// 
		PartryUpdate( pUpdateSPosTxt, pUpdateEPosTxt, pUpdateSPosCB );
	};

private:
	// ꤵ줿ϰϤ򹹿
	void PartryUpdate( T_TxtPtr pSTxt, T_TxtPtr pETxt, T_CBPtr pSCB ) const
	{
		T_TxtPtr wpSTxt;
		while ( !( pSTxt == pETxt ) ) {
			wpSTxt = pSTxt;

			// 
			while ( !( pSTxt == pETxt ) && !( (*pSTxt) == T_Char( '\n' ) ) )
				++pSTxt;
			// Ԥ򹹿
			UpdateLine( &wpSTxt, pSTxt, &pSCB );
			if ( !( pSTxt == pETxt ) ) {
				// ԥɤοꤹ
				(*pSCB) = CCT_ALPHANUMERIC;
				++pSTxt;
				++pSCB;
			}
		}
	}

	// ꤵ줿Ԥ򹹿
	// (*ppSTxt)pETxtޤǤδ֤ˤϲԥɤ¸ߤʤΤȤ
	void UpdateLine( T_TxtPtr *ppSTxt, T_TxtPtr pETxt, T_CBPtr *ppSCB ) const
	{
		int i;
		T_TxtPtr wpSTxt;

		// ꤵ줿Ԥ0ʸʤСϤʤ
		if ( (*ppSTxt) == pETxt ) return ;

		// Ƭζϥåפ
		// SkipSpace( ppSTxt, pETxt, ppSCB );

		// ƬϤޤ6ʸοϡϢֹȸʤ
		i = 0;
		while ( !( (*ppSTxt) == pETxt ) && IsNumeric( (**ppSTxt) ) && i < 6 ) {
			(**ppSCB) = CCT_SEQUENCE_NUMBER;
			++(*ppSCB);
			++(*ppSTxt);
			i++;
		}
		if ( (*ppSTxt) == pETxt ) return ;

		// 򥹥åפ
		SkipSpace( ppSTxt, pETxt, ppSCB );
		if ( (*ppSTxt) == pETxt ) return ;

		// Ϣֹʹߡǽ˽иʳʸ*⤷/ǤäϡιƤ򥳥ȤȤ
		if ( (**ppSTxt) == T_Char( '*' ) || (**ppSTxt) == T_Char( '/' ) ) {
			while ( !( (*ppSTxt) == pETxt ) ) {
				(**ppSCB) = CCT_COMENT;
				++(*ppSCB);
				++(*ppSTxt);
			}
			return ;
		}

		while ( !( (*ppSTxt) == pETxt ) ) {
			// ե٥åȤν
			if ( IsAlphaNumeric( (**ppSTxt) ) ) {
				LookupKeyword( ppSTxt, pETxt, ppSCB );
				continue;
			}

			// ʸν
			if ( (**ppSTxt) == T_Char( '\"' ) || (**ppSTxt) == T_Char( '\'' ) ) {
				SkipString( ppSTxt, pETxt, ppSCB );
				continue;
			}

			// ν
			if ( (**ppSTxt) == T_Char( ' ' ) || (**ppSTxt) == T_Char( '\t' ) ) {
				SkipSpace( ppSTxt, pETxt, ppSCB );
				continue;
			}

			// ʳʸ
			wpSTxt = (*ppSTxt);
			++wpSTxt;
			if ( !( wpSTxt == pETxt ) ) {
				if ( (**ppSTxt) == T_Char( '*' ) && (*wpSTxt) == T_Char( '>' ) ) {
					// *>ʹߤϡƥȤȤ롣
					while ( !( (*ppSTxt) == pETxt ) ) {
						(**ppSCB) = CCT_COMENT;
						++(*ppSCB);
						++(*ppSTxt);
					}
					return ;
				}
			}

			// ̾Υƥ
			(**ppSCB) = CCT_ALPHANUMERIC;
			++(*ppSCB);
			++(*ppSTxt);
		}
	}

	// 
	void SkipSpace( T_TxtPtr *ppSTxt, T_TxtPtr pETxt, T_CBPtr *ppSCB ) const
	{
		// 򥹥åפ
		while ( !( (*ppSTxt) == pETxt ) && ( (**ppSTxt) == T_Char( ' ' ) || (**ppSTxt) == T_Char( '\t' ) ) ) {
			(**ppSCB) = CCT_ALPHANUMERIC;
			++(*ppSCB);
			++(*ppSTxt);
		}
	}

	// ֥륯ơڤӥ󥰥륯ơ
	void SkipString( T_TxtPtr *ppSTxt, T_TxtPtr pETxt, T_CBPtr *ppSCB ) const
	{
		T_Char ch = (**ppSTxt);
		do {
			(**ppSCB) = CCT_STRING;
			++(*ppSCB);
			++(*ppSTxt);
		} while ( !( (*ppSTxt) == pETxt ) && !( (**ppSTxt) == ch ) );
		if ( (*ppSTxt) == pETxt ) return ;

		// ü¦Υơν
		(**ppSCB) = CCT_STRING;
		++(*ppSCB);
		++(*ppSTxt);
	}

	// ե٥åȤ
	void LookupKeyword( T_TxtPtr *ppSTxt, T_TxtPtr pETxt, T_CBPtr *ppSCB ) const
	{
		char c;
		CKeywordFinder< T_Char, false > Finder( &KeywordList.GetKeywordList() );
		T_CBPtr wpCB = (*ppSCB);

		// ѿ
		while ( !( (*ppSTxt) == pETxt ) && IsAlphaNumeric( (**ppSTxt) ) ) {
			Finder.AddChar( (**ppSTxt) );
			++(*ppSTxt);
			++(*ppSCB);
		}

		// ꤹ뿧ꤹ
		if ( Finder.IsFound() )
			c = CCT_KEYWORD;
		else
			c = CCT_ALPHANUMERIC;

		// ꤹ
		while ( !( wpCB == (*ppSCB) ) ) {
			(*wpCB) = c;
			++wpCB;
		}
	}

protected:
	CKeywordList KeywordList;
};

} // namespace NLangExt_cbl

} // namespace NLangExt

#endif // HIGHLIGHTMGR_CBL_H_INCLUDED_
