////////////////////////////////////////////////////////////////////
// LinePseudoPtr.h
// CLinePseudoPtr饹Υץơ
// T_LineDataФ뵿ݥ󥿡ʸФΤȡФΤȤ
////////////////////////////////////////////////////////////////////

#if !defined( LINEPSEUDOPTR_H_INCLUDED_ )
#define LINEPSEUDOPTR_H_INCLUDED_

#include "../LineData.h"

namespace NLangExt {

class CLinePseudoPtr
{
public:
	CLinePseudoPtr() : pData( NULL ){};
	CLinePseudoPtr( T_LineData *pArgData ) :
		pData( pArgData ), CurLineItr( pArgData->begin() ), CurCharPos( 0 )
	{
		// ԰ʾϥǡ¸ߤ뤳
		assert( pArgData && pArgData->begin() != pArgData->end() );
	};

	CLinePseudoPtr( const CLinePseudoPtr& r ) :
		pData( r.pData ), CurLineItr( r.CurLineItr ), CurCharPos( r.CurCharPos )
	{};

	// ֤
	void SetPos( T_CurPos c )
	{
		assert( this && pData );
		CurLineItr = pData->begin() + c.GetLine();
		CurCharPos = c.GetCPos();
	};

	// ü
	void SetEnd()
	{
		assert( this && pData );
		CurLineItr = pData->begin() + ( pData->size() - 1 );
		CurCharPos = CurLineItr->length();
	};

	// 
	bool operator ==( const CLinePseudoPtr &r ) const
	{
		assert( this && pData );
		assert( pData == r.pData );
		return CurLineItr == r.CurLineItr && CurCharPos == r.CurCharPos;
	};
	bool operator <( const CLinePseudoPtr &r ) const
	{
		assert( this && pData );
		assert( pData == r.pData );
		if ( CurLineItr < r.CurLineItr )
			return true;
		if ( CurLineItr > r.CurLineItr )
			return false;
		if ( CurCharPos < r.CurCharPos )
			return true;
		return false;
	};
	bool operator >( const CLinePseudoPtr &r ) const
	{
		assert( this && pData );
		assert( pData == r.pData );
		return !( this->operator ==( r ) ) && !( this->operator <( r ) );
	};

	// 
	const CLinePseudoPtr& operator =( const CLinePseudoPtr &r )
	{
		pData = r.pData;
		CurLineItr = r.CurLineItr;
		CurCharPos = r.CurCharPos;
		return (*this);
	};

	// ǥ
	const CLinePseudoPtr& operator --()
	{
		assert( this && NULL != pData );
		assert( pData->begin() != CurLineItr || CurCharPos > 0 );
		if ( 0 == CurCharPos ) {
			--CurLineItr;
			CurCharPos = CurLineItr->length();
		}
		else {
			--CurCharPos;
		}
		return (*this);
	};

	// 󥯥
	const CLinePseudoPtr& operator ++()
	{
		assert( this && NULL != pData );
		assert( pData->begin() + ( pData->size() - 1 ) != CurLineItr ||
			CurCharPos < CurLineItr->length() );
		if ( CurCharPos == CurLineItr->length() ) {
			CurCharPos = 0;
			++CurLineItr;
		}
		else {
			++CurCharPos;
		}
		return (*this);
	};

protected:

	// ǡ
	T_LineData *pData;

	// ߥݥȤƤ
	T_LineDataItr CurLineItr;
	int CurCharPos;
};

// ƥ
class CLinePseudoPtr_txt : public CLinePseudoPtr
{
public:
	CLinePseudoPtr_txt() : CLinePseudoPtr(){};
	CLinePseudoPtr_txt( T_LineData *pArgData ) : CLinePseudoPtr( pArgData ) {};
	virtual ~CLinePseudoPtr_txt(){};

	// 
	wchar_t operator *() const
	{
		if ( pData->begin() + ( pData->size() - 1 ) == CurLineItr &&
			CurCharPos == CurLineItr->length() )
			return NULL;	// ʸü
		if ( CurCharPos == CurLineItr->length() )
			return L'\n';	// Ԥ
		return (*CurLineItr)[ CurCharPos ].moji;
	};
};

// 
class CLinePseudoPtr_clr : public CLinePseudoPtr
{
public:
	// 黻Ҥˤäƽ񤭴뤿Υ֥
	class CLinePseudoPtr_clr_work
	{
	public:
		CLinePseudoPtr_clr_work( T_LineDataItr argItr, int argCpos ) :
			itr( argItr ), cpos( argCpos ){};

		// 
		operator unsigned char() const
		{
			return itr->getIro( cpos );
		};

		// 
		unsigned char operator =( unsigned char c )
		{
			itr->setIro( cpos, c );
			return c;
		};
	private:
		T_LineDataItr itr;
		int cpos;
	};

	CLinePseudoPtr_clr() : CLinePseudoPtr(){};
	CLinePseudoPtr_clr( T_LineData *pArgData ) : CLinePseudoPtr( pArgData ) {};
	virtual ~CLinePseudoPtr_clr(){};


	// 
	CLinePseudoPtr_clr_work operator *()
	{
		// ϡХåեΰ賰λȤʤ
		assert( pData->begin() + ( pData->size() - 1 ) != CurLineItr ||
			CurCharPos < CurLineItr->length() );
		return CLinePseudoPtr_clr_work( CurLineItr, CurCharPos );
	};
};

}; // namespace NLangExt

#endif // LINEPSEUDOPTR_H_INCLUDED_
