////////////////////////////////////////////////////////////////////////////
// CUndoListMgr 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEdit_std.h"
#include "UndoListMgr.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CUndoListMgr::CUndoListMgr() :
	listUndo(),
	itrUndo(),
	MaxUndoCount( 1000 )
{
	Clear();
}

CUndoListMgr::CUndoListMgr( const CUndoListMgr &r ) :
	listUndo( r.listUndo ),
	itrUndo( r.itrUndo ),
	MaxUndoCount( r.MaxUndoCount )
{

}

CUndoListMgr::~CUndoListMgr()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// Undoǽʺ
void CUndoListMgr::SetMaxUndoCount( int argCnt )
{
	assert( NULL != this && argCnt > 0 && argCnt <= INT_MAX );
	MaxUndoCount = argCnt;
}

// ɥǽݤ
bool CUndoListMgr::EnableUndo() const
{
	list< pair< bool, list< VClsPtr< CEditCommand > > > >::const_iterator wItr;
	assert( NULL != this );

	// ꥹȤΥ0ʤ顢⤽UndoԲǽǤ
	if ( listUndo.size() == 0 ) return false;

	// Ƭ򼨤ƤUndoԲǽ
	if ( listUndo.begin() == itrUndo ) return false;

	// 򼨤ƤUndoǽ
	if ( listUndo.end() == itrUndo ) return true;

	// ߤΥꥹȤꤵƤʤUndoԲ
	if ( !itrUndo->first ) return false;

	return true;
}

// ɥǽݤ
bool CUndoListMgr::EnableRedo() const
{
	assert( NULL != this );

	// ꥹȤΥ0ʤ顢⤽RedoԲǽǤ
	if ( listUndo.size() == 0 ) return false;

	// 򼨤ƤRedoԲ
	if ( listUndo.end() == itrUndo ) return false;

	// ߤΥꥹȤꤵƤʤRedoԲ
	if ( !itrUndo->first ) return false;

	return true;
}

// UndoѤԽޥɥ֥Ȥ
list< VClsPtr< CEditCommand > > CUndoListMgr::GetUndoObj()
{
	list< VClsPtr< CEditCommand > > wList;

	assert( NULL != this && EnableUndo() );

	itrUndo--;

	// ս¤ؤ
	wList = itrUndo->second;
	wList.reverse();

	return wList;
}

// RedoѤԽޥɥ֥Ȥ
list< VClsPtr< CEditCommand > > CUndoListMgr::GetRedoObj()
{
	list< pair< bool, list< VClsPtr< CEditCommand > > > >::iterator  wItr;

	wItr = itrUndo;
	itrUndo++;

	return wItr->second;
}

// Խޥɥ֥Ȥɲä
void CUndoListMgr::PushBack( VClsPtr< CEditCommand > pObj )
{
	assert( NULL != this );

	// itrUndoλؤƤꥹȤꤵ줿ʪǤäϡȾʬ
	if ( itrUndo != listUndo.end() ) {
		if ( itrUndo->first ) {
			listUndo.erase( itrUndo, listUndo.end() );
			itrUndo = listUndo.end();
		}
	}

	if ( itrUndo == listUndo.end() ) {
		// ꥹȤɲ
		list< VClsPtr< CEditCommand > > dmy;
		listUndo.push_back( pair< bool, list< VClsPtr< CEditCommand > > >( false, dmy ) );
		itrUndo--;

		// ꥹȤĶϡƬΤΤ
		if ( listUndo.size() > MaxUndoCount ) {
			list< pair< bool, list< VClsPtr< CEditCommand > > > >::iterator wItr = listUndo.begin();
			wItr++;
			listUndo.erase( listUndo.begin(), wItr );
		}
	}

	// Ǥɲä
	itrUndo->second.push_back( pObj );
}

// ԽλȤ򼨤
void CUndoListMgr::EndEdit()
{
	itrUndo->first = true;
	itrUndo = listUndo.end();
}

// 
void CUndoListMgr::Clear()
{
	assert( NULL != this );
	listUndo.clear();
	itrUndo = listUndo.end();
}

// ꥹȤ򴹤
void CUndoListMgr::Swap( CUndoListMgr *p )
{
	assert( this && p );

	list< pair< bool, list< VClsPtr< CEditCommand > > > >::iterator wItr;
	int wInt;

	wInt = this->MaxUndoCount;
	this->MaxUndoCount = p->MaxUndoCount;
	p->MaxUndoCount = wInt;

	wItr = this->itrUndo;
	this->itrUndo = p->itrUndo;
	p->itrUndo = wItr;

	listUndo.swap( p->listUndo );
}

// 
const CUndoListMgr& CUndoListMgr::operator =( const CUndoListMgr &r )
{
	listUndo = r.listUndo;
	itrUndo = r.itrUndo;
	MaxUndoCount = r.MaxUndoCount;
	return (*this);
}
