////////////////////////////////////////////////////////////////////////////
// CTaEditDraw 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( TAEDITDRAW_H_INCLUDED_ )
#define TAEDITDRAW_H_INCLUDED_

#include "output/gui.h"

#include "ScrollInfoPacket.h"
#include "TaEditDoc.h"
#include "ScrollMgr.h"
#include "Cursor.h"
#include "Mouse.h"
#include "GCStorage.h"
#include "GCMgr.h"
#include "XimMgr.h"
#include "TextEdit.h"
#include "DrewLineCash.h"
#include "TEDrawPopup.h"


class CTaEditDraw :
	public CDraw,
	public CScrEventHandler
{
public:
	CTaEditDraw();
	CTaEditDraw( const CTaEditDraw &r );	// ʣʶػߡ
	~CTaEditDraw();

	// ʶػߡ
	const CTaEditDraw& operator =( const CTaEditDraw &r );

	// 
	void OnCreate( Widget argWgt, XtPointer user_data );

	// ˲
	void OnDestroy( Widget argWgt, XtPointer user_data );

	// ץλ
	void OnExit();

	// ɥȤɤ߹ޤ줿
	void OnReadDocument();

	// СΥ֥Ȥ
	void SetScrollMgr( CScrollMgr *argpH, CScrollMgr *argpV );

	// ޥ
	void OnMouse( Widget w, XEvent *event, Boolean *continue_to_dispatch );

	// ޥݥ󥿤ΰư
	void OnPointerMotion( Widget w, XEvent *event, Boolean *continue_to_dispatch );

	// ޥ٥
	void OnTimer();

	// ƥȤι⤵
	int GetTextHeight() const;
	int GetTextAscent() const;

	// 
	void DrawCursor( int x, int y ) const;
protected:
	void DrawCursor( int x, int y, Drawable drawable ) const;
public:

	// ȹԤβ
	void DrawCurLineUnderbar( int curline, bool flg ) const;
protected:
	void DrawCurLineUnderbar( int curline, bool flg, Drawable drawable ) const;
public:

	// ʸ
	int GetCharWidth( wchar_t c, int xpos ) const;

	// ־褷ƤԤιֹ
	int GetTopLineNum() const;

	// ϰϤκüΥԥΰ֤
	int GetLeftPixPos() const;

	// ӥ塼ǤԿ
	int GetViewLineCnt() const;

	// ӥ塼
	int GetViewWidth() const;

	// ĥ
	void ScrollV( int y, bool NeedRedraw );

	// 
	void ScrollH( int x, bool NeedRedraw );

	// ̾Xɸ顢鲿ʸܤ򻻽Ф
	// pixXLeftColumnWidthˤƵXɸǤ
	int XPosToCharNum( int lineY, int pixX ) const;

	// ̾κɸ顢ʸ֤򻻽Ф
	// pixXLeftColumnWidthˤƵXɸǤ
	T_CurPos PixPosToCurPos( int pixX, int pixY ) const;

	// ̤˲褷Ƥ뤫
	// ʸƤФ١褹٤׹Կ׻
	int GetDrawedLineCnt() const;

	VClsPtr< CTextEdit > GetTextEditor();	// Խ֥Ȥ
	VClsPtr< CCursor > GetCursorInfo();		// ֥Ȥ
	const CCursor* GetCursorInfo() const;

	// ԽκԤ
	void AfterEditRedraw( const ScrollInfoPacket &rScrPacket );

	// ϰϤѲκԤ
	void AfterSelRangeRedraw( int argSLine, int argELine );

	// եξ֤
	bool GetForcusState() const;

protected:
	// ϥХå
	void OnInput( Widget argWgt, XtPointer user_data );

	// ϥ٥
	void OnKey( Widget w, XEvent *event, Boolean *continue_to_dispatch );

	// ɽ
	void OnExpose( Widget argWgt, XtPointer user_data );

	// ѹ
	void OnResize( Widget argWgt, XtPointer user_data );

	// եν
	void OnForcus( Widget w, XEvent *event, Boolean *continue_to_dispatch );

	// ޥܥβ
	void OnMouse2Push( XButtonPressedEvent* event );

	// ޥαܥβ
	void OnMouse3Push( XButtonPressedEvent* event );

	// ޥΥܥˤؤΥ
	void OnMouseScrollUp( XButtonPressedEvent* event );

	// ޥΥܥˤ벼ؤΥ
	void OnMouseScrollDown( XButtonPressedEvent* event );

	// ɥåץ٥
	void OnDrop( DtDndTransferCallbackStruct *pCallbackData );

	// С줿
	void OnScrValueChange( const CScrollMgr *argpMgr, int value, bool NeedRedraw );

	// ΰΥ
	void GetSize( int *pX, int *pY ) const;

	// ̡΢̡ˤ򥯥ꥢ
	void ClearBackScreen();

	// 
	void OnRedraw( enumREDRAWTYPE type , int argSLine, int argELine );
	void OnRedraw( enumREDRAWTYPE type );

	// ʸ־Ѥʸ
	void DrawString_ReuseCharInfo( Display *pDisplay, Drawable argDrawable, int XPos, int YPos, const T_LineDataItr_c &rItr, int LineNum, int ViewWidth, bool IsLastLine ) const;

	// ̤λꤵ줿֤ʸ
	void DrawString( Display *pDisplay, Drawable argDrawable, int XPos, int YPos, const T_LineDataItr_c &rItr, int StrSPos, int StrCnt, int LineNum, bool IsLastLine ) const;

	// TAB
	void DrawTab( Display *pDisplay, Drawable argDrawable, int s, int e, const CDrawCharPos& rDrawCharPos, int width, int XPos, int YPos, GC ClearGC, GC EditMarkGC ) const;

	// Եɽ
	void DrawRetMark( Display *pDisplay, Drawable drawable, int x, int y, GC ClearGC, GC EditMarkGC ) const;

	// ¦Υ
	void DrawLeftColumn( Display *pDisplay, Drawable argDrawable, int YPos, const T_LineDataItr_c &rItr, int LineNumber ) const;


	// ǽ˲̤ɽȤΥ٥
	void OnFirstExpose();

	// եξ֤ѲФ륤٥ȥϥɥ
	static void OnForcusEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch );

	// ܡϤФ륤٥ȥϥɥ
	static void OnKeybordEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch );

	// ޥФ륤٥ȥϥɥ
	static void OnMouseEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch );

	// ޥݥ󥿤ΰưФ륤٥ȥϥɥ
	static void OnPointerMotionEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch );

	// ɥåפ줿ȤΥХå
	static void OnDropCallback( Widget w, XtPointer client_data, XtPointer callback_data );

protected:
	// ֥Хåեѥԥåޥå
	Pixmap BackgndPixmap;

	// ־褷Ƥ
	int numTopLine;

	VClsPtr< CCursor > pCursorInfo;	// ֥
	VClsPtr< CMouse > pMouseInfo;	// ޥ֥
	VClsPtr< CGCStorage > pGCStorage;	// GCݻ֥
	VClsPtr< CGCMgr > pGCMgr;	// GC֥
	VClsPtr< CXimMgr > pXimMgr;	// XIM֥
	VClsPtr< CTextEdit > pTextEditor;	// Խ֥

	int MaxLengthPix;	// äȤĹԤ褹Τפԥ
	int DrawedLineCnt_hoz;	// ߲̤˲褷Ƥ뤫¸ѡ
	vector< CDrewLineCash > vDrewLD;	// 褷ƤԤ˴ؤ

	XFontSet fontSet;	// եȥå
	int TextHeight;	// ƥȤι⤵ʹԴ֤Υޡޤ
	int FontHeight;	// եȤι⤵ʹԴ֤Υޡޤޤʤʸι⤵
	int TextAscent;	// ƥȤξȾʬι⤵
	int TabWidth;	// ֤
	enumTABWIDTHCALCMETHOD TabWidth_CM;	// η׻ˡ
	const wstring *pTabString;	// ֥Ϥʸ

	CScrollMgr *pHScrollMgr;	// ʿС
	CScrollMgr *pVScrollMgr;	// ľС

	bool IsFirstExposed;	// ǽβɽäݤ

	bool ForcusState;	// եξ
						// եƤп

	int LeftColumnWidth;	// ¦˾˳ݤΰ

};

#endif // TAEDITDRAW_H_INCLUDED_

