////////////////////////////////////////////////////////////////////////////
// CTaEditDoc 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEdit_std.h"
#include "TaEditDoc.h"
#include "TaEditShell.h"
#include "FileReader.h"
#include "FileWriter.h"


////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTaEditDoc::CTaEditDoc() :
	vecLine(),
	FileName(),
	IsModify( false ),
	UndoListMgr(),
	EncodeInfo(),
	pTxtColorMgr( NULL )
{
	FileName = "";
	UndoListMgr.Clear();
	vecLine.clear();
}

CTaEditDoc::~CTaEditDoc()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// եɤ߹
CErrorBool CTaEditDoc::OnOpenDocument( const string &argFileName, bool *pIsChanged, enumLANGTYPE LangType, const CEncodeInfo &rEncode )
{
	assert( NULL != this && NULL != pIsChanged );
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int ShowDlgDelay = pConf->GetShowPrecessingDlgDelay();
	CFileReader *pReader;
	CErrorBool r;
	T_LineData wLineData;

	(*pIsChanged) = false;

	r = CheckFileStatus( argFileName, true );
	if ( !r ) return r;

	// ɤ߹ѥ֥Ȥ
	pReader = new CFileReader();
	if ( NULL == pReader )
		return CErrorBool( pConf->RefOutOfMemoryErrorMsg() );
	pReader->SetInfo( argFileName, rEncode, &wLineData );

	// ɤ߹
	if ( m_ProcessingShell->ShowDlg( pReader, ShowDlgDelay ) ) {
		// Ǥ줿
		(*pIsChanged) = false;
		delete pReader;
		return true;
	}

	r = pReader->GetErrorInfo();
	delete pReader;
	pReader = NULL;

	if ( !r ) {
		(*pIsChanged) = false;
		return r;
	}

	(*pIsChanged) = true;
	vecLine.swap( wLineData );
	wLineData.clear();

	// ե̾
	FileName = GlbFunc::ResolvPath( argFileName );
	EncodeInfo = rEncode;

	// ¸󥪥֥Ȥ򹹿
	if ( LANGTYPE_NAN == LangType )
		r = UpdateTextColorMgr( NULL );	// ꤬ʤ
	else
		r = SetTxtColorMgr( LangType );	// ꤵƤ

	// ե饰򤪤
	// ʥեɤ߹ϡ
	// CTaEditDraw::OnReadDocument¹Ԥ뤿ᡢȥκϹԤʤ
	IsModify = false;

	// UndoꥹȤ
	UndoListMgr.Clear();

	return r;
}

// եν
// pColChanged : 󤬹줿Ͽꤵ
CErrorBool CTaEditDoc::OnSaveDocument( const string &argFileName, bool *pColChanged, const CEncodeInfo &rEncode )
{
	assert( NULL != this );

	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int ShowDlgDelay = pConf->GetShowPrecessingDlgDelay();
	bool UseTmpFile = pConf->GetUseWriteTmpFile();
	CFileWriter *pWriter;
	CErrorBool r;
	struct stat StatusInfo;

	if ( pColChanged ) (*pColChanged) = false;

	// եξ֤ǧʥե뤬¸ߤɬפϤʤ
	r = CheckFileStatus( argFileName, false );
	if ( !r ) return r;

	// ե뤬¸ߤʤϡƥݥեؤνϤϹԤʤ
	if ( lstat( argFileName.c_str(), &StatusInfo ) )
		UseTmpFile = false;

	// 񤭹ѥ֥Ȥ
	pWriter = new CFileWriter();
	if ( NULL == pWriter )
		return CErrorBool( pConf->RefOutOfMemoryErrorMsg() );
	pWriter->SetInfo( argFileName, rEncode, &vecLine, UseTmpFile );

	// 񤭹
	if ( m_ProcessingShell->ShowDlg( pWriter, ShowDlgDelay ) )
		goto INTRERRUPT_EXIT;

	r = pWriter->GetErrorInfo();

	// ƥݥեؤǤ硢ĩ魯
	if ( UseTmpFile && pWriter->GetFaultWithTmpFlg() ) {
		// ĩ魯뤫ݤǧ
		int sel = m_TaEditShell->ShowQuestionMsgBox( pConf->RefRetryWithoutSaveTmpFileMsg(), false );
		if ( 1 == sel ) {
			// ĩ
			pWriter->SetInfo( argFileName, rEncode, &vecLine, false );
			if ( m_ProcessingShell->ShowDlg( pWriter, ShowDlgDelay ) )
				goto INTRERRUPT_EXIT;
			r = pWriter->GetErrorInfo();
		}
		else {
			// ĩ路ʤϡ顼֤ʤ
			// ʥ桼ϤǤ˥顼ȯȤΤäƤ뤿
			goto INTRERRUPT_EXIT;
		}
	}

	// 񤭹ѥ֥Ȥ˴
	delete pWriter;
	pWriter = NULL;

	if ( !r ) return r;

	// ե¸顢ɥȤΥե̾ꤹ롣
	FileName = GlbFunc::ResolvPath( argFileName );
	EncodeInfo = rEncode;
	SetModifyFlg( false );	// ե饰򤪤

	// Ԥιե饰򤪤
	if ( pConf->GetModifyLineMarkNumber() >= 0 ) {
		int i;
		for ( i = 0; i < vecLine.size(); i++ ) {
			vecLine[i].SetExtendInfo( pConf->GetModifyLineMarkNumber(), false );
		}
	}

	// ¸UndoꥹȤ˴ԤϡUndoꥹȤ
	if ( pConf->GetClearUndoOnSave() ) {
		UndoListMgr.Clear();
	}

	// ¸󥪥֥Ȥ򹹿
	return UpdateTextColorMgr( pColChanged );

INTRERRUPT_EXIT:
	// 񤭹ѥ֥Ȥ˴
	delete pWriter;
	pWriter = NULL;
	return true;
}

// ե̾λ
const string& CTaEditDoc::GetFileName() const
{
	return FileName;
}

// 
void CTaEditDoc::Initialize()
{
	CLineData dummy;

	vecLine.clear();
	FileName = "";
	EncodeInfo.Initialize();

	UndoListMgr.Clear();	// ɥꥹȤ򥯥ꥢ
	UndoListMgr.SetMaxUndoCount( m_TaEditShell->GetConfigInfo()->GetMaxUndoCount() );

	// ιԤϿ
	vecLine.push_back( dummy );

	// ¸󥪥֥Ȥ򹹿
	UpdateTextColorMgr( NULL );

	// ե饰򤪤
	// ʥɥȤϡ
	// CTaEditDraw::OnReadDocument¹Ԥ뤿ᡢȥκϹԤʤ
	IsModify = false;
}

// ʸ
CErrorBool CTaEditDoc::Insert( const wstring& rStr, const T_CurPos &rCurPos, const T_SelRange &rSelRange, T_CurPos *pResultCurPos )
{
	T_CurPos wCurPos = rCurPos;
	int i;
	int LineCnt, CharCnt;
	VClsPtr< CEditCommand > wpEditCommand;
	CErrorBool r;

	(*pResultCurPos) = rCurPos;
	if ( vecLine.size() <= rCurPos.GetLine() ) return true;
	SetModifyFlg( true );	// ե饰򤿤Ƥ

	// 򤵤ƤϰϤ
	if ( rSelRange.GetLength() > T_CurPos( 0, 0 ) ) {
		r = Delete_WithCreateEC( rSelRange, rCurPos );
		if ( !r ) return r;
		wCurPos = rSelRange.GetSPos();
		(*pResultCurPos) = wCurPos;
	}

	// ԤĹǧ
	CharCnt = wCurPos.GetCPos();
	LineCnt = 0;
	for ( i = 0; i < rStr.length(); i++ ) {
		CharCnt++;
		if ( rStr[i] == L'\n' ) {
			CharCnt = 0;
			LineCnt++;
		}
		if ( CharCnt >= TA_MAX_LINE_SIZE ) {
			return CErrorBool( m_TaEditShell->GetConfigInfo()->RefBrokenLineMsg() );
		}
	}
	// ʤλLineCntˤɲäԤιԿ-1
	// CharCntˤϺǸιԤɲäʸǼƤ롣
	// ʤɲäǡԤäϡ֤Ȥʤ
	if ( CharCnt + vecLine[ wCurPos.GetLine() ].length() - wCurPos.GetCPos() >= TA_MAX_LINE_SIZE )
		return CErrorBool( m_TaEditShell->GetConfigInfo()->RefBrokenLineMsg() );

	// ͤ
	T_CurPos RetACPT( wCurPos.GetLine() + LineCnt, CharCnt );

	// Խޥɥ֥Ȥ
	wpEditCommand = CreateEditCommandObj( TEC_INSERT );
	if ( !wpEditCommand.IsNull() ) {
		if ( rSelRange.GetLength() > T_CurPos( 0, 0 ) )
			wpEditCommand->SetCurPos_SelRange( rSelRange, wCurPos, T_SelRange( RetACPT, RetACPT ), RetACPT );
		else {
			T_SelRange ws = T_SelRange( wCurPos, wCurPos );
			wpEditCommand->SetCurPos_SelRange( ws, wCurPos, T_SelRange( RetACPT, RetACPT ), RetACPT );
		}
		wpEditCommand->SelInsertInfo( wCurPos, rStr );
		UndoListMgr.PushBack( wpEditCommand );
	}

	// ʸ
	InsertSpecifiedStr( wCurPos, rStr );

	(*pResultCurPos) = RetACPT;
	return true;
}

// ü쵭
// pResultCurPos˥ꤹ٤֤֤
CErrorBool CTaEditDoc::InsertSpecialCode( KeySym argKeySym, const T_CurPos &rCurPos, const T_SelRange &rSelRange, T_CurPos *pResultCurPos )
{
	int i;
	VClsPtr< CEditCommand > wpEditCommand;
	const int cpos = rCurPos.GetCPos();
	const int line = rCurPos.GetLine();
	T_CurPos RetACPT;
	T_CurPos wpos;
	CErrorBool r;

	SetModifyFlg( true );	// ե饰򤿤Ƥ
	(*pResultCurPos) = rCurPos;

	// ϰ򤵤Ƥ
	if ( rSelRange.GetLength() > T_CurPos( 0, 0 ) ) {
		// 򤵤ƤϰϤ
		r = Delete_WithCreateEC( rSelRange, rCurPos );
		if ( !r ) return r;

		// BackSpaceDeleteä
		if ( argKeySym == XK_BackSpace || argKeySym == XK_Delete ) {
			// ϰϤƬͤȤơλ
			(*pResultCurPos) = rSelRange.GetSPos();
			return true;
		}
	}

	switch ( argKeySym ) {
	case XK_BackSpace:
		if ( cpos <= 0 && line <= 0 ) return true;// Ǥʤ
		if ( 0 == cpos )
			// ԤƬäϡιԤ鸽ߤιԤƬޤǤ
			RetACPT = T_CurPos( line - 1, vecLine[ line - 1 ].length() );
		else
			// ʸ
			RetACPT = T_CurPos( line, cpos - 1 );
		(*pResultCurPos) = RetACPT;
		r = Delete_WithCreateEC( T_SelRange( RetACPT, rCurPos ), rCurPos );
		return r;

	case XK_Delete:
		if ( line >= vecLine.size() - 1 && cpos >= vecLine[ line ].length() )
			return true;	// Ǥʤ
		RetACPT = rCurPos;
		if ( cpos == vecLine[ line ].length() )
			// Ԥäϡ֤߰鼡ιԤƬޤǤ
			wpos = T_CurPos( line + 1, 0 );
		else
			// ߻ؤƤʸ
			wpos = T_CurPos( line, cpos + 1 );
		r = Delete_WithCreateEC( T_SelRange( rCurPos, wpos ), rCurPos );
		return r;

	case XK_KP_Enter:
	case XK_Return:
		RetACPT = T_CurPos( rSelRange.GetSPos().GetLine() + 1, 0 );
		(*pResultCurPos) = RetACPT;

		// Խޥɥ֥Ȥۤ
		wpEditCommand = CreateEditCommandObj( TEC_INSERT );
		if ( !wpEditCommand.IsNull() ) {
			if ( rSelRange.GetLength() > T_CurPos( 0, 0 ) ) {
				// ʸ󤬺Ƥ
				T_CurPos wc = rSelRange.GetSPos();
				T_SelRange ws = T_SelRange( wc, wc );
				wpEditCommand->SetCurPos_SelRange( ws, wc, T_SelRange( RetACPT, RetACPT ), RetACPT );
				wpEditCommand->SelInsertInfo( wc, L"\n" );
			}
			else {
				// Ƥʤ
				wpEditCommand->SetCurPos_SelRange( rSelRange, rCurPos, T_SelRange( RetACPT, RetACPT ), RetACPT );
				wpEditCommand->SelInsertInfo( rCurPos, L"\n" );
			}
			UndoListMgr.PushBack( wpEditCommand );
		}
		InsertSpecifiedStr( rSelRange.GetSPos(), L"\n" );
		pResultCurPos->SetCPos( ExecAutoIndent( rSelRange.GetSPos().GetLine() ) );
		return true;
	}
	return CErrorBool( m_TaEditShell->GetConfigInfo()->RefUnexpectedErrorMsg() );
}

// ʣԤؤTAB
CErrorBool CTaEditDoc::MultiLineTabInsert( const T_SelRange &rSelRange, T_CurPos *pResultCurPos, T_SelRange *pResultSelRange )
{
	int sl = rSelRange.GetSPos().GetLine();
	int el = rSelRange.GetEPos().GetLine();
	int i;
	T_CurPos dummyCurPos;
	T_CurPos wCurPos;
	T_SelRange wSelRange;
	CErrorBool r;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const wstring &rStr = pConf->RefTabString();
	const bool InsertTabToEmptyLine = pConf->GetInsertTabToEmptyLine();

	// 򤵤Ƥ롢ƹԤιƬTABʸ
	for ( i = sl; i <= el; i++ ) {
		// ԤˤTabʤ礬
		if ( !InsertTabToEmptyLine && vecLine[i].length() == 0 )
			continue;

		wCurPos = T_CurPos( i, 0 );
		wSelRange = T_SelRange( wCurPos, wCurPos );
		r = Insert( rStr, wCurPos, wSelRange, &dummyCurPos );
		if ( !r ) return r;
	}

	// ϰϤTABʸԤäΤȤ롣
	(*pResultCurPos) = T_CurPos( el, vecLine[ el ].length() );
	(*pResultSelRange) = T_SelRange( T_CurPos( sl, 0 ), (*pResultCurPos) );
	return true;
}

// ʣԤTABκ
CErrorBool CTaEditDoc::MultiLineTabDelete( const T_SelRange &rSelRange, T_CurPos *pResultCurPos, T_SelRange *pResultSelRange )
{
	int sl = rSelRange.GetSPos().GetLine();
	int el = rSelRange.GetEPos().GetLine();
	int i;
	T_CurPos wCurPos;
	T_SelRange wSelRange;
	CErrorBool r;
	const wstring &rStr = m_TaEditShell->GetConfigInfo()->RefTabString();

	// 򤵤Ƥ롢ƹԤιƬ¸ߤTABʸ
	for ( i = sl; i <= el; i++ ) {
		wCurPos = T_CurPos( i, 0 );
		// ƬTABʸʤСԤʤ
		if ( wsncmp( vecLine[i].getString().c_str(), rStr.c_str(), rStr.length() ) == 0 ) {
			wSelRange = T_SelRange( T_CurPos( i, 0 ), T_CurPos( i, rStr.length() ) );
			r = Delete_WithCreateEC( wSelRange, wCurPos );
			if ( !r ) return r;
		}
	}

	// ϰϤTABʸκԤäΤȤ롣
	(*pResultCurPos) = T_CurPos( el, vecLine[ el ].length() );
	(*pResultSelRange) = T_SelRange( T_CurPos( sl, 0 ), (*pResultCurPos) );
	return true;
}

// Խޥɥ֥ȤơʸκԤ
CErrorBool CTaEditDoc::Delete_WithCreateEC( T_SelRange DelRange, T_CurPos BeforeCurPos )
{
	VClsPtr< CEditCommand > wpEditCommand;
	CErrorBool r;

	// ϰϤʸ
	wstring wDelStr;
	GetRangeStr( DelRange, &wDelStr );

	// ʸ
	r = Delete( DelRange );
	if ( !r ) return r;

	// Խޥɥ֥Ȥۤ
	wpEditCommand = CreateEditCommandObj( TEC_DELETE );
	if ( !wpEditCommand.IsNull() ) {
		T_CurPos wc = DelRange.GetSPos();
		wpEditCommand->SetCurPos_SelRange( DelRange, BeforeCurPos, T_SelRange( wc, wc ), wc );
		wpEditCommand->SetDeleteInfo( DelRange, wDelStr );
		UndoListMgr.PushBack( wpEditCommand );
	}
	return true;
}

// ǡλ
const T_LineData& CTaEditDoc::RefData() const
{
	return vecLine;
}

// ե饰
bool CTaEditDoc::GetIsModify() const
{
	return IsModify;
}

// Undoꥹȴ֥Ȥ򻲾
const CUndoListMgr& CTaEditDoc::RefUndoListMgr() const
{
	return UndoListMgr;
}

// ɥ
void CTaEditDoc::Undo( T_SelRange *pAfterUndoSelRange, T_CurPos *pAfterUndoCurPos )
{
	assert( NULL != pAfterUndoSelRange && NULL != pAfterUndoCurPos );
	if ( !UndoListMgr.EnableUndo() ) return ;

	list< VClsPtr< CEditCommand > > ecList;
	list< VClsPtr< CEditCommand > >::const_iterator itr;

	ecList = UndoListMgr.GetUndoObj();

	itr = ecList.begin();
	for (; itr != ecList.end(); ++itr ) {
		// ɥϰϤȥ֤
		(*pAfterUndoSelRange) = (*itr)->GetBeforeSelRange();
		(*pAfterUndoCurPos) = (*itr)->GetBeforeCurPos();

		if ( (*itr)->GetType() == TEC_INSERT ) {
			// ʸԤƤ
			// 줿ʸ
			DelSpecifiedStr( (*itr)->GetInsertPos(), (*itr)->GetInsertText() );
		}
		else {
			// ʸκԤƤ
			// 줿ʸ
			InsertSpecifiedStr( (*itr)->GetDeleteRange().GetSPos(), (*itr)->GetDeleteText() );
		}
	}
}

// ɥ
void CTaEditDoc::Redo( T_SelRange *pAfterRedoSelRange, T_CurPos *pAfterRedoCurPos )
{
	assert( NULL != pAfterRedoSelRange && NULL != pAfterRedoCurPos );
	if ( !UndoListMgr.EnableRedo() ) return ;

	list< VClsPtr< CEditCommand > > ecList;
	list< VClsPtr< CEditCommand > >::const_iterator itr;

	ecList = UndoListMgr.GetRedoObj();
	itr = ecList.begin();
	for (; itr != ecList.end(); ++itr ) {
		// ɥϰϤȥ֤
		(*pAfterRedoSelRange) = (*itr)->GetAfterSelRange();
		(*pAfterRedoCurPos) = (*itr)->GetAfterCurPos();

		if ( (*itr)->GetType() == TEC_INSERT ) {
			// ʸԤƤ
			// 줿ʸ򡢺
			InsertSpecifiedStr( (*itr)->GetInsertPos(), (*itr)->GetInsertText() );
		}
		else {
			// ʸκԤƤ
			// 줿ʸ򡢺ٺ
			Delete( (*itr)->GetDeleteRange() );
		}
	}
}

// ꤷ֤¸ߤ롢ꤷʸ
// ʺֵڤӺ줿ƥȤȽ뤬줿ϰϤξ󤬼Ƥ˻ѡ
CErrorBool CTaEditDoc::DelSpecifiedStr( T_CurPos pos, const wstring &rStr )
{
	T_SelRange wSelRange;	// ʸϰϤݻ
	T_CurPos wSelRange_end;		// wSelRangeνλ֤η׻
	int crcnt = 0;
	int i;

	// ʸ˴ޤޤƤԥɤο򻻽
	for ( i = 0; i < rStr.length(); i++ ) {
		if ( rStr[i] == L'\n' ) crcnt++;
	}

	// ʸϰϤ
	if ( crcnt == 0 ) {
		// ʸ˲ԥɤޤޤƤʤ
		wSelRange_end.SetLine( pos.GetLine() );
		wSelRange_end.SetCPos( pos.GetCPos() + rStr.length() );
	}
	else {
		// ʸ˲ԥɤޤޤƤ
		wSelRange_end.SetLine( pos.GetLine() + crcnt );
		wSelRange_end.SetCPos( rStr.length() - rStr.rfind( L'\n' ) - 1 );
	}

	// ʸ
	wSelRange.SetPosEx( pos, wSelRange_end );
	return Delete( wSelRange );
}

// ꤷ֤˻ꤷʸʲԥɤޤˤɲä
void CTaEditDoc::InsertSpecifiedStr( T_CurPos pos, const wstring &rStr )
{
	int i;	// rStrν֤ݻ
	int j;
	int h;	// iΰͤݻ
	int p = pos.GetCPos();
	int wLine = pos.GetLine();
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const int MLMN = pConf->GetModifyLineMarkNumber();

	i = 0;
	h = 0;
	while ( i < rStr.length() ) {

		// ԥɤ򸡺
		while ( i < rStr.length() && rStr[i] != L'\n' ) i++;

		// ʸ
		vecLine[ wLine ].InsertBlank( p, i - h, MLMN );
		for ( j = 0; j < ( i - h ); j++ )
			vecLine[ wLine ].set( p + j, TA_CHAR( rStr[ h + j ], 0 ), MLMN );

		// оݤʸãƤʤСԤɲä
		if ( i >= rStr.length() ) break;
		AddCR( T_CurPos( wLine, p + j ) );	// ιԤˤ硢rStr[i]ϲԥɤǤ

		p = 0;
		i++;	// ʸ
		h = i;
		wLine++;
	}

	// ʸĴɽԤ
	if ( pTxtColorMgr ) {
		T_SelRange sr;
		if ( wLine == pos.GetLine() )
			sr = T_SelRange( pos, T_CurPos( wLine, pos.GetCPos() + rStr.length() ) );
		else
			sr = T_SelRange( pos, T_CurPos( wLine, i - h ) );
		pTxtColorMgr->Update( vecLine, sr );
	}
}

// 
void CTaEditDoc::AddCR( T_CurPos pos )
{
	CLineData w;
	int i, j;
	int cLine = pos.GetLine();
	int nLine = cLine + 1;
	int xPos = pos.GetCPos();
	CLineData *wpLine;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const int MLMN = pConf->GetModifyLineMarkNumber();

	// ƬؤβԥɤϡιԤιǤβԤȸʤ
	// ʤĹ0ιԤǤβԤäϡԤιǤβԤȸʤ
	if ( cLine > 0 && vecLine[cLine].length() > 0 && xPos == 0 ) {
		cLine--;
		nLine--;
		xPos = vecLine[cLine].length();
	}

	// ιԤɲä
	vecLine.insert( vecLine.begin() + nLine, w );
	if ( MLMN >= 0 ) vecLine[ nLine ].SetExtendInfo( MLMN, true );

	// ιԤˤ롢ԥɤο
	// ɲäԤꤹ
	wpLine = &( vecLine[ cLine ] );
	vecLine[ nLine ].setIro( 0, wpLine->getIro( wpLine->length() ) );

	// ɲäιԤˡʸϿ
	j = vecLine[ cLine ].length() - xPos;	// ɲäԤϿʸ

	if ( j <= 0 ) {
		// ԥɤɲäԤѲ̵äȤƤ⡢
		// 褵ɬפ롣ʲԵκ
		vecLine[ cLine ].UpdateTime();
		return ;
	}
	wpLine = &( vecLine[ nLine ] );
	wpLine->InsertBlank( 0, j, MLMN );	// ΰ
	for ( i = 0; i < j; i++ )	// ʸ
		wpLine->set( i, vecLine[ cLine ][ i + xPos ], MLMN );

	// Ԥ˰ܤʬʸ
	vecLine[cLine].Delete( xPos, xPos + j, MLMN );
}

// ưǥȤˤĴ
// lineιԤƬˤʤɤline+1ιƬ
// ʸ֤
int CTaEditDoc::ExecAutoIndent( int line )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	bool AutoIndent = pConf->GetAutoIndent();
	const wstring &IndentChar = pConf->RefIndentChar();
	const int MLMN = pConf->GetModifyLineMarkNumber();
	int i, j;

	assert( this && line < vecLine.size() - 1 );
	
	CLineData *wpLine1 = &( vecLine[ line ] );
	CLineData *wpLine2 = &( vecLine[ line + 1 ] );

	if ( !AutoIndent ) return 0;	// ȥǥȤɬפʤнλ

	// ǥȤʸ򥫥
	for ( i = 0; i < wpLine1->length() && NULL != wcschr( IndentChar.c_str(), (*wpLine1)[i].moji ); ++i );

	wpLine2->InsertBlank( 0, i, MLMN );	// ΰ
	for ( j = 0; j < i; ++j )	// ʸ
		wpLine2->set( j, (*wpLine1)[j], MLMN );

	// ʸĴɽԤ
	if ( pTxtColorMgr )
		pTxtColorMgr->Update( vecLine, T_SelRange( T_CurPos( line + 1, 0 ), T_CurPos( line + 1, i ) ) );

	return i;
}

// ʸκ
CErrorBool CTaEditDoc::Delete( const T_SelRange &rRange )
{
	assert( NULL != this );
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const int MLMN = pConf->GetModifyLineMarkNumber();

	int sline = rRange.GetSPos().GetLine();
	int scpos = rRange.GetSPos().GetCPos();
	int eline = rRange.GetEPos().GetLine();
	int ecpos = rRange.GetEPos().GetCPos();

	assert( sline >= 0 && sline < vecLine.size() && eline >= 0 && eline < vecLine.size() );

	int sLineLength = vecLine[ sline ].length();
	int eLineLength = vecLine[ eline ].length();

	assert( scpos >= 0 && scpos <= sLineLength && ecpos >= 0 && ecpos <= eLineLength );

	if ( sline == eline ) {
		// Ʊΰ
		vecLine[ sline ].Delete( scpos, ecpos, MLMN );

		// ʸĴɽԤ
		if ( pTxtColorMgr ) {
			T_SelRange sr = T_SelRange( rRange.GetSPos(), rRange.GetSPos() );
			pTxtColorMgr->Update( vecLine, sr );
		}

		return true;
	}

	// ԤĹФå
	if ( scpos + ( eLineLength - ecpos ) >= TA_MAX_LINE_SIZE )
		return CErrorBool( pConf->RefBrokenLineMsg() );

	// 򳫻ϤԤФ
	vecLine[ sline ].Delete( scpos, sLineLength, MLMN );

	// ιԤƺ
	vecLine.erase( vecLine.begin() + sline + 1, vecLine.begin() + eline );

	// Ϣ
	vecLine[ sline ].InsertBlank( scpos, ( eLineLength - ecpos ), MLMN );
	for ( int i = 0; i < eLineLength - ecpos; i++ )
		vecLine[ sline ].set( i + scpos, vecLine[ sline + 1 ][ i + ecpos ], MLMN );
	// ʲԥɤοϢ뤹
	unsigned char col = vecLine[ sline + 1 ].getIro( vecLine[ sline + 1 ].length() );
	vecLine[ sline ].setIro( vecLine[ sline ].length(), col );

	// ϰϤκǸιԤ
	vecLine.erase( vecLine.begin() + sline + 1 );

	// ʸĴɽԤ
	if ( pTxtColorMgr )
		pTxtColorMgr->Update( vecLine, T_SelRange( rRange.GetSPos(), rRange.GetSPos() ) );

	return true;
}

// Խޥɥ֥Ȥ
VClsPtr< CEditCommand > CTaEditDoc::CreateEditCommandObj( enumTEC_TYPE argType )
{
	// ʤ

	VClsPtr< CEditCommand > wpEditCommand = new CEditCommand( argType );
	if ( wpEditCommand.IsNull() ) 
		UndoListMgr.Clear();	// ꤬­ϡɥꥹȤ˴
	return wpEditCommand;
}


// ꤷϰϤʸ
void CTaEditDoc::GetRangeStr( const T_SelRange &range, wstring *pStr )
{
	const T_CurPos s = range.GetSPos();
	const T_CurPos e = range.GetEPos();
	int i;
	size_t wLen;

	// ƱιԤꤵ줿
	if ( s.GetLine() == e.GetLine() ) {
		if ( s.GetCPos() == e.GetCPos() ) {
			(*pStr) = L"";	// ֤٤ʸϤʤ
			return ;
		}
		const wstring &wrstr = vecLine[ s.GetLine() ].getString();
		(*pStr) = wrstr.substr( s.GetCPos(), e.GetCPos() - s.GetCPos() );
		return ;
	}

	// ǽιԤʸ
	int sline = s.GetLine();
	int eline = e.GetLine();
	(*pStr) = vecLine[ sline ].getString().substr( s.GetCPos() );

	// ֤ιԤʸ
	// ɬפȤʤʸ򥫥ȡ
	wLen = 0;
	i = sline;
	for ( i++; i != eline; i++ )
		wLen += 1 + vecLine[ sline ].getString().length();
	// ΰ
	pStr->reserve( pStr->length() + wLen );
	// 
	for ( sline++; sline != eline; sline++ ) {
		(*pStr) += wstring( L"\n" ) + vecLine[ sline ].getString();
	}

	// ǸιԤʸ
	(*pStr) += wstring( L"\n" ) + vecLine[ sline ].getString().substr( 0, e.GetCPos() );
}

// եξ֤ǧ
CErrorBool CTaEditDoc::CheckFileStatus( const string &rFileName, bool Exist )
{
	struct stat StatusInfo;
	int r;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	r = lstat( rFileName.c_str(), &StatusInfo );
	if ( -1 == r ) {
		// ե뤬¸ߤʤ
		if ( !Exist )
			return true;	// ¸ߤɬפʤС֤
		return CErrorBool( pConf->RefFileIsNotExistMsg() );
	}

	if ( StatusInfo.st_mode & S_IFDIR )
		return CErrorBool( pConf->RefSpecifiedNameIsDirMsg() );

	return true;
}

// ¸󥪥֥Ȥ
const NLangExt::CTxtColorMgr* CTaEditDoc::GetTxtColorMgr() const
{
	return pTxtColorMgr;
}

// ¸󥪥֥Ȥ򹹿
// 󥪥֥Ȥƹۤ줿ˤϡ(*pIsUpdate)˿ꤹ
CErrorBool CTaEditDoc::UpdateTextColorMgr( bool *pIsUpdate )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const NLangExt::CLangConfig *pLangConf = m_TaEditShell->GetLangConfig();

	if ( pIsUpdate ) (*pIsUpdate) = false;

	// pLangConfNULLβǽ
	if ( NULL == pLangConf ) return false;

	// ⡼ɤͭˤʤ롢եκĹ
	unsigned int LangTypeEnableMaxSize = pConf->GetLangTypeEnableMaxSize();

	// ʸĹ򻻽Ф
	unsigned long size = 0;
	T_LineDataItr_c itr = vecLine.begin();
	for ( ; itr != vecLine.end(); ++itr )
		size += itr->length() + 1;	// +1ϲԥ
	size--;				// βԥɤʬ

	// LangTypeEnableMaxSizeХȤʪФƤϹʸĴɽԤ
	if ( size <= LangTypeEnableMaxSize )
		return SetTxtColorMgr( pLangConf->GetLangTypeID( FileName.c_str() ), pIsUpdate );
	else
		return SetTxtColorMgr( LANGTYPE_TEXT, pIsUpdate );
}

// 󥪥֥Ȥ
// 󥪥֥Ȥƹۤ줿ˤϡ(*pIsUpdate)˿ꤹ
CErrorBool CTaEditDoc::SetTxtColorMgr( enumLANGTYPE type, bool *pIsUpdate )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const NLangExt::CLangConfig *pLangConf = m_TaEditShell->GetLangConfig();
	CErrorBool r;

	if ( pIsUpdate ) (*pIsUpdate) = false;

	// pLangConfNULLβǽ
	if ( NULL == pLangConf ) return false;

	if ( pTxtColorMgr ) {
		// ¸ΤΤ¸ߤ
		if ( pTxtColorMgr->GetLangType() != type ) {
			// 󥪥֥Ȥ򹹿ʤƤϤʤʤϡ¸ΤΤ˴
			delete pTxtColorMgr;
			pTxtColorMgr = NULL;
			if ( pIsUpdate ) (*pIsUpdate) = true;
		}
	}

	if ( !pTxtColorMgr ) {
		// 󥪥֥Ȥۤ
		pTxtColorMgr = pLangConf->CreateColorMgr( type );
		if ( NULL == pTxtColorMgr )
			return CErrorBool( pConf->RefOutOfMemoryErrorMsg() );

		// 󥪥֥Ȥ
		r = pTxtColorMgr->Initialize( pConf );
		if ( !r ) {
			delete pTxtColorMgr;
			pTxtColorMgr = NULL;
			return r;
		}
		if ( pIsUpdate ) (*pIsUpdate) = true;
	}

	// ʸĴɽԤ
	pTxtColorMgr->InitiUpdate( vecLine );
	return true;
}

// ĥ
CErrorBool CTaEditDoc::SetExtendInfo( size_t Line, int idx, bool flg )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	if ( Line < 0 || Line >= vecLine.size() )
		return CErrorBool( pConf->RefUnexpectedErrorMsg() );
	if ( idx < 0 || idx >= pConf->GetExInfoColumnCount() )
		return CErrorBool( pConf->RefUnexpectedErrorMsg() );

	// ĥꤹ
	vecLine[Line].SetExtendInfo( idx, flg );
	// ɥȤȤѹ줿櫓ǤϤʤΤǡ
	// ե饰ꤷʤ

	return true;
}

// Խνλ
void CTaEditDoc::EndEdit()
{
	// UndoꥹȤԽνλΤ
	UndoListMgr.EndEdit();
}

// ե饰ꤹ
void CTaEditDoc::SetModifyFlg( bool flg )
{
	bool r = ( IsModify != flg );

	IsModify = flg;

	// ե饰ѹȤˤϡɥȥκΤ
	if ( r )
		m_TaEditShell->ResetTitle( TITLESTR_MODIFIED_SIGN_STR );
}


// ¾ŪԽüʣ
// 1.CTaEditDocۤ롣
// 2.ۤCTaEditDocˡthisƱԿζԤɲä
// 3.CTaEditDocthisswap롣
CTaEditDoc* CTaEditDoc::CopyForExclusiveEditing()
{
	assert( this );

	CTaEditDoc *wpDoc = new CTaEditDoc();
	if ( NULL == wpDoc ) return NULL;

	// Ԥɲä
	wpDoc->vecLine.resize( this->vecLine.size(), CLineData() );

	// swap
	ReflectionExclusiveEditing( wpDoc );

	return wpDoc;
}

// ¾ŪԽη̤ȿǤ
// 1.pDocthisݻvecLineIsModifyUndoListMgrswap롣
// 2.ιԤ
void CTaEditDoc::ReflectionExclusiveEditing( CTaEditDoc *pDoc )
{
	bool wBool;
	
	assert( this && pDoc );

	pDoc->vecLine.swap( this->vecLine );

	wBool = pDoc->IsModify;
	pDoc->IsModify = this->IsModify;
	this->IsModify = wBool;

	pDoc->UndoListMgr.Swap( &(this->UndoListMgr) );

	// ʸĴɽԤ
	if ( pDoc->pTxtColorMgr )
		pDoc->pTxtColorMgr->InitiUpdate( pDoc->vecLine );
	if ( this->pTxtColorMgr )
		this->pTxtColorMgr->InitiUpdate( this->vecLine );
}

// 󥳡ɤξ
const CEncodeInfo& CTaEditDoc::GetEncodeInfo() const
{
	return EncodeInfo;
}
