////////////////////////////////////////////////////////////////////////////
// PluginFunc.cc ץ饰󶡤뵡ǽ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEdit_std.h"

#include "PluginFunc.h"
#include "PluginFuncID.h"
#include "Plugin.h"
#include "TaEditShell.h"
#include "CompoundStr.h"
#include "EncodeInfo.h"
#include "lang/LangConfig.h"

PFT_BOOL PFunc_GetChar( unsigned long argLP, unsigned long argCP, wchar_t *pC );
PFT_BOOL PFunc_SetChar( unsigned long argLP, unsigned long argCP, wchar_t c );
PFT_BOOL PFunc_GetString( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP, wchar_t *pBuf, unsigned long BufLength );
PFT_BOOL PFunc_Replace( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP, const wchar_t *pBuf );
PFT_BOOL PFunc_GetLineCount( unsigned long *pCnt );
PFT_BOOL PFunc_GetCharCount( unsigned long argLP, unsigned long *pCnt );
PFT_BOOL PFunc_GetCursorPosition( unsigned long *pLP, unsigned long *pCP );
PFT_BOOL PFunc_SetCursorPosition( unsigned long LP, unsigned long CP );
PFT_BOOL PFunc_GetSelectionRange( unsigned long *argSLP, unsigned long *argSCP, unsigned long *argELP, unsigned long *argECP );
PFT_BOOL PFunc_SetSelectionRange( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP );
const wchar_t* PFunc_GetConfigValue( const wchar_t *pName );
const char* PFunc_GetFileName( void );
void PFunc_ShowInformationMsgBox( const wchar_t *pMsg );
int PFunc_ShowQuestionMsgBox( const wchar_t *pMsg, PFT_BOOL ShowCancel );
void PFunc_ShowErrorMsgBox( const wchar_t *pMsg );
PFT_BOOL PFunc_GetModifiedFlg( void );
int PFunc_GetVersion( void );
int PFunc_GetGetExtendInfoCount( void );
PFT_BOOL PFunc_GetExtendInfo( unsigned long argLP, unsigned long idx, PFT_BOOL* pFlg );
PFT_BOOL PFunc_SetExtendInfo( unsigned long argLP, unsigned long idx, PFT_BOOL Flg );
PFT_BOOL PFunc_SaveFile( void );
PFT_BOOL PFunc_OpenFile( const char* pFileName );
PFT_BOOL PFunc_OpenFileNewWindow( const char* pFileName );
void* PFunc_AllocWorkMemory( unsigned long size, const wchar_t* pName, PFT_BOOL IsGlobal );
void* PFunc_FindWorkMemory( const wchar_t* pName, PFT_BOOL IsGlobal );
void PFunc_FreeWorkMemory( const wchar_t* pName, PFT_BOOL IsGlobal );
PFT_BOOL PFunc_IsConstructionMode();
PFT_BOOL PFunc_SetConstruction( PFT_BOOL ShowMessage );
PFT_BOOL PFunc_SetStandalone( PFT_BOOL ShowMessage );
unsigned long PFunc_GetEncodeName( char *pBuf, unsigned long BufLen );
PFT_BOOL PFunc_GetCRType( char *pBuf );
PFT_BOOL PFunc_SaveFile16( const char *pFileName, const char *pEncodeName, const char *pCRTypeName, PFT_BOOL QueryFlg );
PFT_BOOL PFunc_OpenFile16( const char *pFileName, const char *pEncodeName, const char *pLangType, PFT_BOOL NewWindow );

// ؿΥɥ쥹
void* GetFunctionAddress( unsigned int ID )
{
	switch ( ID ) {
	case PFID_GETCHAR:
		return reinterpret_cast< void* >( PFunc_GetChar );
	case PFID_SETCHAR:
		return reinterpret_cast< void* >( PFunc_SetChar );
	case PFID_GETSTRING:
		return reinterpret_cast< void* >( PFunc_GetString );
	case PFID_REPLACE:
		return reinterpret_cast< void* >( PFunc_Replace );
	case PFID_GETLINECOUNT:
		return reinterpret_cast< void* >( PFunc_GetLineCount );
	case PFID_GETCHARCOUNT:
		return reinterpret_cast< void* >( PFunc_GetCharCount );
	case PFID_GETCURSORPOSITION:
		return reinterpret_cast< void* >( PFunc_GetCursorPosition );
	case PFID_SETCURSORPOSITION:
		return reinterpret_cast< void* >( PFunc_SetCursorPosition );
	case PFID_GETSELECTIONRANGE:
		return reinterpret_cast< void* >( PFunc_GetSelectionRange );
	case PFID_SETSELECTIONRANGE:
		return reinterpret_cast< void* >( PFunc_SetSelectionRange );
	case PFID_GETCONFIGVALUE:
		return reinterpret_cast< void* >( PFunc_GetConfigValue );
	case PFID_GETFILENAME:
		return reinterpret_cast< void* >( PFunc_GetFileName );
	case PFID_SHOWINFORMATIONMSGBOX:
		return reinterpret_cast< void* >( PFunc_ShowInformationMsgBox );
	case PFID_SHOWQUESTIONMSGBOX:
		return reinterpret_cast< void* >( PFunc_ShowQuestionMsgBox );
	case PFID_SHOWERRORMSGBOX:
		return reinterpret_cast< void* >( PFunc_ShowErrorMsgBox );
	case PFID_GETMODIFIEDFLG:
		return reinterpret_cast< void* >( PFunc_GetModifiedFlg );
	case PFID_GETVERSION:
		return reinterpret_cast< void* >( PFunc_GetVersion );
	case PFID_GETEXTENDINFOCOUNT:
		return reinterpret_cast< void* >( PFunc_GetGetExtendInfoCount );
	case PFID_GETEXTENDINFO:
		return reinterpret_cast< void* >( PFunc_GetExtendInfo );
	case PFID_SETEXTENDINFO:
		return reinterpret_cast< void* >( PFunc_SetExtendInfo );
	case PFID_SAVEFILE:
		return reinterpret_cast< void* >( PFunc_SaveFile );
	case PFID_OPENFILE:
		return reinterpret_cast< void* >( PFunc_OpenFile );
	case PFID_OPENFILENEWWINDOW:
		return reinterpret_cast< void* >( PFunc_OpenFileNewWindow );
	case PFID_ALLOCWORKMEMORY:
		return reinterpret_cast< void* >( PFunc_AllocWorkMemory );
	case PFID_FINDWORKMEMORY:
		return reinterpret_cast< void* >( PFunc_FindWorkMemory );
	case PFID_FREEWORKMEMORY:
		return reinterpret_cast< void* >( PFunc_FreeWorkMemory );
	case PFID_ISCONSTRUCTIONMODE:
		return reinterpret_cast< void* >( PFunc_IsConstructionMode );
	case PFID_SETCONSTRUCTION:
		return reinterpret_cast< void* >( PFunc_SetConstruction );
	case PFID_SETSTANDALONE:
		return reinterpret_cast< void* >( PFunc_SetStandalone );
	case PFID_GETENCODENAME:
		return reinterpret_cast< void* >( PFunc_GetEncodeName );
	case PFID_GETCRTYPE:
		return reinterpret_cast< void* >( PFunc_GetCRType );
	case PFID_SAVEFILE16:
		return reinterpret_cast< void* >( PFunc_SaveFile16 );
	case PFID_OPENFILE16:
		return reinterpret_cast< void* >( PFunc_OpenFile16 );
	}
	return NULL;
}

// ꤷ֤ʸ
PFT_BOOL PFunc_GetChar( unsigned long argLP, unsigned long argCP, wchar_t *pC )
{
	if ( NULL == pC ) return PFT_FALSE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
		const T_LineData& rData = pDoc->RefData();
	if ( argLP < 0 || argLP >= rData.size() ) return PFT_FALSE;
	if ( argCP < 0 || argCP > rData[ argLP ].length() ) return PFT_FALSE;
	if ( argCP < rData[ argLP ].length() )
		(*pC) = pDoc->RefData()[ argLP ][ argCP ].moji;
	else
		(*pC) = L'\n';
	return PFT_TRUE;
}

// ꤷʸִ
PFT_BOOL PFunc_SetChar( unsigned long argLP, unsigned long argCP, wchar_t c )
{
	wchar_t v[2] = { c, L'\0' };
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	const T_LineData& rData = pDoc->RefData();
	if ( argLP < 0 || argLP >= rData.size() ) return PFT_FALSE;
	if ( argCP < 0 || argCP > rData[ argLP ].length() ) return PFT_FALSE;
	if ( argLP == rData.size() - 1 && argCP == rData[ argLP ].length() + 1 ) return PFT_FALSE;
	if ( argCP < rData[ argLP ].length() )
		return PFunc_Replace( argLP, argCP, argLP, argCP + 1, v );
	else
		return PFunc_Replace( argLP, argCP, argLP + 1, 0, v );
}

// ꤵ줿ϰϤʸ
PFT_BOOL PFunc_GetString( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP, wchar_t *pBuf, unsigned long BufLength )
{
	if ( NULL == pBuf ) return PFT_FALSE;
	if ( BufLength <= 0 ) return PFT_TRUE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	const T_LineData& rData = pDoc->RefData();
	if ( argSLP < 0 || argSLP >= rData.size() ) return PFT_FALSE;
	if ( argSCP < 0 || argSCP > rData[ argSLP ].length() ) return PFT_FALSE;
	if ( argELP < 0 || argELP >= rData.size() ) return PFT_FALSE;
	if ( argECP < 0 || argECP > rData[ argELP ].length() ) return PFT_FALSE;
	const wchar_t *ep = pBuf + BufLength - 1;
	wchar_t *wp = pBuf;
	unsigned long wcp = argSCP;
	unsigned long wlp = argSLP;

	while ( ( wlp < argELP || wlp == argELP && wcp < argECP ) && wp < ep ) {
		if ( wcp < rData[wlp].length() ) {
			(*wp) = rData[ wlp ][ wcp ].moji;
			wcp++;
		}
		else {
			(*wp) = L'\n';
			wcp = 0;
			wlp++;
		}
		wp++;
	}
	(*wp) = L'\0';
	return PFT_TRUE;
}

// ꤷϰϤʸִ
PFT_BOOL PFunc_Replace( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP, const wchar_t *pBuf )
{
	if ( NULL == pBuf ) return PFT_FALSE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	const T_LineData& rData = pDoc->RefData();
	if ( argSLP < 0 || argSLP >= rData.size() ) return PFT_FALSE;
	if ( argSCP < 0 || argSCP > rData[ argSLP ].length() ) return PFT_FALSE;
	if ( argELP < 0 || argELP >= rData.size() ) return PFT_FALSE;
	if ( argECP < 0 || argECP > rData[ argELP ].length() ) return PFT_FALSE;
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();

	T_SelRange Range = T_SelRange( T_CurPos( argSLP, argSCP ), T_CurPos( argELP, argECP ) );
	if ( rPlugin.Replace( Range, pBuf ) )
		return PFT_TRUE;
	else
		return PFT_FALSE;
}

// Կ
PFT_BOOL PFunc_GetLineCount( unsigned long *pCnt )
{
	if ( NULL == pCnt ) return PFT_FALSE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	(*pCnt) = pDoc->RefData().size();
	return PFT_TRUE;
}

// ꤷԤʸ
PFT_BOOL PFunc_GetCharCount( unsigned long argLP, unsigned long *pCnt )
{
	if ( NULL == pCnt ) return PFT_FALSE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	if ( argLP < 0 || argLP >= pDoc->RefData().size() ) return PFT_FALSE;
	(*pCnt) = pDoc->RefData()[ argLP ].length();
	if ( argLP < pDoc->RefData().size() - 1 )
		(*pCnt)++;	// βԥɤޤ
	return PFT_TRUE;
}

// ߤΥ֤
PFT_BOOL PFunc_GetCursorPosition( unsigned long *pLP, unsigned long *pCP )
{
	if ( !( pLP && pCP ) ) return PFT_FALSE;
	const T_CurPos& rCurPos = m_TaEditShell->RefPluginMgr().GetCurPos();
	(*pLP) = rCurPos.GetLine();
	(*pCP) = rCurPos.GetCPos();
	return PFT_TRUE;
}

// ֤
PFT_BOOL PFunc_SetCursorPosition( unsigned long LP, unsigned long CP )
{
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();
	if ( rPlugin.SetCurPos_SelRange( T_CurPos( LP, CP ), rPlugin.GetSelRange() ) )
		return PFT_TRUE;
	else
		return PFT_FALSE;
}

// ߤϰϤ
PFT_BOOL PFunc_GetSelectionRange( unsigned long *argSLP, unsigned long *argSCP, unsigned long *argELP, unsigned long *argECP )
{
	if ( !( argSLP && argSCP && argELP && argECP ) ) return PFT_FALSE;
	const T_SelRange& rSelRange = m_TaEditShell->RefPluginMgr().GetSelRange();
	(*argSLP) = rSelRange.GetSPos().GetLine();
	(*argSCP) = rSelRange.GetSPos().GetCPos();
	(*argELP) = rSelRange.GetEPos().GetLine();
	(*argECP) = rSelRange.GetEPos().GetCPos();
	return PFT_TRUE;
}

// ϰϤ
PFT_BOOL PFunc_SetSelectionRange( unsigned long argSLP, unsigned long argSCP, unsigned long argELP, unsigned long argECP )
{
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();
	T_SelRange selrange( T_CurPos( argSLP, argSCP ), T_CurPos( argELP, argECP ) );
	if ( rPlugin.SetCurPos_SelRange( rPlugin.GetCurPos(), selrange ) )
		return PFT_TRUE;
	else
		return PFT_FALSE;
}

// ̾б
const wchar_t* PFunc_GetConfigValue( const wchar_t *pName )
{
	if ( NULL == pName ) return NULL;
	return m_TaEditShell->RefPluginMgr().GetCurPluginConfig( pName );
}

// ե̾
const char* PFunc_GetFileName( void )
{
	return m_TaEditShell->GetDocument()->GetFileName().c_str();
}

// åܥåɽ
void PFunc_ShowInformationMsgBox( const wchar_t *pMsg )
{
	if ( NULL == pMsg ) return ;
	CCompoundStr str( pMsg );
	m_TaEditShell->ShowInformationMsgBox( str );
}

// åܥåɽ
// ShowCancel : ˤ硢֥󥻥ץܥɽ롣
// ֤͡Ϥפ줿1
// ֤פξ2
// ֥󥻥פξ3
// 顼ξ0
int PFunc_ShowQuestionMsgBox( const wchar_t *pMsg, PFT_BOOL ShowCancel )
{
	if ( NULL == pMsg ) return 0;
	CCompoundStr str( pMsg );
	return m_TaEditShell->ShowQuestionMsgBox( str, ShowCancel ? true : false );
}

// 顼åܥåɽ
void PFunc_ShowErrorMsgBox( const wchar_t *pMsg )
{
	if ( NULL == pMsg ) return ;
	CCompoundStr str( pMsg );
	m_TaEditShell->ShowErrorMsgBox( str );
}

// ѹե饰
PFT_BOOL PFunc_GetModifiedFlg( void )
{
	bool f = m_TaEditShell->GetDocument()->GetIsModify();
	return f ? PFT_TRUE : PFT_FALSE;
}

// ǥΥС
int PFunc_GetVersion( void )
{
	return TAEDIT_VERSION;
}

// Ѳǽʳĥο
int PFunc_GetGetExtendInfoCount( void )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	return pConf->GetExInfoColumnCount();
}

// ԤȤγĥ
PFT_BOOL PFunc_GetExtendInfo( unsigned long argLP, unsigned long idx, PFT_BOOL* pFlg )
{
	if ( NULL == pFlg ) return PFT_FALSE;
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	if ( argLP < 0 || argLP >= pDoc->RefData().size() ) return PFT_FALSE;
	if ( idx < 0 && idx >= PFunc_GetGetExtendInfoCount() ) return PFT_FALSE;
	(*pFlg) = pDoc->RefData()[argLP].GetExtendInfo( idx );
	return PFT_TRUE;
}

// ԤȤγĥ
PFT_BOOL PFunc_SetExtendInfo( unsigned long argLP, unsigned long idx, PFT_BOOL Flg )
{
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return PFT_FALSE;
	if ( argLP < 0 || argLP >= pDoc->RefData().size() ) return PFT_FALSE;
	if ( idx < 0 && idx >= PFunc_GetGetExtendInfoCount() ) return PFT_FALSE;
	return rPlugin.SetExtendInfo( argLP, idx, Flg );
}

// ե¸
PFT_BOOL PFunc_SaveFile( void )
{
	// ¸Ԥ
	// ե̾Ǥʤˤϡ桼䤤碌
	return PFunc_SaveFile16( "", "", "", PFT_TRUE );
}

// ߤΥɥǥե򳫤
PFT_BOOL PFunc_OpenFile( const char* pFileName )
{
	return PFunc_OpenFile16( pFileName, "", "", FALSE );
}

// ɥǥե򳫤
PFT_BOOL PFunc_OpenFileNewWindow( const char* pFileName )
{
	return PFunc_OpenFile16( pFileName, "", "", TRUE );
}

// ѥγ
void* PFunc_AllocWorkMemory( unsigned long size, const wchar_t* pName, PFT_BOOL IsGlobal )
{
	if ( size <= 0 || NULL == pName ) return NULL;
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();
	if ( IsGlobal )
		return rPlugin.GetWorkMemoryMgr().Alloc( size, pName, NULL );
	else
		return rPlugin.GetWorkMemoryMgr().Alloc( size, pName, rPlugin.GetPluginID() );
}

// ѥμ
void* PFunc_FindWorkMemory( const wchar_t* pName, PFT_BOOL IsGlobal )
{
	if ( NULL == pName ) return NULL;
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();
	if ( IsGlobal )
		return rPlugin.GetWorkMemoryMgr().Find( pName, NULL );
	else
		return rPlugin.GetWorkMemoryMgr().Find( pName, rPlugin.GetPluginID() );
}

// ѥβ
void PFunc_FreeWorkMemory( const wchar_t* pName, PFT_BOOL IsGlobal )
{
	if ( NULL == pName ) return ;
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();
	if ( IsGlobal )
		return rPlugin.GetWorkMemoryMgr().Free( pName, NULL );
	else
		return rPlugin.GetWorkMemoryMgr().Free( pName, rPlugin.GetPluginID() );
}

// 󥹥ȥ饯󡦥⡼ɤݤ
PFT_BOOL PFunc_IsConstructionMode( void )
{
	return m_TaEditShell->IsConstructionMode() ? PFT_TRUE : PFT_FALSE;
}

// 󥹥ȥ饯󡦥⡼ɤѹ
PFT_BOOL PFunc_SetConstruction( PFT_BOOL ShowMessage )
{
	CErrorBool r = m_TaEditShell->SetConstructionMode();
	if ( ShowMessage ) m_TaEditShell->ProcErrorMsg( r );
	return r ? PFT_TRUE : PFT_FALSE;
}

// ɥ󡦥⡼ɤѹ
PFT_BOOL PFunc_SetStandalone( PFT_BOOL ShowMessage )
{
	CErrorBool r = m_TaEditShell->SetStandaloneMode();
	if ( ShowMessage ) m_TaEditShell->ProcErrorMsg( r );
	return r ? PFT_TRUE : PFT_FALSE;
}

// 󥳡̾
// 󥳡̾ʸ֤
unsigned long PFunc_GetEncodeName( char *pBuf, unsigned long BufLen )
{
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	string EncodeName = pDoc->GetEncodeInfo().GetEncodeName();
	unsigned long r = EncodeName.length();

	// NULLꤵ줿ʸ֤ƽλ
	if ( !pBuf ) return r;

	// Хåե­ϡʸ֤ƽλ
	if ( r + 1 > BufLen ) return r;

	// Хåե˥󥳡̾񤭹
	strncpy( pBuf, EncodeName.c_str(), BufLen );

	return r;
}

// ԥɤμ̤
// pBufˤϡǤ5ХȰʾΥХåեꤹɬפ
PFT_BOOL PFunc_GetCRType( char *pBuf )
{
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	int len;

	if ( !pBuf ) return PFT_FALSE;

	// ԥɤμ̤
	const char *pName = pDoc->GetEncodeInfo().GetCRTypeName();
	len = strlen( pName );
	strncpy( pBuf, pName, len + 1 );

	return PFT_TRUE;
}

// ե¸
// pFileName : ե̾NULL⤷Ĺ0ʸξϡ¸
// pEncodeName : 󥳡̾NULL⤷Ĺ0ʸξϡߤΥ󥳡ɤѤ롣¸ξ̵뤵롣
// pCRTypeName : ԥ̾
// QueryFlg : ̾ΤʤեФƾ¸Ԥ硢ꤹȥ桼˥ե̾䤤碌롣
PFT_BOOL PFunc_SaveFile16( const char *pFileName, const char *pEncodeName, const char *pCRTypeName, PFT_BOOL QueryFlg )
{
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	string CurFName;
	CEncodeInfo CurEncode;
	bool r;

	// ե饰򤪤
	rPlugin.NoticeEndEdit();

	// ߤΥե̾ȥ󥳡ɤ
	CurFName = pDoc->GetFileName();
	CurEncode = pDoc->GetEncodeInfo();

	if ( !pFileName || strlen( pFileName ) == 0 ) {
		// ե̾ꤵʤäΤǡ¸
		
		// ̾ꤷʤ礫ĥ桼ؤ䤤碌ϹԤʤϡǤ
		if ( CurFName.length() == 0 && !QueryFlg )
			return false;

		// ¸Ԥ
		r = m_TaEditShell->SaveFileProcedure();
	}
	else {
		// ե̾ꤵ줿顢¸Ԥ

		// Ѥ륨󥳡ɤꤹ
		CEncodeInfo wEncode = CurEncode;
		if ( pEncodeName && strlen( pEncodeName ) > 0 )
			wEncode = CEncodeInfo( pEncodeName, wEncode.GetCRType() );
		if ( pCRTypeName && strlen( pCRTypeName ) > 0 )
			wEncode = CEncodeInfo( wEncode.GetEncodeName(), pCRTypeName );

		// ե¸
		r = m_TaEditShell->WriteFile( pFileName, wEncode );
	}

	return r ? PFT_TRUE : PFT_FALSE;
}

// ե򳫤
// pFileName : ե̾
// pEncodeName : 󥳡̾NULLޤĹ0ʸξϡȤΥΥ󥳡ɤѤ롣
// pLangType : ʸ̡NULLޤĹ0ʸξϥǥեͤѤ
// NewWindow : ξϡɥǥե򳫤
PFT_BOOL PFunc_OpenFile16( const char *pFileName, const char *pEncodeName, const char *pLangType, PFT_BOOL NewWindow )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CPlugin &rPlugin = m_TaEditShell->RefPluginMgr();
	enumLANGTYPE wLangType;
	string wEncodeName;
	string wFileName;
	bool r;

	if ( !NewWindow ) {
		// ߤΥɥǳˤϡե饰򤪤
		rPlugin.NoticeEndEdit();
	}

	if ( !pFileName ) return PFT_FALSE;

	// ե̾
	wFileName = pFileName;

	// 󥳡̾
	if ( pEncodeName && strlen( pEncodeName ) > 0 )
		wEncodeName = pEncodeName;
	else
		wEncodeName = "";

	// ʸ̤
	if ( pLangType && strlen( pLangType ) > 0 )
		wLangType = NLangExt::GetLangTypeID_ByLangName( pLangType );
	else
		wLangType = LANGTYPE_NAN;

	if ( !NewWindow ) {
		// ߤΥɥǳ
		r = m_TaEditShell->OpenFile( wFileName, wLangType, wEncodeName );
	}
	else {
		// ɥǳ
		int wLine = pConf->GetLineNumberOrigin();
		string wLangName = NLangExt::GetLangName_ByLangTypeID( wLangType );
		r = m_TaEditShell->OpenFileInNewWindow( wFileName.c_str(), wLine, wEncodeName, wLangName );
	}

	return r ? PFT_TRUE : PFT_FALSE;
}


