////////////////////////////////////////////////////////////////////////////
// CPlugin 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( PLUGIN_H_INCLUDED_ )
#define PLUGIN_H_INCLUDED_

#include "WorkMemoryMgr.h"

class CTaEditDraw;

class CPlugin
{
	typedef struct tagPLUGININFO {
		tagPLUGININFO() :
			IsSeparator( false ), wgtMenuBtn( NULL ),
			SectionName( L"" ), PluginName( "" ), LibraryName( "" ),
			FunctionName( "" ), MenuLabel( "" )
		{};

		tagPLUGININFO( const tagPLUGININFO& r ) :
			SectionName( r.SectionName ),
			IsSeparator( r.IsSeparator ),
			PluginName( r.PluginName ),
			LibraryName( r.LibraryName ),
			FunctionName( r.FunctionName ),
			MenuLabel( r.MenuLabel ),
			wgtMenuBtn( r.wgtMenuBtn )
		{};

		const tagPLUGININFO& operator =( const tagPLUGININFO& r )
		{
			SectionName = r.SectionName;
			IsSeparator = r.IsSeparator;
			PluginName = r.PluginName;
			LibraryName = r.LibraryName;
			FunctionName = r.FunctionName;
			MenuLabel = r.MenuLabel;
			wgtMenuBtn = r.wgtMenuBtn;
			return (*this);
		};

		wstring SectionName;
		bool IsSeparator;
		string PluginName;
		string LibraryName;
		string FunctionName;
		string MenuLabel;
		Widget wgtMenuBtn;	// ˥塼Υå
	} PLUGIN_INFO;
public:
	CPlugin();
	CPlugin( const CPlugin &r );	// ʣʶػߡ
	~CPlugin();

	// ץ饰
	CErrorBool ConfigurePlugin( const string& rConfigFile, Widget wgtCascade, Widget wgtPullDown, CTaEditDraw *argpView );

	// ֤μ
	const T_CurPos& GetCurPos() const;

	// ϰϤμ
	const T_SelRange& GetSelRange() const;

	// ֤ϰϤ
	bool SetCurPos_SelRange( const T_CurPos &rCurPos, const T_SelRange& rSelRange );

	// ʸִ
	bool Replace( const T_SelRange &rRange, const wchar_t *pStr );

	// ߼¹Υץ饰
	const wchar_t* GetCurPluginConfig( const wchar_t *pName ) const;

	// ĥꤹ
	bool SetExtendInfo( unsigned long Line, int idx, bool flg );

	// ߼¹ԤƤץ饰̤ID
	const wchar_t* GetPluginID() const;

	// ѥ֥Ȥ
	CWorkMemoryMgr& GetWorkMemoryMgr();

	// ƥȤԽνλΤ
	void NoticeEndEdit();

	// ʶػߡ
	const CPlugin& operator =( const CPlugin &r );

private:
	// ץ饰ξɤ߹
	CErrorBool ReadPluginInfo( const string &rConfigFile );
	// ɤ߹ץ饰ξǧ
	void CheckPluginInfo();
	// ̾˻ѤƤʸǧ
	bool CheckNameStr( const string& r ) const;

	// ˥塼ۤ
	CErrorBool CreateMenu( Widget wgtCascade, Widget wgtPullDown );

	// ˥塼줿ȤΥХå
	static void PluginMenuCallback( Widget wgt, XtPointer client_data, XtPointer call_data );

	// ˥塼򤵤줿Υ٥
	void OnMenu( Widget wgt );
	
	// ץ饰δؿƤӽФ
	void CallPlugin( const string &rLibraryName, const string &rFunctionName );

protected:
	vector< PLUGIN_INFO > vPluginInfo;
	CONFMAN pPluginConf;
	const PLUGIN_INFO* pCurPlugin;
	bool Modified;		// ץ饰¹˥ƥȤѹݤ
	CWorkMemoryMgr m_WorkMemoryMgr;	// ѥ֥
	CTaEditDraw *pView;
};

#endif // PLUGIN_H_INCLUDED_

