////////////////////////////////////////////////////////////////////////////
// CGCMgr 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEdit_std.h"
#include "GCMgr.h"

using namespace NLangExt;
using namespace NNabikiVClsPtr;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CGCMgr::CGCMgr() :
	wgtDraw( NULL ),
	pTxtColorMgr( NULL ),
	pStorage( NULL ),
	CCPInterface()
{
}

CGCMgr::~CGCMgr()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// GCι
// pTCMNULLβǽ
bool CGCMgr::CreateGC(
	Widget argpDraw,
	VClsPtr< CConfigInfo > pConf,
	const NLangExt::CTxtColorMgr *pTCM,
	VClsPtr< CGCStorage > argStorage
)
{
	int i;
	int ExInfoColumnCnt = pConf->GetExInfoColumnCount();
	GC wGC;
	Pixel fg;
	Pixel bg;

	wgtDraw = argpDraw;
	pTxtColorMgr = pTCM;
	pStorage = argStorage;

	// ̾ΥƥȤ
	fg = pConf->RefNormalTextF_Color();
	bg = pConf->RefNormalTextB_Color();
	if ( !pStorage->CreateGC( GCID_FAILED_TEXT, wgtDraw, fg, bg ) )
		return false;

	// ƥѣǣ
	if ( pTCM ) {
		int cnt = pTCM->GetColorCount();
		for ( i = 0; i < cnt; i++ ) {
			fg = pTCM->GetColor( i );
			bg = pConf->RefNormalTextB_Color();
			pStorage->CreateGC( GCID_TEXT | i, wgtDraw, fg, bg );
		}
	}

	// Tabʸѣǣ
	fg = pConf->RefNormalTextB_Color();
	bg = pConf->RefNormalTextF_Color();
	if ( !pStorage->CreateGC( GCID_TAB, wgtDraw, fg, bg ) )
		return false;

	// 򤵤줿Tabѣǣ
	fg = pConf->RefSelectedTextB_Color();
	bg = pConf->RefSelectedTextF_Color();
	if ( !pStorage->CreateGC( GCID_SELTAB, wgtDraw, fg, bg ) )
		return false;

	// 򤵤줿ƥȤ
	fg = pConf->RefSelectedTextF_Color();
	bg = pConf->RefSelectedTextB_Color();
	if ( !pStorage->CreateGC( GCID_SELTEXT, wgtDraw, fg, bg ) )
		return false;

	// ̤ξõѣǣ
	fg = pConf->RefBackgroundColor();
	bg = pConf->RefBackgroundColor();
	if ( !pStorage->CreateGC( GCID_CLEAR, wgtDraw, fg, bg ) )
		return false;

	// GC
	fg = pConf->RefCursorColor();
	bg = pConf->RefCursorColor();
	if ( !pStorage->CreateGC( GCID_CURSOR, wgtDraw, fg, bg ) )
		return false;
	wGC = pStorage->GetGC( GCID_CURSOR );
	XSetFunction( XtDisplay( argpDraw ), wGC, GXxor );	// XOR

	// ¦γƥ褹뤿GC
	for ( i = 0; i < ExInfoColumnCnt; i++ ) {
		fg = pConf->RefExInfoColumnColor( i );
		bg = pConf->RefBackgroundColor();
		if ( !pStorage->CreateGC( GCID_INFOCOL | i, wgtDraw, fg, bg ) )
			return false;
	}

	// ¦Υڤ褹뤿GC
	fg = pConf->RefSeparatorLineColor();
	bg = pConf->RefBackgroundColor();
	if ( !pStorage->CreateGC( GCID_LEFTCOL_SEPA, wgtDraw, fg, bg ) )
		return false;

	// ȤιԤβ褹뤿GC
	fg = pConf->RefCurLineUnderBar_Color();
	bg = pConf->RefBackgroundColor();
	pStorage->CreateGC( GCID_UNDERBAR, wgtDraw, fg, bg );

	// Խ褹뤿GC
	fg = pConf->RefEditMark_Color();
	bg = pConf->RefBackgroundColor();
	pStorage->CreateGC( GCID_EDITMARK, wgtDraw, fg, bg );

	// ֹ褹뤿GC
	fg = pConf->RefLineNumberF_Color();
	bg = pConf->RefBackgroundColor();
	pStorage->CreateGC( GCID_LINENUMBER, wgtDraw, fg, bg );

	return true;
}

// ƥGC
GC CGCMgr::GetTextDrawGC( unsigned char c, bool IsSelected, bool IsTab ) const
{
	GC wGC;
	int ID;

	if ( !IsTab ) {
		if ( IsSelected )
			return pStorage->GetGC( GCID_SELTEXT );
		else {
			if ( !pTxtColorMgr )
				return pStorage->GetGC( GCID_FAILED_TEXT );

			// ꤵ줿ʸο褹GC򸡺
			ID = GCID_TEXT | pTxtColorMgr->TranseToIdx( c );
			wGC = pStorage->GetGC( ID );

			// ĤФ̵֤ХǥեȤ֤ۤ
			if ( wGC ) return wGC;
			return pStorage->GetGC( GCID_FAILED_TEXT );
		}
	}
	else {
		if ( IsSelected )
			return GetSelTabGC();
		else
			return GetTabGC();
	}
}

// TabʸGC
GC CGCMgr::GetTabGC() const
{
	return pStorage->GetGC( GCID_TAB );
}

GC CGCMgr::GetSelTabGC() const
{
	return pStorage->GetGC( GCID_SELTAB );
}

// طʾõGCμ
GC CGCMgr::GetClearGC() const
{
	return pStorage->GetGC( GCID_CLEAR );
}

// GCμ
GC CGCMgr::GetCursorGC() const
{
	return pStorage->GetGC( GCID_CURSOR );
}

GC CGCMgr::GetExInfoColumnGC( int idx ) const
{
	return pStorage->GetGC( GCID_INFOCOL | idx );
}

GC CGCMgr::GetLeftColumnSeparatorGC() const
{
	return pStorage->GetGC( GCID_LEFTCOL_SEPA );
}

GC CGCMgr::GetCurLineUnderBarGC() const
{
	return pStorage->GetGC( GCID_UNDERBAR );
}

GC CGCMgr::GetEditMarkGC() const
{
	return pStorage->GetGC( GCID_EDITMARK );
}

GC CGCMgr::GetLineNumberGC() const
{
	return pStorage->GetGC( GCID_LINENUMBER );
}
