////////////////////////////////////////////////////////////////////////////
// CEncodeInfo 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#if !defined( ENCODEINFO_H_INCLUDED_ )
#define ENCODEINFO_H_INCLUDED_


// 󥳡Ѵμ
typedef enum enumENCTYPE
{
	ENCTYPE_NOTHIG,		// ̤
	ENCTYPE_SPECIFIED,	// ꤵ줿󥳡̾
	ENCTYPE_CURRENT		// ȤΥǻѤƤ륨󥳡ɤ
} ENCTYPE;

// ԥɤμ
typedef enum enumCRTYPE
{
	CRTYPE_LF,
	CRTYPE_CRLF,
	CRTYPE_CR,
	CRTYPE_LFCR
} CRTYPE;

// 󥳡ɤξݻ
class CEncodeInfo
{
public:
	CEncodeInfo() :
		EncodeName( "" ),
		EncodeType( ENCTYPE_NOTHIG ),
		CRType( CRTYPE_LF )
	{};

	CEncodeInfo( const CEncodeInfo& r ) :
		EncodeName( r.EncodeName ),
		EncodeType( r.EncodeType ),
		CRType( r.CRType )
	{};

	CEncodeInfo( const string &rEN, ENCTYPE ET, CRTYPE CT ) :
		EncodeName( rEN ),
		EncodeType( ET ),
		CRType( CT )
	{};

	CEncodeInfo( const string &rEN, CRTYPE CT ) :
		EncodeName( rEN ),
		CRType( CT )
	{
		if ( EncodeName.length() > 0 )
			EncodeType = ENCTYPE_SPECIFIED;
		else
			EncodeType = ENCTYPE_NOTHIG;
	};

	CEncodeInfo( const string &rEN, const string &rCTName ) :
		EncodeName( rEN )
	{
		if ( EncodeName.length() > 0 )
			EncodeType = ENCTYPE_SPECIFIED;
		else
			EncodeType = ENCTYPE_NOTHIG;
		if ( rCTName == "CR" )
			CRType = CRTYPE_CR;
		else if ( rCTName == "LF" )
			CRType = CRTYPE_LF;
		else if ( rCTName == "CRLF" )
			CRType = CRTYPE_CRLF;
		else if ( rCTName == "LFCR" )
			CRType = CRTYPE_LFCR;
		else
			CRType = CRTYPE_LF;
	};

	string GetEncodeName() const
	{
		if ( EncodeType == ENCTYPE_SPECIFIED && EncodeName.length() > 0 )
			return EncodeName;

		// ꤵ줿󥳡̾Ѥʤϡ
		// ߤΥΥ󥳡ɤ֤
		return nl_langinfo( CODESET );
	};

	ENCTYPE GetEncodeType() const
	{
		return EncodeType;
	};

	CRTYPE GetCRType() const
	{
		return CRType;
	};
	const char* GetCRTypeName() const
	{
		switch ( CRType ) {
			case CRTYPE_LF:
				return "LF";
			case CRTYPE_CRLF:
				return "CRLF";
			case CRTYPE_LFCR:
				return "LFCR";
			case CRTYPE_CR:
				return "CR";
			default:
				return "LF";
		}
	};

	const bool operator ==( const CEncodeInfo &r ) const
	{
		if ( CRType != r.CRType )
			return false;
		if ( EncodeType != r.EncodeType )
			return false;
		if ( ENCTYPE_SPECIFIED != EncodeType )
			return true;
		return EncodeName == r.EncodeName;
	};

	const CEncodeInfo& operator =( const CEncodeInfo &r )
	{
		EncodeName = r.EncodeName;
		EncodeType = r.EncodeType;
		CRType = r.CRType;
		return (*this);
	};

	void Initialize()
	{
		EncodeName = "";
		EncodeType = ENCTYPE_NOTHIG;
		CRType = CRTYPE_LF;
	};

protected:
	string EncodeName;
	ENCTYPE EncodeType;
	CRTYPE CRType;
};


#endif // ENCODEINFO_H_INCLUDED_

