// DrawCharPos.cpp: CDrawCharPos 饹Υץơ
//
//////////////////////////////////////////////////////////////////////

#include "TaEdit_std.h"
#include "DrawCharPos.h"

//////////////////////////////////////////////////////////////////////
// /
//////////////////////////////////////////////////////////////////////

CDrawCharPos::CDrawCharPos() :
	RXPos( 0 ),
	vXPos(),
	IsEnable( false )
{
}

CDrawCharPos::CDrawCharPos( const CDrawCharPos &r ) :
	RXPos( r.RXPos ),
	vXPos( r.vXPos ),
	IsEnable( r.IsEnable )
{

}

CDrawCharPos::~CDrawCharPos()
{

}

//////////////////////////////////////////////////////////////////////
// ᥽å
//////////////////////////////////////////////////////////////////////

// ̾Ρ
void CDrawCharPos::Clear()
{
	assert( NULL != this );
	RXPos = 0;
	vXPos.Clear();
}

// ̾ΡϿƤʸ
int CDrawCharPos::GetCharCnt() const
{
	assert( NULL != this );
	return vXPos.GetUsedLen();
}

// ̾ΡüXɸ
unsigned int CDrawCharPos::GetRightXPos() const
{
	assert( NULL != this );
	return RXPos;
}

// ̾ΡʸȤ֤
unsigned int CDrawCharPos::GetCharPos( int x ) const
{
	assert( NULL != this );
	assert( !( x < 0 || GetCharCnt() <= x ) );
	return vXPos[ x ];
}

// ͭݤ
bool CDrawCharPos::GetIsEnable() const
{
	assert( NULL != this );
	return IsEnable;
}

// ̾Ρʸ䤹
void CDrawCharPos::AddChar( unsigned int argXPos )
{
	assert( NULL != this );
	vXPos.PushBack( argXPos );
}

// ̾ΡüXɸ
void CDrawCharPos::SetRightXPos( unsigned int argRXPos )
{
	assert( NULL != this );
	RXPos = argRXPos;
}

// ̾Ρʸ֤
void CDrawCharPos::SetXPos( int x, unsigned int argXPos )
{
	assert( NULL != this );
	assert( !( x < 0 || GetCharCnt() <= x ) );
	vXPos[ x ] = argXPos;
}

// ͭݤꤹ
void CDrawCharPos::SetIsEnable( bool f )
{
	assert( NULL != this );
	IsEnable = f;
}

// ̾Ρΰ֤򻻽
// ǽʹƬ0ȤXɸꤷԤκʸ򻻽Ф롣
int CDrawCharPos::FindPosToRowNum( unsigned int XPos, enumCHARSELTYPE CharSelType ) const
{
	long l;
	long h;
	long m;
	long w;

	assert( NULL != this );

	if ( XPos == 0 ) return 0;	// Ū0λ϶Ū0Ȥ

	// ꤵ줿֤褵Ƥʸαü걦¦ˤ
	if ( GetRightXPos() <= XPos )
		return GetCharCnt();

	l = 0;
	h = GetCharCnt() - 1;
	m = ( l + h ) / 2;
	while ( l <= h ){
		w = GetCharPos( m );
		if ( w > XPos )
			h = m - 1;
		else
			l = m + 1;
		m = ( l + h ) / 2;
	}
	l--;
	if ( l < 0 ) return 0;

	// ˤĴ
	switch ( CharSelType ) {
	case CST_LEFT:
		return l;
	case CST_RIGHT:
		return l + 1;
	default:
		if ( GetCharPos( l ) + ( GetCharWidth( l ) / 2 ) < XPos )
			l++;
		return l;
	}
}

// ݻƤ륭å夫˳ʸ褵Ƥ򻻽Ф
unsigned int CDrawCharPos::GetCharWidth( unsigned int idx ) const
{
	assert( NULL != this );
	assert( idx < GetCharCnt() );

	if ( idx == GetCharCnt() - 1 )
		return GetRightXPos() - GetCharPos( idx );	// üʸξ
	else
		return GetCharPos( idx + 1 ) - GetCharPos( idx );
}

// 
const CDrawCharPos& CDrawCharPos::operator =( const CDrawCharPos& r )
{
	RXPos = r.RXPos;
	vXPos = r.vXPos;
	IsEnable = r.IsEnable;
	return (*this);
}

