///////////////////////////////////////////////////////////////////////////
// CConfigInfo 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEdit_std.h"
#include "ConfigInfo.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CConfigInfo::CConfigInfo( Widget widget )
	: m_Widget( widget ),
	pExInfoColumnColor( NULL )
{
	assert( NULL != widget );
}

CConfigInfo::~CConfigInfo()
{
	Display *pDisplay;
	Colormap wColormap;
	map< string, Pixel >::iterator itr;

	// ĥΰǻѤ뿧̾ݻΰ
	if ( pExInfoColumnColor )
		delete []pExInfoColumnColor;
	pExInfoColumnColor = NULL;

	if ( !m_Widget ) return ;

	// ݤ
	pDisplay = XtDisplay( m_Widget );
	wColormap = DefaultColormap( pDisplay, DefaultScreen( pDisplay ) );
	for ( itr = mapPixelCash.begin(); itr != mapPixelCash.end(); itr++ ) {
		XFreeColors( pDisplay, wColormap, &(itr->second), 1, 1 );
	}
	mapPixelCash.clear();
}

////////////////////////////////////////////////////////////////////////////
// ؿ
////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CConfigInfo::Initialize()
{
	assert( NULL != this && NULL != m_Widget );

	struct tagAppData {
		const char* OkString;				// åܥåOKܥ
		const char* CancelString;			// ƱCancel
		const char* YesString;				// ƱYes
		const char* NoString;				// ƱNo
		const char* NewFileWndTitle;		// եۤݤΡɥΥȥ
		const char* FailToConvertCharSet;	// ʸɤѴ˼
		const char* BrokenLineMsg;			// Ԥ10kۤȤΥå
		const char* DeviceIOErrorMsg;		// ϻ˥ǥХǥ顼
		const char* TextEncodeErrorMsg;		// Ϥ줿ƥȤ
		const char* IOErrorMsg;				// ¾ϻΥ顼Υå
		const char* OutOfMemoryErrorMsg;	// ­Υ顼Υå
		const char* FileNameIsNotInputtedErrorMsg;// ե̾ϤƤʤȤΥå
		const char* UnexpectedErrorMsg;		// ͽʤ顼Υå
		const char* FileIsNotExistMsg;		// ե뤬¸ߤʤȤΥå
		const char* SpecifiedNameIsDirMsg;	// ǥ쥯ȥ꤬ꤵ줿Υå
		const char* FaultFileOpenMsg;		// եΥץ˼ԤΥå
		const char* PreservationCheckMsg;	// ե¸ǧΥå
		const char* RunScriptEAGAINMsg;		// ץĶˤ롢ҥץ˼
		const char* RunScriptEINTRMsg;		// ҥץ˳ߤ줿
		const char* RunScriptENOMEMMsg;		// ­ˤҥץ˼
		const char* RunScriptCancelOpenMsg;	// ץȤˤեΥץ󤬥󥻥뤵줿
		const char* RunScriptCancelSaveMsg;	// ץȤˤեΥ֤󥻥뤵줿
		const char* ShowCancelOpenMsg;		// ץȤˤեΥץ󤬥󥻥뤵줿Ȥåɽ뤫ݤ
		const char* ShowCancelSaveMsg;		// ץȤˤեΥ֤󥻥뤵줿Ȥåɽ뤫ݤ
		const char* FaultLoadPluginLibraryMsg;	// ץ饰Υ饤֥Υɤ˼ԤȤΥå
		const char* FaultGetPluginFunctionMsg;	// ץ饰δؿΥɥ쥹μ˼ԤȤΥå
		const char* FaultToSaveTmpFileMsg;		// ƥݥե¸˼ԤȤΥå
		const char* RetryWithoutSaveTmpFileMsg;	// ƥݥեؤ¸ʤǥȥ饤뤫ݤ
		const char* FailedToInitConstructionModeMsg;	// 󥹥ȥ饯⡼ɤν˼ԤȤΥå
		const char* ConstructionCommunicationErrorMsg;	// ФȤ̿˼ԤȤΥå
		const char* RebootServerMsg;			// ФƵưȤΥå
		const char* FailedToRebootServerMsg;	// ФκƵư˼ԤȤΥå
		const char* ServerRevokedMsg;			// ФߤƤȤΥå
		const char* FileIsOpenedByAnotherMsg;	// ꤵ줿եϡǤ¾μɮˤäƳƤ
		const char* ReplaceStrIsNullMsg;		// ִꤹʸϤƤʤΥå
		const char* FailedToStartEncConvMsg;	// ʸѴץεư˼ԤȤΥå
		const char* EncodeNameIsInvalidMsg;		// ʸ̾ʾΥå
		const char* FailedToConvertEncodeMsg;	// 󥳡ɤѴ˼ԤȤΥå
		const char* FailedToReadKeywordListMsg;	// ɤΥꥹȤɤ߹ߤ˼ԤȤΥå
		const char* FailedToReadPaperSizeConfigMsg;	// ѻ極ͤɤ߹ߤ˼ԤΥå
		const char* FailedToReadPrinterConfMsg;	// printer.confɤ߹ߤ˼ԤΥå
		const char* PrintDlgWrongValueMsg;		// Ϥ줿ͤäΥå
		const char* FailedToStartPdlGenMsg;		// PostScriptץεư˼ԤȤΥå
		const char* PdlGenNameIsInvalidMsg;		// PoscStriptץΥѥ̾λ꤬ʾΥå
		const char* FailedToStartLprMsg;		// Lprޥɤεư˼ԤȤΥå
		const char* LprNameIsInvalidMsg;		// LprޥɤΥѥ̾λ꤬ʾΥå
		const char* FailedToGenPSMsg;			// PostScript˼ԤΥå
		const char* FailedToGenPSMsgWithStatus;	// PostScriptץब۾ｪλȤΥå
		const char* FailedToLprMsgWithStatus;	// Lprޥɤ۾ｪλȤΥå
		const char* TargetPrinterNameIsInvalidMsg;	// ץ̾λ꤬
		const char* PaperSizeIsInvalidMsg;		// ѻ極λ꤬
		const char* FailToGetPID;				// getpid˼ԤΥå
		const char* FailToCreateChildProcess;	// ҥץ˼ԤΥå
		const char* FileOpenDlgTitle;		// ե򳫤Υȥ
		const char* FileSaveDlgTitle;		// ̾դ¸Υȥ
		const char* NormalTextF_ColorName;	// ƥȤ褹뿧̾
		const char* NormalTextB_ColorName;	// ƥȤطʤο̾
		const char* SelectedTextF_ColorName;	// 򤵤줿ƥȤο̾
		const char* SelectedTextB_ColorName;	// 򤵤줿ƥȤطʤο̾
		const char* BackgroundColorName;	// طʤο̾
		const char* CursorColorName;		// 褹뿧̾
		const char* PreEditTextF_ColorName;	// ԽΥƥȤο̾
		const char* PreEditTextB_ColorName;	// ԽΥƥȤطʤο̾
		const char* CurLineUnderBar_ColorName;	// 뤬Ԥ˰ο
		const char* DrawCurLineUnderBar;	// 뤬Ԥ˲ݤ
		int CurrentLineUnderbarPosition;	// 褹
		const char* EditMark_ColorName;		// Խο
		const char* DrawEditMark;			// Խ褹뤫ݤ
		const char* FontName;				// ѤեȤ̾
		int TabWidth;						// Tab
		const char* CantFindTextMsg;		// оݤʸ󤬸ĤʤȤΥå
		const char* WrongRegexPatternMsg;	// ɽΥѥ󤬴ְäƤȤΥå
		const char* WRP_EofNotAnticipated;	// ɽθθͽʤEOF
		const char* WRP_OutOfMemory;		// Ʊ­
		const char* WRP_UncertainChar;		// ƱǧǤʤʸ
		const char* WRP_ZeroLengthPattern;	// ƱѥĹ0
		const char* WRP_Unexpected;		// Ʊͽʤ顼
		const char* AppTitle;			// ץꥱΥȥ̾
		const char* TitleFormat;		// ȥԤɽʸΥեޥå
		const char* CharSelType;		// ʸˡ
		int LeftPadding;			// ü;
		int RightPadding;			// ü;
		int LineNumberOrigin;		// ֹγ
		int LineGapWidth;			// Դ֤
		const char* TabWidthCalculationMethod;	// η׻ˡ
		const char* TabString;				// ֥Ϥʸ
		const char* ProcUpScript;			// ץư줿Ȥ˼¹Ԥ륳ޥ
		const char* FileReadScript;			// եɤ߹߻˼¹Ԥ륳ޥ
		const char* FileAfterReadScript;	// եɤ߹߸˼¹Ԥ륳ޥ
		const char* FileBeforeWriteScript;	// ե񤭹˼¹Ԥ륳ޥ
		const char* FileWriteScript;		// ե񤭹߻˼¹Ԥ륳ޥ
		const char* FileCloseScript;		// ե뤬ĤȤ˼¹Ԥ륳ޥ
		const char* ProcDownScript;			// ץλȤ˼¹Ԥ륳ޥ
		const char* AutoIndent;				// ưǥȤ̵ͭ
		const char* IndentChar;				// ǥоݤʸ
		const char* WordCharSet;			// ñ˻Ѥʸ
		const char* DropFileOpenMethod;		// ɥåפ줿եγ
		const char* Btn2Func;				// ޥܥεư
		int MaxUndoCount;			// Undoǽʲ
		int HScrollAt;				// ưȼԤñ
		const char* ClipboardEncode;		// ʸ򥯥åץܡɤĥդȤΥ󥳡
		int ShowPrecessingDlgDelay;			// ɽޤǤٱ
		int WindowWidth;					// ֤ˤ륦ɥ
		int WindowHeight;					// ֤ˤ륦ɥι⤵
		int ScrollMouseSpeed;				// ޥǤΥ뤹®
		const char* IconImageName;			// ѥԥåޥåפ̾
		int ExInfoColumnCount;				// ̺¦ˤ⤦ĥΰο
		int ExInfoColumnWidth;				// Ƴĥΰ
		const char* ExInfoColumnColor;		// Ƴĥΰο
		const char* DrawSeparatorLine;		// ¦ΥʬΥݤ
		const char* SeparatorLineColor;		// ¦ΥʬΥο
		int AutoSaveInterval;				// ư¸Ԥֳ
		const char* AutoSaveNewFileMethod;	// ̾ʤեФ뼫ư¸ν
		const char* ModifiedSignStr;		// 줿Ȥ򼨤ȥɽʸ
		const char* InsertTabToEmptyLine;	// TabˤʣԤΥǥȤԤȤԤTab뤫ݤ
		const char* UseDoubleBuffering;		// ֥Хåե󥰤Ȥݤ
		int CPUCount;						// ܤƤCPUο
		const char* UseWriteTmpFile;		// եϻ˰եѤ뤫ݤ
		const char* EncodeName;				// եɤ߹ߡ񤭽Ф˻Ѥ륨󥳡̾
		const char* CurrentEncodeText;		// ָߤΥǤΥ󥳡ɡפɽ̾
		const char* CursorBehaviorMode;		// ư⡼
		int LineNumberColumnWidth;			// ֹɽΰ
		const char* LineNumberF_Color;		// ֹ褹뿧
		const char* LineNumberB_Color;		// ֹ褹ΰطʿ
		int ModifyLineMarkNumber;			// ѹ줿Ԥ򼨤ĥΰΥ
		const char* ClearUndoOnSave;		// ¸UndoꥹȤ˴뤫ݤ
		const char* PrintDlg_ValueRegFile;	// Ϥ줿ͤ¸ե̾
		const char* PrintDlg_DefaultValueRegFile;	// νͤݻե̾
		const char* PrintDlg_PaperSizeConfFileName;	// ѻ極ͤݻե̾
		const char* PrintDlg_FontList;		// ɽե̾Υꥹ
		const char* PrintDlg_PostScriptEncode;	// PostScriptǤΥ󥳡
		const char* PrintDlg_PrinterConfFileName;	// printer.confեΥե̾
		const char* PrintDlg_lpr_Args;		// ˻Ѥlprޥ
		int LangTypeEnableMaxSize;				// ⡼ɤѤ롢եκĹ
		const char* CPP_FileExt;				// C++⡼ɤǳեγĥ
		const char* JAVA_FileExt;				// Java⡼ɤǳեγĥ
		const char* COBOL_FileExt;				// Cobol⡼ɤǳեγĥ
		const char* JS_FileExt;					// JavaScript⡼ɤǳեγĥ
		const char* VBS_FileExt;				// VBScript⡼ɤǳեγĥ
		const char* CS_FileExt;					// C#⡼ɤǳեγĥ
		const char* HTML_FileExt;				// HTML⡼ɤǳեγĥ
		const char* CPP_KeywordList;				// C++⡼ɤǻѤ륭ɤΰɽΥե̾
		const char* JAVA_KeywordList;				// Java⡼ɤǻѤ륭ɤΰɽΥե̾
		const char* COBOL_KeywordList;				// Cobol⡼ɤǻѤ륭ɤΰɽΥե̾
		const char* JS_KeywordList;					// JavaScript⡼ɤǻѤ륭ɤΰɽΥե̾
		const char* VBS_KeywordList;				// VBScript⡼ɤǻѤ륭ɤΰɽΥե̾
		const char* CS_KeywordList;					// C#⡼ɤǻѤ륭ɤΰɽΥե̾
		const char* HTML_KeywordList;				// HTML⡼ɤǻѤ륭ɤΰɽΥե̾
		const char* CPP_NormalTextF_ColorName;	// C++Ǥ̾ʸο
		const char* CPP_KeywordF_ColorName;		// C++ǤΥɤο
		const char* CPP_CommentF_ColorName;		// C++ǤΥȤο
		const char* CPP_SringF_ColorName;		// C++Ǥʸο
		const char* JAVA_NormalTextF_ColorName;	// JavaǤ̾ʸο
		const char* JAVA_KeywordF_ColorName;	// JavaǤΥɤο
		const char* JAVA_CommentF_ColorName;	// JavaǤΥȤο
		const char* JAVA_SringF_ColorName;		// JavaǤʸο
		const char* COBOL_NormalTextF_ColorName;	// CobolǤ̾ʸο
		const char* COBOL_KeywordF_ColorName;		// CobolǤΥɤο
		const char* COBOL_CommentF_ColorName;		// CobolǤΥȤο
		const char* COBOL_SringF_ColorName;			// CobolǤʸο
		const char* COBOL_SequenceNumberF_ColorName;// CobolǤΰϢֹο
		const char* JS_NormalTextF_ColorName;	// JavaScriptǤ̾ʸο
		const char* JS_KeywordF_ColorName;		// JavaScriptǤΥɤο
		const char* JS_CommentF_ColorName;		// JavaScriptǤΥȤο
		const char* JS_SringF_ColorName;		// JavaScriptǤʸο
		const char* VBS_NormalTextF_ColorName;	// VBScriptǤ̾ʸο
		const char* VBS_KeywordF_ColorName;		// VBScriptǤΥɤο
		const char* VBS_CommentF_ColorName;		// VBScriptǤΥȤο
		const char* VBS_SringF_ColorName;		// VBScriptǤʸο
		const char* CS_NormalTextF_ColorName;	// C#Ǥ̾ʸο
		const char* CS_KeywordF_ColorName;		// C#ǤΥɤο
		const char* CS_CommentF_ColorName;		// C#ǤΥȤο
		const char* CS_SringF_ColorName;		// C#Ǥʸο
		const char* HTML_NormalTextF_ColorName;	// HTMLǤ̾ʸο
		const char* HTML_TagF_ColorName;		// HTMLǤΥʸο
		const char* HTML_KeywordF_ColorName;	// HTMLǤΥɤο
		const char* HTML_CommentF_ColorName;	// HTMLǤΥȤο
		const char* HTML_SringF_ColorName;		// HTMLǤʸο
		const char* PluginConfigFileName;		// ץ饰ե̾
	} AppData;
	int i;

	// ꥽ηȥǥե
	XtResource resources[] = {
		{ const_cast< char* >( "okBtnText" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, OkString ), XtRString, const_cast< char* >( "OK" ) },
		{ const_cast< char* >( "cancelBtnText"), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CancelString ), XtRString, const_cast< char* >( "Cancel" ) },
		{ const_cast< char* >( "yesBtnText" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, YesString ), XtRString, const_cast< char* >( "Yes" ) },
		{ const_cast< char* >( "noBtnText" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, NoString ), XtRString, const_cast< char* >( "No" ) },
		{ const_cast< char* >( "newFileWndTitle" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, NewFileWndTitle ), XtRString, const_cast< char* >( "Untitled" ) },
		{ const_cast< char* >( "failToConvertCharSet" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailToConvertCharSet ), XtRString, const_cast< char* >( "Failed to convert character set." ) },
		{ const_cast< char* >( "brokenLineMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, BrokenLineMsg ), XtRString, const_cast< char* >( "The line broke." ) },
		{ const_cast< char* >( "deviceIoErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, DeviceIOErrorMsg ), XtRString, const_cast< char* >( "I/O Device Error occurred." ) },
		{ const_cast< char* >( "textEncodeErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, TextEncodeErrorMsg ), XtRString, const_cast< char* >( "The data obtained from the input stream doesn't compose a correct character. " ) },
		{ const_cast< char* >( "ioErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, IOErrorMsg ), XtRString, const_cast< char* >( "I/O Error occurred." ) },
		{ const_cast< char* >( "outOfMemoryErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, OutOfMemoryErrorMsg ), XtRString, const_cast< char* >( "Out of memory." ) },
		{ const_cast< char* >( "fileNameIsNotInputtedErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileNameIsNotInputtedErrorMsg ), XtRString, const_cast< char* >( "File name is not specified." ) },
		{ const_cast< char* >( "unexpectedErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, UnexpectedErrorMsg ), XtRString, const_cast< char* >( "Unexpected Error." ) },
		{ const_cast< char* >( "fileIsNotExistMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileIsNotExistMsg ), XtRString, const_cast< char* >( "File is not Exist." ) },
		{ const_cast< char* >( "specifiedNameIsDirMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, SpecifiedNameIsDirMsg ), XtRString, const_cast< char* >( "Specified name is Dir." ) },
		{ const_cast< char* >( "faultFileOpenMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FaultFileOpenMsg ), XtRString, const_cast< char* >( "File open Error occurred." ) },
		{ const_cast< char* >( "preservationCheckMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PreservationCheckMsg ), XtRString, const_cast< char* >( "The file is not saved. Does it save?" ) },
		{ const_cast< char* >( "runScriptEAGAINMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RunScriptEAGAINMsg ), XtRString, const_cast< char* >( "The number of processes exceeded restriction of a system." ) },
		{ const_cast< char* >( "runScriptEINTRMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RunScriptEINTRMsg ), XtRString, const_cast< char* >( "Child process was interrupted." ) },
		{ const_cast< char* >( "runScriptENOMEMMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RunScriptENOMEMMsg ), XtRString, const_cast< char* >( "The new process requires more memory than is available." ) },
		{ const_cast< char* >( "runScriptCancelOpenMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RunScriptCancelOpenMsg ), XtRString, const_cast< char* >( "File open was canceled by File-Read-Script" ) },
		{ const_cast< char* >( "runScriptCancelSaveMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RunScriptCancelSaveMsg ), XtRString, const_cast< char* >( "File Save was canceled by File-Before-Write-Script" ) },
		{ const_cast< char* >( "showCancelOpenMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ShowCancelOpenMsg ), XtRString, const_cast< char* >( "True" ) },
		{ const_cast< char* >( "showCancelSaveMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ShowCancelSaveMsg ), XtRString, const_cast< char* >( "True" ) },
		{ const_cast< char* >( "faultLoadPluginLibraryMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FaultLoadPluginLibraryMsg ), XtRString, const_cast< char* >( "Fault to load library %1.\nReason : %2" ) },
		{ const_cast< char* >( "faultGetPluginFunctionMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FaultGetPluginFunctionMsg ), XtRString, const_cast< char* >( "Fault to get Function %2 on library %1.\nReason : %3" ) },
		{ const_cast< char* >( "faultToSaveTmpFileMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FaultToSaveTmpFileMsg ), XtRString, const_cast< char* >( "Fault to save temporary file." ) },
		{ const_cast< char* >( "retryWithoutSaveTmpFileMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RetryWithoutSaveTmpFileMsg ), XtRString, const_cast< char* >( "It failed to take refuge in the temporary file.\nDo you want to retry it without refuge?" ) },
		{ const_cast< char* >( "failedToInitConstructionModeMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToInitConstructionModeMsg ), XtRString, const_cast< char* >( "It failed to initialize construction mode." ) },
		{ const_cast< char* >( "constructionCommunicationErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ConstructionCommunicationErrorMsg ), XtRString, const_cast< char* >( "It failed to comunicate with server." ) },
		{ const_cast< char* >( "rebootServerMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RebootServerMsg ), XtRString, const_cast< char* >( "Syuhitu server was rebooted." ) },
		{ const_cast< char* >( "failedToRebootServerMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToRebootServerMsg ), XtRString, const_cast< char* >( "It failed to reboot syuhitu server." ) },
		{ const_cast< char* >( "serverRevokedMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ServerRevokedMsg ), XtRString, const_cast< char* >( "Server was revoked. Syuhitu will be standalone mode." ) },
		{ const_cast< char* >( "fileIsOpenedByAnotherMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileIsOpenedByAnotherMsg ), XtRString, const_cast< char* >( "Specified file has been opened by another Syuhitu instance." ) },
		{ const_cast< char* >( "replaceStrIsNullMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ReplaceStrIsNullMsg ), XtRString, const_cast< char* >( "Change to string is empty." ) },
		{ const_cast< char* >( "failedToStartEncodeConverterMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToStartEncConvMsg ), XtRString, const_cast< char* >( "Failed to start encode converter." ) },
		{ const_cast< char* >( "encodeNameIsInvalidMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, EncodeNameIsInvalidMsg ), XtRString, const_cast< char* >( "Specified encode name is invalid." ) },
		{ const_cast< char* >( "failedToConvertEncodeMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToConvertEncodeMsg ), XtRString, const_cast< char* >( "Failed to convert encode." ) },
		{ const_cast< char* >( "failedToReadKeywordListMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToReadKeywordListMsg ), XtRString, const_cast< char* >( "Failed to read keyword list file." ) },
		{ const_cast< char* >( "failedToReadPaperSizeConfigMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToReadPaperSizeConfigMsg ), XtRString, const_cast< char* >( "Failed to read paper size configuration." ) },
		{ const_cast< char* >( "failedToReadPrinterConfMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToReadPrinterConfMsg ), XtRString, const_cast< char* >( "Failed to get printer names." ) },
		{ const_cast< char* >( "printDlgWrongValueMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PrintDlgWrongValueMsg ), XtRString, const_cast< char* >( "Input value was wrong.\nIt is automatically corrected." ) },
		{ const_cast< char* >( "failedToStartPdlGenMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToStartPdlGenMsg ), XtRString, const_cast< char* >( "Failed to start TaEditPdlGen." ) },
		{ const_cast< char* >( "pdlGenNameIsInvalidMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PdlGenNameIsInvalidMsg ), XtRString, const_cast< char* >( "Specified path name of TaEditPdlGen was invalid." ) },
		{ const_cast< char* >( "failedToStartLprMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToStartLprMsg ), XtRString, const_cast< char* >( "Failed to start lpr command." ) },
		{ const_cast< char* >( "lprNameIsInvalidMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, LprNameIsInvalidMsg ), XtRString, const_cast< char* >( "Specified path name of lpr command was invalid." ) },
		{ const_cast< char* >( "failedToGenPSMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToGenPSMsg ), XtRString, const_cast< char* >( "Failed to generate PostScript." ) },
		{ const_cast< char* >( "failedToGenPSMsgWithStatus" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToGenPSMsgWithStatus ), XtRString, const_cast< char* >( "PostScript generator error terminated.\nStatus = \"%1\"" ) },
		{ const_cast< char* >( "failedToLprMsgWithStatus" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailedToLprMsgWithStatus ), XtRString, const_cast< char* >( "Lpr command error terminated.\nStatus = \"%1\"\nMessage = \"%2\"" ) },
		{ const_cast< char* >( "targetPrinterNameIsInvalidMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, TargetPrinterNameIsInvalidMsg ), XtRString, const_cast< char* >( "Specified target printer name is invalid." ) },
		{ const_cast< char* >( "paperSizeIsInvalidMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PaperSizeIsInvalidMsg ), XtRString, const_cast< char* >( "Specified paper size is invalid." ) },
		{ const_cast< char* >( "failToGetPID" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailToGetPID ), XtRString, const_cast< char* >( "Fail to getpid." ) },
		{ const_cast< char* >( "failToCreateChildProcess" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailToCreateChildProcess ), XtRString, const_cast< char* >( "Fail to create child process." ) },
		{ const_cast< char* >( "fileOpenDlgTitle" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileOpenDlgTitle ), XtRString, const_cast< char* >( "Open" ) },
		{ const_cast< char* >( "fileSaveDlgTitle" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileSaveDlgTitle ), XtRString, const_cast< char* >( "Save" ) },
		{ const_cast< char* >( "normalTextForegroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "normalTextBackgroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, NormalTextB_ColorName ), XtRString, const_cast< char* >( "White" ) },
		{ const_cast< char* >( "selectedTextForegroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, SelectedTextF_ColorName ), XtRString, const_cast< char* >( "White" ) },
		{ const_cast< char* >( "selectedTextBackgroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, SelectedTextB_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "backgroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, BackgroundColorName ), XtRString, const_cast< char* >( "White" ) },
		{ const_cast< char* >( "cursorColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CursorColorName ), XtRString, const_cast< char* >( "White" ) },
		{ const_cast< char* >( "preEditTextForegroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PreEditTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "preEditTextBackgroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PreEditTextB_ColorName ), XtRString, const_cast< char* >( "White" ) },
		{ const_cast< char* >( "currentLineUnderbarColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CurLineUnderBar_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "drawCurrentLineUnderbar" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, DrawCurLineUnderBar ), XtRString, const_cast< char* >( "True" ) },
		{ const_cast< char* >( "currentLineUnderbarPosition" ), XtCHeight, XtRInt, sizeof( int ), XtOffset( tagAppData*, CurrentLineUnderbarPosition ), XtRString, const_cast< char* >( "0" ) },
		{ const_cast< char* >( "editMarkColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, EditMark_ColorName ), XtRString, const_cast< char* >( "DarkGrey" ) },
		{ const_cast< char* >( "drawEditMark" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, DrawEditMark ), XtRString, const_cast< char* >( "True" ) },
		{ const_cast< char* >( "fontName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FontName ), XtRString, const_cast< char* >( "*-14-*" ) },
		{ const_cast< char* >( "tabWidth" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, TabWidth ), XtRString, const_cast< char* >( "8" ) },
		{ const_cast< char* >( "cantFindTextMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CantFindTextMsg ), XtRString, const_cast< char* >( "Target string is not exist.\nDo you search agein at the first line ?" ) },
		{ const_cast< char* >( "wrongRegexPatternMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WrongRegexPatternMsg ), XtRString, const_cast< char* >( "Regular expression pattern is wrong.\n%1 : %2" ) },
		{ const_cast< char* >( "WRP_EofNotAnticipated" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WRP_EofNotAnticipated ), XtRString, const_cast< char* >( "EOF not anticipated." ) },
		{ const_cast< char* >( "WRP_OutOfMemory" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WRP_OutOfMemory ), XtRString, const_cast< char* >( "Out of memory." ) },
		{ const_cast< char* >( "WRP_UncertainChar" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WRP_UncertainChar ), XtRString, const_cast< char* >( "Uncertain char." ) },
		{ const_cast< char* >( "WRP_ZeroLengthPattern" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WRP_ZeroLengthPattern ), XtRString, const_cast< char* >( "Pattern is not exist." ) },
		{ const_cast< char* >( "WRP_Unexpected" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WRP_Unexpected ), XtRString, const_cast< char* >( "Unexpected error." ) },
		{ const_cast< char* >( "appTitle" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, AppTitle ), XtRString, const_cast< char* >( "Syuhitu" ) },
		{ const_cast< char* >( "titleFormat" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, TitleFormat ), XtRString, const_cast< char* >( "%1 : %2 : %4 : %5 %3" ) },
		{ const_cast< char* >( "characterSelectionType" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CharSelType ), XtRString, const_cast< char* >( "CENTER" ) },
		{ const_cast< char* >( "leftPadding" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, LeftPadding ), XtRString, const_cast< char* >( "5" ) },
		{ const_cast< char* >( "rightPadding" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, RightPadding ), XtRString, const_cast< char* >( "5" ) },
		{ const_cast< char* >( "lineNumberOrigin" ), XtCY, XtRInt, sizeof( int ), XtOffset( tagAppData*, LineNumberOrigin ), XtRString, const_cast< char* >( "1" ) },
		{ const_cast< char* >( "lineGapWidth" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, LineGapWidth ), XtRString, const_cast< char* >( "0" ) },
		{ const_cast< char* >( "tabWidthCalculationMethod" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, TabWidthCalculationMethod ), XtRString, const_cast< char* >( "Flex" ) },
		{ const_cast< char* >( "tabString" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, TabString ), XtRString, const_cast< char* >( "\t" ) },
		{ const_cast< char* >( "procUpScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ProcUpScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "fileReadScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileReadScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "fileAfterReadScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileAfterReadScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "fileBeforeWriteScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileBeforeWriteScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "fileWriteScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileWriteScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "fileCloseScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileCloseScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "procDownScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ProcDownScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "autoIndent" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, AutoIndent ), XtRString, const_cast< char* >( "True" ) },
		{ const_cast< char* >( "indentChar" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, IndentChar ), XtRString, const_cast< char* >( "\t " ) },
		{ const_cast< char* >( "wordCharSet" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WordCharSet ), XtRString, const_cast< char* >( "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_" ) },
		{ const_cast< char* >( "dropFileOpenMethod" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, DropFileOpenMethod ), XtRString, const_cast< char* >( "Current" ) },
		{ const_cast< char* >( "mouseButton2Function" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, Btn2Func ), XtRString, const_cast< char* >( "Left" ) },
		{ const_cast< char* >( "maxUndoCount" ), XtCLength, XtRInt, sizeof( int ), XtOffset( tagAppData*, MaxUndoCount ), XtRString, const_cast< char* >( "100" ) },
		{ const_cast< char* >( "hScrollAt" ), XtCWidth, XtRInt, sizeof( unsigned int ), XtOffset( tagAppData*, HScrollAt ), XtRString, const_cast< char* >( "50" ) },
		{ const_cast< char* >( "clipboardEncode" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ClipboardEncode ), XtRString, const_cast< char* >( "ASCII" ) },
		{ const_cast< char* >( "showPrecessingDlgDelay" ), XtCInterval, XtRInt, sizeof( int ), XtOffset( tagAppData*, ShowPrecessingDlgDelay ), XtRString, const_cast< char* >( "1000" ) },
		{ const_cast< char* >( "windowWidth" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, WindowWidth ), XtRString, const_cast< char* >( "640" ) },
		{ const_cast< char* >( "windowHeight" ), XtCHeight, XtRInt, sizeof( int ), XtOffset( tagAppData*, WindowHeight ), XtRString, const_cast< char* >( "480" ) },
		{ const_cast< char* >( "scrollMouseSpeed" ), XtCLength, XtRInt, sizeof( int ), XtOffset( tagAppData*, ScrollMouseSpeed ), XtRString, const_cast< char* >( "3" ) },
		{ const_cast< char* >( "iconImageName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, IconImageName ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "extendInfoColumnCount" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, ExInfoColumnCount ), XtRString, const_cast< char* >( "0" ) },
		{ const_cast< char* >( "extendInfoColumnWidth" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, ExInfoColumnWidth ), XtRString, const_cast< char* >( "5" ) },
		{ const_cast< char* >( "extendInfoColumnColor" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ExInfoColumnColor ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "drawSeparatorLine" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, DrawSeparatorLine ), XtRString, const_cast< char* >( "False" ) },
		{ const_cast< char* >( "separatorLineColor" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, SeparatorLineColor ), XtRString, const_cast< char* >( "gray" ) },
		{ const_cast< char* >( "autoSaveInterval" ), XtCInterval, XtRInt, sizeof( int ), XtOffset( tagAppData*, AutoSaveInterval ), XtRString, const_cast< char* >( "0" ) },
		{ const_cast< char* >( "autoSaveNewFileMethod" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, AutoSaveNewFileMethod ), XtRString, const_cast< char* >( "Nothig" ) },
		{ const_cast< char* >( "modifiedSignStr" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ModifiedSignStr ), XtRString, const_cast< char* >( ": (Modified)" ) },
		{ const_cast< char* >( "insertTabToEmptyLine" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, InsertTabToEmptyLine ), XtRString, const_cast< char* >( "False" ) },
		{ const_cast< char* >( "useDoubleBuffering" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, UseDoubleBuffering ), XtRString, const_cast< char* >( "True" ) },
		{ const_cast< char* >( "CPUCount" ), XtCParameter, XtRInt, sizeof( int ), XtOffset( tagAppData*, CPUCount ), XtRString, const_cast< char* >( "1" ) },
		{ const_cast< char* >( "useWriteTmpFile" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, UseWriteTmpFile ), XtRString, const_cast< char* >( "False" ) },
		{ const_cast< char* >( "encodeName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, EncodeName ), XtRString, const_cast< char* >( "C" ) },
		{ const_cast< char* >( "currentEncodeText" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CurrentEncodeText ), XtRString, const_cast< char* >( "Current Locale" ) },
		{ const_cast< char* >( "cursorBehaviorMode" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CursorBehaviorMode ), XtRString, const_cast< char* >( "Memory" ) },
		{ const_cast< char* >( "lineNumberColumnWidth" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, LineNumberColumnWidth ), XtRString, const_cast< char* >( "35" ) },
		{ const_cast< char* >( "lineNumberColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, LineNumberF_Color ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "modifyLineMarkNumber" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, ModifyLineMarkNumber ), XtRString, const_cast< char* >( "-1" ) },
		{ const_cast< char* >( "clearUndoOnSave" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ClearUndoOnSave ), XtRString, const_cast< char* >( "False" ) },
		{ const_cast< char* >( "PrintDlg_ValueRegFile" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PrintDlg_ValueRegFile ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "PrintDlg_DefaultValueRegFile" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PrintDlg_DefaultValueRegFile ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "PrintDlg_PaperSizeConfFileName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PrintDlg_PaperSizeConfFileName ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "PrintDlg_FontList" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PrintDlg_FontList ), XtRString, const_cast< char* >( "Times-Roman,Helvetica,Courier" ) },
		{ const_cast< char* >( "PrintDlg_PostScriptEncode" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PrintDlg_PostScriptEncode ), XtRString, const_cast< char* >( "ASCII" ) },
		{ const_cast< char* >( "PrintDlg_PrinterConfFileName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PrintDlg_PrinterConfFileName ), XtRString, const_cast< char* >( "/etc/printers.conf" ) },
		{ const_cast< char* >( "PrintDlg_lpr_Args" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PrintDlg_lpr_Args ), XtRString, const_cast< char* >( "-P %1 -# %2" ) },
		{ const_cast< char* >( "langTypeEnableMaxSize" ), XtCLength, XtRInt, sizeof( int ), XtOffset( tagAppData*, LangTypeEnableMaxSize ), XtRString, const_cast< char* >( "524288" ) },
		{ const_cast< char* >( "CPP_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_FileExt ), XtRString, const_cast< char* >( "c,cc,cpp,cxx,h,hpp" ) },
		{ const_cast< char* >( "JAVA_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_FileExt ), XtRString, const_cast< char* >( "java" ) },
		{ const_cast< char* >( "COBOL_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_FileExt ), XtRString, const_cast< char* >( "cob,cbl,cobol" ) },
		{ const_cast< char* >( "JS_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_FileExt ), XtRString, const_cast< char* >( "js" ) },
		{ const_cast< char* >( "VBS_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_FileExt ), XtRString, const_cast< char* >( "vbs" ) },
		{ const_cast< char* >( "CS_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_FileExt ), XtRString, const_cast< char* >( "cs" ) },
		{ const_cast< char* >( "HTML_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, HTML_FileExt ), XtRString, const_cast< char* >( "html,htm" ) },
		{ const_cast< char* >( "CPP_KeywordList" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_KeywordList ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "JAVA_KeywordList" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_KeywordList ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "COBOL_KeywordList" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_KeywordList ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "JS_KeywordList" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_KeywordList ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "VBS_KeywordList" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_KeywordList ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "CS_KeywordList" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_KeywordList ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "HTML_KeywordList" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, HTML_KeywordList ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "CPP_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "CPP_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "CPP_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "CPP_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "JAVA_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "JAVA_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "JAVA_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "JAVA_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "COBOL_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "COBOL_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "COBOL_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "COBOL_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "COBOL_SequenceNumberF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_SequenceNumberF_ColorName ), XtRString, const_cast< char* >( "DarkGrey" ) },
		{ const_cast< char* >( "JS_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "JS_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "JS_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "JS_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "VBS_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "VBS_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "VBS_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "VBS_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "CS_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "CS_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "CS_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "CS_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "HTML_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, HTML_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "HTML_TagF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, HTML_TagF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "HTML_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, HTML_KeywordF_ColorName ), XtRString, const_cast< char* >( "Red" ) },
		{ const_cast< char* >( "HTML_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, HTML_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "HTML_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, HTML_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "pluginConfigFileName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PluginConfigFileName ), XtRString, const_cast< char* >( "" ) },
	};

	mapPixelCash.clear();

	// ꥽ͤ
	XtGetApplicationResources( m_Widget, &AppData, resources, XtNumber( resources ), NULL, 0 );

	// ѿ˼
	OkStr.SetStr( AppData.OkString );
	CancelStr.SetStr( AppData.CancelString );
	YesStr.SetStr( AppData.YesString );
	NoStr.SetStr( AppData.NoString );
	GlbFunc::MBStoWCS( AppData.NewFileWndTitle, &NewFileWndTitleStr );
	FailToConvertCharSet.SetStr( AppData.FailToConvertCharSet );
	BrokenLineMsg.SetStr( AppData.BrokenLineMsg );
	DeviceIOErrorMsg.SetStr( AppData.DeviceIOErrorMsg );
	TextEncodeErrorMsg.SetStr( AppData.TextEncodeErrorMsg );
	IOErrorMsg.SetStr( AppData.IOErrorMsg );
	OutOfMemoryErrorMsg.SetStr( AppData.OutOfMemoryErrorMsg );
	FileNameIsNotInputtedErrorMsg.SetStr( AppData.FileNameIsNotInputtedErrorMsg );
	UnexpectedErrorMsg.SetStr( AppData.UnexpectedErrorMsg );
	FileIsNotExistMsg.SetStr( AppData.FileIsNotExistMsg );
	SpecifiedNameIsDirMsg.SetStr( AppData.SpecifiedNameIsDirMsg );
	FaultFileOpenMsg.SetStr( AppData.FaultFileOpenMsg );
	PreservationCheckMsg.SetStr( AppData.PreservationCheckMsg );
	RunScriptEAGAINMsg.SetStr( AppData.RunScriptEAGAINMsg );
	RunScriptEINTRMsg.SetStr( AppData.RunScriptEINTRMsg );
	RunScriptENOMEMMsg.SetStr( AppData.RunScriptENOMEMMsg );
	RunScriptCancelOpenMsg.SetStr( AppData.RunScriptCancelOpenMsg );
	RunScriptCancelSaveMsg.SetStr( AppData.RunScriptCancelSaveMsg );
	ShowCancelOpenMsg = GlbFunc::MbsToBoolean( AppData.ShowCancelOpenMsg, false );
	ShowCancelSaveMsg = GlbFunc::MbsToBoolean( AppData.ShowCancelSaveMsg, false );
	FaultLoadPluginLibraryMsg = AppData.FaultLoadPluginLibraryMsg;
	FaultGetPluginFunctionMsg = AppData.FaultGetPluginFunctionMsg;
	FaultToSaveTmpFileMsg.SetStr( AppData.FaultToSaveTmpFileMsg );
	RetryWithoutSaveTmpFileMsg.SetStr( AppData.RetryWithoutSaveTmpFileMsg );
	FailedToInitConstructionModeMsg.SetStr( AppData.FailedToInitConstructionModeMsg );
	ConstructionCommunicationErrorMsg.SetStr( AppData.ConstructionCommunicationErrorMsg );
	RebootServerMsg.SetStr( AppData.RebootServerMsg );
	FailedToRebootServerMsg.SetStr( AppData.FailedToRebootServerMsg );
	ServerRevokedMsg.SetStr( AppData.ServerRevokedMsg );
	FileIsOpenedByAnotherMsg.SetStr( AppData.FileIsOpenedByAnotherMsg );
	ReplaceStrIsNullMsg.SetStr( AppData.ReplaceStrIsNullMsg );
	FailedToStartEncConvMsg.SetStr( AppData.FailedToStartEncConvMsg );
	EncodeNameIsInvalidMsg.SetStr( AppData.EncodeNameIsInvalidMsg );
	FailedToConvertEncodeMsg.SetStr( AppData.FailedToConvertEncodeMsg );
	FailedToReadKeywordListMsg.SetStr( AppData.FailedToReadKeywordListMsg );
	FailedToReadPaperSizeConfigMsg.SetStr( AppData.FailedToReadPaperSizeConfigMsg );
	FailedToReadPrinterConfMsg.SetStr( AppData.FailedToReadPrinterConfMsg );
	PrintDlgWrongValueMsg.SetStr( AppData.PrintDlgWrongValueMsg );
	FailedToStartPdlGenMsg.SetStr( AppData.FailedToStartPdlGenMsg );
	PdlGenNameIsInvalidMsg.SetStr( AppData.PdlGenNameIsInvalidMsg );
	FailedToStartLprMsg.SetStr( AppData.FailedToStartLprMsg );
	LprNameIsInvalidMsg.SetStr( AppData.LprNameIsInvalidMsg );
	FailedToGenPSMsg.SetStr( AppData.FailedToGenPSMsg );
	FailedToGenPSMsgWithStatus = AppData.FailedToGenPSMsgWithStatus;
	FailedToLprMsgWithStatus = AppData.FailedToLprMsgWithStatus;
	TargetPrinterNameIsInvalidMsg.SetStr( AppData.TargetPrinterNameIsInvalidMsg );
	PaperSizeIsInvalidMsg.SetStr( AppData.PaperSizeIsInvalidMsg );
	FailToGetPID.SetStr( AppData.FailToGetPID );
	FailToCreateChildProcess.SetStr( AppData.FailToCreateChildProcess );
	FileOpenDlgTitle.SetStr( AppData.FileOpenDlgTitle );
	FileSaveDlgTitle.SetStr( AppData.FileSaveDlgTitle );
	NormalTextF_Color = AppData.NormalTextF_ColorName;
	NormalTextB_Color = AppData.NormalTextB_ColorName;
	SelectedTextF_Color = AppData.SelectedTextF_ColorName;
	SelectedTextB_Color = AppData.SelectedTextB_ColorName;
	BackgroundColor = AppData.BackgroundColorName;
	CursorColor = AppData.CursorColorName;
	PreEditTextF_Color = AppData.PreEditTextF_ColorName;
	PreEditTextB_Color = AppData.PreEditTextB_ColorName;
	CurLineUnderBar_Color = AppData.CurLineUnderBar_ColorName;
	DrawCurLineUnderBar = GlbFunc::MbsToBoolean( AppData.DrawCurLineUnderBar, false );
	CurrentLineUnderbarPosition = GlbFunc::CheckRange( AppData.CurrentLineUnderbarPosition, -32767, 32767 );
	EditMark_Color = AppData.EditMark_ColorName;
	DrawEditMark = GlbFunc::MbsToBoolean( AppData.DrawEditMark, false );
	FontName = AppData.FontName;
	TabWidth = GlbFunc::CheckRange( AppData.TabWidth, 1, 100 );
	CantFindTextMsg.SetStr( AppData.CantFindTextMsg );
	GlbFunc::MBStoWCS( AppData.WrongRegexPatternMsg, &WrongRegexPatternMsg );
	GlbFunc::MBStoWCS( AppData.WRP_EofNotAnticipated, &WRP_EofNotAnticipated );
	GlbFunc::MBStoWCS( AppData.WRP_OutOfMemory, &WRP_OutOfMemory );
	GlbFunc::MBStoWCS( AppData.WRP_UncertainChar, &WRP_UncertainChar );
	GlbFunc::MBStoWCS( AppData.WRP_ZeroLengthPattern, &WRP_ZeroLengthPattern );
	GlbFunc::MBStoWCS( AppData.WRP_Unexpected, &WRP_Unexpected );
	GlbFunc::MBStoWCS( AppData.AppTitle, &AppTitle );
	GlbFunc::MBStoWCS( AppData.TitleFormat, &TitleFormat );
	CharSelType = GlbFunc::MbsToValue( AppData.CharSelType, CST_CENTER, 3, "left", CST_LEFT, "right", CST_RIGHT, "center", CST_CENTER );
	LeftPadding = GlbFunc::CheckRange( AppData.LeftPadding, 0, 1024 );
	RightPadding = GlbFunc::CheckRange( AppData.RightPadding, 0, 1024 );
	LineNumberOrigin = AppData.LineNumberOrigin;
	LineGapWidth = AppData.LineGapWidth;
	TabWidthCalculationMethod = GlbFunc::MbsToValue( AppData.TabWidthCalculationMethod, TWCM_FLEX, 2, "Fix", TWCM_FIX, "Flex", TWCM_FLEX );
	if ( !GlbFunc::MBStoWCS( AppData.TabString, &TabString ) ) TabString =L"\t";
	ProcUpScript = AppData.ProcUpScript;
	FileReadScript = AppData.FileReadScript;
	FileAfterReadScript = AppData.FileAfterReadScript;
	FileBeforeWriteScript = AppData.FileBeforeWriteScript;
	FileWriteScript = AppData.FileWriteScript;
	FileCloseScript = AppData.FileCloseScript;
	ProcDownScript = AppData.ProcDownScript;
	AutoIndent = GlbFunc::MbsToBoolean( AppData.AutoIndent, false );
	GlbFunc::MBStoWCS( AppData.IndentChar, &IndentChar );
	GlbFunc::MBStoWCS( AppData.WordCharSet, &WordCharSet );
	DropFileOpenMethod = GlbFunc::MbsToValue( AppData.DropFileOpenMethod, DFOM_CURRENT_WINDOW, 2, "New", DFOM_NEW_WINDOW, "Current", DFOM_CURRENT_WINDOW );
	Btn2Func = GlbFunc::MbsToValue( AppData.Btn2Func, B2F_LEFT_SHIFT, 3, "Left", B2F_LEFT, "Left+Ctrl", B2F_LEFT_CTRL, "Left+Shift", B2F_LEFT_SHIFT );
	MaxUndoCount = GlbFunc::CheckRange( AppData.MaxUndoCount, 1, INT_MAX );
	HScrollAt = GlbFunc::CheckRange( AppData.HScrollAt, 1, INT_MAX );
	ClipboardEncode = AppData.ClipboardEncode;
	ShowPrecessingDlgDelay = GlbFunc::CheckRange( AppData.ShowPrecessingDlgDelay, 0, INT_MAX );
	WindowWidth = GlbFunc::CheckRange( AppData.WindowWidth, 80, INT_MAX );
	WindowHeight = GlbFunc::CheckRange( AppData.WindowHeight, 25, INT_MAX );
	ScrollMouseSpeed = GlbFunc::CheckRange( AppData.ScrollMouseSpeed, 0, 10000 );
	IconImageName = AppData.IconImageName;
	ExInfoColumnCount = GlbFunc::CheckRange( AppData.ExInfoColumnCount, 0, 9999 );
	ExInfoColumnWidth = GlbFunc::CheckRange( AppData.ExInfoColumnWidth, 1, 9999 );

	pExInfoColumnColor = new string[ ExInfoColumnCount ];
	if ( NULL == pExInfoColumnColor ) {
		// ꤬ݤǤʤä顢
		ExInfoColumnCount = 0;
	}
	else {
		// ޤǶڤ줿̾
		vector< string > vColName = GlbFunc::DiviteString( AppData.ExInfoColumnColor, ',' );
		for ( i = 0; i < vColName.size() && i < ExInfoColumnCount; i++ )
			pExInfoColumnColor[i] = GlbFunc::Trim( vColName[i], " \n\t", " \n\t" );
		for (; i < ExInfoColumnCount; i++ )
			pExInfoColumnColor[i] = "Black";
	}
	DrawSeparatorLine = GlbFunc::MbsToBoolean( AppData.DrawSeparatorLine, false );
	SeparatorLineColor = AppData.SeparatorLineColor;
	AutoSaveInterval = GlbFunc::CheckRange( AppData.AutoSaveInterval, 0, 200000000 );
	AutoSaveNewFileMethod = GlbFunc::MbsToValue( AppData.AutoSaveNewFileMethod, ASNW_ASC_NAME, 3, "Nothing", ASNW_NOTHING, "Nothig", ASNW_NOTHING, "Asc", ASNW_ASC_NAME );
	GlbFunc::MBStoWCS( AppData.ModifiedSignStr, &ModifiedSignStr );
	InsertTabToEmptyLine = GlbFunc::MbsToBoolean( AppData.InsertTabToEmptyLine, false );
	UseDoubleBuffering = GlbFunc::MbsToBoolean( AppData.UseDoubleBuffering, false );
	CPUCount = GlbFunc::CheckRange( AppData.CPUCount, 1, 65535 );
	UseWriteTmpFile = GlbFunc::MbsToBoolean( AppData.UseWriteTmpFile, false );
	EncodeName = GlbFunc::DiviteString( AppData.EncodeName, ',' );
	CurrentEncodeText = AppData.CurrentEncodeText;
	CursorBehaviorMode = GlbFunc::MbsToValue( AppData.CursorBehaviorMode, CBM_MEMORY, 2, "Forget", CBM_FORGET, "Memory", CBM_MEMORY );
	LineNumberColumnWidth = GlbFunc::CheckRange( AppData.LineNumberColumnWidth, -1, 65536 );
	LineNumberF_Color = AppData.LineNumberF_Color;
	ModifyLineMarkNumber = GlbFunc::CheckRange( AppData.ModifyLineMarkNumber, -1, ExInfoColumnCount );
	ClearUndoOnSave = GlbFunc::MbsToBoolean( AppData.ClearUndoOnSave, false );
	PrintDlg_ValueRegFile = AppData.PrintDlg_ValueRegFile;
	PrintDlg_DefaultValueRegFile = AppData.PrintDlg_DefaultValueRegFile;
	PrintDlg_PaperSizeConfFileName = AppData.PrintDlg_PaperSizeConfFileName;
	PrintDlg_FontList = AppData.PrintDlg_FontList;
	PrintDlg_PostScriptEncode = AppData.PrintDlg_PostScriptEncode;
	PrintDlg_PrinterConfFileName = AppData.PrintDlg_PrinterConfFileName;
	PrintDlg_lpr_Args = AppData.PrintDlg_lpr_Args;
	LangTypeEnableMaxSize = GlbFunc::CheckRange( AppData.LangTypeEnableMaxSize, 0, INT_MAX );
	CPP_FileExt = AppData.CPP_FileExt;
	JAVA_FileExt = AppData.JAVA_FileExt;
	COBOL_FileExt = AppData.COBOL_FileExt;
	JS_FileExt = AppData.JS_FileExt;
	VBS_FileExt = AppData.VBS_FileExt;
	CS_FileExt = AppData.CS_FileExt;
	HTML_FileExt = AppData.HTML_FileExt;
	CPP_KeywordList = AppData.CPP_KeywordList;
	JAVA_KeywordList = AppData.JAVA_KeywordList;
	COBOL_KeywordList = AppData.COBOL_KeywordList;
	JS_KeywordList = AppData.JS_KeywordList;
	VBS_KeywordList = AppData.VBS_KeywordList;
	CS_KeywordList = AppData.CS_KeywordList;
	HTML_KeywordList = AppData.HTML_KeywordList;

	CPP_NormalTextF_Color = AppData.CPP_NormalTextF_ColorName;
	CPP_KeywordF_Color = AppData.CPP_KeywordF_ColorName;
	CPP_CommentF_Color = AppData.CPP_CommentF_ColorName;
	CPP_SringF_Color = AppData.CPP_SringF_ColorName;
	JAVA_NormalTextF_Color = AppData.JAVA_NormalTextF_ColorName;
	JAVA_KeywordF_Color = AppData.JAVA_KeywordF_ColorName;
	JAVA_CommentF_Color = AppData.JAVA_CommentF_ColorName;
	JAVA_SringF_Color = AppData.JAVA_SringF_ColorName;
	COBOL_NormalTextF_Color = AppData.COBOL_NormalTextF_ColorName;
	COBOL_KeywordF_Color = AppData.COBOL_KeywordF_ColorName;
	COBOL_CommentF_Color = AppData.COBOL_CommentF_ColorName;
	COBOL_SringF_Color = AppData.COBOL_SringF_ColorName;
	COBOL_SequenceNumberF_Color = AppData.COBOL_SequenceNumberF_ColorName;
	JS_NormalTextF_Color = AppData.JS_NormalTextF_ColorName;
	JS_KeywordF_Color = AppData.JS_KeywordF_ColorName;
	JS_CommentF_Color = AppData.JS_CommentF_ColorName;
	JS_SringF_Color = AppData.JS_SringF_ColorName;
	VBS_NormalTextF_Color = AppData.VBS_NormalTextF_ColorName;
	VBS_KeywordF_Color = AppData.VBS_KeywordF_ColorName;
	VBS_CommentF_Color = AppData.VBS_CommentF_ColorName;
	VBS_SringF_Color = AppData.VBS_SringF_ColorName;
	CS_NormalTextF_Color = AppData.CS_NormalTextF_ColorName;
	CS_KeywordF_Color = AppData.CS_KeywordF_ColorName;
	CS_CommentF_Color = AppData.CS_CommentF_ColorName;
	CS_SringF_Color = AppData.CS_SringF_ColorName;
	HTML_NormalTextF_Color = AppData.HTML_NormalTextF_ColorName;
	HTML_TagF_Color = AppData.HTML_TagF_ColorName;
	HTML_KeywordF_Color = AppData.HTML_KeywordF_ColorName;
	HTML_CommentF_Color = AppData.HTML_CommentF_ColorName;
	HTML_SringF_Color = AppData.HTML_SringF_ColorName;
	PluginConfigFileName = AppData.PluginConfigFileName;
}

const CCompoundStr& CConfigInfo::RefOkStr() const
{
	assert( NULL != this );
	return OkStr;
}

const CCompoundStr& CConfigInfo::RefCancelStr() const
{
	assert( NULL != this );
	return CancelStr;
}

const CCompoundStr& CConfigInfo::RefYesStr() const
{
	assert( NULL != this );
	return YesStr;
}

const CCompoundStr& CConfigInfo::RefNoStr() const
{
	assert( NULL != this );
	return NoStr;
}

const wstring& CConfigInfo::RefNewFileWndTitleStr() const
{
	assert( NULL != this );
	return NewFileWndTitleStr;
}

const CCompoundStr& CConfigInfo::RefFailToConvertCharSet() const
{
	assert( NULL != this );
	return FailToConvertCharSet;
}

const CCompoundStr& CConfigInfo::RefBrokenLineMsg() const
{
	assert( NULL != this );
	return BrokenLineMsg;
}

const CCompoundStr& CConfigInfo::RefIOErrorMsg( int ErrorNo ) const
{
	assert( NULL != this );
	switch ( ErrorNo ) {
	case EIO:
		return DeviceIOErrorMsg;
	case ENOMEM:
		return OutOfMemoryErrorMsg;
	case EILSEQ:
		return TextEncodeErrorMsg;
	default:
		return IOErrorMsg;
	}
}

const CCompoundStr& CConfigInfo::RefOutOfMemoryErrorMsg() const
{
	assert( NULL != this );
	return OutOfMemoryErrorMsg;
}

const CCompoundStr& CConfigInfo::RefFileNameIsNotInputtedErrorMsg() const
{
	assert( NULL != this );
	return FileNameIsNotInputtedErrorMsg;
}

const CCompoundStr& CConfigInfo::RefUnexpectedErrorMsg() const
{
	assert( NULL != this );
	return UnexpectedErrorMsg;
}	

const CCompoundStr& CConfigInfo::RefFileIsNotExistMsg() const
{
	assert( NULL != this );
	return FileIsNotExistMsg;
}

const CCompoundStr& CConfigInfo::RefSpecifiedNameIsDirMsg() const
{
	assert( NULL != this );
	return SpecifiedNameIsDirMsg;
}

const CCompoundStr& CConfigInfo::RefFaultFileOpenMsg() const
{
	assert( NULL != this );
	return FaultFileOpenMsg;
}

const CCompoundStr& CConfigInfo::RefPreservationCheckMsg() const
{
	assert( NULL != this );
	return PreservationCheckMsg;
}

const CCompoundStr& CConfigInfo::RefRunScriptEAGAINMsg() const
{
	assert( NULL != this );
	return RunScriptEAGAINMsg;
}

const CCompoundStr& CConfigInfo::RefRunScriptEINTRMsg() const
{
	assert( NULL != this );
	return RunScriptEINTRMsg;
}

const CCompoundStr& CConfigInfo::RefRunScriptENOMEMMsg() const
{
	assert( NULL != this );
	return RunScriptENOMEMMsg;
}

const CCompoundStr& CConfigInfo::RefRunScriptCancelOpenMsg() const
{
	assert( NULL != this );
	return RunScriptCancelOpenMsg;
}

const CCompoundStr& CConfigInfo::RefRunScriptCancelSaveMsg() const
{
	assert( NULL != this );
	return RunScriptCancelSaveMsg;
}

// systemؿ¹ԤȤerrnoбå
const CCompoundStr& CConfigInfo::RefRunScriptErrnoMsg( int e ) const
{
	assert( NULL != this );

	switch ( e ) {
	case EAGAIN:
		return RefRunScriptEAGAINMsg();
	case EINTR:
		return RefRunScriptEINTRMsg();
	case ENOMEM:
		return RefRunScriptENOMEMMsg();
	}
	return RefUnexpectedErrorMsg();
}

bool CConfigInfo::GetShowCancelOpenMsg() const
{
	assert( NULL != this );
	return ShowCancelOpenMsg;
}

bool CConfigInfo::GetShowCancelSaveMsg() const
{
	assert( NULL != this );
	return ShowCancelSaveMsg;
}

bool CConfigInfo::GetFaultLoadPluginLibraryMsg( CCompoundStr *pCS, const string &rLibraryName, const char* pReason ) const
{
	assert( NULL != this && NULL != pCS );

	const char *p[2] = { rLibraryName.c_str(), pReason };
	string w = GlbFunc::CreateMsgString< string, char >( FaultLoadPluginLibraryMsg, 2, p );
	pCS->SetStr( w.c_str() );
	return true;
}

bool CConfigInfo::GetFaultGetPluginFunctionMsg( CCompoundStr *pCS, const string &rLibraryName, const string &rFunctionName, const char* pReason ) const
{
	assert( NULL != this && NULL != pCS );

	const char *v[] = { rLibraryName.c_str(), rFunctionName.c_str(), pReason };
	string w = GlbFunc::CreateMsgString< string, char >( FaultGetPluginFunctionMsg, 3, v );
	pCS->SetStr( w.c_str() );
	return true;
}

const CCompoundStr& CConfigInfo::RefFaultToSaveTmpFileMsg() const
{
	assert( NULL != this );
	return FaultToSaveTmpFileMsg;
}

const CCompoundStr& CConfigInfo::RefRetryWithoutSaveTmpFileMsg() const
{
	assert( NULL != this );
	return RetryWithoutSaveTmpFileMsg;
}

const CCompoundStr& CConfigInfo::RefFailedToInitConstructionModeMsg() const
{
	assert( NULL != this );
	return FailedToInitConstructionModeMsg;
}

const CCompoundStr& CConfigInfo::RefConstructionCommunicationErrorMsg() const
{
	assert( NULL != this );
	return ConstructionCommunicationErrorMsg;
}

const CCompoundStr& CConfigInfo::RefRebootServerMsg() const
{
	assert( NULL != this );
	return RebootServerMsg;
}

const CCompoundStr& CConfigInfo::RefFailedToRebootServerMsg() const
{
	assert( NULL != this );
	return FailedToRebootServerMsg;
}

const CCompoundStr& CConfigInfo::RefServerRevokedMsg() const
{
	assert( NULL != this );
	return ServerRevokedMsg;
}

const CCompoundStr& CConfigInfo::RefFileIsOpenedByAnotherMsg() const
{
	assert( NULL != this );
	return FileIsOpenedByAnotherMsg;
}

const CCompoundStr& CConfigInfo::RefReplaceStrIsNullMsg() const
{
	assert( NULL != this );
	return ReplaceStrIsNullMsg;
}

const CCompoundStr& CConfigInfo::RefFailedToStartEncConvMsg() const
{
	assert( NULL != this );
	return FailedToStartEncConvMsg;
}

const CCompoundStr& CConfigInfo::RefEncodeNameIsInvalidMsg() const
{
	assert( NULL != this );
	return EncodeNameIsInvalidMsg;
}

const CCompoundStr& CConfigInfo::RefFailedToConvertEncodeMsg() const
{
	assert( NULL != this );
	return FailedToConvertEncodeMsg;
}

const CCompoundStr& CConfigInfo::RefFailedToReadKeywordListMsg() const
{
	assert( NULL != this );
	return FailedToReadKeywordListMsg;
}

const CCompoundStr& CConfigInfo::RefFailedToReadPaperSizeConfigMsg() const
{
	assert( NULL != this );
	return FailedToReadPaperSizeConfigMsg;
}

const CCompoundStr& CConfigInfo::RefFailedToReadPrinterConfMsg() const
{
	assert( NULL != this );
	return FailedToReadPrinterConfMsg;
}

const CCompoundStr& CConfigInfo::RefPrintDlgWrongValueMsg() const
{
	assert( NULL != this );
	return PrintDlgWrongValueMsg;
}

const CCompoundStr& CConfigInfo::RefFailedToStartPdlGenMsg() const
{
	assert( NULL != this );
	return FailedToStartPdlGenMsg;
}

const CCompoundStr& CConfigInfo::RefPdlGenNameIsInvalidMsg() const
{
	assert( NULL != this );
	return PdlGenNameIsInvalidMsg;
}

const CCompoundStr& CConfigInfo::RefFailedToStartLprMsg() const
{
	assert( NULL != this );
	return FailedToStartLprMsg;
}

const CCompoundStr& CConfigInfo::RefLprNameIsInvalidMsg() const
{
	assert( NULL != this );
	return LprNameIsInvalidMsg;
}

const CCompoundStr& CConfigInfo::RefFailedToGenPSMsg() const
{
	assert( NULL != this );
	return FailedToGenPSMsg;
}

void CConfigInfo::GetFailedToGenPSMsgWithStatus( CCompoundStr *pCS, int s ) const
{
	assert( NULL != this && NULL != pCS );

	char Buf[24] = { 0 };
	const char *p[1] = { Buf };
	snprintf( Buf, sizeof( Buf ), "%d", s );
	string w = GlbFunc::CreateMsgString< string, char >( FailedToGenPSMsgWithStatus, 1, p );
	pCS->SetStr( w.c_str() );
}

void CConfigInfo::GetFailedToLprMsgWithStatus( CCompoundStr *pCS, int s, const char *pMsg ) const
{
	assert( NULL != this && NULL != pCS );

	char Buf[24] = { 0 };
	const char *p[2] = { Buf, pMsg };
	snprintf( Buf, sizeof( Buf ), "%d", s );
	string w = GlbFunc::CreateMsgString< string, char >( FailedToLprMsgWithStatus, 2, p );
	pCS->SetStr( w.c_str() );
}

const CCompoundStr& CConfigInfo::RefTargetPrinterNameIsInvalidMsg() const
{
	assert( NULL != this );
	return TargetPrinterNameIsInvalidMsg;
}

const CCompoundStr& CConfigInfo::RefPaperSizeIsInvalidMsg() const
{
	assert( NULL != this );
	return PaperSizeIsInvalidMsg;
}

const CCompoundStr& CConfigInfo::RefFailToGetPID() const
{
	assert( NULL != this );
	return FailToGetPID;
}

const CCompoundStr& CConfigInfo::RefFailToCreateChildProcess() const
{
	assert( NULL != this );
	return FailToCreateChildProcess;
}

const CCompoundStr& CConfigInfo::RefFileOpenDlgTitle() const
{
	assert( NULL != this );
	return FileOpenDlgTitle;
}

const CCompoundStr& CConfigInfo::RefFileSaveDlgTitle() const
{
	assert( NULL != this );
	return FileSaveDlgTitle;
}

Pixel CConfigInfo::RefNormalTextF_Color()
{
	assert( NULL != this );
	return GetColorByName( NormalTextF_Color, true );
}

Pixel CConfigInfo::RefNormalTextB_Color()
{
	assert( NULL != this );
	return GetColorByName( NormalTextB_Color, false );
}

Pixel CConfigInfo::RefSelectedTextF_Color()
{
	assert( NULL != this );
	return GetColorByName( SelectedTextF_Color, false );
}

Pixel CConfigInfo::RefSelectedTextB_Color()
{
	assert( NULL != this );
	return GetColorByName( SelectedTextB_Color, true );
}

Pixel CConfigInfo::RefBackgroundColor()
{
	assert( NULL != this );
	return GetColorByName( BackgroundColor, false );
}

Pixel CConfigInfo::RefCursorColor()
{
	assert( NULL != this );
	return GetColorByName( CursorColor, false );
}

Pixel CConfigInfo::RefPreEditTextF_Color()
{
	assert( NULL != this );
	return GetColorByName( PreEditTextF_Color, true );
}

Pixel CConfigInfo::RefPreEditTextB_Color()
{
	assert( NULL != this );
	return GetColorByName( PreEditTextB_Color, false );
}

Pixel CConfigInfo::RefCurLineUnderBar_Color()
{
	assert( NULL != this );
	return GetColorByName( CurLineUnderBar_Color, true );
}

bool CConfigInfo::GetDrawCurLineUnderBar() const
{
	assert( NULL != this );
	return DrawCurLineUnderBar;
}

int CConfigInfo::GetCurrentLineUnderbarPosition() const
{
	return CurrentLineUnderbarPosition;
}

Pixel CConfigInfo::RefEditMark_Color()
{
	assert( NULL != this );
	return GetColorByName( EditMark_Color, true );
}

bool CConfigInfo::GetDrawEditMark() const
{
	assert( NULL != this );
	return DrawEditMark;
}

const string& CConfigInfo::RefFontName() const
{
	assert( NULL != this );
	return FontName;
}

int CConfigInfo::RefTabWidth() const
{
	assert( NULL != this );
	return TabWidth;
}

const CCompoundStr& CConfigInfo::RefCantFindTextMsg() const
{
	assert( NULL != this );
	return CantFindTextMsg;
}

bool CConfigInfo::GetWrongRegexPatternMsg( CCompoundStr *pCS, const wstring &msg, int idx ) const
{
	assert( NULL != this && NULL != pCS );

	wstring wStr;
	wchar_t wBuf[ 16 ];
	const wchar_t *v[2];

	// å
	swprintf( wBuf, 16, L"%d\0", idx );
	v[0] = msg.c_str();
	v[1] = wBuf;
	pCS->SetStr( GlbFunc::CreateMsgString( WrongRegexPatternMsg, 2, v ).c_str() );
	return true;
}

const wstring& CConfigInfo::RefWRP_EofNotAnticipated() const
{
	assert( NULL != this );
	return WRP_EofNotAnticipated;
}

const wstring& CConfigInfo::RefWRP_OutOfMemory() const
{
	assert( NULL != this );
	return WRP_OutOfMemory;
}

const wstring& CConfigInfo::RefWRP_UncertainChar() const
{
	assert( NULL != this );
	return WRP_UncertainChar;
}

const wstring& CConfigInfo::RefWRP_ZeroLengthPattern() const
{
	assert( NULL != this );
	return WRP_ZeroLengthPattern;
}

const wstring& CConfigInfo::RefWRP_Unexpected() const
{
	assert( NULL != this );
	return WRP_Unexpected;
}

const wstring& CConfigInfo::RefAppTitle() const
{
	assert( NULL != this );
	return AppTitle;
}

const wstring& CConfigInfo::RefTitleFormat() const
{
	assert( NULL != this );
	return TitleFormat;
}

enumCHARSELTYPE CConfigInfo::GetCharSelType() const
{
	assert( NULL != this );
	return CharSelType;
}

int CConfigInfo::GetLeftPadding() const
{
	assert( NULL != this );
	return LeftPadding;
}

int CConfigInfo::GetRightPadding() const
{
	assert( NULL != this );
	return RightPadding;
}

int CConfigInfo::GetLineNumberOrigin() const
{
	assert( NULL != this );
	return LineNumberOrigin;
}

int CConfigInfo::GetLineGapWidth() const
{
	assert( NULL != this );
	return LineGapWidth;
}

enumTABWIDTHCALCMETHOD CConfigInfo::GetTabWidthCalculationMethod() const
{
	assert( NULL != this );
	return TabWidthCalculationMethod;
}

const wstring& CConfigInfo::RefTabString() const
{
	assert( NULL != this );
	return TabString;
}

const string& CConfigInfo::RefProcUpScript() const
{
	assert( NULL != this );
	return ProcUpScript;
}

const string& CConfigInfo::RefFileReadScript() const
{
	assert( NULL != this );
	return FileReadScript;
}

const string& CConfigInfo::RefFileAfterReadScript() const
{
	assert( NULL != this );
	return FileAfterReadScript;
}

const string& CConfigInfo::RefFileBeforeWriteScript() const
{
	assert( NULL != this );
	return FileBeforeWriteScript;
}

const string& CConfigInfo::RefFileWriteScript() const
{
	assert( NULL != this );
	return FileWriteScript;
}

const string& CConfigInfo::RefFileCloseScript() const
{
	assert( NULL != this );
	return FileCloseScript;
}

const string& CConfigInfo::RefProcDownScript() const
{
	assert( NULL != this );
	return ProcDownScript;
}

bool CConfigInfo::GetAutoIndent() const
{
	assert( NULL != this );
	return AutoIndent;
}

const wstring& CConfigInfo::RefIndentChar() const
{
	assert( NULL != this );
	return IndentChar;
}

const wstring& CConfigInfo::RefWordCharSet() const
{
	assert( NULL != this );
	return WordCharSet;
}

enumDROPFILEOPENMETHOD CConfigInfo::GetDropFileOpenMethod() const
{
	assert( NULL != this );
	return DropFileOpenMethod;
}

enumBTN2FUNC CConfigInfo::GetBtn2Func() const
{
	assert( NULL != this );
	return Btn2Func;
}

int CConfigInfo::GetMaxUndoCount() const
{
	assert( NULL != this );
	return MaxUndoCount;
}

int CConfigInfo::GetHScrollAt() const
{
	assert( NULL != this );
	return HScrollAt;
}

const string& CConfigInfo::RefClipboardEncode() const
{
	assert( NULL != this );
	return ClipboardEncode;
}

int CConfigInfo::GetShowPrecessingDlgDelay() const
{
	assert( NULL != this );
	return ShowPrecessingDlgDelay;
}

int CConfigInfo::GetWindowWidth() const
{
	assert( NULL != this );
	return WindowWidth;
}

int CConfigInfo::GetWindowHeight() const
{
	assert( NULL != this );
	return WindowHeight;
}

int CConfigInfo::GetScrollMouseSpeed() const
{
	assert( NULL != this );
	return ScrollMouseSpeed;
}

const string& CConfigInfo::RefIconImageName() const
{
	assert( NULL != this );
	return IconImageName;
}

int CConfigInfo::GetExInfoColumnCount() const
{
	assert( NULL != this );
	return ExInfoColumnCount;
}

int CConfigInfo::GetExInfoColumnWidth() const
{
	assert( NULL != this );
	return ExInfoColumnWidth;
}

Pixel CConfigInfo::RefExInfoColumnColor( int idx )
{
	assert( idx >= 0 && idx < GetExInfoColumnCount() && NULL != this );
	return GetColorByName( pExInfoColumnColor[idx], true );
}

bool CConfigInfo::GetDrawSeparatorLine() const
{
	assert( NULL != this );
	return DrawSeparatorLine;
}

Pixel CConfigInfo::RefSeparatorLineColor()
{
	assert( NULL != this );
	return GetColorByName( SeparatorLineColor, true );
}

int CConfigInfo::GetAutoSaveInterval() const
{
	assert( NULL != this );
	return AutoSaveInterval;
}

enumAUTOSAVE_NEWFILE CConfigInfo::GetAutoSaveNewFileMethod() const
{
	assert( NULL != this );
	return AutoSaveNewFileMethod;
}

const wstring& CConfigInfo::RefModifiedSignStr() const
{
	assert( NULL != this );
	return ModifiedSignStr;
}

bool CConfigInfo::GetInsertTabToEmptyLine() const
{
	assert( NULL != this );
	return InsertTabToEmptyLine;
}

bool CConfigInfo::GetUseDoubleBuffering() const
{
	assert( NULL != this );
	return UseDoubleBuffering;
}

int CConfigInfo::GetCPUCount() const
{
	assert( NULL != this );
	return CPUCount;
}

bool CConfigInfo::GetUseWriteTmpFile() const
{
	assert( NULL != this );
	return UseWriteTmpFile;
}

const vector< string >& CConfigInfo::RefEncodeName() const
{
	assert( NULL != this );
	return EncodeName;
}

const string& CConfigInfo::RefCurrentEncodeText() const
{
	assert( NULL != this );
	return CurrentEncodeText;
}

enumCURSORBEHAVIORMODE CConfigInfo::GetCursorBehaviorMode() const
{
	assert( NULL != this );
	return CursorBehaviorMode;
}

int CConfigInfo::GetLineNumberColumnWidth() const
{
	assert( NULL != this );
	return LineNumberColumnWidth;
}

Pixel CConfigInfo::RefLineNumberF_Color()
{
	assert( NULL != this );
	return GetColorByName( LineNumberF_Color, true );
}

int CConfigInfo::GetModifyLineMarkNumber() const
{
	assert( NULL != this );
	return ModifyLineMarkNumber;
}

bool CConfigInfo::GetClearUndoOnSave() const
{
	assert( NULL != this );
	return ClearUndoOnSave;
}

const string& CConfigInfo::RefPrintDlg_ValueRegFile() const
{
	assert( NULL != this );
	return PrintDlg_ValueRegFile;
}

const string& CConfigInfo::RefPrintDlg_DefaultValueRegFile() const
{
	assert( NULL != this );
	return PrintDlg_DefaultValueRegFile;
}

const string& CConfigInfo::RefPrintDlg_PaperSizeConfFileName() const
{
	assert( NULL != this );
	return PrintDlg_PaperSizeConfFileName;
}

const string& CConfigInfo::RefPrintDlg_FontList() const
{
	assert( NULL != this );
	return PrintDlg_FontList;
}

const string& CConfigInfo::RefPrintDlg_PostScriptEncode() const
{
	assert( NULL != this );
	return PrintDlg_PostScriptEncode;
}

const string& CConfigInfo::RefPrintDlg_PrinterConfFileName() const
{
	assert( NULL != this );
	return PrintDlg_PrinterConfFileName;
}

const string& CConfigInfo::RefPrintDlg_lpr_Args() const
{
	assert( NULL != this );
	return PrintDlg_lpr_Args;
}

int CConfigInfo::GetLangTypeEnableMaxSize() const
{
	assert( NULL != this );
	return LangTypeEnableMaxSize;
}

const string& CConfigInfo::RefCPP_FileExt() const
{
	assert( NULL != this );
	return CPP_FileExt;
}

const string& CConfigInfo::RefCPP_KeywordList() const
{
	assert( NULL != this );
	return CPP_KeywordList;
}

const string& CConfigInfo::RefJAVA_FileExt() const
{
	assert( NULL != this );
	return JAVA_FileExt;
}

const string& CConfigInfo::RefJAVA_KeywordList() const
{
	assert( NULL != this );
	return JAVA_KeywordList;
}

const string& CConfigInfo::RefCOBOL_FileExt() const
{
	assert( NULL != this );
	return COBOL_FileExt;
}

const string& CConfigInfo::RefCOBOL_KeywordList() const
{
	assert( NULL != this );
	return COBOL_KeywordList;
}

const string& CConfigInfo::RefJS_FileExt() const
{
	assert( NULL != this );
	return JS_FileExt;
}

const string& CConfigInfo::RefJS_KeywordList() const
{
	assert( NULL != this );
	return JS_KeywordList;
}

const string& CConfigInfo::RefVBS_FileExt() const
{
	assert( NULL != this );
	return VBS_FileExt;
}

const string& CConfigInfo::RefVBS_KeywordList() const
{
	assert( NULL != this );
	return VBS_KeywordList;
}

const string& CConfigInfo::RefCS_FileExt() const
{
	assert( NULL != this );
	return CS_FileExt;
}

const string& CConfigInfo::RefCS_KeywordList() const
{
	assert( NULL != this );
	return CS_KeywordList;
}

const string& CConfigInfo::RefHTML_FileExt() const
{
	assert( NULL != this );
	return HTML_FileExt;
}

const string& CConfigInfo::RefHTML_KeywordList() const
{
	assert( NULL != this );
	return HTML_KeywordList;
}

Pixel CConfigInfo::RefCPP_NormalTextF_Color()
{
	assert( NULL != this );
	return GetColorByName( CPP_NormalTextF_Color, true );
}

Pixel CConfigInfo::RefCPP_KeywordF_Color()
{
	assert( NULL != this );
	return GetColorByName( CPP_KeywordF_Color, true );
}

Pixel CConfigInfo::RefCPP_CommentF_Color()
{
	assert( NULL != this );
	return GetColorByName( CPP_CommentF_Color, true );
}

Pixel CConfigInfo::RefCPP_SringF_Color()
{
	assert( NULL != this );
	return GetColorByName( CPP_SringF_Color, true );
}

Pixel CConfigInfo::RefJAVA_NormalTextF_Color()
{
	assert( NULL != this );
	return GetColorByName( JAVA_NormalTextF_Color, true );
}

Pixel CConfigInfo::RefJAVA_KeywordF_Color()
{
	assert( NULL != this );
	return GetColorByName( JAVA_KeywordF_Color, true );
}

Pixel CConfigInfo::RefJAVA_CommentF_Color()
{
	assert( NULL != this );
	return GetColorByName( JAVA_CommentF_Color, true );
}

Pixel CConfigInfo::RefJAVA_SringF_Color()
{
	assert( NULL != this );
	return GetColorByName( JAVA_SringF_Color, true );
}

Pixel CConfigInfo::RefCOBOL_NormalTextF_Color()
{
	assert( NULL != this );
	return GetColorByName( COBOL_NormalTextF_Color, true );
}

Pixel CConfigInfo::RefCOBOL_KeywordF_Color()
{
	assert( NULL != this );
	return GetColorByName( COBOL_KeywordF_Color, true );
}

Pixel CConfigInfo::RefCOBOL_CommentF_Color()
{
	assert( NULL != this );
	return GetColorByName( COBOL_CommentF_Color, true );
}

Pixel CConfigInfo::RefCOBOL_SringF_Color()
{
	assert( NULL != this );
	return GetColorByName( COBOL_SringF_Color, true );
}

Pixel CConfigInfo::RefCOBOL_SequenceNumberF_Color()
{
	assert( NULL != this );
	return GetColorByName( COBOL_SequenceNumberF_Color, true );
}

Pixel CConfigInfo::RefJS_NormalTextF_Color()
{
	assert( NULL != this );
	return GetColorByName( JS_NormalTextF_Color, true );
}

Pixel CConfigInfo::RefJS_KeywordF_Color()
{
	assert( NULL != this );
	return GetColorByName( JS_KeywordF_Color, true );
}

Pixel CConfigInfo::RefJS_CommentF_Color()
{
	assert( NULL != this );
	return GetColorByName( JS_CommentF_Color, true );
}

Pixel CConfigInfo::RefJS_SringF_Color()
{
	assert( NULL != this );
	return GetColorByName( JS_SringF_Color, true );
}

Pixel CConfigInfo::RefVBS_NormalTextF_Color()
{
	assert( NULL != this );
	return GetColorByName( VBS_NormalTextF_Color, true );
}

Pixel CConfigInfo::RefVBS_KeywordF_Color()
{
	assert( NULL != this );
	return GetColorByName( VBS_KeywordF_Color, true );
}

Pixel CConfigInfo::RefVBS_CommentF_Color()
{
	assert( NULL != this );
	return GetColorByName( VBS_CommentF_Color, true );
}

Pixel CConfigInfo::RefVBS_SringF_Color()
{
	assert( NULL != this );
	return GetColorByName( VBS_SringF_Color, true );
}

Pixel CConfigInfo::RefCS_NormalTextF_Color()
{
	assert( NULL != this );
	return GetColorByName( CS_NormalTextF_Color, true );
}

Pixel CConfigInfo::RefCS_KeywordF_Color()
{
	assert( NULL != this );
	return GetColorByName( CS_KeywordF_Color, true );
}

Pixel CConfigInfo::RefCS_CommentF_Color()
{
	assert( NULL != this );
	return GetColorByName( CS_CommentF_Color, true );
}

Pixel CConfigInfo::RefCS_SringF_Color()
{
	assert( NULL != this );
	return GetColorByName( CS_SringF_Color, true );
}

Pixel CConfigInfo::RefHTML_NormalTextF_Color()
{
	assert( NULL != this );
	return GetColorByName( HTML_NormalTextF_Color, true );
}

Pixel CConfigInfo::RefHTML_TagF_Color()
{
	assert( NULL != this );
	return GetColorByName( HTML_TagF_Color, true );
}

Pixel CConfigInfo::RefHTML_KeywordF_Color()
{
	assert( NULL != this );
	return GetColorByName( HTML_KeywordF_Color, true );
}

Pixel CConfigInfo::RefHTML_CommentF_Color()
{
	assert( NULL != this );
	return GetColorByName( HTML_CommentF_Color, true );
}

Pixel CConfigInfo::RefHTML_SringF_Color()
{
	assert( NULL != this );
	return GetColorByName( HTML_SringF_Color, true );
}

const string& CConfigInfo::RefPluginConfigFileName() const
{
	assert( NULL != this );
	return PluginConfigFileName;
}

// ̾Pixelͤ
Pixel CConfigInfo::GetColorByName( const string& rStr, bool DefaultIsBlack )
{
	assert( NULL != m_Widget && NULL != this );

	Display *pDisplay = XtDisplay( m_Widget );
	Colormap wColormap = DefaultColormap( pDisplay, DefaultScreen( pDisplay ) );
	XColor screen_def;
	XColor exact_def;
	map< string, Pixel >::const_iterator itr;
	Pixel r;
	Pixel DefColor;

	// ǥեȤο
	if ( DefaultIsBlack )
		DefColor = BlackPixelOfScreen( XtScreen( m_Widget ) );
	else
		DefColor = WhitePixelOfScreen( XtScreen( m_Widget ) );

	// å夵Ƥ뿧򸡺
	itr = mapPixelCash.find( rStr );
	if ( itr != mapPixelCash.end() )
		return itr->second;	// å夵ƤPixel֤ͤ

	if ( !XLookupColor( pDisplay, wColormap, rStr.c_str(), &exact_def, &screen_def ) ) {
		r = DefColor;	// ԤʥǥեȤο֤
		goto EXIT_L;
	}

	// ԥͤ
	if ( !XAllocColor( pDisplay, wColormap, &screen_def ) ) {
		r = DefColor;	// 
		goto EXIT_L;
	}

	r = screen_def.pixel;

EXIT_L:
	mapPixelCash.insert( pair< string, Pixel >( rStr, r ) );	// åϿ
	return r;
}

