#include <md5.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

void OutputMD5( unsigned char *pData, size_t len )
{
	unsigned char digest[16] = { 0 };
	char hex_output[33] = { 0 };
	int i;

	md5_calc( digest, pData, len );

	for ( i = 0; i < 16; ++i )
		sprintf( hex_output + i * 2, "%02x", digest[i] );
	printf( "%s\n", hex_output );
}

int main( int argc, char *argv[] )
{
	FILE *infile;
	unsigned char *pBuf;
	int len;

	if ( argc <= 1 ) {
		printf( "md5 infile\n" );
		return 1;
	}

	// ե򳫤
	infile = fopen( argv[1], "r" );
	if ( NULL == infile ) {
		printf( "Failed to open specified file. : %s\n", argv[1] );
		return 1;
	}

	// եĹǧ
	fseek( infile, 0, SEEK_END );
	len = ftell( infile );
	fseek( infile, 0, SEEK_SET );

	// ХåեѰդ
	pBuf = (unsigned char*)malloc( sizeof( unsigned char ) * len );
	if ( NULL == pBuf ) {
		printf( "Out of memory\n" );
		fclose( infile );
		return 1;
	}

	// եɤ
	fread( pBuf, sizeof( unsigned char ), len, infile );

	// ϥå
	OutputMD5( pBuf, len );

	// Хåե
	free( pBuf );

	// եĤ
	fclose( infile );

	return 0;
}
