#include <stdio.h>
#include <locale.h>

#include "PdlCmd.h"
#include "AsmPS.h"

// ˡɽ
int help()
{
	fprintf( stderr, "TaEditPdlgen - TaEdit PostScript genelator\n" );
	fprintf( stderr, "[usage]\n" );
	fprintf( stderr, "  TaEditPdlgen [switches] < InFile > OutFile\n" );
	fprintf( stderr, "[Arguments]\n" );
	fprintf( stderr, "  -h\tShow this message.\n" );
	fprintf( stderr, "  -PageWidth size\tSpecify the page width.\n" );
	fprintf( stderr, "  -PageHeight size\tSpecify the page height.\n" );
	fprintf( stderr, "  -NUp 1|2|4\tSpecify the number of n pages in one page.\n" );
	fprintf( stderr, "  -HeaderPosition position\tSpecify where to display the header.\n" );
	fprintf( stderr, "  -LeftHeader string\tSpecify the header string that displayed at the left side.\n" );
	fprintf( stderr, "  -CenterHeader string\tSpecify the header string that displayed at the center.\n" );
	fprintf( stderr, "  -RightHeader string\tSpecify the header string that displayed at the right side.\n" );
	fprintf( stderr, "  -FooterPosition position\tSpecify where to display the footer.\n" );
	fprintf( stderr, "  -LeftFooter string\tSpecify the footer string that displayed at the left side.\n" );
	fprintf( stderr, "  -CenterFooter string\tSpecify the footer string that displayed at the center.\n" );
	fprintf( stderr, "  -RightFooter string\tSpecify the footer string that displayed at the right size.\n" );
	fprintf( stderr, "  -TopMargin margin\tSpecify the height of the top space.\n" );
	fprintf( stderr, "  -LeftMargin margin\tSpecify the width of the left size space.\n" );
	fprintf( stderr, "  -RightMargin margin\tSpecify the width of the right size space.\n" );
	fprintf( stderr, "  -BottomMargin margin\tSpecify the height of the bottom space.\n" );
	fprintf( stderr, "  -FontName name\tSpecify the font name.\n" );
	fprintf( stderr, "  -TextHeight size\tSpecify the height of font size.\n" );
	fprintf( stderr, "  -TextWidth size\tSpecify the width of font size.\n" );
	fprintf( stderr, "  -LineMargin size\tSpecify the height of the line margin.\n" );
	fprintf( stderr, "  -TabWidth width\tSpecify the number of space used at the tab character.\n" );
	fprintf( stderr, "  -Turn\t\tIf this switch is specifyed, the direction was holizontal.\n" );
	fprintf( stderr, "  -ShowLineNumber\t\t\nIf this switch is specified, the line number is printed at left side of the text." );
	fprintf( stderr, "  -Duplex\t\t\nSpecIf this switch is specified, the page is printed within duplex." );
	return 1;
}

int main( int argc, char *argv[] )
{
	CPdlCmd cmd;
	CAsmPS aps;
	map< string, bool > FlagsType;

	// 
	setlocale( LC_ALL, "" );

	// β
	FlagsType.insert( pair< string, bool >( "-h", false ) );
	FlagsType.insert( pair< string, bool >( "-PageWidth", true ) );
	FlagsType.insert( pair< string, bool >( "-PageHeight", true ) );
	FlagsType.insert( pair< string, bool >( "-NUp", true ) );
	FlagsType.insert( pair< string, bool >( "-HeaderPosition", true ) );
	FlagsType.insert( pair< string, bool >( "-LeftHeader", true ) );
	FlagsType.insert( pair< string, bool >( "-CenterHeader", true ) );
	FlagsType.insert( pair< string, bool >( "-RightHeader", true ) );
	FlagsType.insert( pair< string, bool >( "-FooterPosition", true ) );
	FlagsType.insert( pair< string, bool >( "-LeftFooter", true ) );
	FlagsType.insert( pair< string, bool >( "-CenterFooter", true ) );
	FlagsType.insert( pair< string, bool >( "-RightFooter", true ) );
	FlagsType.insert( pair< string, bool >( "-TopMargin", true ) );
	FlagsType.insert( pair< string, bool >( "-LeftMargin", true ) );
	FlagsType.insert( pair< string, bool >( "-RightMargin", true ) );
	FlagsType.insert( pair< string, bool >( "-BottomMargin", true ) );
	FlagsType.insert( pair< string, bool >( "-FontName", true ) );
	FlagsType.insert( pair< string, bool >( "-TextHeight", true ) );
	FlagsType.insert( pair< string, bool >( "-TextWidth", true ) );
	FlagsType.insert( pair< string, bool >( "-LineMargin", true ) );
	FlagsType.insert( pair< string, bool >( "-TabWidth", true ) );
	FlagsType.insert( pair< string, bool >( "-Turn", false ) );
	FlagsType.insert( pair< string, bool >( "-ShowLineNumber", false ) );
	FlagsType.insert( pair< string, bool >( "-Duplex", false ) );
	if ( !cmd.SetCommand( argc, argv, FlagsType ) )
		return help();

	// -hꤵ줿顢ˡɽ
	if ( cmd.IsExist( "-h" ) ) return help();

	// ꤹ
	if ( !aps.SetPageWidth( cmd.GetArgVal( "-PageWidth", 596.0 ) ) )
		return help();
	if ( !aps.SetPageHeight( cmd.GetArgVal( "-PageHeight", 843.0 ) ) )
		return help();
	if ( !aps.SetNUp( cmd.GetArgVal( "-NUp", 1 ) ) )
		return help();
	if ( !aps.SetHeaderPosition( cmd.GetArgVal( "-HeaderPosition", 57 ) ) )
		return help();
	if ( !aps.SetLeftHeader( cmd.GetArgVal( "-LeftHeader", "" ) ) )
		return help();
	if ( !aps.SetCenterHeader( cmd.GetArgVal( "-CenterHeader", "" ) ) )
		return help();
	if ( !aps.SetRightHeader( cmd.GetArgVal( "-RightHeader", "" ) ) )
		return help();
	if ( !aps.SetFooterPosition( cmd.GetArgVal( "-FooterPosition", 57 ) ) )
		return help();
	if ( !aps.SetLeftFooter( cmd.GetArgVal( "-LeftFooter", "" ) ) )
		return help();
	if ( !aps.SetCenterFooter( cmd.GetArgVal( "-CenterFooter", "" ) ) )
		return help();
	if ( !aps.SetRightFooter( cmd.GetArgVal( "-RightFooter", "" ) ) )
		return help();
	if ( !aps.SetTopMargin( cmd.GetArgVal( "-TopMargin", 85 ) ) )
		return help();
	if ( !aps.SetLeftMargin( cmd.GetArgVal( "-LeftMargin", 57 ) ) )
		return help();
	if ( !aps.SetRightMargin( cmd.GetArgVal( "-RightMargin", 57 ) ) )
		return help();
	if ( !aps.SetBottomMargin( cmd.GetArgVal( "-BottomMargin", 85 ) ) )
		return help();
	if ( !aps.SetFontName( cmd.GetArgVal( "-FontName", "Times-Roman" ) ) )
		return help();
	if ( !aps.SetTextHeight( cmd.GetArgVal( "-TextHeight", 12 ) ) )
		return help();
	if ( !aps.SetTextWidth( cmd.GetArgVal( "-TextWidth", 12 ) ) )
		return help();
	if ( !aps.SetLineMargin( cmd.GetArgVal( "-LineMargin", 0 ) ) )
		return help();
	if ( !aps.SetTabWidth( cmd.GetArgVal( "-TabWidth", 4 ) ) )
		return help();
	if ( !aps.SetTurn( cmd.IsExist( "-Turn" ) ) )
		return help();
	if ( !aps.SetShowLineNumber( cmd.IsExist( "-ShowLineNumber" ) ) )
		return help();
	if ( !aps.SetDuplex( cmd.IsExist( "-Duplex" ) ) )
		return help();

	// PostScriptϤ
	if ( !aps.OutputPS( stdin, stdout ) ) {
		fprintf( stderr, "Faild to genelate PostScript\n" );
		return 2;
	}

	return 0;
}
