////////////////////////////////////////////////////////////////////////////
// CAsmPS 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <limits.h>
#include <assert.h>
#include <GlbFunc.h>
#include "AsmPS.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CAsmPS::CAsmPS()
{
	// ͤꤹ
	PageWidth = 596.0;
	PageHeight = 843.0;
	NUp = 1;
	HeaderPosition = 57;
	LeftHeader = "";
	CenterHeader = "";
	RightHeader = "";
	FooterPosition = 57;
	LeftFooter = "";
	CenterFooter = "";
	RightFooter = "";
	TopMargin = 85;
	LeftMargin = 57;
	RightMargin = 57;
	BottomMargin = 85;
	FontName = "Times-Roman";
	TextHeight = 12;
	TextWidth = 12;
	LineMargin = 0;
	TabWidth = 4;
	Turn = false;
	ShowLineNumber = false;
	Duplex = false;
	LineNumberColumnCount = 5;
}

CAsmPS::~CAsmPS()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

bool CAsmPS::SetPageWidth( double d )
{
	assert( this );
	if ( d <= 0 || d >= INT_MAX )
		return false;
	PageWidth = d;
	return true;
}

bool CAsmPS::SetPageHeight( double d )
{
	assert( this );
	if ( d <= 0 || d >= INT_MAX )
		return false;
	PageHeight = d;
	return true;
}

bool CAsmPS::SetNUp( int d )
{
	assert( this );
	if ( d != 1 && d != 2 && d != 4 )
		return false;
	NUp = d;
	return true;
}

bool CAsmPS::SetHeaderPosition( int d )
{
	assert( this );
	if ( d < 0 || d >= INT_MAX )
		return false;
	HeaderPosition = d;
	return true;
}

bool CAsmPS::SetLeftHeader( const string &r )
{
	assert( this );
	LeftHeader = r;
	return true;
}

bool CAsmPS::SetCenterHeader( const string &r )
{
	assert( this );
	CenterHeader = r;
	return true;
}

bool CAsmPS::SetRightHeader( const string &r )
{
	assert( this );
	RightHeader = r;
	return true;
}

bool CAsmPS::SetFooterPosition( int d )
{
	assert( this );
	if ( d < 0 || d >= INT_MAX )
		return false;
	FooterPosition = d;
	return true;
}

bool CAsmPS::SetLeftFooter( const string &r )
{
	assert( this );
	LeftFooter = r;
	return true;
}

bool CAsmPS::SetCenterFooter( const string &r )
{
	assert( this );
	CenterFooter = r;
	return true;
}

bool CAsmPS::SetRightFooter( const string &r )
{
	assert( this );
	RightFooter = r;
	return true;
}

bool CAsmPS::SetTopMargin( int d )
{
	assert( this );
	TopMargin = d;
	return true;
}

bool CAsmPS::SetLeftMargin( int d )
{
	assert( this );
	if ( d < 0 || d >= INT_MAX )
		return false;
	LeftMargin = d;
	return true;
}

bool CAsmPS::SetRightMargin( int d )
{
	assert( this );
	if ( d < 0 || d >= INT_MAX )
		return false;
	RightMargin = d;
	return true;
}

bool CAsmPS::SetBottomMargin( int d )
{
	assert( this );
	if ( d < 0 || d >= INT_MAX )
		return false;
	BottomMargin = d;
	return true;
}

bool CAsmPS::SetFontName( const string &r )
{
	assert( this );
	FontName = r;
	return true;
}

bool CAsmPS::SetTextHeight( int d )
{
	assert( this );
	if ( d < 0 || d >= INT_MAX )
		return false;
	TextHeight = d;
	return true;
}

bool CAsmPS::SetTextWidth( int d )
{
	assert( this );
	if ( d < 0 || d >= INT_MAX )
		return false;
	TextWidth = d;
	return true;
}

bool CAsmPS::SetLineMargin( int d )
{
	assert( this );
	if ( d < 0 || d >= INT_MAX )
		return false;
	LineMargin = d;
	return true;
}

bool CAsmPS::SetTabWidth( int d )
{
	assert( this );
	if ( d <= 0 || d >= INT_MAX )
		return false;
	TabWidth = d;
	return true;
}

bool CAsmPS::SetTurn( bool d )
{
	assert( this );
	Turn = d;
	return true;
}

bool CAsmPS::SetShowLineNumber( bool d )
{
	assert( this );
	ShowLineNumber = d;
	return true;
}

bool CAsmPS::SetDuplex( bool d )
{
	assert( this );
	Duplex = d;
	return true;
}

bool CAsmPS::SetLineNumberColumnCount( int d )
{
	assert( this );
	LineNumberColumnCount = d;
	return true;
}

// ƥȤϤPostScriptʸϤ
bool CAsmPS::OutputPS( FILE *infile, FILE *outfile ) const
{
	string LineStr;
	bool IsFirst = true;

	assert( this && infile && outfile );

	fprintf( outfile, "%%!PS-Adobe-1.0\n\n" );

	// ڡ礭
	fprintf( outfile, "/PageWidth %f def\n", PageWidth * 2.83 );
	fprintf( outfile, "/PageHeight %f def\n", PageHeight * 2.83 );

	// ѻ礭ʻθ˰¸ʤ
	if ( Turn ) {
		// ˰硢ѻ極ⲣĹͿ뤿ᡢĲȿžɬפ
		fprintf( outfile, "/PseudWidth %f def\n", PageHeight * 2.83 );
		fprintf( outfile, "/PseudHeight %f def\n", PageWidth * 2.83 );
	}
	else {
		fprintf( outfile, "/PseudWidth %f def\n", PageWidth * 2.83 );
		fprintf( outfile, "/PseudHeight %f def\n", PageHeight * 2.83 );
	}

	// ΰΥ
	fprintf( outfile, "/LeftBound %f def\n", LeftMargin * 2.83 );
	fprintf( outfile, "/RightBound PageWidth %f sub def\n", RightMargin * 2.83 );
	fprintf( outfile, "/TopBound PageHeight %f sub def\n", TopMargin * 2.83 );
	fprintf( outfile, "/BottomBound %f def\n", BottomMargin * 2.83 );

	// إåȥեå
	fprintf( outfile, "/HeaderHeight PageHeight %f sub def\n", HeaderPosition * 2.83 );
	fprintf( outfile, "/FooterHeight %f def\n\n", FooterPosition * 2.83 );

	// ֤
	fprintf( outfile, "/TabWidth %d def\n\n", TabWidth );

	// ʸ礭
	fprintf( outfile, "/TextHeight %d def\n", TextHeight );
	fprintf( outfile, "/TextWidth %d def\n\n", TextWidth );
	fprintf( outfile, "/LineMargin %d def\n\n", LineMargin );

	// ڡ
	fprintf( outfile, "/PageCount 0 def\n\n" );

	// ֹ
	fprintf( outfile, "/LineCount 1 def\n\n" );

	// ڡԤ줿ݤ򼨤ե饰
	fprintf( outfile, "/NewPageFlg false def\n\n" );

	// ǥХ
	fprintf( outfile, "5 dict\n" );
	if ( Duplex )
		fprintf( outfile, "dup /Duplex true put\n" );
	fprintf( outfile, "dup /PageSize [ PseudWidth PseudHeight ] put\n" );
	fprintf( outfile, "setpagedevice\n" );

	// 褹ʸ˳Ǽ֤
	fprintf( outfile, "/LeftHeaderString\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  [\n" );
	ShowStringHF( LeftHeader, outfile );
	fprintf( outfile, "  ]\n" );
	fprintf( outfile, "} def\n\n" );

	// 褹ʸ˳Ǽ֤
	fprintf( outfile, "/CenterHeaderString\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  [\n" );
	ShowStringHF( CenterHeader, outfile );
	fprintf( outfile, "  ]\n" );
	fprintf( outfile, "} def\n\n" );

	// 褹ʸ˳Ǽ֤
	fprintf( outfile, "/RightHeaderString\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  [\n" );
	ShowStringHF( RightHeader, outfile );
	fprintf( outfile, "  ]\n" );
	fprintf( outfile, "} def\n\n" );

	// 褹ʸ˳Ǽ֤
	fprintf( outfile, "/LeftFooterString\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  [\n" );
	ShowStringHF( LeftFooter, outfile );
	fprintf( outfile, "  ]\n" );
	fprintf( outfile, "} def\n\n" );

	// 褹ʸ˳Ǽ֤
	fprintf( outfile, "/CenterFooterString\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  [\n" );
	ShowStringHF( CenterFooter, outfile );
	fprintf( outfile, "  ]\n" );
	fprintf( outfile, "} def\n\n" );

	// 褹ʸ˳Ǽ֤
	fprintf( outfile, "/RightFooterString\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  [\n" );
	ShowStringHF( RightFooter, outfile );
	fprintf( outfile, "  ]\n" );
	fprintf( outfile, "} def\n\n" );

	// ˳Ǽ줿ʸʸĹפ
	fprintf( outfile, "/CalcStringWidth\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  0 exch\n" );
	fprintf( outfile, "  {\n" );
	fprintf( outfile, "    stringwidth pop add\n" );
	fprintf( outfile, "  } forall\n" );
	fprintf( outfile, "} def\n\n" );

	// ˳Ǽ줿ʸ褹
	fprintf( outfile, "/ShowVecString\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  { show } forall\n" );
	fprintf( outfile, "} def\n\n" );

	// إå褹
	fprintf( outfile, "/PrintHeader\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  currentpoint\n" );
	fprintf( outfile, "  /HY_PrintHeader exch def\n" );
	fprintf( outfile, "  /HX_PrintHeader exch def\n" );
	fprintf( outfile, "\n" );
	fprintf( outfile, "  LeftBound HeaderHeight moveto\n" );
	fprintf( outfile, "  LeftHeaderString ShowVecString\n" );
	fprintf( outfile, "\n" );
	fprintf( outfile, "  PageWidth 2 div\n" );
	fprintf( outfile, "  CenterHeaderString CalcStringWidth\n" );
	fprintf( outfile, "  2 div\n" );
	fprintf( outfile, "  sub\n" );
	fprintf( outfile, "  HeaderHeight moveto\n" );
	fprintf( outfile, "  CenterHeaderString ShowVecString\n" );
	fprintf( outfile, "\n" );
	fprintf( outfile, "  RightBound RightHeaderString CalcStringWidth sub\n" );
	fprintf( outfile, "  HeaderHeight moveto\n" );
	fprintf( outfile, "  RightHeaderString ShowVecString\n" );
	fprintf( outfile, "\n" );
	fprintf( outfile, "  HX_PrintHeader HY_PrintHeader moveto\n" );
	fprintf( outfile, "} def\n\n" );

	// եå褹
	fprintf( outfile, "/PrintFooter\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  currentpoint\n" );
	fprintf( outfile, "  /HY_PrintFooter exch def\n" );
	fprintf( outfile, "  /HX_PrintFooter exch def\n" );
	fprintf( outfile, "\n" );
	fprintf( outfile, "  LeftBound FooterHeight moveto\n" );
	fprintf( outfile, "  LeftFooterString ShowVecString\n" );
	fprintf( outfile, "\n" );
	fprintf( outfile, "  PageWidth 2 div\n" );
	fprintf( outfile, "  CenterFooterString CalcStringWidth\n" );
	fprintf( outfile, "  2 div\n" );
	fprintf( outfile, "  sub\n" );
	fprintf( outfile, "  FooterHeight moveto\n" );
	fprintf( outfile, "  CenterFooterString ShowVecString\n" );
	fprintf( outfile, "\n" );
	fprintf( outfile, "  RightBound RightFooterString CalcStringWidth sub\n" );
	fprintf( outfile, "  FooterHeight moveto\n" );
	fprintf( outfile, "  RightFooterString ShowVecString\n" );
	fprintf( outfile, "\n" );
	fprintf( outfile, "  HX_PrintFooter HY_PrintFooter moveto\n" );
	fprintf( outfile, "} def\n\n" );

	// ڡԤ
	fprintf( outfile, "/NewPage\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  /PageCount PageCount 1 add def\n" );
	switch ( NUp ) {
	case 1:
		fprintf( outfile, "  PageCount 1 ne { showpage newpath } if\n" );
		break;
	case 2:
		fprintf( outfile, "  PageCount 2 mod 0 eq {\n" );
		fprintf( outfile, "    grestore\n" );
		fprintf( outfile, "    /%s findfont\n", FontName.c_str() );
		fprintf( outfile, "    [ TextWidth 0 0 TextHeight 0 0 ] makefont setfont\n" );
		fprintf( outfile, "    PseudWidth 0 translate\n" );
		fprintf( outfile, "  } if\n" );
		fprintf( outfile, "  PageCount 2 mod 1 eq {\n" );
		fprintf( outfile, "    PageCount 1 ne { showpage newpath } if\n" );
		// 2-Upǲ˰Ͼ岼դˤʤ뤿ᡢǲžƤ
		if ( Turn ) {
			fprintf( outfile, "    180 rotate\n" );
			fprintf( outfile, "    PseudWidth -1 mul PseudHeight -1 mul translate\n" );
		}
		fprintf( outfile, "    90 rotate\n" );
		fprintf( outfile, "    0.707106781 0.707106781 scale\n" );
		fprintf( outfile, "    0 PseudHeight -1 mul translate\n" );
		fprintf( outfile, "    gsave\n" );
		fprintf( outfile, "    /%s findfont\n", FontName.c_str() );
		fprintf( outfile, "    [ TextWidth 0 0 TextHeight 0 0 ] makefont setfont\n" );
		fprintf( outfile, "  } if\n" );
		break;
	case 4:
		fprintf( outfile, "  PageCount 4 mod 0 eq {\n" );
		fprintf( outfile, "    grestore\n" );
		fprintf( outfile, "    /%s findfont\n", FontName.c_str() );
		fprintf( outfile, "    [ TextWidth 0 0 TextHeight 0 0 ] makefont setfont\n" );
		fprintf( outfile, "    PseudWidth 0 translate\n" );
		fprintf( outfile, "  } if\n" );
		fprintf( outfile, "  PageCount 4 mod 1 eq {\n" );
		fprintf( outfile, "    PageCount 1 ne { showpage newpath } if\n" );
		// Ĥ˰Ͼ岼դˤʤ뤿ᡢ˰2-upλ
		// 򤽤뤿ˡžƤ
		fprintf( outfile, "    180 rotate\n" );
		fprintf( outfile, "    PseudWidth -1 mul PseudHeight -1 mul translate\n" );
		fprintf( outfile, "    90 rotate\n" );
		fprintf( outfile, "    0.707106781 0.707106781 scale\n" );
		fprintf( outfile, "    0 PseudHeight -1 mul translate\n" );
		fprintf( outfile, "    90 rotate\n" );
		fprintf( outfile, "    0.707106781 0.707106781 scale\n" );
		// ѻθ㤦ȡƥڡ֤֤ۤʤ
		if ( Turn )
			fprintf( outfile, "    0 PseudHeight -2 mul translate\n" );
		else
			fprintf( outfile, "    0 PseudHeight -1 mul translate\n" );
		fprintf( outfile, "    gsave\n" );
		fprintf( outfile, "    /%s findfont\n", FontName.c_str() );
		fprintf( outfile, "    [ TextWidth 0 0 TextHeight 0 0 ] makefont setfont\n" );
		fprintf( outfile, "  } if\n" );
		fprintf( outfile, "  PageCount 4 mod 2 eq {\n" );
		fprintf( outfile, "    grestore\n" );
		fprintf( outfile, "    /%s findfont\n", FontName.c_str() );
		fprintf( outfile, "    [ TextWidth 0 0 TextHeight 0 0 ] makefont setfont\n" );
		fprintf( outfile, "    PseudWidth 0 translate\n" );
		fprintf( outfile, "    gsave\n" );
		fprintf( outfile, "  } if\n" );
		fprintf( outfile, "  PageCount 4 mod 3 eq {\n" );
		fprintf( outfile, "    grestore\n" );
		fprintf( outfile, "    /%s findfont\n", FontName.c_str() );
		fprintf( outfile, "    [ TextWidth 0 0 TextHeight 0 0 ] makefont setfont\n" );
		// ѻθ㤦ȡƥڡ֤֤ۤʤ
		if ( Turn )
			fprintf( outfile, "    PseudWidth -1 mul PseudHeight translate\n" );
		else
			fprintf( outfile, "    PseudWidth -1 mul PseudHeight -1 mul translate\n" );
		fprintf( outfile, "    gsave\n" );
		fprintf( outfile, "  } if\n" );
		break;
	default:
		fprintf( outfile, "  PageCount 1 ne { showpage newpath } if\n" );
		break;
	}
	if ( Turn ) {
		fprintf( outfile, "  90 rotate\n" );
		fprintf( outfile, "  0 PageHeight -1 mul translate\n" );
	}
	if ( ShowLineNumber ) {
		fprintf( outfile, "  LeftBound SpaceWidth 2 div sub TopBound moveto\n" );
		fprintf( outfile, "  LeftBound SpaceWidth 2 div sub BottomBound TextHeight sub lineto\n" );
		fprintf( outfile, "  stroke\n" );
	}
	fprintf( outfile, "  LeftBound TopBound TextHeight sub moveto\n" );
	fprintf( outfile, "  /NewPageFlg true def\n" );
	fprintf( outfile, "} def\n\n" );

	// ʸ褹
	fprintf( outfile, "/PrintTab\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  /MaxTabWidth_PrintTab SpaceWidth TabWidth mul def\n" );
	fprintf( outfile, "  /CX_PrintTab currentpoint pop LeftBound sub def\n" );
	fprintf( outfile, "  /VT_Tab_Cnt_PrintTab CX_PrintTab MaxTabWidth_PrintTab div truncate 1.0 add def\n" );
	fprintf( outfile, "  /RemainWidth_PrintTab VT_Tab_Cnt_PrintTab MaxTabWidth_PrintTab mul CX_PrintTab sub def\n" );
	fprintf( outfile, "  RemainWidth_PrintTab SpaceWidth 2.0 div lt {\n" );
	fprintf( outfile, "    /RemainWidth_PrintTab RemainWidth_PrintTab MaxTabWidth_PrintTab add def\n" );
	fprintf( outfile, "  } if\n" );
	fprintf( outfile, "  /CX_PrintTab CX_PrintTab RemainWidth_PrintTab add LeftBound add def\n" );
	fprintf( outfile, "  CX_PrintTab currentpoint exch pop moveto\n" );
	fprintf( outfile, "} def\n\n" );

	// ֹʬζ򤢤
	fprintf( outfile, "/ShowLineNumber_empty\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  LeftBound currentpoint exch pop moveto\n" );
	fprintf( outfile, "} def\n\n" );

	// ֹɽ
	fprintf( outfile, "/ShowLineNumber\n" );
	fprintf( outfile, "{\n" );
	if ( ShowLineNumber ) {
		fprintf( outfile, "  currentpoint\n" );
		fprintf( outfile, "  /HY_ShowLineNumber exch def\n" );
		fprintf( outfile, "  /HX_ShowLineNumber exch def\n" );
		fprintf( outfile, "\n" );
		fprintf( outfile, "  LineCount 10 string cvs\n" );
		fprintf( outfile, "  dup stringwidth pop LeftBound exch sub SpaceWidth sub\n" );
		fprintf( outfile, "  HY_ShowLineNumber moveto\n" );
		fprintf( outfile, "  show\n" );
		fprintf( outfile, "  ShowLineNumber_empty\n" );
		fprintf( outfile, "  HX_ShowLineNumber HY_ShowLineNumber moveto\n" );
	}
	fprintf( outfile, "} def\n\n" );

	// Ԥ
	fprintf( outfile, "/Newline\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  /WY_Newline currentpoint exch pop TextHeight sub def\n" );
	fprintf( outfile, "  LeftBound WY_Newline moveto\n" );
	fprintf( outfile, "  WY_Newline BottomBound lt { NewPage } if\n" );
	fprintf( outfile, "  /LineCount LineCount 1 add def\n" );
	fprintf( outfile, "  ShowLineNumber\n" );
	fprintf( outfile, "} def\n\n" );

	// ֹû˲Ԥ
	fprintf( outfile, "/Newline2\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  /WY_Newline2 currentpoint exch pop TextHeight sub def\n" );
	fprintf( outfile, "  LeftBound WY_Newline2 moveto\n" );
	fprintf( outfile, "  WY_Newline2 BottomBound lt { NewPage } if\n" );
	fprintf( outfile, "  ShowLineNumber_empty\n" );
	fprintf( outfile, "} def\n\n" );

	// ޤ֤Ԥ
	fprintf( outfile, "/LineTrun\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  pop\n" );
	fprintf( outfile, "  /CharWidth_LineTrun exch def\n" );
	fprintf( outfile, "  /WS_LineTrun 1 string def\n" );
	fprintf( outfile, "  WS_LineTrun 0 3 -1 roll put\n" );
	fprintf( outfile, "  currentpoint pop RightBound CharWidth_LineTrun sub gt { Newline2 } if\n" );
	fprintf( outfile, "  WS_LineTrun show\n" );
	fprintf( outfile, "} def\n\n" );

	// ʬʸϤ
	fprintf( outfile, "/PrintLine\n" );
	fprintf( outfile, "{\n" );
	fprintf( outfile, "  dup\n" );
	fprintf( outfile, "  type /stringtype eq {\n" );
	fprintf( outfile, "    dup length 0 gt {\n" );
	fprintf( outfile, "      /LineTrun load exch cshow\n" );
	fprintf( outfile, "    }\n" );
	fprintf( outfile, "    {\n" );
    fprintf( outfile, "      pop\n" );
    fprintf( outfile, "    } ifelse\n" );
	fprintf( outfile, "  }\n" );
	fprintf( outfile, "  {\n" );
	fprintf( outfile, "    load exec\n" );
	fprintf( outfile, "  } ifelse\n" );
	fprintf( outfile, "  NewPageFlg {\n" );
	fprintf( outfile, "    PrintHeader\n" );
	fprintf( outfile, "    PrintFooter\n" );
	fprintf( outfile, "    /NewPageFlg false def\n" );
	fprintf( outfile, "  } if\n" );
	fprintf( outfile, "} def\n\n" );

	// եȤ򤹤
	fprintf( outfile, "/%s findfont\n", FontName.c_str() );
	fprintf( outfile, "[ TextWidth 0 0 TextHeight 0 0 ] makefont setfont\n\n" );

	// ڡʬ礭ʥη׻˻Ѥ
	fprintf( outfile, "/SpaceWidth ( ) stringwidth pop dup 0 le { pop 1 } if def\n\n" );

	fprintf( outfile, "NewPage\n" );
	fprintf( outfile, "/NewPageFlg false def\n" );
	fprintf( outfile, "PrintHeader\n" );
	fprintf( outfile, "PrintFooter\n" );
	fprintf( outfile, "ShowLineNumber\n" );
	fprintf( outfile, "[\n" );

	// եԤɤ߹ߡƥȤϤ
	while ( !ferror( infile ) && !ferror( outfile ) && !feof( infile ) ) {
		GlbFunc::ReadLine( infile, &LineStr );
		if ( !IsFirst ) {
			// ǽΰԤǤʤСԽԤ碌
			fprintf( outfile, " /Newline\n" );
		}
		IsFirst = false;

		// 8ʥƥȲƽϤ
		fprintf( outfile, "  (" );
		ShowStringMain( LineStr, outfile );
		fprintf( outfile, ")" );
	}

	fprintf( outfile, "\n] { PrintLine } forall\n\n" );
	fprintf( outfile, "showpage\n\n" );

	return true;
}

// ʸ8ʥƥȤǽϤʥ֤νԤ
void CAsmPS::ShowStringMain( const string &r, FILE *outfile ) const
{
	int i;
	int c;

	for ( i = 0; i < r.length(); i++ ) {
		c = r[i] & 0xFF;
		if ( c != '\t' ) {
			// ְʳʸǤ8ʿϤ
			fprintf( outfile, "\\%03o", c );
		}
		else {
			// ֤Ϥ
			fprintf( outfile, ") /PrintTab (" );
		}
	}
}

// ʸ8ʥƥȤǽϤʥإåեåѡ
void CAsmPS::ShowStringHF( const string &r, FILE *outfile ) const
{
	int i, c;

	fprintf( outfile, "    (" );

	i = 0;
	while ( i < r.length() ) {
		
		c = r[i] & 0xFF;
		if ( r[i] != '%' || i == r.length() - 1 ) {
			// %̵ФΤޤ޽Ϥ
			fprintf( outfile, "\\%03o", c );
			i++;
			continue;
		}
		i++;
		switch ( r[i] ) {
		case 'p':
		case 'P':
			// %pޤ%PǤСڡֹϤ
			fprintf( outfile, ")\n    PageCount 5 string cvs\n    (" );
			break;
		case '%':
			// %%Ǥ%ʸϤ
			fprintf( outfile, "\\%03o", c );
			break;
		default:
			// ʳʸǤСΤޤ޽Ϥ
			fprintf( outfile, "\\%03o", c );
			c = r[i] & 0xFF;
			fprintf( outfile, "\\%03o", c );
		}
		i++;
	}
	fprintf( outfile, ")\n" );	
}
