////////////////////////////////////////////////////////////////////////////
// CStringTable 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <assert.h>
#include "GlbFunc.h"
#include "StringTable.h"

// ̾
#define ST_SECTION_NAME L"StringTable"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CStringTable::CStringTable() :
	theConf( NULL ),
	mapDefault()
{
	mapDefault.clear();
}

CStringTable::~CStringTable()
{
	Close();
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
bool CStringTable::Initialize( const char *pPath, unsigned long *pError )
{
	assert( NULL != this );

	if ( pError ) (*pError) = CF_NOERROR;

	// ǰΤᡢ¸ΤΤ˴
	Close();

	// pPathNULLϤ줿ϡΥ饹ѤʤΤȸʤ
	if ( !pPath ) return true;

	// ե򳫤
	theConf = confman_CreateConf( pPath );
	if ( NULL == theConf ) {
		// 顼֤ͤʤ
		if ( pError ) (*pError) = CF_NOERROR;
		return false;
	}

	// ɤ߹
	if ( !confman_Open( theConf ) ) {
		if ( pError )
			(*pError) = confman_GetLastError( theConf );
		Close();
		theConf = NULL;
		return false;
	}
	return true;
}

// ǥեͤ
void CStringTable::SetDefault( const wchar_t *pName, const wchar_t *pDef )
{
	string mbs;
	map< wstring, string >::iterator itr;

	// ¸ΤΤ򸡺
	itr = mapDefault.find( wstring( pName ) );

	// ¸ΤΤ¸ߤϡ
	if ( itr != mapDefault.end() )
		mapDefault.erase( itr );

	// ͤɲä
	if ( !GlbFunc::WCStoMBS( pDef, &mbs ) ) return ;
	mapDefault.insert( pair< wstring, string >( wstring( pName ), mbs ) );
}

// ͤμ
string CStringTable::GetStr( const wchar_t *pName, const char *pDef ) const
{
	const wchar_t *rp = NULL;
	string mbs;
	map< wstring, string >::const_iterator itr;

	mbs = "";
	assert( NULL != this );

	// 
	if ( theConf )
		rp = exconf_GetConstStr( theConf, ST_SECTION_NAME, pName );
	if ( rp )
		GlbFunc::WCStoMBS( rp, &mbs );


	// ͤĤС֤
	if ( !mbs.empty() ) return mbs;

	// ϿƤǥեͤ򸡺
	itr = mapDefault.find( wstring( pName ) );
	if ( itr == mapDefault.end() )
		return string( pDef );
	else
		return itr->second;
}

// 顼ͤμ
unsigned long CStringTable::GetLastError( ) const
{
	if ( theConf )
		return confman_GetLastError( theConf );
	else
		return CF_NOERROR;
}

// Ĥ
void CStringTable::Close()
{
	assert( NULL != this );

	mapDefault.clear();

	// confmanƤʤʤ餹Ϥʤ
	if ( !theConf ) return ;

	// Ĥ
	confman_SetModify( theConf, CF_FALSE );
	confman_Close( theConf );
	theConf = NULL;
}

