////////////////////////////////////////////////////////////////////////////
// CSequencer 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( SEQUENCER_H_INCLUDED_ )
#define SEQUENCER_H_INCLUDED_

#include <map>
#include "Semaphore.h"
#include "Mutex.h"

template< typename T_MSG >
class CSequencer
{
public:
	CSequencer() :
		ExitFlg( false ),
		SeqNumber( 0 )
	{};

	~CSequencer()
	{
		JobLock.Destroy();
		ExitFlgLock.Destroy();
	};

	// 
	bool Initialize()
	{
		bool r1 = JobLock.Initialize();
		bool r2 = ExitFlgLock.Initialize();
		bool r3 = WaitLock.Initialize();
		if ( r3 ) WaitLock.Lock();	// ֤ǥåƤ
		return r1 && r2 && r3;
	};

	// Ż
	void push( int idx, const T_MSG &r )
	{
		std::map< int, T_MSG >::iterator itr;

		assert( NULL != this && SeqNumber <= idx );

		// mapФ¾ݤ
		JobLock.Lock();

		// ޥåפɲä
		// Ʊ쥤ǥåΤΤǤ¸ߤϡ
		// ¸ΤΤ뤷Ƥɲä
		itr = mapJob.find( idx );
		if ( itr != mapJob.end() )
			mapJob.erase( itr );
		mapJob.insert( std::pair< int, T_MSG >( idx, r ) );

		// ˼Ф٤Ż줿顢semaWaitû
		if ( SeqNumber == idx )
			WaitLock.Unlock();

		// ¾
		JobLock.Unlock();
	};

	// ŻФ
	bool pop( T_MSG *pJob, int *pIdx = NULL )
	{
		int flg;

		assert( NULL != this && NULL != pJob );

		// mapJob˥ǡɲäޤԤ碌
		WaitLock.Lock();

		// ExitFlgФ¾ݤ
		ExitFlgLock.Lock();

		// λե饰ͤ
		// ѿflgϥåɥǤ뤳Ȥ
		flg = ExitFlg;

		// ExitFlgФ¾
		ExitFlgLock.Unlock();

		if ( flg ) {
			// ߤݤƤ

			// semaWaitԤäƤ¾Υåɤư褦ˤƤ
			WaitLock.Unlock();
			return false;
		}

		// ޥåפФ¾ݤ
		JobLock.Lock();

		// ޥåפŻФ
		(*pJob) = mapJob.begin()->second;
		if ( pIdx ) (*pIdx) = mapJob.begin()->first;
		mapJob.erase( mapJob.begin() );

		// ˴ԤŻΥǥåû
		SeqNumber++;

		// ޥåפˡǤ˼˴ԤŻ¸ߤϡ
		// Ԥ碌ѤΥޥեû
		if ( mapJob.size() > 0 ) {
			if ( mapJob.begin()->first == SeqNumber )
				WaitLock.Unlock();
		}

		// ¾
		JobLock.Unlock();

		return true;
	};

	// 
	void Interrupt()
	{
		// ExitFlgФ¾ݤ
		ExitFlgLock.Lock();

		// λե饰ꤹ
		ExitFlg = true;

		// semaWaitԤ碌Ƥ륹åɤ餻Ƥ
		WaitLock.Unlock();

		// ExitFlgФ¾
		ExitFlgLock.Unlock();
	};

protected:
	// ֻŻפΥޥå
	std::map< int, T_MSG > mapJob;

	// ˼Ф٤Ż
	int SeqNumber;

	// mapjob˥Ԥ¾
	CMutex JobLock;

	// mapJob˥ǡޤǤԤ碌
	CMutex WaitLock;

	// λե饰
	volatile bool ExitFlg;

	// ExitFlgФ¾
	CMutex ExitFlgLock;

};

#endif // SEQUENCER_H_INCLUDED_

