////////////////////////////////////////////////////////////////////////////
// CLock 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "Lock.h"
#include <assert.h>

using namespace std;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CLock::CLock() :
	sema_Occupation( 1 ),
	sema_Share( 1 ),
	sema_id( 1 ),
	counter( 1 ),
	ShareLockCount( 0 ),
	mapLockNumber()
{

}

CLock::~CLock()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ͭåߤ
LOCK_ID CLock::TryOccupationLock()
{
	// ޤͭåγǧԤ
	// ïͤǤⶦͭåäƤ顢ͭåϽʤ
	if ( !sema_Share.Try() ) return 0;

	// ͭåγǧԤ
	if ( !sema_Occupation.Try() ) return 0;

	// ͭåIDȯ֤
	return CreateID( LT_OCCUPATION );
}

// ͭåߤ
LOCK_ID CLock::TryShareLock()
{
	// ͭåγǧԤ
	// ïͭåƤ顢ͭåϽʤ
	if ( !sema_Occupation.Try() ) return 0;
	sema_Occupation.V();

	// ͭåԤʥåʤƤ⤫ޤʤ
	sema_Share.Try();

	// ͭåIDȯ֤
	return CreateID( LT_SHARE );
}

// ͭåޤԤ碌
LOCK_ID CLock::WaitOccupationLock()
{
	// ޤͭåԤ
	sema_Share.Try();

	// ͭåԤ
	sema_Occupation.P();

	// ͭåIDȯ֤
	return CreateID( LT_OCCUPATION );
}

// ͭåޤԤ碌
LOCK_ID CLock::WaitShareLock()
{
	// ͭåԤ碌Ԥ
	sema_Occupation.P();
	sema_Occupation.V();

	// ͭåԤ
	sema_Share.Try();

	// ͭåIDȯ֤
	return CreateID( LT_SHARE );
}

// å
void CLock::Free( LOCK_ID id )
{
	sema_id.P();

	assert( NULL != this );
	map< LOCK_ID, LOCKTYPE >::iterator itr = mapLockNumber.find( id );
	assert( mapLockNumber.end() != itr );

	// ͭåο򸺻
	ShareLockCount--;

	if ( itr->second == LT_OCCUPATION ) {
		// ͭåβ
		sema_Occupation.V();
		sema_Share.V();
	}
	else {
		// ͭåβ
		if ( 0 == ShareLockCount )
			sema_Share.V();
	}

	// map
	mapLockNumber.erase( itr );

	sema_id.V();
}

// ꤵ줿IDͭåƤ뤫ݤ
bool CLock::CheckOccupationLock( LOCK_ID id ) const
{
	bool r = true;
	sema_id.P();

	assert( NULL != this );
	map< LOCK_ID, LOCKTYPE >::const_iterator itr = mapLockNumber.find( id );
	if ( itr == mapLockNumber.end() )
		r = false;
	else
		r = ( LT_OCCUPATION == itr->second );

	sema_id.V();

	return r;
}

// ꤵ줿IDǶͭåƤ뤫ݤ
bool CLock::CheckShareLock( LOCK_ID id ) const
{
	bool r = true;
	sema_id.P();

	assert( NULL != this );
	map< LOCK_ID, LOCKTYPE >::const_iterator itr = mapLockNumber.find( id );
	if ( itr == mapLockNumber.end() )
		r = false;
	else
		r = ( LT_SHARE == itr->second );

	sema_id.V();

	return r;
}

// IDȯ֤
LOCK_ID CLock::CreateID( LOCKTYPE type )
{
	// IDѥޥեǡmapLockNumbercounterå
	sema_id.P();

	// ͭåΤäƤ򥫥Ȥ
	ShareLockCount++;

	// ͤmapɲáͤβûԤ
	LOCK_ID r = counter;
	++counter;
	mapLockNumber.insert( pair< LOCK_ID, LOCKTYPE >( r, type ) );

	// å
	sema_id.V();

	return r;
}

