////////////////////////////////////////////////////////////////////////////
// GlbFunc.h
// Хؿ
////////////////////////////////////////////////////////////////////////////

#if !defined( GLBFUNC_H_NICLUDED_ )
#define GLBFUNC_H_NICLUDED_

#include <stdio.h>

#include <string>
#include <map>
#include <vector>

#include "VPtr.h"
#include "VClsPtr.h"
#include "FilePtr.h"

namespace GlbFunc {

// ʸꤵ줿ʸǶڤ
std::vector< std::string > DiviteString( const std::string &r, char c );

// ѥ̾
std::string ResolvPath( const std::string &r );

// ѥ̾ʻꤵ줿֤Хѥȸʤ
std::string ResolvPath( const std::string &r, const char *pBase );

// ȥǥ쥯ȥ
std::string GetCurDir( void );

// ĤFILEؤ
bool SwapPort( FILE *a, FILE *b );

// ѥפۤFILE֤
bool CreatePipeByFILE( FILE **ppIn, const char *pInMode, FILE **ppOut, const char *pOutMode );

// ѥפۤVClsPtr< CFilePtr >֤
bool CreatePipeByFilePtr( NNabikiVClsPtr::VClsPtr< CFilePtr > *pIn, const char *pInMode, NNabikiVClsPtr::VClsPtr< CFilePtr > *pOut, const char *pOutMode );

// ʸ夫顢ꤷʸ
std::string Trim( const std::string &s, const std::string &scv, const std::string &ecv );

// ɤ߹
bool ReadLine( FILE *infile, std::string *pLine, int RetCode = '\n', bool UseEscSeq = false, int EscChar = '\\' );

// ʸѴ
std::string ToUpper( const std::string &r );
std::wstring ToUpperWcs( const std::wstring &r );

// 磻ɥХʸޥХʸѴ
bool WCStoMBS( const wchar_t *pWCS, std::string *pMBS );

// ޥХʸ磻ɥХʸѴ
bool MBStoWCS( const char *pMBS, std::wstring *pWCS );

// ʸ%1%9ꤵ줿ƥȤִ
template< typename T_Str, typename T_Char >
T_Str CreateMsgString( const T_Str &rMsg, int cnt, const T_Char *pvArgStr[] );

// ʸ%1%9ޤޤ뤫ݤĴ٤
template< typename T_Str >
void InspectMsgString( const T_Str &rMsg, int cnt, bool vFlg[] );

// եΥѥ̾顢ե̾ʬڤФ
template< typename T_Str >
T_Str GetFileNameFromFullPathName( const T_Str& FullPathName );

// ʸ򿿵ͤѴ
bool MbsToBoolean( const char *pStr, bool d = true );
bool WcsToBoolean( const wchar_t *pStr, bool d = true );

// ʸͤѴ
template< typename T_Val >
T_Val MbsToValue( const char *pStr, T_Val d, int cnt, ... );
template< typename T_Val >
T_Val WcsToValue( const wchar_t *pStr, T_Val d, int cnt, ... );

// ͤб̤ͤѴ
template< typename T_Val1, typename T_Val2 >
T_Val2 TranslateValue( T_Val1 v, T_Val2 d, int cnt, ... );

// ͤϰϤ
template< typename T_Val >
T_Val CheckRange( T_Val v, T_Val u, T_Val h, bool *pError = NULL );

// ƥݥʸ
NNabikiVPtr::VPtr< char > TempStr( const std::string &r );
NNabikiVPtr::VPtr< wchar_t > TempStr( const std::wstring &r );

// פ줿ʸŸ
template< typename T_Str, typename T_Char >
T_Str ExpandEscapedString( const T_Str &rStr, const std::map< T_Char, T_Str > &rDict, T_Char EscChar );

}

#endif // GLBFUNC_H_NICLUDED_


