////////////////////////////////////////////////////////////////////////////
// GlbFunc.h
// Хؿ
////////////////////////////////////////////////////////////////////////////

#include "GlbFunc.h"

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <limits.h>
#include <assert.h>

#include <vector>
#include <string>

using namespace std;

// ʸꤵ줿ʸʬ䤹
vector< string > GlbFunc::DiviteString( const string &r, char c )
{
	vector< string > wv;
	int i, j;

	if ( r.length() == 0 ) return vector< string >();

	// ƬcͿ줿ϡʸܤϥåפ
	if ( r[0] == c )
		i = 1;
	else
		i = 0;
	while ( i < r.length() ) {
		for ( j = i; j < r.length() && r[j] != c; j++ );
		wv.push_back( r.substr( i, j - i ) );
		i = j + 1;
	}
	return wv;
}

// ѥ̾褹
string GlbFunc::ResolvPath( const string &r )
{
	char *p = getcwd( NULL, PATH_MAX );
	string rs = ResolvPath( r, p );
	free( p );
	return rs;
}

// ѥ̾ʻꤵ줿֤Хѥȸʤ
std::string GlbFunc::ResolvPath( const std::string &r, const char *pBase )
{
	string ws;
	int i;
	vector< string > wv;
	vector< string > wv2;

	assert( pBase );

	if ( r.length() == 0 ) return "";

	if ( r[0] != '/' ) {
		ws = pBase;
		if ( ws.length() == 0 ) return r;
		if ( ws[ ws.length() - 1 ] != '/' ) ws += '/';
	}
	ws += r;

	// ѥ̾/Ƕڤ
	wv = DiviteString( ws, '/' );

	// פǤ
	wv2.clear();
	for ( i = 0; i < wv.size(); i++ ) {
		// Ĺ0ʸ/Ϣ³ˤ䡢"."Ͻ
		if ( wv[i].length() == 0 || wv[i] == "." ) continue;
		if ( wv[i] == ".." ) {
			// ƥǥ쥯ȥλ
			if ( wv2.size() > 0 ) wv2.pop_back();
			continue;
		}
		// 嵭ʳϡɲä
		wv2.push_back( wv[i] );
	}

	// ͤۤ
	ws = "";
	for ( i = 0; i < wv2.size(); i++ ) {
		ws += string( "/" ) + wv2[i];
	}
	if ( ws.length() == 0 ) ws += "/";
	return ws;
}

// ȥǥ쥯ȥ
std::string GlbFunc::GetCurDir( void )
{
	char *p = NULL;
	int BufSize = 10;
	string rstr;

	// ֤ǥѥ̾μߤ
	p = getcwd( NULL, BufSize );

	// Хåե­ǼԤַ֤
	while ( NULL == p && ERANGE == errno ) {
		// ХåեĹ2ܤˤ
		BufSize *= 2;
		// ٥ѥ̾μߤ
		p = getcwd( NULL, BufSize );
	}

	// ɤޤʤäˤϡĹ0ʸ֤
	if ( NULL == p ) return "";

	// ΰ֤ͤ
	rstr = p;
	free( p );
	return rstr;
}

// ĤFILEؤ
bool GlbFunc::SwapPort( FILE *a, FILE *b )
{
	int a_no;
	int b_no;
	int a_no2;

	assert( a && b );
	fflush( a );
	fflush( b );

	/* ǥץץ */
	a_no = fileno( a );
	b_no = fileno( b );

	/* aʣ */
	a_no2 = dup( a_no );
	if ( a_no < 0 ) return false;

	/* ab˺ؤ */
	if ( dup2( b_no, a_no ) < 0 ) return false;

	/* bʣaȺؤ */
	if ( dup2( a_no2, b_no ) < 0 ) {
		/* ɤ褦ʤȤꤢ᤹Ϥ򤹤 */
		dup2( a_no2, a_no );
		close( a_no2 );
		return false;
	}
	close( a_no2 );

	clearerr( a );
	clearerr( b );

	return true;
}

// ѥפۤFILE֤
bool GlbFunc::CreatePipeByFILE( FILE **ppIn, const char *pInMode, FILE **ppOut, const char *pOutMode )
{
	assert( ppIn && pInMode && ppOut && pOutMode );

	int vPipeFD[2] = { 0 };	// ѥפΥǥץ

	// ѥפ
	if ( pipe( vPipeFD ) ) return false;

	// ѥפΥǥץFILE˴ϢŤ
	(*ppIn) = fdopen( vPipeFD[0], pInMode );
	if ( NULL == (*ppIn) ) {
		close( vPipeFD[0] );
		close( vPipeFD[1] );
		return false;
	}

	(*ppOut) = fdopen( vPipeFD[1], pOutMode );
	if ( NULL == (*ppOut) ) {
		fclose( (*ppIn) );
		(*ppIn) = NULL;
		close( vPipeFD[1] );
		return false;
	}

	return true;
}

// ѥפۤVClsPtr< CFilePtr >֤
bool GlbFunc::CreatePipeByFilePtr( NNabikiVClsPtr::VClsPtr< CFilePtr > *pIn, const char *pInMode, NNabikiVClsPtr::VClsPtr< CFilePtr > *pOut, const char *pOutMode )
{
	FILE *in = NULL;
	FILE *out = NULL;
	NNabikiVClsPtr::VClsPtr< CFilePtr > wIn, wOut;

	assert( pIn && pInMode && pOut && pOutMode );

	// ѥפۤ
	if ( !CreatePipeByFILE( &in, pInMode, &out, pOutMode ) )
		return false;

	// vClsPtr< CFilePtr >˷Ѵ
	wIn = new CFilePtr( in );
	wOut = new CFilePtr( out );
	if ( wIn.IsNull() || wOut.IsNull() ) return false;

	(*pIn) = wIn;
	(*pOut) = wOut;
	return true;
}

// ʸsƬscv˴ޤޤƤʸ
// ecv˴ޤޤƤʸ̤֤
string GlbFunc::Trim( const string &s, const string &scv, const string &ecv )
{
	int i, j, sp, ep;

	// ƬνϰϤ
	for ( i = 0; i < s.length(); i++ ) {
		// s[i]scv˴ޤޤƤ뤫ݤ
		for ( j = 0; j < scv.length() && s[i] != scv[j]; j++ );
		if ( j >= scv.length() ) break;
	}
	if ( i >= s.length() ) return "";
	sp = i;

	// νϰϤ
	for ( i = s.length() - 1; i >= 0 && i >= sp; i-- ) {
		// s[i]ecv˴ޤޤƤ뤫ݤ
		for ( j = 0; j < ecv.length() && s[i] != ecv[j]; j++ );
		if ( j >= ecv.length() ) break;
	}
	if ( i < 0 || i < sp ) return "";
	ep = i + 1;

	return s.substr( sp, ep - sp );
}

// ɤ߹
// infile : ϥե
// pLine : ɤ߹
// RetCode : ԥɤʸ
// UseEscSeq : ץ󥹤Ѥ뤫ݤ
// EscChar : ʸ
bool GlbFunc::ReadLine( FILE *infile, string *pLine, int RetCode, bool UseEscSeq, int EscChar )
{
	char c;
	int flg = 0;	// פƤ뤫ݤ

	assert( infile && pLine );
	assert( !UseEscSeq || ( RetCode != EscChar ) );

	pLine->clear();
	if ( ferror( infile ) || feof( infile ) ) return false;

	// ǽΰʸɤ߹
	c = fgetc( infile );
	if ( UseEscSeq && c == EscChar ) flg = 1;

	while ( !ferror( infile ) && !feof( infile ) && !( c == RetCode && flg == 0 ) ) {
		switch ( flg ) {
		case 0:
			// פƤʤ
			// Ϸ̤ʸϢ뤷ơʸɤ߹
			(*pLine) += c;
			c = fgetc( infile );
			if ( UseEscSeq && c == EscChar ) flg = 1;
			break;
		case 1:
			// ʸƤ
			// ʸɤ߹
			c = fgetc( infile );
			flg = 2;
			break;
		case 2:
			// ʸμʸɤ߹Ǥ
			if ( c != RetCode && c != EscChar ) {
				// ԥɤȥʸʳʸפƤ顢
				// ʸޤᡢϤ줿ʸ򤽤Τޤ޽ʸꤹ
				(*pLine) += EscChar;
			}
			(*pLine) += c;
			// ʸɤ߹
			c = fgetc( infile );
			flg = 0;
			if ( UseEscSeq && c == EscChar ) flg = 1;
		}
	}

	if ( ferror( infile ) || feof( infile ) )
		return false;
	else
		return true;
}

// ʸΤ٤ƤξʸʸѴ
string GlbFunc::ToUpper( const string &r )
{
	int i;
	string result;

	result = "";
	for ( i = 0; i < r.length(); i++ )
		result += (char)( toupper( r[i] ) );
	return result;
}

std::wstring GlbFunc::ToUpperWcs( const std::wstring &r )
{
	int i;
	wstring result;

	result = L"";
	for ( i = 0; i < r.length(); i++ )
		result += (wchar_t)( towupper( r[i] ) );
	return result;
}

// 磻ɥХʸ󤫤ޥХʸѴ
bool GlbFunc::WCStoMBS( const wchar_t *pWCS, std::string *pMBS )
{
	NNabikiVPtr::VPtr< char > pBuf;
	size_t len;

	if ( !pWCS ) return false;

	len = wcstombs( NULL, pWCS, 0 ) + 1;
	if ( len == 0 ) return false;

	pMBS->clear();

	// ΰ
	if ( !pBuf.Malloc( len * sizeof( wchar_t ) ) )
		return false;

	// ޥХʸѴ
	if ( wcstombs( pBuf.GetPtr(), pWCS, len * sizeof( wchar_t ) ) == (size_t)-1 )
		return false;

	// ͤ
	(*pMBS) = pBuf.GetPtr();
	return true;
}

// ޥХʸ󤫤磻ɥХʸѴ
bool GlbFunc::MBStoWCS( const char *pMBS, std::wstring *pWCS )
{
	NNabikiVPtr::VPtr< wchar_t > pBuf;
	size_t len;

	if ( !pMBS ) return false;

	len = mbstowcs( NULL, pMBS, 0 ) + 1;
	if ( len == 0 ) return false;
	pWCS->clear();

	// ΰ
	if ( !pBuf.Malloc( len * sizeof( wchar_t ) ) )
		return false;

	// 磻ɥХʸѴ
	if ( mbstowcs( pBuf.GetPtr(), pMBS, len * sizeof( wchar_t ) ) == (size_t)-1 )
		return false;

	// ͤ
	(*pWCS) = pBuf.GetPtr();
	return true;
}

// ʸ%1%9ꤵ줿ƥȤִ
template< typename T_Str, typename T_Char >
T_Str GlbFunc::CreateMsgString( const T_Str &rMsg, int cnt, const T_Char *pvArgStr[] )
{
	int i;
	map< T_Char, T_Str > dict;

	assert( cnt >= 1 && cnt < 9 );
	for ( i = 0; i < cnt; i++ )
		dict.insert( pair< T_Char, T_Str >( '1' + i, T_Str( pvArgStr[i] ) ) );
	return ExpandEscapedString( rMsg, dict, T_Char( '%' ) );
}

// ʸ%1%9ޤޤ뤫ݤĴ٤
template< typename T_Str >
void GlbFunc::InspectMsgString( const T_Str &rMsg, int cnt, bool vFlg[] )
{
	int i;

	assert( cnt >= 1 && cnt <= 9 );	// Ǥ⣹

	// ե饰ˡ餫ᵶꤷƤ
	for ( i = 0; i < cnt; i++ )
		vFlg[i] = false;

	for ( i = 0; i < rMsg.size(); i++ ) {
		// %ʳʸǤɤФ
		if ( rMsg[i] != T_Str::value_type( '%' ) )
			continue;

		i++;

		// ãλ
		if ( i >= rMsg.length() ) break;

		if ( rMsg[i] >= T_Str::value_type( '1' ) && rMsg[i] < ( T_Str::value_type( '1' ) + cnt ) ) {
			// %1%cntޤǤξϡե饰˿ꤹ
			vFlg[ rMsg[i] - T_Str::value_type( '1' ) ] = true;
		}
	}
}

// եΥѥ̾ե̾Τߤ
template< typename T_Str >
T_Str GlbFunc::GetFileNameFromFullPathName( const T_Str& FullPathName )
{
	T_Str r;
	if ( FullPathName.empty() ) return FullPathName;

	// ƥȤڤ국򸡺
	int idx = FullPathName.rfind( T_Str::value_type( '/' ) );
	if ( idx < 0 || idx - 1 >= FullPathName.length() )
		return r;	// Ĥʤä

	return FullPathName.substr( idx + 1 );
}

// ʸ򿿵ͤѴ
bool GlbFunc::MbsToBoolean( const char *pStr, bool d )
{
	return MbsToValue( pStr, d, 2, "True", true, "False", false );
}

bool GlbFunc::WcsToBoolean( const wchar_t *pStr, bool d )
{
	return WcsToValue( pStr, d, 2, L"True", true, L"False", false );
}

// ʸͤѴ
// pStr : Ѵоݤʸ
// d : Ѵ˼Ԥ֤ǥե
// cnt : ο
// ... : ʸͤߤcnt󷫤֤
template< typename T_Val >
T_Val GlbFunc::MbsToValue( const char *pStr, T_Val d, int cnt, ... )
{
	va_list p;
	int i;
	const char *wp;
	T_Val wd;

	if ( !pStr ) return d;

	va_start( p, cnt );	
	for ( i = 0; i < cnt; i++ ) {
		// 
		wp = va_arg( p, const char* );
		wd = va_arg( p, T_Val );
		if ( wp == NULL ) continue;

		// 
		if ( strcasecmp( pStr, wp ) == 0 ) {
			// פΤĤСб֤ͤƽλ
			va_end( p );
			return wd;
		}
	}

	// פΤĤʤСǥե֤ͤƽλ
	va_end( p );
	return d;
}

// ʸͤѴ
template< typename T_Val >
T_Val GlbFunc::WcsToValue( const wchar_t *pStr, T_Val d, int cnt, ... )
{
	va_list p;
	int i;
	const wchar_t *wp;
	T_Val wd;
	wstring pStrUppser;
	wstring TargetUpper;

	if ( !pStr ) return d;

	// оݤʸʸѴ
	pStrUppser = ToUpperWcs( pStr );

	va_start( p, cnt );	
	for ( i = 0; i < cnt; i++ ) {
		// 
		wp = va_arg( p, const wchar_t* );
		TargetUpper = ToUpperWcs( wp );
		wd = va_arg( p, T_Val );
		if ( wp == NULL ) continue;

		// 
		if ( wcscmp( pStrUppser.c_str(), TargetUpper.c_str() ) == 0 ) {
			// פΤĤСб֤ͤƽλ
			va_end( p );
			return wd;
		}
	}

	// פΤĤʤСǥե֤ͤƽλ
	va_end( p );
	return d;
}

// ͤб̤ͤѴ
// v : Ѵоݤ
// d : Ѵ˼Ԥ֤ǥե
// cnt : ο
// ... : 12ߤcnt󷫤֤
template< typename T_Val1, typename T_Val2 >
T_Val2 GlbFunc::TranslateValue( T_Val1 v, T_Val2 d, int cnt, ... )
{
	va_list p;
	T_Val1 wv1;
	T_Val2 wv2;
	int i;

	va_start( p, cnt );	
	for ( i = 0; i < cnt; i++ ) {
		// 
		wv1 = va_arg( p, T_Val1 );
		wv2 = va_arg( p, T_Val2 );

		// 
		if ( wv1 == v ) {
			// פΤĤСб֤ͤƽλ
			va_end( p );
			return wv2;
		}
	}

	// פΤĤʤСǥե֤ͤƽλ
	va_end( p );
	return d;
}

// ͤϰϤ
// ͤζԤ줿ˤϡ(*pError)˿ꤵ
template< typename T_Val >
T_Val GlbFunc::CheckRange( T_Val v, T_Val u, T_Val h, bool *pError )
{
	if ( u > h ) {
		T_Val w = u;
		u = h;
		h = w;
	}
	if ( v < u ) {
		if ( pError ) (*pError) = true;
		return u;
	}
	if ( v > h ) {
		if ( pError ) (*pError) = true;
		return h;
	}
	return v;
}

// ƥݥʸ
NNabikiVPtr::VPtr< char > GlbFunc::TempStr( const std::string &r )
{
	NNabikiVPtr::VPtr< char > v;
	v.Malloc( r.size() + 1 );
	memcpy( v.GetPtr(), r.c_str(), sizeof( char ) * ( r.size() + 1 ) );
	return v;
}

NNabikiVPtr::VPtr< wchar_t > GlbFunc::TempStr( const std::wstring &r )
{
	NNabikiVPtr::VPtr< wchar_t > v;
	v.Malloc( r.size() + 1 );
	memcpy( v.GetPtr(), r.c_str(), sizeof( wchar_t ) * ( r.size() + 1 ) );
	return v;
}

// פ줿ʸŸ
template< typename T_Str, typename T_Char >
T_Str GlbFunc::ExpandEscapedString( const T_Str &rStr, const std::map< T_Char, T_Str > &rDict, T_Char EscChar )
{
	T_Str RetStr;	// ͤȤʤʸݻ
	std::map< T_Char, T_Str >::const_iterator itr;
	int i = 0;

	RetStr.clear();
	while ( i < rStr.length() ) {
		if ( rStr[i] != EscChar ) {
			// ʸǤʤСΤޤͤ
			RetStr += rStr[i];
			i++;
		}
		else {
			// ʸ줿
			i++;

			// ñΥʸи̵뤹
			if ( i >= rStr.length() ) break;

			// פ줿ʸǼ򸡺
			itr = rDict.find( rStr[i] );
			if ( itr == rDict.end() ) {
				// ΤĤʤäϡϤʸ򤽤Τޤ޽ϤȤ
				RetStr += EscChar;
				RetStr += rStr[i];
			}
			else {
				// ˻ꤵ줿ʸִ
				RetStr += itr->second;
			}
			i++;
		}
	}

	return RetStr;
}

