////////////////////////////////////////////////////////////////////////////
// CDoorClient 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <door.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <assert.h>
#include <unistd.h>

#include "DoorClient.h"
#include "VPtr.h"

using namespace NNabikiVPtr;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CDoorClient::CDoorClient() :
	DoorDescriptor( -1 )
{

}

CDoorClient::~CDoorClient()
{
	Close();
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// Door򳫤
bool CDoorClient::Open( const char *pFnmae )
{
	assert( NULL != this && pFnmae );

	// ꤵ줿եǧ
	if ( !CheckDoor( pFnmae ) ) return false;

	// 
	DoorDescriptor = open( pFnmae, O_RDWR );
	if ( DoorDescriptor < 0 ) return false;

	return true;
}

// DoorƤӽФ
VPtr< char > CDoorClient::Call( const CNegCmd *cmd, bool *pSrvDownFlg ) const
{
	string SendData;
	door_arg_t DoorArg;
	VPtr< char > pSendBuf;
	VPtr< char > pRetBuf;
	char RetBuf_Auto[256] = { 0 };
	int ByteSeqLen;

	assert( NULL != this && NULL != cmd );
	assert( DoorDescriptor >= 0 );
	if ( pSrvDownFlg ) (*pSrvDownFlg) = false;

	// doorѲǽݤǧ
	if ( !CheckDoor( DoorDescriptor ) ) {
		if ( pSrvDownFlg ) (*pSrvDownFlg) = true;
		return VPtr< char >( NULL );
	}

	// Фǡۤ
	SendData = cmd->GetSendData();

	if ( SendData.length() == 0 ) return VPtr< char >( NULL );

	// ѥХåեѰդơѥǡ򥳥ԡ
	if ( !pSendBuf.Malloc( sizeof( char ) * SendData.length() ) )
		return VPtr< char >( NULL );
	memcpy( pSendBuf.GetPtr(), SendData.c_str(), sizeof( char ) * SendData.length() );
	SendData = "";

	// DoorArg¤Τͤꤹ롣
	DoorArg.data_ptr = pSendBuf.GetPtr();
	DoorArg.data_size = pSendBuf.GetLen();
	DoorArg.desc_ptr = NULL;
	DoorArg.desc_num = 0;
	DoorArg.rbuf = RetBuf_Auto;
	DoorArg.rsize = sizeof( RetBuf_Auto ) * sizeof( char );

	// doorƤӽФ
	if ( door_call( DoorDescriptor, &DoorArg ) )
		return VPtr< char >( NULL );
	pSendBuf.Free();

	// ѤΥǡ
	if ( pRetBuf.Malloc( sizeof( char ) * DoorArg.rsize ) )
		memcpy( pRetBuf.GetPtr(), DoorArg.rbuf, sizeof( char ) * DoorArg.rsize );

	if ( DoorArg.rbuf != RetBuf_Auto )
		munmap( DoorArg.rbuf, DoorArg.rsize );

	return pRetBuf;
}

// Ĥ
void CDoorClient::Close()
{
	if ( DoorDescriptor > 0 )
		close( DoorDescriptor );
	DoorDescriptor = -1;
}

// door򳫤Ƥ뤫ݤ
bool CDoorClient::Enable() const
{
	return ( DoorDescriptor >= 0 );
}

// doorѲǽݤǧ
bool CDoorClient::CheckDoor( const char *pFnmae )
{
	struct stat wStat;
	int dd;
	bool r = false;

	assert( pFnmae );

	// եξ֤ǧ
	if ( lstat( pFnmae, &wStat ) )
		return false;	// ե뤬ʤ

	// doorݤ
	if ( !wStat.st_mode & S_IFDOOR )
		return false;

	// doorե򳫤Ƥߤ
	dd = open( pFnmae, O_RDWR );
	if ( dd < 0 ) return false;

	// doorȤ뤫ɤǧ
	r = CheckDoor( dd );

	close( dd );

	return r;
}

// ꤵ줿ǥץdoorѲǽݤǧ
bool CDoorClient::CheckDoor( int dd )
{
	struct door_info info;

	// doorξ
	if ( door_info( dd, &info ) )
		return false;

	// revoke̵doorѲǽǤ
	if ( info.di_attributes & DOOR_REVOKED )
		return false;

	return true;
}

