////////////////////////////////////////////////////////////////////////////
// conv.cc
// ʸѴġ
////////////////////////////////////////////////////////////////////////////

#include "conv_glo.h"

#include "FileName.h"
#include "Converter.h"

using namespace std;
using namespace NNabikiVClsPtr;

int TransMain( int argc, char *argv[] );
int printerrmsg( int n );
int help( const char *p );
int InputStdIn( const CCmdOpt &rOption, const CConverter &rConv );
int InputFile( const CCmdOpt &rOption, const CConverter &rConv );
int InputDir( const CCmdOpt &rOption, const CConverter &rConv );
int ConvertFileToFile( const string &rIn, const string &rOut, const CConverter &rConv );
int ConvertDir( string InDir, string OutDir, const CConverter &rConv, bool Recursive, set< unsigned long > *pSetINode );
bool CreateDir( string dir );

int main( int argc, char *argv[] )
{
	// 
	setlocale( LC_ALL, "" );

	// ѴԤ
	return TransMain( argc, argv );
}

// ѴԤ
// mainؿǤϥΤߤԤ
int TransMain( int argc, char *argv[] )
{
	CCmdOpt option;
	CFileName wFileName;
	bool IsDir;
	CConverter conv;
	string InCode;
	string OutCode;
	NEWLINE_CHAR nlc;
	string NewLineType;
	const NEWLINE_CHAR vNC[] = { NC_LF, NC_CR, NC_LFCR, NC_CRLF };
	const char *vNCName[] = { "LF", "CR", "LFCR", "CRLF" };
	int i;
	bool NeedToTransEncode = true;

	// Υå
	option.Initialize( argc, argv );

	// ϤΥ󥳡ɤ
	InCode = option.GetValue( "-ifc", "" );
	OutCode = option.GetValue( "-ofc", "" );

	// 󥳡̾ά줿ϡȤΥΥ󥳡ɤѤ롣
	if ( InCode.empty() ) InCode = nl_langinfo( CODESET );
	if ( OutCode.empty() ) OutCode = nl_langinfo( CODESET );

	if ( option.IsExist( "-t" ) ) {
		// 󥳡̾Υꥢ
		CAlias alias;
		const char *pAliasFileName = getenv( SCEV_ALIAS_PATH );

		alias.Initialize();

		// ꥢΥեϡ:Ƕڤäʣꤹ뤳ȤǤ
		if ( pAliasFileName ) {
			vector< string > vAliasFiles = GlbFunc::DiviteString( pAliasFileName, ':' );
			for ( i = 0; i < vAliasFiles.size(); i++ )
				alias.AddAliasFile( vAliasFiles[i].c_str() );
		}
		// ̾Ѵ
		InCode = alias.TransName( InCode );
		OutCode = alias.TransName( OutCode );
	}

	// ϤΥ󥳡ɤƱäϡѴɬפʤ
	if ( InCode == OutCode )
		NeedToTransEncode = false;

	// ԥɤμ̤
	NewLineType = option.GetValue( "-c", "" );
	for ( i = 0; i < 4 && strncasecmp( NewLineType.c_str(), vNCName[i], NewLineType.length() ); i++ );
	if ( i < 4 )
		nlc = vNC[i];
	else
		nlc = NC_NON;

	// ѴѤ˽
	if ( NeedToTransEncode ) {
		if ( !conv.Initialize( InCode.c_str(), OutCode.c_str(), nlc ) )
			return printerrmsg( 2 );
	}
	else {
		if ( !conv.Initialize( nlc ) )
			return printerrmsg( 2 );
	}

	// ̤˽
	if ( option.GetValue( "-ifn", "" ).empty() )
		return printerrmsg( InputStdIn( option, conv ) );

	// եξ֤
	wFileName.Set( option.GetValue( "-ifn", "" ).c_str() );
	if ( !wFileName.GetStatus( NULL, &IsDir, NULL ) )
		return printerrmsg( 5 );

	// ̾Υեä
	if ( !IsDir )
		return printerrmsg( InputFile( option, conv ) );

	// ǥ쥯ȥä
	if( IsDir )
		return printerrmsg( InputDir( option, conv ) );

	return help( argv[0] );
}

int help( const char *p )
{
	printf( "%s : Codeset conversion tool.\n", p );
	printf( "switch\n" );
	printf( "\t-ifn Input File Name\n" );	// ϥե̾λ
	printf( "\t-ofn Output File Name\n" );	// ϥե̾λ
	printf( "\t-ifc Input Encode\n" );		// ϥ󥳡ɤλ
	printf( "\t-ofc Output Encode\n" );		// ϥ󥳡ɤλ
	printf( "\t-r\n" );		// ֥ǥ쥯ȥΥեѴ
	printf( "\t-o\n" );		// ϥե˾񤭤
	printf( "\t-c CR|LF|CRLF|LFCR\n" );	// ԥɤ
	printf( "\t-t\n" );		// 󥳡̾Ԥ
	return 1;
	/*
	ϤΥ󥳡ɤά줿ϡȥΥ󥳡ɤѤ롣
	-ifnά줿ɸϤѤ
	Ϥե⤷ɸϤξ硢-r̵뤹롣
	ϤɸϤꤵ줿
		-ofnά줿ϡ-oλ˴ؤ餺ɸϤ˽Ϥ
		-ofn˥ե̾ꤵ줿Υե˽Ϥ
		-ofn˥ǥ쥯ȥ̾ꤵ줿ϥ顼
	Ϥ˥ե̾ꤵ줿
		-ofn-oꤵƤʤä顢ɸϤ˽Ϥ
		-ofnꤵ줺-oꤵƤϡϥե˾񤭤
		-ofn˥ե̾ꤵƤϡ-o˻˴ؤ餺ꤵ줿ե˽Ϥ
		-ofn˥ǥ쥯ȥ̾ꤵƤϡ-o̵ͭ˴ؤ餺ꤵ줿ǥ쥯ȥϥեƱ̾Υե˽Ϥ롣
	Ϥ˥ǥ쥯ȥ̾ꤵƤ
		-ofn-oꤵƤʤäϡ顼
		-ofn˥ե̾ꤵƤϡ-o̵ͭ˴ؤ餺顼
		-ofn˥ǥ쥯ȥ̾ꤵƤϡ-o̵ͭ˴ؤ餺ꤵ줿ǥ쥯ȥ˽
		-ofnʤ-oΤߤꤵƤϡϥե񤭤
	*/
}

// ͤ˱顼åϤ
int printerrmsg( int n )
{
	switch ( n ) {
	case 0:
		// 顼ȯƤʤ
		return 0;
	case 2:
		// ꤵ줿ѴԲǽ
		fprintf( stderr, "Specified converter was not offered.\n" );
		break;
	case 3:
		// ϥե뤬ʤ
		fprintf( stderr, "Failed to open specified input file.\n" );
		break;
	case 4:
		// ϥե뤬ʤ
		fprintf( stderr, "Failed to open specified output file.\n" );
		break;
	case 5:
		// ϥեξμ˼
		fprintf( stderr, "Failed to get input file status.\n" );
		break;
	case 6:
		// Ѵ˼Ԥ
		fprintf( stderr, "Failed to convert.\n" );
		break;
	case 7:
		// ɸϤǥ쥯ȥؤϽϤǤʤ
		fprintf( stderr, "Can't output to dir from stdin.\n" );
		break;
	case 8:
		// ǥ쥯ȥ꤫ɸϤեؤѴϤǤʤ
		fprintf( stderr, "Can't output file or stdout from dir.\n" );
		break;
	case 9:
		// ǥ쥯ȥκ˼
		fprintf( stderr, "Failed to create dir.\n" );
		break;
	default:
		fprintf( stderr, "Unexpected error.\n" );
	}
	return n;
}


// ɸϤϤ
int InputStdIn( const CCmdOpt &rOption, const CConverter &rConv )
{
	string wofname;
	CFileName OutFileName;
	VClsPtr< CFilePtr > ppOutFile;
	bool IsDir;

	wofname = rOption.GetValue( "-ofn", "" );

	if ( wofname.empty() )
		// ɸϤɤ߹ߡɸϤؽ񤭹
		return rConv.Convert( stdin, stdout ) ? 0 : 6;

	OutFileName.Set( wofname.c_str() );
	if ( OutFileName.GetStatus( NULL, &IsDir, NULL ) ) {
		// ɸϤǥ쥯ȥؤѴǤʤ
		if ( IsDir ) return 7;
	}

	ppOutFile = new CFilePtr( wofname.c_str(), "wb" );
	if ( ppOutFile.IsNull() || (*ppOutFile).IsNull() )
		return 4; // ե뤬ʤ

	// ɸϤɤ߹ߡե˽Ϥ
	return rConv.Convert( stdin, (*ppOutFile) ) ? 0 : 6;
}

// ե뤫Ѵ
int InputFile( const CCmdOpt &rOption, const CConverter &rConv )
{
	string wifname;
	string wofname;
	CFileName OutFileName;
	bool IsDir;

	// ϥե̾
	wifname = rOption.GetValue( "-ifn", "" );

	// ϥե̾
	wofname = rOption.GetValue( "-ofn", "" );
	if ( wofname.empty() ) {
		if ( !rOption.IsExist( "-o" ) ) {
			// ϥե̾-oꤵƤʤСɸϤؽ񤭽Ф
			VClsPtr< CFilePtr > ppInFile = new CFilePtr( wifname.c_str(), "rb" );
			if ( ppInFile.IsNull() || (*ppInFile).IsNull() )
				return 3;
			return rConv.Convert( (*ppInFile), stdout ) ? 0 : 6;
		}
		else {
			// -oꤵƤϡϥե˾񤭤
			wofname = wifname;
		}
	}
	else {
		OutFileName.Set( wofname.c_str() );
		if ( OutFileName.GetStatus( NULL, &IsDir, NULL ) ) {
			if ( IsDir ) {
				// ǥ쥯ȥ꤬ꤵ줿ϡꤵ줿ǥ쥯ȥ
				// ϥեƱ̾Υե
				vector< string > wv = CFileName( wifname.c_str() ).Divide();
				wofname = OutFileName.GetSafeDirName() + wv[ wv.size() -1 ];
			}
		}
	}

	// Ѵ
	return ConvertFileToFile( wifname, wofname, rConv );
}

// ǥ쥯ȥѴ
int InputDir( const CCmdOpt &rOption, const CConverter &rConv )
{
	CFileName OutFileName;
	string woutfile;
	string winfile;
	bool IsDir;
	set< unsigned long > setINode;	// եIΡֹݻ

	woutfile = rOption.GetValue( "-ofn", "" );
	winfile = rOption.GetValue( "-ifn", "" );

	// -o-ofnꤵƤʤХ顼
	if ( !rOption.IsExist( "-o" ) && woutfile.empty() )
		return 8;

	// -ofn˥ե̾ꤵ줿ϥ顼
	if ( !woutfile.empty() ) {
		bool OptFNameIsDir;
		OutFileName.Set( woutfile.c_str() );
		OutFileName.GetStatus( NULL, &OptFNameIsDir, NULL );
		if ( !OptFNameIsDir ) return 8;
	}
	else {
		// Ȥơϥǥ쥯ȥѤ
		woutfile = winfile;
	}

	// Ѵ
	return ConvertDir( winfile, woutfile, rConv, rOption.IsExist( "-r" ), &setINode );
}

// ǥ쥯ȥѴԤ
int ConvertDir( string InDir, string OutDir, const CConverter &rConv, bool Recursive, set< unsigned long > *pSetINode )
{
	CFileName InDirNameObj;
	CFileName OutDirNameObj;
	CFileName OutFNameObj;
	CFileName SubFNameObj;
	string wsInFName;
	string wsOutFName;
	vector< string > wvSubFile;
	bool IsDir;
	unsigned long INodeNum;
	int i;
	int r;

	InDirNameObj.Set( InDir.c_str() );
	OutDirNameObj.Set( OutDir.c_str() );

	// ϥǥ쥯ȥˤե롦ǥ쥯ȥ
	wvSubFile = InDirNameObj.ListDir();
	for ( i = 0; i < wvSubFile.size(); i++ ) {
		// оݤΥե̾
		wsInFName = InDirNameObj.GetSafeDirName() + wvSubFile[i];
		wsOutFName = OutDirNameObj.GetSafeDirName() + wvSubFile[i];

		// ꤵ줿֥Ȥե뤫ǥ쥯ȥ꤫ȽǤ
		SubFNameObj.Set( wsInFName.c_str() );
		if ( !SubFNameObj.GetStatus( NULL, &IsDir, &INodeNum ) ) continue;

		// iΡֹ椫顢ѤߤݤȽǤ
		set< unsigned long >::const_iterator itr = pSetINode->find( INodeNum );
		if ( itr != pSetINode->end() ) continue;
		pSetINode->insert( INodeNum );

		if ( IsDir ) {
			if ( Recursive ) {
				// ǥ쥯ȥξǡ֥ǥ쥯ȥ
				// ŪΥǥ쥯ȥ
				if ( !CreateDir( wsOutFName ) ) return 9;
				// ƵŪѴ
				r = ConvertDir( wsInFName, wsOutFName, rConv, Recursive, pSetINode );
				if ( r != 0 ) return r;
			}
		}
		else {
			// оݤեǤä
			r = ConvertFileToFile( wsInFName, wsOutFName, rConv );
			if ( r != 0 ) return r;
		}
	}
	return 0;
}

// ǥ쥯ȥ
bool CreateDir( string dir )
{
	bool IsDir;
	CFileName wFileName;

	wFileName.Set( dir.c_str() );
	if ( wFileName.GetStatus( NULL, &IsDir, NULL ) ) {
		// Ʊ̾Υǥ쥯ȥ꤬Ǥ¸ߤϡ֤ƽλ
		if ( IsDir ) return true;
		// Ʊ̾Υե뤬¸ߤϥ顼
		return false;
	}
	// ǥ쥯ȥ
	if ( mkdir( dir.c_str(), S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH ) )
		return false;
	else
		return true;
}

// ꤵ줿ե֤ѴԤ
int ConvertFileToFile( const string &rIn, const string &rOut, const CConverter &rConv )
{
	string wstr;
	VClsPtr< CFilePtr > ppInFile;
	VClsPtr< CFilePtr > ppOutFile;
	CFileName InFileName;
	CFileName OutFileName;
	unsigned long InINode, OutINode;
	bool InIsDir, OutIsDir;

	// оݤΥեiΡɤӤ

	InFileName.Set( rIn.c_str() );
	OutFileName.Set( rOut.c_str() );

	if ( !InFileName.GetStatus( NULL, &InIsDir, &InINode ) )
		return 3;	// ϥեξ֤Ǥʤ
	if ( InIsDir )
		return 3;	// ϥեȤƥǥ쥯ȥ꤬ꤵ줿

	if ( OutFileName.GetStatus( NULL, &OutIsDir, &OutINode ) ) {
		if ( OutIsDir ) return 4;	// Ϥ˥ǥ쥯ȥ꤬ꤵ줿
		if ( OutINode == InINode ) {
			// ϤΥե뤬Ʊ

			VClsPtr< CFilePtr > ppTempFile;
			char Buf[4096];
			int len;

			// ϥե򳫤
			ppInFile = new CFilePtr( rIn.c_str(), "rb" );
			if ( ppInFile.IsNull() || (*ppInFile).IsNull() ) return 3;

			// ƥݥΥե򳫤
			ppTempFile = new CFilePtr();
			if ( ppTempFile.IsNull() ) return 4;
			if ( !(*ppTempFile).OpenTmp() ) return 4;

			// ϥեƥݥΥեؽϤ
			while ( !feof( (*ppInFile) ) && !ferror( (*ppInFile) ) ) {
				len = fread( Buf, sizeof( char ), 4096, (*ppInFile) );
				fwrite( Buf, sizeof( char ), len, (*ppTempFile) );
			}
			ppInFile = NULL;
			fseek( (*ppTempFile), 0, SEEK_SET );

			// ƥݥΥե뤫ѴԤϥեؽϤ

			// ϥե򳫤
			ppOutFile = new CFilePtr( rOut.c_str(), "wb" );
			if ( ppOutFile.IsNull() || (*ppOutFile).IsNull() )
				return 4;

			// Ѵ
			return rConv.Convert( (*ppTempFile), (*ppOutFile) ) ? 0 : 6;
		}
	}
	// ϤΥե뤬ۤʤ

	// ϥե򳫤
	ppInFile = new CFilePtr( rIn.c_str(), "rb" );
	if ( ppInFile.IsNull() || (*ppInFile).IsNull() )
		return 3;

	// ϥե򳫤
	ppOutFile = new CFilePtr( rOut.c_str(), "wb" );
	if ( ppOutFile.IsNull() || (*ppOutFile).IsNull() )
		return 4;

	// Ѵ
	return rConv.Convert( (*ppInFile), (*ppOutFile) ) ? 0 : 6;
}
