/*/////////////////////////////////////////////////////////////////////////////
// confman ϥ饤֥
// confman.cc confman󥿥եؿμ
*/

/* إåե */
#include "confman.h"
#include "ConfImp.h"
#include <limits.h>
#include <string>
#include <wchar.h>
#include <widec.h>
#include <assert.h>
using namespace std;

/* ޥ */
#define IMP( p ) ( (CConfImp*)( p->pConf ) )
#define SMB( p ) ( (map<wstring,ULONG>*)( p->smb ) )

/* CONFMAN */
CONFMAN confman_CreateConf( const char *FileName )
{
	CONFMAN p;

	assert( FileName );

	/* ¤Τΰ */
	p = (CONFMAN)malloc( sizeof( tagConf ) );
	if ( p == NULL ) return NULL;

	/* 饹 */
	p->pConf = (void*)new CConfImp();
	if ( p->pConf == NULL ){
		free( p );		/* 饹ιۤ˼Ԥ */
		return NULL;	/* ΰNULL֤ */
	}

	/* ե̾Ͽ */
	IMP(p)->ConfImp_SetFileName( FileName );

	p->smb = NULL;	/* ȤʤNULLǼ */
	return p;
}

/* ɤ߹߻ؼ */
CF_BOOL confman_Open( CONFMAN p )
{
	assert( p && IMP( p ) );
	return IMP(p)->ConfImp_Open();
}


/*  */

CF_BOOL confman_GetString(	CONFMAN p,
				const wchar_t *SectionName,
				const wchar_t *KeyName,
				wchar_t *buf,
				int length )
{
	assert( p  && IMP( p ) && SectionName && KeyName && buf );
	return IMP( p )->ConfImp_GetString( SectionName, KeyName, buf, length );
}

/*  */

CF_BOOL confman_SetString(	CONFMAN p,
				const wchar_t *SectionName,
				const wchar_t *KeyName,
				const wchar_t *value )
{
	assert( p && IMP( p ) && SectionName && KeyName && value );
	return IMP( p )->ConfImp_SetString( SectionName, KeyName, value );
}

/* ͤϿ */
CF_API CF_BOOL confman_SetInteger( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName, int value )
{
	wchar_t buf[20];
	assert( p && IMP( p ) && SectionName && KeyName && value );
	swprintf( buf, 20, L"%d", value );
	return IMP( p )->ConfImp_SetString( SectionName, KeyName, buf );
}

/* եĤ */
/* ѹƤϥե¸CONFMAN˴ */
CF_BOOL confman_Close( CONFMAN p )
{
	assert( p && IMP( p ) );

	/* ¸ */
	if ( !confman_Save( p ) ) return CF_FALSE;

	/* ˴ */
	confman_Delete( p );
	return CF_TRUE;
}

/* ե¸ */
CF_API CF_BOOL confman_Save( CONFMAN p )
{
	assert( p && IMP( p ) );
	return IMP( p )->ConfImp_Close( );
}

/* ˴ */
CF_API void confman_Delete( CONFMAN p )
{
	if ( NULL == p ) return ;

	if ( IMP(p) ) {
		delete IMP(p);
		p->pConf = NULL;
	}
	if ( SMB(p) ) {
		delete SMB(p);
		p->smb = NULL;
	}
	free( p );
	return ;
}

// ե饰
CF_BOOL confman_GetModify( CONFMAN p )
{
	assert( p && IMP( p ) );
	return IMP( p )->ConfImp_GetModifyFlag();
}

// ե饰ѹ
void confman_SetModify( CONFMAN p, CF_BOOL b )
{
	assert( p && IMP( p ) );
	IMP( p )->ConfImp_SetModifyFlag( b );
}

// ̾ꥹȤ
CF_BOOL confman_GetSectionList( CONFMAN p, wchar_t *buf, int Length )
{
	wstring w;
	CF_BOOL r;

	assert( p && IMP( p ) && buf && Length > 0 );

	r = IMP( p )->ConfImp_GetSectionList( w, Length );
	memcpy( buf, w.c_str(), w.size() * sizeof( wchar_t ) );
	buf[Length-1] = L'\0';	// ǡʤɬǸˤNULLĤ
	return r;
}

/* ̾ΥꥹȤ */
CF_BOOL confman_GetKeyList( CONFMAN p, const wchar_t *SectionName, wchar_t *buf, int Length )
{
	wstring w;
	CF_BOOL r;

	assert( p && IMP( p ) && SectionName && buf && Length > 0 );

	r = IMP( p )->ConfImp_GetKeyList( SectionName, w, Length );
	memcpy( buf, w.c_str(), w.size() * sizeof( wchar_t ) );
	buf[Length-1] = L'\0';	// ǡʤɬǸˤNULLĤ
	return r;
}


/* ɲ */
CF_BOOL confman_AddSection( CONFMAN p, const wchar_t *SectionName )
{
	assert( p && IMP( p ) && SectionName );
	return IMP( p )->ConfImp_AddSection( SectionName );
}

/* ɲ */
CF_BOOL confman_AddKeyString( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName, const wchar_t *Value )
{
	assert( p && IMP( p ) && SectionName && KeyName && Value );
	return IMP( p )->ConfImp_AddKey( SectionName, KeyName, Value );
}

/* ɲ */
CF_API CF_BOOL confman_AddKeyInteger( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName, int Value )
{
	wchar_t buf[20];
	assert( p && IMP( p ) && SectionName && KeyName );
	swprintf( buf, 20, L"%d", Value );
	return IMP( p )->ConfImp_AddKey( SectionName, KeyName, buf );
}

/*  */
CF_BOOL confman_RemoveSection( CONFMAN p, const wchar_t *SectionName )
{
	assert( p && IMP( p ) && SectionName );
	return IMP( p )->ConfImp_RemoveSection( SectionName );
}


/* κ */
CF_BOOL confman_RemoveKey( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName )
{
	assert( p && IMP( p ) && SectionName && KeyName );
	return IMP( p )->ConfImp_RemoveKey( SectionName, KeyName );
}


/* 顼ͤμ */
unsigned long confman_GetLastError( CONFMAN p )
{
	assert( p && IMP( p ) );
	return IMP( p )->ConfImp_GetLastError();
}

/* 顼ͤΥꥢ */
void confman_ClearLastError( CONFMAN p )
{
	assert( p && IMP( p ) );
	IMP( p )->ConfImp_ClearLastError();
}

/* ĥǽ */
/* ܥɲ */
CF_BOOL exconf_AddSymbol( CONFMAN p, const wchar_t *symbol, ULONG val )
{
	assert( p && symbol );

	/* ޤȤƤʤΰ */
	if ( p->smb == NULL ){
		p->smb = (void*)new map<wstring, ULONG>;
		/* ΰݤ˼Ԥ鵶֤ */
		if ( p->smb == NULL )
			return CF_FALSE;
	}

	/* ܥͤϿ */
	SMB(p)->insert( pair<wstring, ULONG>( (wstring)symbol, val ) );
	return CF_TRUE;
}

/* бʸ󤫤饷ܥͤ */
ULONG exconf_GetSymbol( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName )
{
	wstring w;

	assert( p && IMP(p) && SectionName && KeyName );

	if ( SMB(p) == NULL ){
		// ܥ뵡ǽ̤
		IMP(p)->ConfImp_SetError(ECF_UNUSESYMBOL);
		return ULONG_MAX;
	}

	/* 򸡺 */
	if ( IMP(p)->ConfImp_GetSTLString( SectionName, KeyName, w ) == CF_FALSE )
		return ULONG_MAX;	/* Ĥʤ */

	/* б륷ܥ֤ͤ */
	return exconf_StrToVal( p, w.c_str() );
}

/* ܥǡ */
void exconf_ReleaseSymbol( CONFMAN p )
{
	assert( p );
	if ( SMB(p) != NULL ){
		delete SMB(p);
		p->smb = NULL;
	}
}

/* ʸ󤫤饷ܥͤ */
ULONG exconf_StrToVal( CONFMAN p, const wchar_t *Symbol )
{
	map<wstring,ULONG>::iterator i;

	assert( p && SMB(p) && Symbol );

	/* ܥ򸡺 */
	i = SMB(p)->find( (wstring)Symbol );
	if ( i == SMB(p)->end() ){
		// ܥ̾Ĥʤ
		IMP(p)->ConfImp_SetError(ECF_NOSYMBOL);
		return ULONG_MAX;
	}
	return i->second;
}

/* ͤǼ */
CF_BOOL exconf_GetInt( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName, int *c )
{
	wstring w;
	assert( p && IMP(p) && SectionName && KeyName && c );
	if ( !IMP(p)->ConfImp_GetSTLString( SectionName, KeyName, w ) )
		return CF_FALSE;
	(*c) = watoi( w.c_str() );
	return CF_TRUE;
}

/* ̾ꥹȤ */
void* exconf_CreateInternalSectionList( CONFMAN p, int *Length )
{
	wstring *s;

	assert( p && IMP(p) && Length );

	s = new wstring;
	if ( s == NULL ) return NULL;	// stringιۤ˼

	if ( !IMP( p )->ConfImp_GetSectionList( *s, -1 ) ){	// ꥹȤ
		delete s;		// 
		return NULL;
	}

	(*Length) = s->size();	// Ǽ
	return (void*)s;		// ɥ쥹֤
}

/* ̾ꥹȤ */
void* exconf_CreateInternalKeyList( CONFMAN p, const wchar_t *SectionName, int *Length )
{
	wstring *s;

	assert( p && IMP(p) && SectionName && Length );

	s = new wstring;
	if ( s == NULL ) return NULL;	// stringιۤ˼

	if ( !IMP( p )->ConfImp_GetKeyList( SectionName, *s, -1 ) ){	// ꥹȤ
		delete s;		// 
		return NULL;
	}

	(*Length) = s->size();	// Ǽ
	return (void*)s;		// ɥ쥹֤
}

/* ꥹȤ */
void exconf_GetInternalList( void *h, wchar_t *buf, int Length )
{
	wstring *p = NULL;
	int l = 0;

	// hNULLʤв⤷ʤ
	if ( NULL == h ) return ;

	p = ((wstring*)h);			// 㥹Ȥ
	l = Length < p->size() ? Length : p->size();	// ۤ

	// bufNULLξϡͤμϹԤʤ
	if ( buf ) {
		memcpy( buf, p->c_str(), l * sizeof( wchar_t ) );	// Хåե˳Ǽ
		buf[l-1] = L'\0';					// Ǹ夬NULLĤˤʤ뤳Ȥݾ
		buf[l-2] = L'\0';
	}

	delete p;							// stringϤǳ
}

/* ݻƤͤΥɥ쥹 */
const wchar_t* exconf_GetConstStr( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName )
{
	assert( p && IMP(p) && SectionName && KeyName );
	return IMP( p )->ConfImp_GetConstStr( SectionName, KeyName );
}

