/*/////////////////////////////////////////////////////////////////////////////
// confman ϥ饤֥
// ConfImp.h CConfImp饹
*/

#include <errno.h>
#include <assert.h>
#include "ConfImp.h"

///////////////////////////////////////////////////////////////////////////////
// ۡ˴

CConfImp::CConfImp( )
{
	mapConfig.clear();		// Ȥꤢ
	strFileName = "";
	ModifyFlag = CF_FALSE;		// ѹե饰ν
	LastError = CF_NOERROR;		// 顼ֹν
}

CConfImp::~CConfImp( )
{

}

///////////////////////////////////////////////////////////////////////////////
// 󥿥եδؿ

// ե̾¸
void CConfImp::ConfImp_SetFileName( const char *FileName )
{
	assert( this && FileName );
	strFileName = FileName;
}

// եɤ
CF_BOOL CConfImp::ConfImp_Open()
{
	FILE *in_file = NULL;	// ϥե
	CF_BOOL r;	// 
	SEC_TYPE::iterator p_sec;
	CONF_TYPE::iterator p_conf;

	assert( this );

	// ե̾ꤵƤʤϥ顼
	if ( strFileName.empty() ) {
		LastError = CF_FILENAMEISEMPTY;
		return CF_FALSE;
	}

	// ե򳫤
	in_file = fopen( strFileName.c_str(), "r" );
	if ( NULL == in_file ){
		// ե뤬ʤХ顼λ
		LastError = CF_CANTOPENFILE;
		return CF_FALSE;
	}

	// եɤ
	r = ReadFile( in_file );

	// եĤ
	if ( fclose( in_file ) ) {
		LastError = CF_CANTCLOSEFILE;
		r = CF_FALSE;	// ˼Ԥˤ⵶֤
	}

	return r;				// ̤֤
}

// ʸ
CF_BOOL CConfImp::ConfImp_GetString( const wchar_t *SectionName, const wchar_t *KeyName, wchar_t *buf, int length )
{
	SEC_ITR p;	// ȿ

	assert( this && SectionName && KeyName && buf && length > 0 );

	if ( !FindKey( SectionName, KeyName, &p ) )	// 
		return CF_FALSE;			// Ĥʤе֤

	// Ĥäʸ򥳥ԡ
	wcsncpy( buf, p->second.c_str(), length - 1 );
	buf[ length - 1 ] = '\0';		// ǸNULLդ뤳Ȥݾڤ
	return CF_TRUE;				// ֤

}

// ʸꤹ
CF_BOOL CConfImp::ConfImp_SetString( const wchar_t *SectionName, const wchar_t *KeyName, const wchar_t *value )
{
	SEC_ITR p;	// ȿ

	assert( this && SectionName && KeyName && value );

	if ( !FindKey( SectionName, KeyName, &p ) )	// 
		return CF_FALSE;			// Ĥʤе֤

	p->second = value;	// ʸ򵭲
	ModifyFlag = CF_TRUE;	// ե饰ΩƤ
	return CF_TRUE;		// ֤

}

// Ĥ
CF_BOOL CConfImp::ConfImp_Close()
{
	assert( this );

	// ƤʤС⤻˿֤ƽλ
	if ( !ModifyFlag ) return CF_TRUE;

	// ե˽Ϥ
	return WriteFile();
}

// ե饰
CF_BOOL CConfImp::ConfImp_GetModifyFlag( void )
{
	assert( this );
	return ModifyFlag;
}

// ե饰ꤹ
void CConfImp::ConfImp_SetModifyFlag( CF_BOOL b )
{
	assert( this );
	ModifyFlag = b;
}

// ̾ΥꥹȤ
CF_BOOL CConfImp::ConfImp_GetSectionList( wstring &s, int Length )
{
	assert( this && ( Length == -1 || Length >= 1 ) );
	return MakeList( mapConfig.begin(), mapConfig.end(), s, Length );
}

// δؿƱͥΥꥹȤ֤
CF_BOOL CConfImp::ConfImp_GetKeyList( const wchar_t *SectionName, wstring &s, int Length )
{
	CONF_ITR conf_p;

	assert( this && SectionName && ( Length == -1 || Length >= 1 ) );

	// 򸡺
	conf_p = mapConfig.find( (wstring)SectionName );

	if ( conf_p == mapConfig.end() ){
		// 󤬸Ĥʤ
		LastError = CF_NOSECTION;
		return CF_FALSE;
	}

	// ꥹȤۤ
	return MakeList( conf_p->second.begin(), conf_p->second.end(), s, Length );
}

// ɲ
CF_BOOL CConfImp::ConfImp_AddSection( const wchar_t *SectionName )
{
	SEC_TYPE w;
	CONF_ITR conf_p;

	assert( this && SectionName );

	w.clear();	// Υ
	conf_p = mapConfig.find( (wstring)SectionName );	// 
	if ( conf_p != mapConfig.end() ){
		// ĤäɲäǤʤ
		LastError = CF_FINDSECTION;
		return CF_FALSE;
	}

	// Ĥʤɲä
	mapConfig.insert( pair< wstring, SEC_TYPE >( (wstring)SectionName, w ) );
	ModifyFlag = CF_TRUE;			// ե饰ΩƤ
	return CF_TRUE;

}

// ɲ
CF_BOOL CConfImp::ConfImp_AddKey( const wchar_t *SectionName, const wchar_t *KeyName, const wchar_t *Value )
{
	SEC_ITR sec_p;	// ȿ
	CONF_ITR conf_p;

	assert( this && SectionName && KeyName && Value );

	conf_p = mapConfig.find( (wstring)SectionName );	// 򸡺
	if ( conf_p == mapConfig.end() ){
		LastError = CF_NOSECTION;
		return CF_FALSE;		// 󤬤ʤХ顼
	}

	sec_p = ( conf_p->second ).find( (wstring)KeyName );	// Ǹ
	if ( sec_p != ( conf_p->second ).end() ){
		LastError = CF_FINDKEY;
		return CF_FALSE;		// Х顼
	}

	// 󤬤ꡢʤʤɲ
	(conf_p->second).insert( pair< wstring, wstring >( (wstring)KeyName, (wstring)Value ) );
	ModifyFlag = CF_TRUE;			// ե饰ΩƤ
	return CF_TRUE;
}

// 
CF_BOOL CConfImp::ConfImp_RemoveSection( const wchar_t *SectionName )
{
	CONF_ITR conf_p;

	assert( this && SectionName );

	conf_p = mapConfig.find( (wstring)SectionName );	// 
	if ( conf_p == mapConfig.end() ){
		LastError = CF_NOSECTION;
		return CF_FALSE;		// ˤʤе֤
	}

	mapConfig.erase( conf_p );	// 
	ModifyFlag = CF_TRUE;		// ե饰ΩƤ

	return CF_TRUE;
}

// 
CF_BOOL CConfImp::ConfImp_RemoveKey( const wchar_t *SectionName, const wchar_t *KeyName )
{
	CONF_ITR conf_p;
	SEC_ITR sec_p;

	assert( this && SectionName && KeyName );

	conf_p = mapConfig.find( (wstring)SectionName );	// 򸡺
	if ( conf_p == mapConfig.end() ){		// ʤе֤
		LastError = CF_NOSECTION;
		return CF_FALSE;
	}

	sec_p = ( conf_p->second ).find( (wstring)KeyName );	// Ǹ
	if ( sec_p == ( conf_p->second ).end() ){
		LastError = CF_NOKEY;
		return CF_FALSE;			// ̵е֤
	}

	(conf_p->second).erase( sec_p );	// 
	ModifyFlag = CF_TRUE;			// ե饰ΩƤ

	return CF_TRUE;	
}

// ǸΥ顼
unsigned long CConfImp::ConfImp_GetLastError()
{
	assert( this );
	return LastError;
}

// 顼ͤΥꥢ
void CConfImp::ConfImp_ClearLastError()
{
	assert( this );
	LastError = CF_NOERROR;
}

// ͤstringǼ
CF_BOOL CConfImp::ConfImp_GetSTLString( const wchar_t *SectionName, const wchar_t *KeyName, wstring &str )
{
	SEC_ITR p;

	assert( this && SectionName && KeyName );

	// ͤ򸡺	
	if ( FindKey( SectionName, KeyName, &p ) ){
		// ĤС֤ͤƽλ
		str = p->second;
		return CF_TRUE;
	}
	return CF_FALSE;
}

// 顼ͤ
void CConfImp::ConfImp_SetError( unsigned long e )
{
	assert( this );
	LastError = e;
}

// ̾̾бͤʸؤΥݥ󥿤
const wchar_t* CConfImp::ConfImp_GetConstStr( const wchar_t *SectionName, const wchar_t *KeyName )
{
	SEC_ITR p;	// ȿ

	assert( this && SectionName && KeyName );

	if ( !FindKey( SectionName, KeyName, &p ) )	// 
		return NULL;
	return p->second.c_str();	// ֤ͤ
}

///////////////////////////////////////////////////////////////////////////////
// ؿ
// եɹ

CF_BOOL CConfImp::ReadFile( FILE *in_file )
{
	SEC_TYPE w_sec;
	wstring w_secname;
	tagCFChar ch;
	int stat = 1;

	assert( this && in_file );

	// 
	do {
		ch = GetChar( in_file );
	} while( ch.type != CFCT_LS && !feof( in_file ) );

	// ֤Τޤޥե뽪üãϥ顼
	if ( feof( in_file ) ){
		LastError = CF_CANTFINDSECTION;
		return CF_FALSE;
	}
	// Ǿ̾װ
	while( stat > 0 ){
		switch( stat ){
		case 1:	// ̾ɤ߹
			stat = ReadSectionName( in_file, &w_secname );
			break;
		case 2:	// Ƥɤ߹
			stat = CreateSection( in_file, &w_sec );
			mapConfig.insert( pair<wstring, SEC_TYPE >( w_secname, w_sec ) );
			break;
		}
	}
	if ( stat == -1 ) // 餫̿Ū顼ȯ
		return CF_FALSE;

	return CF_TRUE;
}

// ̾ɤ߹
int CConfImp::ReadSectionName( FILE *in_file, wstring *name )
{
	tagCFChar ch;

	assert( this && in_file && name );

	// ʸν
	name->erase( name->begin(), name->end() );

	// ʸ
	ch = GetChar( in_file );
	while( !feof( in_file ) && ch.type != CFCT_RETURN && ch.type != CFCT_RS ){
		(*name) += ch.c;
		ch = GetChar( in_file );
	}

	// Ĥ̤Ǥʤϥ顼
	if ( ch.type != CFCT_RS ){
		LastError = CF_SECTIONNAMEERROR;
		return -1;
	}
	// ̾ϥۤ
	return 2;
}

// ۾Ѱ
int CConfImp::CreateSection( FILE *in_file, SEC_TYPE *sec )
{
	tagCFChar ch;
	int CS_stat = 1;	// Υ٥Ǥξ
	int EXIT_stat = 0;	// ͡ʾ̥٥Ǥμξ֡
				// ｪλͤȤ

	assert( this && in_file && sec );

	sec->clear();	// 
	while( CS_stat > 0 ){
		switch( CS_stat ){
		case 1:	// å
			CS_stat = LineEndSkip( in_file );
			break;
		case 2:	// Ƭå
			CS_stat = LineHeadSkip( in_file, &ch, &EXIT_stat );
			break;
		case 3:	// ͼ
			CS_stat = ReadKeyVal( in_file, ch, sec );
			break;
		}
	}
	return EXIT_stat;
}

// å
int CConfImp::LineEndSkip( FILE *in_file )
{
	tagCFChar ch;

	assert( this && in_file );

	do {
		ch = GetChar( in_file );
	} while( !feof( in_file ) && ch.type != CFCT_RETURN );
	// ԤʤйƬåפ
	if ( ch.type == CFCT_RETURN ) return 2;
	// ե뽪üʤｪλ
	return 0;
}

// Ƭå
int CConfImp::LineHeadSkip( FILE *in_file, tagCFChar *ch, int *EXIT_stat )
{
	assert( this && in_file && ch && EXIT_stat );

	do {
		(*ch) = GetChar( in_file );
	} while( !feof( in_file ) && ch->type != CFCT_COMMENT && ch->type != CFCT_LS && 
		( ch->type == CFCT_SPACE || ch->type == CFCT_TAB ) );

	// ե뽪üʤｪλ
	if ( feof( in_file ) ) return 0;

	switch( ch->type ){
	case CFCT_COMMENT:
		return 1;	// åפ
	case CFCT_LS:
		(*EXIT_stat) = 1;	// ̾
		return 0;
	default :		// ѻˤĤͼ
		return 3;
	}
}

// ͼ
int CConfImp::ReadKeyVal( FILE *in_file, tagCFChar ch, SEC_TYPE *sec )
{
	// chϹƬåפϤǽΰʸ
	tagCFChar ws = ch;
	wstring strKey;
	wstring strVal;

	assert( this && in_file && sec );

	strKey.erase( strKey.begin(), strKey.end() );	// ǥǤ
	strVal.erase( strVal.begin(), strVal.end() );	// ͡Ǥ

	// 
	while( ws.type != CFCT_EQUAL && ws.type != CFCT_RETURN && 
		ws.type != CFCT_SPACE && ws.type != CFCT_TAB && !feof( in_file ) ){
		strKey += ws.c;
		ws = GetChar( in_file );
	}

	// ԡե뽪üʤй˴
	if ( feof( in_file ) || ws.type == CFCT_RETURN ) goto BREAK_LINE;

	// ֥åסʥ򥤥ȴʤˤ⤷ʤ
	while ( !feof( in_file ) && ( ws.type == CFCT_SPACE || ws.type == CFCT_TAB ) ) {	// 򥹥å
		ws = GetChar( in_file );
	}
	// ʳʤй˴
	if ( ws.type != CFCT_EQUAL || feof( in_file ) ){
		if ( ws.type == CFCT_COMMENT ) ws.type = CFCT_ERR; // ǤΥߥϥ顼
		goto BREAK_LINE;
	}

	// 롦ʹ֥å
	do {
		ws = GetChar( in_file );
	} while ( ( ws.type == CFCT_SPACE || ws.type == CFCT_TAB ) && !feof( in_file ) );	// 򥹥å
	// ե뽪üԤʤй˴
	if ( feof( in_file ) || ws.type == CFCT_RETURN ) goto BREAK_LINE;

	// ͡ɤ߹ߡʥ롦ʹ֥åפɤǸΰʸstrVal˲ä
	do {
		strVal += ws.c;
		ws = GetChar( in_file );
	} while ( !feof( in_file ) && ws.type != CFCT_RETURN && ws.type != CFCT_COMMENT );

	// ͤ򥻥å
	sec->insert( pair< wstring, wstring >( strKey, strVal ) );

	// ξ֤װܤ
	switch( ws.type ){
		case CFCT_ELSE : return 0;
		case CFCT_RETURN : return 2;
		default : return 1;
	}

BREAK_LINE:	// Ԥ˴줿ν
	switch( ws.type ){
	case CFCT_ELSE :
		LastError = CF_BREAKLINE_EOF;
		return 0;	// ｪλ
	case CFCT_RETURN:
		LastError = CF_BREAKLINE_RTN;
		return 2;	// Ƭåפ
	case CFCT_COMMENT :	// ߥξϥ顼ǤϤʤ
		return 1;	// åפ
	default :
		LastError = CF_BREAKLINE_ETC;
		return 1;	// åפ
	}
}

///////////////////////////////////////////////////////////////////////////////
// ¾롼

// ̾ȥǸ
CF_BOOL CConfImp::FindKey( const wchar_t *SectionName, const wchar_t *KeyName, SEC_ITR *p )
{
	assert( this && SectionName && KeyName && p );

	// Ǽmap򸡺
	CONF_ITR conf_p = mapConfig.find( (wstring)SectionName );
	if ( conf_p == mapConfig.end() ){
		// 󤬸Ĥʤ
		LastError = CF_NOSECTION;
		return CF_FALSE;
	}

	// 󤬸ĤХǸ
	(*p) = ( conf_p->second ).find( (wstring)KeyName );
	if ( (*p) == ( conf_p->second ).end() ){
		// Ĥʤ
		LastError = CF_NOKEY;
		return CF_FALSE;
	}

	return CF_TRUE;				// Ĥä
}

// եإեå夹
CF_BOOL CConfImp::WriteFile( void )
{
	FILE *out_file = NULL;
	CONF_ITR p_conf;
	SEC_ITR p_sec;
	wstring w_str;
	const wstring EN_LK( L"\n[" );
	const wstring EN_RK( L"]\n" );

	assert( this );

	if ( strFileName.empty() ) {
		// ե̾ꤵƤʤХ顼
		LastError = CF_FILENAMEISEMPTY;
		return CF_FALSE;
	}		

	// ե򥪡ץ
	out_file = fopen( strFileName.c_str(), "w" );
	if ( out_file == NULL ){
		LastError = CF_CANTOPENFILE;
		return CF_FALSE;	// ե륪ץ˼Ԥ
	}

	for( p_conf = mapConfig.begin(); p_conf != mapConfig.end(); p_conf++ ){

		// ̾νʸ
		w_str = EN_LK + p_conf->first + EN_RK;

		// ʸϡ顼ξ
		if ( !WriteLine( out_file, &w_str ) ) goto ERR_EXIT;

		// Υͤ
		for ( p_sec = p_conf->second.begin(); p_sec != p_conf->second.end(); p_sec++ ){

			// ͤʸ
			w_str = L" ";
			w_str += p_sec->first;
			w_str += L" = ";
			w_str += p_sec->second;
			w_str += L"\n";

			// 
			if ( !WriteLine( out_file, &w_str ) ) goto ERR_EXIT;
		}
	}

	if ( fclose( out_file ) ) {
		LastError = CF_CANTCLOSEFILE;
		return CF_FALSE;
	}

	return CF_TRUE;

ERR_EXIT:
	if ( fclose( out_file ) )
		LastError = CF_CANTCLOSEFILE;
	out_file = NULL;
	return CF_FALSE;
}

// Ԥ
bool CConfImp::WriteLine( FILE *out_file, wstring *str )
{
	int length = 0;
	int i;

	assert( this && out_file && str );

	length = str->size();	// ʸĹ

	// ե˽Ϥ
	for ( i = 0; i < length && !ferror( out_file ) && !feof( out_file ); i++ )
		fputwc( (*str)[i], out_file );

	// ٤ƤʸϤ뤳ȤǤʤе֤
	return ( i >= length );
}

// ̾̾ΥꥹȤ
// ХåեNULLʸǶڤ줿󡦥̾ǼǸNULL
template <class TYPE>
CF_BOOL CConfImp::MakeList( TYPE s, TYPE e, wstring &buf, int Length )
{
	assert( this );

	buf.clear();

	while ( s != e ){			// ٤ƤǤ
		if ( Length != -1 && s->first.size() + buf.size() + 2 >= Length ){
			buf.insert( buf.end(), L'\0' );		// NULLʸɲä
			return CF_FALSE;	// ʸĹĶϵ֤λ
		}
		buf += s->first;		// ʸ򥳥ԡ
		buf.insert( buf.end(), L'\0' );		// NULLʸɲä
		s++;					// Ǥ
	}
	buf.insert( buf.end(), L'\0' );		// NULLʸɲä
	return CF_TRUE;				// ῿֤
}

// ̾Ρʸɤ߹
// ǽץ󥹤ᤷʸɤ߹
tagCFChar CConfImp::GetChar( FILE *infile )
{
	tagCFChar wt;

	assert( this && infile );

	wt.c = NULL;
	wt.type = CFCT_ERR;
	if ( feof( infile ) ) return wt;	// ɤʤϥ顼֤
	wt.c = fgetwc( infile );		// Ȥꤢʸ

	if ( wt.c != L'\\' ) {
		// \̵ϥץ󥹤ǤϤʤ
		// ʸбꤹ
		switch ( wt.c ) {
		case L';' :
			wt.type = CFCT_COMMENT;
			break;
		case L'\n' :
			wt.type = CFCT_RETURN;
			break;
		case L'=' :
			wt.type = CFCT_EQUAL;
			break;
		case L' ' :
			wt.type = CFCT_SPACE;
			break;
		case L'\t' :
			wt.type = CFCT_TAB;
			break;
		case L'[' :
			wt.type = CFCT_LS;
			break;
		case L']' :
			wt.type = CFCT_RS;
			break;
		case EOF :
			wt.type = CFCT_ERR;
			break;
		default :
			wt.type = CFCT_ELSE;
		}
	}
	else {
		// \äФϥץ󥹤ˤĤ
		// ʸɤ߹ߡȽǤ롣
		// ɤ߹ʤХ顼֤
		if ( feof( infile ) ) return wt;
		wt.c = fgetwc( infile );
		switch ( wt.c ) {
		case L';' :	// \;ʸȤƤ;
		case L'=' :	// \=ʸȤƤ=
		case L' ' :	// \ ʸȤƤΥڡ
		case L'\\' :	// \\\
		case L'[' :	// \[[
		case L']' :	// \]]
			wt.type = CFCT_ELSE;
			break;
		case L'n' :	// \nʸȤƤβԥ
			wt.type = CFCT_ELSE;
			wt.c = L'\n';
			break;
		case L'\n' :	// Ԥ\ϡιԤط³
			return GetChar( infile );	// ʸɤ֤
			break;
		case L't' :	// \tϥ
			wt.type = CFCT_ELSE;
			wt.c = L'\t';
			break;
		default :
			wt.type = CFCT_ERR;
		}
	}
	return wt;
}
