////////////////////////////////////////////////////////////////////////////
// TaEditSvr.cc
// ɮ
////////////////////////////////////////////////////////////////////////////

#include "Server_glo.h"

#include "Server.h"
#include "SyInstance.h"


int main( int argc, char *argv[] )
{
	CServer *pServer = NULL;
	CSyInstance *pInstanceMgr = NULL;
	struct stat wStat;
	int fd;
	int r = 1;

	// 
	setlocale( LC_ALL, "" );

	// οǧ
	if ( argc <= 2 ) {
		fprintf( stderr, "Syuhitu server.\n" );
		fprintf( stderr, "\t%s <File Name> <File Discripter>\n", argv[0] );
		return 1;
	}

	// ꤵ줿եǥץǧ
	fd = atoi( argv[2] );
	if ( fstat( fd, &wStat ) ) {
		fprintf( stderr, "ERROR Syuhitu server : File Discripter %d is not valid.\n", fd );
		return 1;
	}

	// ɮ󥹥󥹴֥Ȥ
	pInstanceMgr = new CSyInstance();
	if ( NULL == pInstanceMgr ) {
		fprintf( stderr, "ERROR Syuhitu server : Out of memory.\n" );
		goto ON_EXIT;
	}
	if ( !pInstanceMgr->Initialize() )
		goto ON_EXIT;

	// д֥Ȥ
	pServer = new CServer( pInstanceMgr );
	if ( NULL == pServer ) {
		fprintf( stderr, "ERROR Syuhitu server : Out of memory.\n" );
		goto ON_EXIT;
	}

	// н򳫻
	if ( !pServer->StartServer( argv[1], fd ) ) {
		// ۾ｪλϡưץˤλݤΤƤ
		write( fd, "err\n", 4 );
		goto ON_EXIT;
	}
	r = 0;

ON_EXIT:

	// д֥Ȥ˴
	delete pServer;
	pServer = NULL;

	// ɮ󥹥󥹴֥Ȥ˴
	delete pInstanceMgr;
	pInstanceMgr = NULL;

	return r;
}

