#include <locale.h>
#include <stdio.h>
#include "../syuhitu/PluginFuncID.h"
#include <malloc.h>
#include <wchar.h>
#include <stdlib.h>
#include <limits.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <assert.h>
#include <string.h>

// ѥ
static const char* GetSearchPath( PFT_GetAPIFunction GetAPIFunction, const wchar_t *pWorkMemoryName, const wchar_t *pConfigName )
{
	PFT_AllocWorkMemory AllocWorkMemory = (PFT_AllocWorkMemory)GetAPIFunction( PFID_ALLOCWORKMEMORY );
	PFT_FindWorkMemory FindWorkMemory = (PFT_FindWorkMemory)GetAPIFunction( PFID_FINDWORKMEMORY );
	PFT_GetConfigValue GetConfigValue = (PFT_GetConfigValue)GetAPIFunction( PFID_GETCONFIGVALUE );
	PFT_ShowErrorMsgBox ShowErrorMsgBox = (PFT_ShowErrorMsgBox)GetAPIFunction( PFID_SHOWERRORMSGBOX );
	PFT_FreeWorkMemory FreeWorkMemory = (PFT_FreeWorkMemory)GetAPIFunction( PFID_FREEWORKMEMORY );

	void *vp = NULL;
	const wchar_t *wp = NULL;
	char *cp = NULL;
	char *cp2;
	wchar_t *pBuf = NULL;
	wchar_t *pBuf2;
	size_t len;
	int i;

	// ¸Υǡ򸡺
	vp = FindWorkMemory( pWorkMemoryName, PFT_FALSE );
	if ( vp ) return (const char*)vp;

	// ¸ߤʤäϡ󤫤ͤ
	wp = GetConfigValue( pConfigName );
	if ( NULL == wp ){
		ShowErrorMsgBox( L"It fails to get configulation information." );
		return NULL;
	}

	// Ѥ˥ΰݤ
	len = wcslen( wp ) + 1;
	pBuf = (wchar_t*)malloc( sizeof( wchar_t ) * ( len + 1 ) );
	if ( NULL == pBuf ) return NULL;
	memcpy( pBuf, wp, len * sizeof( wchar_t ) );
	pBuf[len] = L'\0';	// pBufˤ\0ĳǼƤ

	// ޥХʸѴɬפȤʤХȿ
	len = wcstombs( NULL, wp, 0 ) + 10;
	if ( (size_t)-1 == len ) goto ERR_EXIT;

	// ΰݤ
	cp = (char*)AllocWorkMemory( len, pWorkMemoryName, PFT_FALSE );
	if ( NULL == cp ) goto ERR_EXIT;

	// ڤ국:\0ִʸ\0֤
	cp2 = cp;	// ѽ񤭹ݥ
	pBuf2 = pBuf;	// ɤ߹߸ݥ
	while ( (*pBuf2) != L'\0' && cp2 < cp + len ) {
		const wchar_t *hpBuf2 = pBuf2;		// pBuf2򤹤
		for (; (*pBuf2) != L':' && (*pBuf2); pBuf2++ );	// :򸡺
		if ( pBuf2 == hpBuf2 ) {
			// :³ϡ̵뤹
			pBuf2++;
		}
		else {
			(*pBuf2) = L'\0';
			cp2 += wcstombs( cp2, hpBuf2, len - ( cp2 - cp ) );
			cp2++;
			pBuf2++;
		}
	}
	(*cp2) = '\0';	// \0
	free( pBuf );
	return cp;

ERR_EXIT:
	free( pBuf );
	// FreeWorkMemory( L"INCLUDE_PATH", PFT_FALSE );
	return NULL;
}

// ϰϤʸ
static char *GetSelectionRangeStr( PFT_GetAPIFunction GetAPIFunction )
{
	PFT_GetSelectionRange GetSelectionRange = (PFT_GetSelectionRange)GetAPIFunction( PFID_GETSELECTIONRANGE );
	PFT_GetString GetString = (PFT_GetString)GetAPIFunction( PFID_GETSTRING );
	wchar_t *pSelRangeStrW = NULL;
	char *pSelRangeStr = NULL;
	int i;
	unsigned long SL, SC, EL, EC;

	// ϰϤ
	GetSelectionRange( &SL, &SC, &EL, &EC );

	// ʸ򤵤Ƥʤ⤷ϰϤʣԤˤޤäƤϡʤ
	if ( SL == EL && SC == EC || SL != EL ) return NULL;

	// ϰϤʸ
	i = EC - SC; // 򤵤ƤʸĹ
	pSelRangeStrW = (wchar_t*)malloc( sizeof( wchar_t ) * ( i + 1 ) );
	if ( NULL == pSelRangeStrW ) return NULL;
	if ( !GetString( SL, SC, EL, EC, pSelRangeStrW, i + 1 ) ) goto ERR_EXIT;
	pSelRangeStrW[i] = L'\0';

	// 줿ʸ򡢥ޥХʸѴ
	i = wcstombs( NULL, pSelRangeStrW, 0 );
	pSelRangeStr = (char*)malloc( sizeof( char ) * ( i + 1 ) );
	if ( NULL == pSelRangeStr ) goto ERR_EXIT;
	wcstombs( pSelRangeStr, pSelRangeStrW, i );
	pSelRangeStr[i] = '\0';
	free( pSelRangeStrW );
	pSelRangeStrW = NULL;

	return pSelRangeStr;

ERR_EXIT:
	free( pSelRangeStrW );
	free( pSelRangeStr );
	return NULL;
}

// ե̾顢ΥեΥѥʬФ
char* CreateFileNamePath( const char *pFileName )
{
	int i;
	char *rp = NULL;

	// ΰ
	i = strlen( pFileName );
	rp = (char*)malloc( sizeof( char ) * ( i + 1 ) );
	if ( NULL == rp ) return NULL;

	// ͤ򥳥ԡե̾ʬ
	memcpy( rp, pFileName, sizeof( char ) * ( i + 1 ) );
	for (; i >= 0 && rp[i] != '/'; --i );
	if ( i >= 0 ) rp[i] = '\0';

	return rp;
}


// pBuf˳оݤȤʤե̾
// pBufϺPATH_MAXޤ
static PFT_BOOL ResolvPathName( char *pBuf, const char *pIcludePath, const char *pBase, const char *pFileName )
{
	// InckudePathХѥäpIcludePath+pFileName
	// ХѥäϡpBase+pIcludePath+pFileName

	int IP, B, FN;
	int i;

	assert( pBuf && pIcludePath && pBase && pFileName );

	if ( '/' == pIcludePath[0] ) {
		IP = strlen( pIcludePath );
		FN = strlen( pFileName );
		if ( IP + FN + 1 >= PATH_MAX ) return PFT_FALSE;
		strncpy( pBuf, pIcludePath, PATH_MAX );
		i = IP;
		if ( 0 == i || i > 0 && '/' != pBuf[ i - 1 ] ) {
			pBuf[i] = '/';
			i++;
		}
		strncpy( pBuf + i, pFileName, PATH_MAX - i );
	}
	else {
		IP = strlen( pIcludePath );
		FN = strlen( pFileName );
		B = strlen( pBase );
		if ( IP + B + FN + 2 >= PATH_MAX ) return PFT_FALSE;
		strncpy( pBuf, pBase, PATH_MAX );
		i = B;
		if ( 0 == i ) {
			// pBaseͿʤäϡץΥȥǥ쥯ȥȸʤ
			pBuf[i] = '.';
			i++;
		}
		if ( '/' != pBuf[ i - 1 ] ) {
			pBuf[i] = '/';
			i++;
		}
		strncpy( pBuf + i , pIcludePath, PATH_MAX - i );
		i += IP;
		if ( 0 == i || '/' != pBuf[ i - 1 ] ) {
			pBuf[i] = '/';
			i++;
		}
		strncpy( pBuf + i, pFileName, PATH_MAX - i );
	}
	return PFT_TRUE;
}

// ꤵ줿ե򳫤
static PFT_BOOL OpenSpecifiedFile( const char *pFileName, PFT_GetAPIFunction GetAPIFunction )
{
	struct stat wStat;

	// ɥǥե򳫤APIؿ
	PFT_OpenFileNewWindow OpenFileNewWindow = (PFT_OpenFileNewWindow)GetAPIFunction( PFID_OPENFILENEWWINDOW );

	assert( pFileName );

	if ( pFileName[0] == '\0' ) return PFT_FALSE;

	// ꤵ줿եξ֤ǧ
	if ( stat( pFileName, &wStat ) )
		return PFT_FALSE;

	// ե򳫤
	return OpenFileNewWindow( pFileName );
}

// 򤵤줿ե̾Υե򳫤
// 򤵤줿ʸХѥɽƤˤϡե뤫鸡ѥơ
// 򸵤˸Ԥ
void OpenInclude( PFT_GetAPIFunction GetAPIFunction )
{
	PFT_ShowInformationMsgBox ShowInformationMsgBox = (PFT_ShowInformationMsgBox)GetAPIFunction( PFID_SHOWINFORMATIONMSGBOX );
	PFT_GetFileName GetFileName = (PFT_GetFileName)GetAPIFunction( PFID_GETFILENAME );
	const char *pIncludePath;
	const char *cp;
	const char *pFileName = NULL;
	char *pBasePath = NULL;
	char *pSelRangeStr = NULL;
	int i;
	char FileNameBuf[ PATH_MAX ];

	// 򤵤줿ϰϤʸ
	pSelRangeStr = GetSelectionRangeStr( GetAPIFunction );
	if ( NULL == pSelRangeStr ) return ;

	// ߳Ƥե̾
	pFileName = GetFileName();

	// Хѥ褹뤿ΡȤʤѥ̾
	pBasePath = CreateFileNamePath( pFileName );
	if ( NULL == pBasePath ) goto ERR_EXIT;

	// includeեθѥ
	pIncludePath = GetSearchPath( GetAPIFunction, L"INCLUDE_PATH", L"IncludePath" );
	if ( NULL == pIncludePath ) goto ERR_EXIT;

	cp = pIncludePath;
	while ( (*cp) ) {
		// ե̾
		if ( ResolvPathName( FileNameBuf, cp, pBasePath, pSelRangeStr ) ) {
			// ե򳫤
			if ( OpenSpecifiedFile( FileNameBuf, GetAPIFunction ) )
				goto ERR_EXIT;	// 顼ǤϤʤ
		}
		for (; (*cp); cp++ );
		cp++;
	}
	// ե뤬ĤʤäȤΤ
	ShowInformationMsgBox( L"Can't find specified file." );
ERR_EXIT:
	free( pBasePath );
	free( pSelRangeStr );
}

// ե̾Ӥ
// ĤΥե̾ƱեؤƤϿ֤
PFT_BOOL CompareFileName( const char *f1, const char *f2 )
{
	char Buf1[ PATH_MAX ];
	char Buf2[ PATH_MAX ];

	realpath( f1, Buf1 );
	realpath( f2, Buf2 );
	return ( strcmp( Buf1, Buf2 ) == 0 );
}

// ĥҤե̾פե򸡺
void OpenSiblings( PFT_GetAPIFunction GetAPIFunction )
{
	PFT_ShowInformationMsgBox ShowInformationMsgBox = (PFT_ShowInformationMsgBox)GetAPIFunction( PFID_SHOWINFORMATIONMSGBOX );
	PFT_GetFileName GetFileName = (PFT_GetFileName)GetAPIFunction( PFID_GETFILENAME );
	const char *pSearchPath;
	const char *pSearchExt;
	const char *cp1, *cp2;
	const char *pFileName = NULL;
	char *pBasePath = NULL;
	char *pFileNameBody = NULL;
	int i, j;
	char FileNameBuf[ PATH_MAX ];

	// ߳Ƥե̾
	pFileName = GetFileName();

	// Хѥ褹뤿ΡȤʤѥ̾
	pBasePath = CreateFileNamePath( pFileName );
	if ( NULL == pBasePath ) goto ERR_EXIT;

	// ե̾γĥҤʬ
	i = strlen( pFileName );
	pFileNameBody = (char*)malloc( sizeof( char ) * ( i + 1 ) );
	if ( NULL == pFileNameBody ) goto ERR_EXIT;
	j = strlen( pBasePath );
	memcpy( pFileNameBody, pFileName + j + 1, i - j );
	pFileNameBody[ i - j ] = '\0';
	for ( i = i - j - 1; i >= 0 && pFileNameBody[i] != '.'; i-- );
	if ( i >= 0 ) pFileNameBody[ i + 1 ] = '\0';

	// եθѥ
	pSearchPath = GetSearchPath( GetAPIFunction, L"SEARCH_PATH", L"SearchPath" );
	if ( NULL == pSearchPath ) goto ERR_EXIT;

	// оݤγĥҤ
	pSearchExt = GetSearchPath( GetAPIFunction, L"SEARCH_EXT", L"SearchExt" );
	if ( NULL == pSearchExt ) goto ERR_EXIT;

	cp1 = pSearchPath;
	while ( (*cp1) ) {
		cp2 = pSearchExt;
		while ( (*cp2) ) {
			// ե̾
			if ( ResolvPathName( FileNameBuf, cp1, pBasePath, pFileNameBody ) ) {
				if ( strlen( FileNameBuf ) + strlen( cp2 ) + 1 <= PATH_MAX ) {
					// ĥҤϢ뤹
					strcat( FileNameBuf, cp2 );
					if ( !CompareFileName( FileNameBuf, pFileName ) ) {
						// ե򳫤
						if ( OpenSpecifiedFile( FileNameBuf, GetAPIFunction ) )
							goto ERR_EXIT;	// 顼ǤϤʤ
					}
				}
			}
			for (; (*cp2); cp2++ );
			cp2++;
		}
		for (; (*cp1); cp1++ );
		cp1++;
	}
	// ե뤬ĤʤäȤΤ
	ShowInformationMsgBox( L"Can't find specified file." );

ERR_EXIT:
	free( pBasePath );
	free( pFileNameBody );
}
