/////////////////////////////////////////////////////////////////////////////
// HighlightMgr_html.h CHighlightMgr_html饹Υץơ
// 
/////////////////////////////////////////////////////////////////////////////

#if !defined( HIGHLIGHTMGR_HTML_H_INCLUDED_ )
#define HIGHLIGHTMGR_HTML_H_INCLUDED_

#include <vector>
#include <algorithm>
#include "../KeywordFinder.h"
#include "../KeywordList.h"

using namespace std;

namespace NLangExt {

namespace NLangExt_html {

///////////////////////////////////////////////////////////////////////////
// CProgPtr HTMLΥɤΥݥȡӹʸǤȽ

/*
*/

// ߥݥȤƤʸμ򼨤
enum CURCHARTYPE {
	CCT_OUTER_STRING	= 0x01,	// ʸ
	CCT_LESSTHAN		= 0x02,	// γ
	CCT_GREATERTHAN		= 0x03,	// νλ
	CCT_INNER_STRING	= 0x04,	// ʸ
	CCT_KEYWORD			= 0x05,	// 
	CCT_STRING1_LEFT	= 0x06,	// ʸʥ󥰥륯ơ 
	CCT_STRING1_RIGHT	= 0x07,	// ʸʥ󥰥륯ơ 
	CCT_STRING1_MID		= 0x08,	// ʸʥ󥰥륯ơ ʸ
	CCT_STRING2_LEFT	= 0x09,	// ʸʥ֥륯ơ 
	CCT_STRING2_RIGHT	= 0x0A,	// ʸʥ֥륯ơ 
	CCT_STRING2_MID		= 0x0B,	// ʸʥ֥륯ơ ʸ
	CCT_COMMENT_LEFT	= 0x0C,	// ȡʻü <!--
	CCT_COMMENT_RIGHT	= 0x0D,	// ȡʽü -->
	CCT_COMMENT_MID		= 0x0E,	// ȡʸ
	CCT_NULL			= 0x0F
};

// cե٥åȤݤȽǤ
template< typename T_Char >
bool IsAlphaNumeric( T_Char c )
{
#if LANGEXT_IS_ASCII
	return (
		c >= T_Char( 'A' ) && c <= T_Char( 'Z' ) ||
		c >= T_Char( 'a' ) && c <= T_Char( 'z' ) ||
		c >= T_Char( '0' ) && c <= T_Char( '9' ) ||
		c == T_Char( '-' ) || c == T_Char( '_' )
	);
#else
	const char *p = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
	while ( (*p) ) {
		if ( T_Char( (*p) ) == c ) return true;
		++p;
	}
	return false;
#endif
}

// cݤȽǤ
template < typename T_Char >
bool IsNumeric( T_Char c )
{
	return ( T_Char( '0' ) <= c && c <= T_Char( '9' ) );
}

///////////////////////////////////////////////////////////////////////////
// CHighlightMgr HTMLιʸĴɽԤ

template < typename T_Char, typename T_TxtPtr, typename T_CBPtr >
class CHighlightMgr_html
{
public:
	CHighlightMgr_html(){};
	virtual ~CHighlightMgr_html(){};

	// 
	bool Initialize( const char *pKeywordListName )
	{
		return KeywordList.Initialize( pKeywordListName, false );
	};

	// Ƥο򹹿
	// pSTxtϹƬݥȤƤꡢpETxtϹݥȤƤΤȲꤹ
	void FullUpdate( T_TxtPtr pSTxt, T_TxtPtr pETxt, T_CBPtr pSCB ) const
	{
		if ( pSTxt == pETxt ) return ;	// ƥĹ0ʤФϤʤ
		PartryUpdate( pSTxt, pETxt, pSCB, CCT_OUTER_STRING, true, pETxt );
	};

	// ѹȼ
	void UpdateWidthChange(
		T_TxtPtr pSTxt,		// ƥȻü
		T_TxtPtr pETxt,		// ƥü
		T_TxtPtr pUpdateSPosTxt,	// ѹϰ
		T_CBPtr pUpdateSPosCB,		// ѹϰ֤Υ顼Хåե
		T_TxtPtr pUpdateEPosTxt		// ѹλ
		) const
	{
		// öäƤ顢ʤ
		// ʸ	ʸ
		// ʸ	ѿʳʸޤϥʸޤ
		// 		ѿʳʸޤϥʸޤ
		// Ȼü		Ȼüʳʸޤ
		// Ƚü		Ƚüʳʸޤ
		// 		ʸ
		// ʸ		ʸ

		int btype = CCT_OUTER_STRING;
		int i = 0;
		if ( pSTxt == pETxt ) return ;	// ƥĹ0ʤФϤʤ

		// ѹϰ֤ƥȻüʤСɬפϤʤ
		if ( !( pSTxt == pUpdateSPosTxt ) ) {
			// ޤϤˡʸ
			--pUpdateSPosTxt;
			--pUpdateSPosCB;

			switch ( (*pUpdateSPosCB) ) {
			case CCT_OUTER_STRING:
				// ʸǤСϤʤ
				break;
			case CCT_LESSTHAN:
			case CCT_GREATERTHAN:
			case CCT_INNER_STRING:
			case CCT_KEYWORD:
				// ʸޤϥ
				while ( !( pUpdateSPosTxt == pSTxt ) &&
						( (*pUpdateSPosCB) == CCT_LESSTHAN ||
						(*pUpdateSPosCB) == CCT_INNER_STRING ||
						(*pUpdateSPosCB) == CCT_KEYWORD )/* &&
						IsAlphaNumeric( (*pUpdateSPosTxt) ) */) {
					--pUpdateSPosTxt;
					--pUpdateSPosCB;
				}
				break;
			case CCT_STRING1_LEFT:
			case CCT_STRING1_RIGHT:
			case CCT_STRING1_MID:
			case CCT_STRING2_LEFT:
			case CCT_STRING2_RIGHT:
			case CCT_STRING2_MID:
				break;
			case CCT_COMMENT_LEFT:
				// Ȼü
				while ( !( pUpdateSPosTxt == pSTxt ) && (*pUpdateSPosCB) == CCT_COMMENT_LEFT ) {
					--pUpdateSPosTxt;
					--pUpdateSPosCB;
				}
				break;
			case CCT_COMMENT_RIGHT:
				// Ƚü
				while ( !( pUpdateSPosTxt == pSTxt ) && (*pUpdateSPosCB) == CCT_COMMENT_RIGHT ) {
					--pUpdateSPosTxt;
					--pUpdateSPosCB;
				}
				break;
			case CCT_COMMENT_MID:
				// ʸ
				// üΤ줬뤿ᡢ->
				// 3ʸʾɬפϤʤ
				i = 0;
				while ( !( pUpdateSPosTxt == pSTxt ) &&
					( (*pUpdateSPosTxt) == T_Char( '-' ) || (*pUpdateSPosTxt) == T_Char( '>' ) ) &&
					(*pUpdateSPosCB) == CCT_COMMENT_MID && i < 3 ) {
					--pUpdateSPosTxt;
					--pUpdateSPosCB;
					i++;
				}
				break;
			default:
				break;
			}
			btype = (*pUpdateSPosCB);

			// ʸʤ
			if ( !( pETxt == pUpdateSPosTxt ) ) {
				++pUpdateSPosTxt;
				++pUpdateSPosCB;
			}
		}

		// 
		PartryUpdate( pUpdateSPosTxt, pETxt, pUpdateSPosCB, btype, false, pUpdateEPosTxt );
	};

private:
	// ꤵ줿ϰϤ򹹿
	// pSTxt : ϰ
	// pETxt : ƥȽü
	// pSCB : 顼Хåեγϰ
	// btype : ϰ֤ľʸο
	// IsFull : ξϥƥΤ򹹿
	// pUpdateEPosTxt : λ
	void PartryUpdate( T_TxtPtr pSTxt, T_TxtPtr pETxt, T_CBPtr pSCB, int btype, bool IsFull, T_TxtPtr pUpdateEPosTxt ) const
	{
		T_TxtPtr ptr = pSTxt;
		int OldType;	// ѹʸ
		int BeforeType;	// ʸʸ
		int i;
		bool OverFlg = IsFull;

		BeforeType = btype;
		OldType = ~btype;
		while ( !( ptr == pETxt ) && ( IsFull || OldType != BeforeType || !OverFlg ) ) {

			OldType = (*pSCB);	// ѹʸ

			switch ( BeforeType ) {
			case CCT_OUTER_STRING:
			case CCT_COMMENT_RIGHT:
			case CCT_GREATERTHAN:
				if ( (*ptr) == T_Char( '<' ) ) {
					// Ȥβǽ
					ProcCommentLeft( &ptr, pETxt, &pSCB, &OldType );
				}
				else {
					(*pSCB) = CCT_OUTER_STRING;
				}
				break;
			case CCT_LESSTHAN:
			case CCT_INNER_STRING:
			case CCT_KEYWORD:
			case CCT_STRING1_RIGHT:
			case CCT_STRING2_RIGHT:
				if ( IsAlphaNumeric( (*ptr) ) ) {
					// ɤβǽ
					LookupKeyword( &ptr, pETxt, &pSCB, &OldType );
				}
				else if ( (*ptr) == T_Char( '\'' ) ) {
					(*pSCB) = CCT_STRING1_LEFT;
				}
				else if ( (*ptr) == T_Char( '\"' ) ) {
					(*pSCB) = CCT_STRING2_LEFT;
				}
				else if ( (*ptr) == T_Char( '>' ) ) {
					(*pSCB) = CCT_GREATERTHAN;
				}
				else {
					(*pSCB) = CCT_INNER_STRING;
				}
				break;
			case CCT_STRING1_LEFT:
			case CCT_STRING1_MID:
				if ( (*ptr) == T_Char( '\'' ) ) {
					(*pSCB) = CCT_STRING1_RIGHT;
				}
				else
					(*pSCB) = CCT_STRING1_MID;
				break;
			case CCT_STRING2_LEFT:
			case CCT_STRING2_MID:
				if ( (*ptr) == T_Char( '\"' ) ) {
					(*pSCB) = CCT_STRING2_RIGHT;
				}
				else
					(*pSCB) = CCT_STRING2_MID;
				break;
			case CCT_COMMENT_LEFT:
			case CCT_COMMENT_MID:
				if ( (*ptr) == T_Char( '-' ) ) {
					// Ȥνüβǽ
					ProcCommentRight( &ptr, pETxt, &pSCB, &OldType );
				}
				else
					(*pSCB) = CCT_COMMENT_MID;
					
				break;
			}

			BeforeType = (*pSCB);

			++pSCB;
			++ptr;

			if ( ptr > pUpdateEPosTxt ) OverFlg = true;

		}
	}

	// Ȥκ¦
	void ProcCommentLeft( T_TxtPtr *ppSTxt, T_TxtPtr pETxt, T_CBPtr *ppSCB, int *pOldType ) const
	{
		T_Char wBuf[4];
		T_TxtPtr wp = (*ppSTxt);
		int i;

		// ѹʸ򤷤Ƥ
		(*pOldType) = (**ppSCB);

		// Хåե˥ȤȤܤʸƤ
		for ( i = 0; i < 4 && !( wp == pETxt ); i++, ++wp )
			wBuf[i] = (*wp);

		if ( i != 4 ) {
			// ã饳ȤǤϤʤΤȤ
			(**ppSCB) = CCT_LESSTHAN;
			return ;
		}

		if ( !( wBuf[0] == T_Char( '<' ) && wBuf[1] == T_Char( '!' ) &&
			wBuf[2] == T_Char( '-' ) && wBuf[3] == T_Char( '-' ) ) ) {
			// ȤǤϤʤä
			(**ppSCB) = CCT_LESSTHAN;
			return ;
		}

		// Ȥλüä
		for ( i = 0; i < 3; i++ ) {
			(**ppSCB) = CCT_COMMENT_LEFT;
			++(*ppSTxt);
			++(*ppSCB);
		}
		(**ppSCB) = CCT_COMMENT_LEFT;

		// ǤСǸʸʸ򤷤ƤΤ
		// ȺüΡ-פΰʸܤʸܤѲ롢Ȥѥ󤬤뤿ᡢ
		// CCT_COMMENT_LEFTʳʸꤷƤ
		(*pOldType) = ~CCT_COMMENT_LEFT;
	}

	// Ȥα¦
	void ProcCommentRight( T_TxtPtr *ppSTxt, T_TxtPtr pETxt, T_CBPtr *ppSCB, int *pOldType ) const
	{
		T_Char wBuf[3];
		T_TxtPtr wp = (*ppSTxt);
		int i;

		// ѹʸ򤷤Ƥ
		(*pOldType) = (**ppSCB);

		// Хåե˥ȤȤܤʸ
		for ( i = 0; i < 3 && !( wp == pETxt ); i++, ++wp )
			wBuf[i] = (*wp);

		if ( i != 3 ) {
			// ã饳ȤνüǤϤʤΤȤ
			(**ppSCB) = CCT_COMMENT_MID;
			return ;
		}

		if ( !( wBuf[0] == T_Char( '-' ) && wBuf[1] == T_Char( '-' ) && wBuf[2] == T_Char( '>' ) ) ) {
			// ȽüǤϤʤä
			(**ppSCB) = CCT_COMMENT_MID;
			return ;
		}

		// Ȥνüä
		for ( i = 0; i < 2; i++ ) {
			(**ppSCB) = CCT_COMMENT_RIGHT;
			++(*ppSTxt);
			++(*ppSCB);
		}
		(*pOldType) = (**ppSCB);		// Ǹʸʸ򤷤Ƥɬפ
		(**ppSCB) = CCT_COMMENT_RIGHT;
	}

	// ե٥åȤ
	void LookupKeyword( T_TxtPtr *ppSTxt, T_TxtPtr pETxt, T_CBPtr *ppSCB, int *pOldType ) const
	{
		char c;
		CKeywordFinder< T_Char, false > Finder( &KeywordList.GetKeywordList() );
		T_TxtPtr wpTXT = (*ppSTxt);
		int cnt, i;

		// ѹʸ򤷤Ƥ
		(*pOldType) = (**ppSCB);

		// ѿ
		cnt = 0;
		while ( !( wpTXT == pETxt ) && IsAlphaNumeric( (*wpTXT) ) ) {
			Finder.AddChar( (*wpTXT) );
			++wpTXT;
			cnt++;
		}

		// ꤹ뿧ꤹ
		if ( Finder.IsFound() )
			c = CCT_KEYWORD;
		else
			c = CCT_INNER_STRING;

		// ꤹ
		for ( i = 0; i < cnt - 1; i++ ) {
			(**ppSCB) = c;
			++(*ppSTxt);
			++(*ppSCB);
		}
		(*pOldType) = (**ppSCB);		// Ǹʸʸ򤷤Ƥɬפ
		(**ppSCB) = c;
	}

protected:
	CKeywordList KeywordList;
};

} // namespace NLangExt_html

} // namespace NLangExt

#endif // HIGHLIGHTMGR_HTML_H_INCLUDED_

