////////////////////////////////////////////////////////////////////////////
// CTxtColorMgr_cs 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TxtColorMgr_cs.h"

using namespace NLangExt;
using namespace NLangExt_cs;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTxtColorMgr_cs::CTxtColorMgr_cs()
{
	int i;
	for ( i = 0; i < 78; i++ ) IndexTable[i] = 0;
	IndexTable[ NLangExt_cpp::CCT_ALPHANUMERIC ] = 0;
	IndexTable[ NLangExt_cpp::CCT_KEYWORD ] = 1;
	IndexTable[ NLangExt_cpp::CCT_COM1_LEFT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_COM1_RIGHT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_COM1_TEXT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_COM2_LEFT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_COM2_RIGHT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_COM2_TEXT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_DQUOTE_LEFT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_DQUOTE_RIGHT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_DQUOTE_TEXT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_SQUOTE_LEFT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_SQUOTE_RIGHT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_SQUOTE_TEXT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_OTHER ] = 0;
	IndexTable[ NLangExt_cpp::CCT_NULL ] = 0;
}

CTxtColorMgr_cs::~CTxtColorMgr_cs()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
CErrorBool CTxtColorMgr_cs::Initialize( VClsPtr< CConfigInfo > pConf )
{
	vColor[0] = pConf->RefCS_NormalTextF_Color();
	vColor[1] = pConf->RefCS_KeywordF_Color();
	vColor[2] = pConf->RefCS_CommentF_Color();
	vColor[3] = pConf->RefCS_SringF_Color();
	if ( !m_HM.Initialize( pConf->RefCS_KeywordList().c_str() ) )
		return CErrorBool( pConf->RefFailedToReadKeywordListMsg() );
	return true;
}

// Ѥ뿧ο
int CTxtColorMgr_cs::GetColorCount() const
{
	return 4;
}

// 
Pixel CTxtColorMgr_cs::GetColor( int idx ) const
{
	assert( idx >= 0 && idx < 4 );
	return vColor[idx];
}

// 󤫤鿧ΥǥåѴ
int CTxtColorMgr_cs::TranseToIdx( unsigned char c ) const
{
	assert( c >= 0 && c < 78 );
	return IndexTable[c];
}

// ֤ǹ
void CTxtColorMgr_cs::InitiUpdate( T_LineData &rData ) const
{
	InitUpdateColorFunc( m_HM, rData );
}

// ʸιȼι
void CTxtColorMgr_cs::Update( T_LineData &rData, const T_SelRange &range ) const
{
	UpdateColorFunc( m_HM, rData, range );
}
