////////////////////////////////////////////////////////////////////////////
// CTitleMgr 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TitleMgr.h"
#include "TaEditDoc.h"
#include "TaEditShell.h"
#include "TaEditDraw.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTitleMgr::CTitleMgr() :
	fmFlg( 0 ),
	pDoc( 0 ),
	pDraw( 0 ),
	pConfig( NULL )
{

}

CTitleMgr::CTitleMgr( const CTitleMgr& r ) :
	fmFlg( r.fmFlg ),
	pDoc( r.pDoc ),
	pDraw( r.pDraw ),
	pConfig( r.pConfig )
{

}

CTitleMgr::~CTitleMgr()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CTitleMgr::Initialize( VClsPtr< CConfigInfo > pArgConf, const CTaEditDoc *pArgDoc, const CTaEditDraw *pArgDraw )
{
	bool ArgFlg[7] = { false, false, false, false, false, false, false };
	const wstring &rFormat = pArgConf->RefTitleFormat();

	// ȥΥեޥåˡ%1%7ޤޤƤ뤫ݤĴ٤
	GlbFunc::InspectMsgString( rFormat, 7, ArgFlg );

	// ե饰ͤꤹ
	fmFlg = 0;
	if ( ArgFlg[0] ) fmFlg |= TITLESTR_APP_TITLE;
	if ( ArgFlg[1] ) fmFlg |= TITLESTR_FPFILE_NAME;
	if ( ArgFlg[2] ) fmFlg |= TITLESTR_FILE_NAME;
	if ( ArgFlg[3] ) fmFlg |= TITLESTR_MODIFIED_SIGN_STR;
	if ( ArgFlg[4] ) fmFlg |= TITLESTR_LINE_NUMBER;
	if ( ArgFlg[5] ) fmFlg |= TITLESTR_COLUMN1;
	if ( ArgFlg[6] ) fmFlg |= TITLESTR_COLUMN2;

	pDoc = pArgDoc;
	pDraw = pArgDraw;
	pConfig = pArgConf;
}

// ȥꤹʸ
// FLGˤϡȥͳꤹ
// ȥ˼Ԥ硢⤷Ϻꤹɬפʤˤ
// Ĺ0ʸ֤
string CTitleMgr::GetTitleStr( unsigned int FLG ) const
{
	wchar_t LineNumber[15] = { 0 };	// θ֤߰ιֹʸ󲽤뤿ΥХåե
	wchar_t Column1[15] = { 0 };	// θ֤߰Υֹʸ󲽤뤿ΥХåե
	wchar_t Column2[15] = { 0 };	// ƱʥʸʤɤŸ
	wstring wTitleString;	// ȥСꤹʸʥ磻ɥХȡˤݻ
	string sTitleString;	// ȥСꤹʸʥޥХȡˤݻ
	int LineNumberOrigin = 0;
	const wchar_t *MsgArg[10] = { 0 };
	wstring wFPFileName;
	wstring wFileName;

	// ѹ줿ͤ򡢥ȥȤƻѤʤΤǤС
	// ꤹɬפϤʤ
	if ( !( FLG & fmFlg ) ) return "";

	const CCursor* pCursor = pDraw->GetCursorInfo();
	if ( NULL == pCursor ) return "";

	const wstring& AppTitle = pConfig->RefAppTitle();
	const string& sFPFileName = pDoc->GetFileName();
	const wstring& NewFileTitleStr = pConfig->RefNewFileWndTitleStr();
	const wstring& ModifiedSignStr = pConfig->RefModifiedSignStr();
	const wstring& TitleFormat = pConfig->RefTitleFormat();
	const T_CurPos& CurPos = pCursor->GetCurPos();
	LineNumberOrigin = pConfig->GetLineNumberOrigin();

	// ե̾磻ɥХʸѴ
	GlbFunc::MBStoWCS( sFPFileName.c_str(), &wFPFileName );
	wFileName = GlbFunc::GetFileNameFromFullPathName( wFPFileName );

	// ֹʸ
	if ( fmFlg & TITLESTR_LINE_NUMBER )
		swprintf( LineNumber, sizeof( LineNumber ), L"%3d", CurPos.GetLine() + LineNumberOrigin );

	// ʸ
	if ( fmFlg & TITLESTR_COLUMN1 )
		swprintf( Column1, sizeof( Column1 ), L"%3d", CurPos.GetCPos() );

	// ʸ
	if ( fmFlg & TITLESTR_COLUMN2 ) {
		swprintf( Column2, sizeof( Column2 ), L"%3d", CalcColumnType2() );
	}

	// ȥꤹʸۤ
	MsgArg[0] = AppTitle.c_str();
	if ( sFPFileName.empty() )
		MsgArg[1] = NewFileTitleStr.c_str();
	else
		MsgArg[1] = wFPFileName.c_str();
	if ( sFPFileName.empty() )
		MsgArg[2] = NewFileTitleStr.c_str();
	else
		MsgArg[2] = wFileName.c_str();

	if ( pDoc->GetIsModify() )
		MsgArg[3] = ModifiedSignStr.c_str();
	else
		MsgArg[3] = L"";
	MsgArg[4] = LineNumber;
	MsgArg[5] = Column1;
	MsgArg[6] = Column2;
	wTitleString = GlbFunc::CreateMsgString( TitleFormat, 7, MsgArg );

	// ޥХʸѴơ֤ͤ
	GlbFunc::WCStoMBS( wTitleString.c_str(), &sTitleString );
	return sTitleString;
}

// ꤹʸ
string CTitleMgr::GetIconName( unsigned int FLG ) const
{
	const string& sFileName = pDoc->GetFileName();
	const wstring& NewFileTitleStr = pConfig->RefNewFileWndTitleStr();
	string wstr;

	// ե̾ѹ줿ΤǤʤС̾Ѥɬפʤ
	if ( !( FLG & TITLESTR_FILE_NAME ) ) return "";

	// ե̾ʤ顢򤽤Τޤ֤
	if ( !sFileName.empty() )
		return GlbFunc::GetFileNameFromFullPathName( sFileName );

	GlbFunc::WCStoMBS( NewFileTitleStr.c_str(), &wstr );
	return wstr;
}

// 
const CTitleMgr& CTitleMgr::operator =( const CTitleMgr& r )
{
	fmFlg = r.fmFlg;
	pDoc = r.pDoc;
	pDraw = r.pDraw;
	pConfig = r.pConfig;
	return (*this);
}

// ʸŸˤ륫֤
// ֤顢ڡǲʸʬ򻻽Ф
int CTitleMgr::CalcColumnType2() const
{
	// ڡ
	int SpaceCharWidth = pDraw->GetCharWidth( L' ', 0 );

	// ߥ褷Ƥ֤
	const CCursor* pCursor = pDraw->GetCursorInfo();
	int CurPosX = pCursor->GetCurPosX();

	return CurPosX / SpaceCharWidth;
}



