////////////////////////////////////////////////////////////////////////////
// CTextEdit 饹Υ󥿥ե
//
// ƥȤԽ
////////////////////////////////////////////////////////////////////////////

#if !defined( TEXTEDIT_H_INCLUDED_ )
#define TEXTEDIT_H_INCLUDED_

#include "TaEdit_std.h"

#include "Cursor.h"
#include "ScrollInfoPacket.h"
#include "regex/SRegex.h"
#include "TextMatchLib.h"

class CTaEditDoc;
class CTaEditDraw;

class CTextEdit : public CCPInterface
{

public:
	CTextEdit( CTaEditDraw *argpDraw, VClsPtr< CCursor > argpCursorInfo, CTaEditDoc *argpDoc );
	CTextEdit( const CTextEdit &r );	// ʣʶػߡ
	~CTextEdit();

	// ϰϤ˥ƥȤ
	void PasteText( const wstring& rStr, bool DoRedraw );

	void Undo();
	void Redo();
	void DelSelRange();
	void FullSelect();
	void Cut();
	void Copy();
	void Paste();
	bool IsEnableCopy() const;

	// ʸθԤ
	void FindText( const wstring &rPattern, bool IgnoreCase );

	// ѥ˰פʸִ롣
	void ReplaceAll( const wstring &rPattern, const wstring& rAfterText, bool IgnoreCase );

	// ʸΰưԤ
	void MoveText( T_SelRange SourceRange, int DestXPos, int DestYPos );

	// Ԥذư
	void OnMoveto();
	void OnMoveto( int Line );

	// ʶػߡ
	const CTextEdit& operator =( const CTextEdit &r );

protected:
	// ϰ
	void ClearSelect();

	CTaEditDraw *pDraw;
	VClsPtr< CCursor > pCursorInfo;
	CTaEditDoc *pDoc;
};

#endif // TEXTEDIT_H_INCLUDED_

