////////////////////////////////////////////////////////////////////////////
// CTextEdit 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TextEdit.h"
#include "TaEditDoc.h"
#include "TaEditDraw.h"
#include "TaEditShell.h"
#include "TaEditJPEXT.h"
#include "TaEditMovetoDlg.h"
#include "TaEditProcessingDlg.h"
#include "FindText.h"
#include "ReplaceAll.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTextEdit::CTextEdit( CTaEditDraw *argpDraw, VClsPtr< CCursor > argpCursorInfo, CTaEditDoc *argpDoc ) :
	CCPInterface(),
	pDraw( argpDraw ),
	pCursorInfo( argpCursorInfo ),
	pDoc( argpDoc )
{

}

CTextEdit::~CTextEdit()
{
	pCursorInfo = NULL;
	pDraw = NULL;
	pDoc = NULL;
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 򤵤ƤϰϤ˥ƥȤĥդ
void CTextEdit::PasteText( const wstring& rStr, bool DoRedraw )
{
	T_CurPos NextPos;
	ScrollInfoPacket ScrPacket;
	T_SelRange SR = pCursorInfo->GetSelRange();
	T_CurPos CP = pCursorInfo->GetCurPos();

	// ʸ
	m_TaEditShell->ProcErrorMsg( pDoc->Insert( rStr, SR.GetSPos(), SR, &NextPos ) );
	pDoc->EndEdit();

	// 
	pCursorInfo->SetCurPos( NextPos, &ScrPacket, T_SelRange( NextPos, NextPos ) );

	// 
	if ( DoRedraw ) pDraw->AfterEditRedraw( ScrPacket );
}

// ɥ
void CTextEdit::Undo()
{
	ScrollInfoPacket scrPacket;
	T_SelRange wSR;	// ɥϰ
	T_CurPos wCP;	// ɥΥ

	ClearSelect();	// öϰ롣

	pDoc->Undo( &wSR, &wCP );
	pCursorInfo->SetCurPos( wCP, &scrPacket, wSR );	// ֤
	pDraw->AfterEditRedraw( scrPacket );	// 
}

// ɥ
void CTextEdit::Redo()
{
	ScrollInfoPacket scrPacket;
	T_SelRange wSR;	// ɥϰ
	T_CurPos wCP;	// ɥΥ

	ClearSelect();	// öϰ롣

	pDoc->Redo( &wSR, &wCP );
	pCursorInfo->SetCurPos( wCP, &scrPacket, wSR );	// ֤
	pDraw->AfterEditRedraw( scrPacket );	// 
}

// ϰϤκ
void CTextEdit::DelSelRange()
{
	ScrollInfoPacket scrPacket;
	T_CurPos wCP;

	// 򤵤ƤϰϤ
	CErrorBool r = pDoc->InsertSpecialCode( XK_Delete, pCursorInfo->GetCurPos(), pCursorInfo->GetSelRange(), &wCP );
	pDoc->EndEdit();
	m_TaEditShell->ProcErrorMsg( r );

	// ֤
	pCursorInfo->SetCurPos( wCP, &scrPacket, false );

	// 
	pDraw->AfterEditRedraw( scrPacket );
}

// 
void CTextEdit::FullSelect()
{
	ScrollInfoPacket scrPacket;

	// ߤΥ֤
	T_CurPos wCP = pCursorInfo->GetCurPos();

	// Կ
	const int LineCnt = pDoc->RefData().size();

	// ǸιԤ˴ޤޤʸ
	T_LineDataItr_c LastLineItr = pDoc->RefData().end();
	LastLineItr--;
	const int LastLineCharCnt = LastLineItr->length();

	// ꤹ٤ϰϤ
	T_SelRange wSR( T_CurPos( 0, 0 ), T_CurPos( LineCnt - 1, LastLineCharCnt ) );

	// ֤
	pCursorInfo->SetCurPos( wCP, &scrPacket, wSR );

	// 
	pDraw->AfterSelRangeRedraw( scrPacket.ChangeSLine, scrPacket.ChangeELine );
}

// å
void CTextEdit::Cut()
{
	if ( !IsEnableCopy() ) return ;

	Copy();	// ߤϰϤ򥳥ԡ
	DelSelRange();	// ϰϤ
}

// ԡ
void CTextEdit::Copy()
{
	T_SelRange SR = pCursorInfo->GetSelRange();
	wstring wStr;

	if ( !IsEnableCopy() ) return ;

	// ԡоݤʸ
	pDoc->GetRangeStr( SR, &wStr );

	// åץܡɤ
	JPEXT_SetClipboardData( m_TaEditShell->m_TaEditShell, wStr );
}

// ڡ
void CTextEdit::Paste()
{
	wstring wStr;

	// åץܡɤǡ
	JPEXT_GetClipboardData( m_TaEditShell->m_TaEditShell, &wStr );

	// ƥȤ
	PasteText( wStr, true );
}

// åץܡɤؤΥԡǽݤ
bool CTextEdit::IsEnableCopy() const
{
	if ( pCursorInfo->GetSelRange().GetLength() <= T_CurPos( 0, 0 ) )
		return false;
	else
		return true;
}

// ߤΥ֤ѥΥƥȤȰפʬ򸡺롣
void CTextEdit::FindText( const wstring &rPattern, bool IgnoreCase )
{
	ScrollInfoPacket scrPacket;
	T_SelRange nSelRange;
	T_CurPos nCurPos;
	T_CurPos FindStartPos;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int ShowDlgDelay = pConf->GetShowPrecessingDlgDelay();
	bool FindLoop;

	// ѤΥ֥Ȥ
	CFindText *pFindTextObj = new CFindText();
	if ( NULL == pFindTextObj ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefOutOfMemoryErrorMsg() );
		return ;
	}

	if ( pDoc->RefData().size() == 1 && pDoc->RefData().begin()->length() == 0 ) {
		// ٤ʸ󤬰ʸʤ
		m_TaEditShell->ShowInformationMsgBox( pConf->RefCantFindTextMsg() );
		goto ERR_EXIT;
	}

	// ʸ󤬸Ĥ뤫ߤޤǷ֤
	FindLoop = true;
	FindStartPos = pCursorInfo->GetCurPos();
	while ( FindLoop ) {

		// ֥Ȥ˾
		if ( !pFindTextObj->SetInfo( pDoc, FindStartPos, rPattern, pConf, IgnoreCase ) )
			goto ERR_EXIT;

		// 
		if ( m_ProcessingShell->ShowDlg( pFindTextObj, ShowDlgDelay ) )
			goto ERR_EXIT;
		if ( !m_TaEditShell->ProcErrorMsg( pFindTextObj->GetErrorInfo() ) )
			goto ERR_EXIT;

		if ( !pFindTextObj->IsMatched() ) {
			// Ĥʤϡåɽơ
			// ǽ餫鸡뤫ݤҤͤ
			int r = m_TaEditShell->ShowQuestionMsgBox( pConf->RefCantFindTextMsg(), false );

			// ߤϡؿȴ
			if ( r != 1 ) goto ERR_EXIT;

			// ϰ֤Ƭˤơ֤
			FindStartPos = T_CurPos( 0, 0 );
		}
		else {
			// ޥåʸ󤬸Ĥä顢롼פȴ
			FindLoop = false;
		}
	}

	// ֤
	nSelRange = pFindTextObj->GetMatchRange();
	nCurPos = nSelRange.GetEPos();
	pCursorInfo->SetCurPos( nCurPos, &scrPacket, nSelRange );

	// 
	if ( scrPacket.NeedXScroll || scrPacket.NeedYScroll )
		pDraw->AfterEditRedraw( scrPacket );
	else
		pDraw->AfterSelRangeRedraw( scrPacket.ChangeSLine, scrPacket.ChangeELine );

ERR_EXIT:
	delete pFindTextObj;
}


// ѥ˰פʸִ롣
void CTextEdit::ReplaceAll( const wstring &rPattern, const wstring& rAfterText, bool IgnoreCase )
{
	ScrollInfoPacket scrPacket;
	T_CurPos wCurPos;
	T_SelRange nSelRange;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int ShowDlgDelay = pConf->GetShowPrecessingDlgDelay();
	CReplaceAll *pReplaceAllObj = NULL;
	CTaEditDoc *wpDoc = NULL;

	if ( pDoc->RefData().size() == 1 && pDoc->RefData().begin()->length() == 0 ) {
		// ٤ʸ󤬰ʸʤ
		m_TaEditShell->ShowInformationMsgBox( pConf->RefCantFindTextMsg() );
		return ;
	}

	// ִѥ֥Ȥ
	pReplaceAllObj = new CReplaceAll();
	if ( NULL == pReplaceAllObj ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefOutOfMemoryErrorMsg() );
		return ;
	}

	// ¾ŪԽѤˡɥȥ֥Ȥʣ
	wpDoc = pDoc->CopyForExclusiveEditing();
	if ( NULL == wpDoc ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefOutOfMemoryErrorMsg() );
		goto ERR_EXIT;
	}

	// ֥Ȥ˾
	if ( !pReplaceAllObj->SetInfo( wpDoc, rPattern, pConf, rAfterText, IgnoreCase ) )
		goto ERR_EXIT;

	// 
	m_ProcessingShell->ShowDlg( pReplaceAllObj, ShowDlgDelay );
	wpDoc->EndEdit();

	// 顼
	m_TaEditShell->ProcErrorMsg( pReplaceAllObj->GetErrorInfo() );

	// ԽƤȿǤ
	pDoc->ReflectionExclusiveEditing( wpDoc );

	// ֤
	wCurPos = T_CurPos( 0, 0 );	// ΥϡƥȤƬꤹ
	nSelRange = T_SelRange( wCurPos, wCurPos );
	pCursorInfo->SetCurPos( wCurPos, &scrPacket, nSelRange );

	// 
	pDraw->AfterEditRedraw( scrPacket );

ERR_EXIT:
	delete pReplaceAllObj;
	delete wpDoc;
}

// ʸΰưԤ
void CTextEdit::MoveText( T_SelRange SourceRange, int DestXPos, int DestYPos )
{
	ScrollInfoPacket scrPacket;
	wstring wStr;
	T_CurPos wCurPos;
	CErrorBool r;

	// ưоݤʸ
	pDoc->GetRangeStr( SourceRange, &wStr );

	// ֤׻
	T_CurPos DestPos = pDraw->PixPosToCurPos( DestXPos, DestYPos );

	// ֤ưξϡƤ롣
	if ( SourceRange.GetSPos() > DestPos ) {
		r = pDoc->InsertSpecialCode( XK_Delete, SourceRange.GetEPos(), SourceRange, &wCurPos );
		if ( r ) r = pDoc->Insert( wStr, DestPos, T_SelRange( DestPos, DestPos ), &wCurPos );
	}
	else {
		r = pDoc->Insert( wStr, DestPos, T_SelRange( DestPos, DestPos ), &wCurPos );
		if ( r ) r = pDoc->InsertSpecialCode( XK_Delete, SourceRange.GetEPos(), SourceRange, &wCurPos );
	}
	m_TaEditShell->ProcErrorMsg( r );
	pDoc->EndEdit();

	// ֤ϰϤ
	T_SelRange nSelRange = T_SelRange( DestPos, DestPos );
	pCursorInfo->SetCurPos( DestPos, &scrPacket, nSelRange );

	// 
	pDraw->AfterEditRedraw( scrPacket );
}

// Ԥذư
// MoveToɽϤ줿Ԥذư
void CTextEdit::OnMoveto()
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	// ߤΥ֤
	int CurLine = pCursorInfo->GetCurPos().GetLine();
	CurLine += pConf->GetLineNumberOrigin();

	// ưιֹư
	OnMoveto( m_MovetoShell->ShowDlg( CurLine ) );
}

// ꤵ줿Ԥذư
void CTextEdit::OnMoveto( int Line )
{
	T_CurPos wCurPos;
	ScrollInfoPacket scrPacket;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int LineCnt = pDoc->RefData().size();	// ߤԿ

	Line -= pConf->GetLineNumberOrigin();
	if ( Line < 0 ) Line = 0;
	if ( Line >= LineCnt ) Line = LineCnt - 1;

	// ư
	wCurPos.SetLine( Line );
	wCurPos.SetCPos( 0 );
	pCursorInfo->SetCurPos( wCurPos, &scrPacket, false );
	pDraw->AfterEditRedraw( scrPacket );
}


// ϰ
void CTextEdit::ClearSelect()
{
	T_SelRange wSR;
	ScrollInfoPacket scrPacket;

	// ϰ򤵤Ƥϡϰƺ褹
	wSR = pCursorInfo->GetSelRange();
	if ( wSR.GetLength() == T_CurPos( 0, 0 ) )
		return ;

	const T_CurPos &wCP = pCursorInfo->GetCurPos();
	wSR.SetPos( wCP, wCP );
	pCursorInfo->SetCurPos( wCP, &scrPacket, wSR );
	pDraw->AfterSelRangeRedraw( scrPacket.ChangeSLine, scrPacket.ChangeELine );
}

