////////////////////////////////////////////////////////////////////////////
// CTaEditFileSelDlg 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEditFileSelDlg.h"
#include <Xm/XmAll.h>
#include <Xm/FileSBP.h>
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTaEditFileSelDlg::CTaEditFileSelDlg() :
	CFileSelDlg(),
	IsSelected( false ),
	SelectedFile( "" ),
	EncodeInfo(),
	LastFilePath( "" ),
	m_ModalDlg(),
	IsFirstShow( true )
{
	EncodeInfo.Initialize();
}

CTaEditFileSelDlg::~CTaEditFileSelDlg()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// Ĥ
void CTaEditFileSelDlg::OnClose( Widget argWgt, XtPointer user_data )
{
	OnCancel( argWgt, user_data );
}

// 󥻥ܥβ
void CTaEditFileSelDlg::OnCancel( Widget argWgt, XtPointer user_data )
{
	m_ModalDlg.ExitModal();	// ⡼νλ
	IsSelected = false;	// ߤ줿
	SelectedFile = "";
	EncodeInfo.Initialize();
}

// ϣ˥ܥβ
void CTaEditFileSelDlg::OnOK( Widget argWgt, XtPointer user_data )
{
	Arg al[3];
	int ac = 0;
	Widget tf;
	char *wpEncodeName;
	int SelectedItem;
	char *pFileName;
	char *pDirName;
	string strFileName;
	CRTYPE wCR;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	// ǥ쥯ȥ̾
	if ( !XmStringGetLtoR( FS_Directory( m_FileSelectDlg ), XmFONTLIST_DEFAULT_TAG, &pDirName ) ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefUnexpectedErrorMsg() );
		return ;
	}

	// ե̾
	pFileName = XmTextGetString( m_FileNameText );
	strFileName = pFileName;

	// եѥΥե̾
	SelectedFile = pDirName;
	SelectedFile += strFileName;

	// ꤵ줿եΥѥ̾
	LastFilePath = pDirName;

	XtFree( pFileName );
	XtFree( pDirName );

	if ( strFileName.empty() ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFileNameIsNotInputtedErrorMsg() );
		return ;
	}

	// ԥɤμ̤
	ac = 0;
	XtSetArg( al[ac], XmNmenuHistory, &tf ); ac++;
	XtGetValues( m_FileCROption, al, ac );
	if ( tf == m_FileCRMenu_LF )
		wCR = CRTYPE_LF;
	else if ( tf == m_FileCRMenu_CRLF )
		wCR = CRTYPE_CRLF;
	else if ( tf == m_FileCRMenu_CR )
		wCR = CRTYPE_CR;
	else
		wCR = CRTYPE_LFCR;

	// 󥳡̾ϤƥȥեɥåȤ
	XtSetArg( al[ac], XmNtextField, &tf ); ac++;
	XtGetValues( m_FileCodeCombo, al, ac );

	// 󥳡̾
	wpEncodeName = XmTextFieldGetString( tf );
	EncodeInfo = CEncodeInfo( string( wpEncodeName ), ENCTYPE_SPECIFIED, wCR );

	// 򤵤Ƥ륢ƥֹ
	ac = 0;
	XtSetArg( al[ac], XmNselectedPosition, &SelectedItem ); ac++;
	XtGetValues( m_FileCodeCombo, al, ac );

	if ( 0 == SelectedItem ) {
		// 0֤򤵤줿ϡָߤΥפȼϤȤĤ
		VClsPtr< CConfigInfo > pConfig = m_TaEditShell->GetConfigInfo();
		const string& rCurrentEncodeText = pConfig->RefCurrentEncodeText();
		if ( strcmp( rCurrentEncodeText.c_str(), wpEncodeName ) == 0 ) {
			// ָߤΥפ򤵤줿
			EncodeInfo = CEncodeInfo( "", ENCTYPE_CURRENT, wCR );
		}
	}
	XtFree( (char*)wpEncodeName );
	wpEncodeName = NULL;

	// ⡼νλ
	m_ModalDlg.ExitModal();
	IsSelected = true;
}

// ɽ
void CTaEditFileSelDlg::OnShow( Widget argWgt, XtPointer user_data )
{
	string ws;
	if ( LastFilePath.length() == 0 )
		ws = "*";
	else {
		if ( LastFilePath[ LastFilePath.length() - 1 ] != '/' )
			ws = LastFilePath + "/*";
		else
			ws = LastFilePath + "*";
	}
	XmFileSelectionDoSearch( m_FileSelectDlg, CCompoundStr( ws ) );
}

void CTaEditFileSelDlg::OnCRMenu_LF( Widget argWgt, XtPointer user_data )
{

}

void CTaEditFileSelDlg::OnCRMenu_CRLF( Widget argWgt, XtPointer user_data )
{

}

void CTaEditFileSelDlg::OnCRMenu_CR( Widget argWgt, XtPointer user_data )
{

}

void CTaEditFileSelDlg::OnCRMenu_LFCR( Widget argWgt, XtPointer user_data )
{

}


// Υȥ
void CTaEditFileSelDlg::SetDlgTitle( const CCompoundStr &rStr, bool IsRead ) const
{
	int ac = 0;
	Arg al[2];
	Boolean flg;

	// ȥ
	XtSetArg( al[ac], XmNdialogTitle, rStr.GetStr() ); ac++;
	XtSetValues( m_FileSelectDlg, al, ac );

	// ɤ߹ߤξϡԥɤΥ˥塼̵
	if ( IsRead )
		flg = false;
	else
		flg = true;
	ac = 0;
	XtSetArg( al[ac], XmNsensitive, flg ); ac++;
	XtSetValues( m_FileCROption, al, ac );
}

// ǥեȤΥ󥳡̾ꤹ
void CTaEditFileSelDlg::SetDefaultEncodeInfo( const CEncodeInfo &rEI )
{
	EncodeInfo = rEI;
}

// ɽ
// ݤ֤
bool CTaEditFileSelDlg::ShowDlg()
{
	int ac = 0;
	Arg al[2];
	Widget tf;
	int i;

	// 󥳡̾ꤹ롣
	if ( IsFirstShow ) {
		VClsPtr< CConfigInfo > pConfig = m_TaEditShell->GetConfigInfo();
		const string& rCurrentEncodeText = pConfig->RefCurrentEncodeText();
		const vector< string >& rvEncodeName = pConfig->RefEncodeName();
		CCompoundStr wCS;

		IsFirstShow = false;

		// ֥ȤΥΥ󥳡ɡפ򼨤ʸ
		wCS.SetStr( rCurrentEncodeText );
		XmComboBoxAddItem( m_FileCodeCombo, wCS, 1, true );
		for ( i = 0; i < rvEncodeName.size(); i++ ) {
			// ꥽˻ꤵ줿󥳡̾
			wCS.SetStr( rvEncodeName[i] );
			XmComboBoxAddItem( m_FileCodeCombo, wCS, i + 2, true );
		}
	}

	SelectedFile = "";

	if ( EncodeInfo.GetEncodeType() != ENCTYPE_NOTHIG ) {
		// ǥեȤΥ󥳡̾ꤹ
		if ( EncodeInfo.GetEncodeType() == ENCTYPE_CURRENT ) {
			// ߤΥǻѤƤ륨󥳡
			XtSetArg( al[ac], XmNselectedPosition, 0 ); ac++;
			XtSetValues( m_FileCodeCombo, al, ac );
		}
		else {
			// ꤵƤ륨󥳡̾
			XtSetArg( al[ac], XmNtextField, &tf ); ac++;
			XtGetValues( m_FileCodeCombo, al, ac );
			XmTextFieldSetString( tf, const_cast< char* >( EncodeInfo.GetEncodeName().c_str() ) );
		}
	}

	// ԥɤ
	switch( EncodeInfo.GetCRType() ) {
	case CRTYPE_LF:
		tf = m_FileCRMenu_LF;
		break;
	case CRTYPE_CRLF:
		tf = m_FileCRMenu_CRLF;
		break;
	case CRTYPE_CR:
		tf = m_FileCRMenu_CR;
		break;
	case CRTYPE_LFCR:
		tf = m_FileCRMenu_LFCR;
		break;
	}
	ac = 0;
	XtSetArg( al[ac], XmNmenuHistory, tf ); ac++;
	XtSetValues( m_FileCROption, al, ac );

	// ⡼ɽ
	m_ModalDlg.DoModal( m_FileSelectDlg );

	return IsSelected;
}

// 򤵤줿ե̾
const string& CTaEditFileSelDlg::GetSelectedFileName() const
{
	return SelectedFile;
}

// 򤵤줿󥳡ɤξ
const CEncodeInfo& CTaEditFileSelDlg::GetSelectedEncodeInfo() const
{
	return EncodeInfo;
}

// եѥ⤷ʤե̾顢ե̾ΤߤФ
/*const char* CTaEditFileSelDlg::FullPathToFileName( const char *pFileName ) const
{
	int slen = strlen( pFileName );
	for (; slen > 0 && pFileName[ slen ] != '/'; slen-- );
	return pFileName + slen;
}*/

