////////////////////////////////////////////////////////////////////////////
// CScrollMgr 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "ScrollMgr.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CScrollMgr::CScrollMgr() :
	m_Scr( NULL ) ,
	pEventHandler( NULL ),
	m_Min( 0 ),
	m_Max( 1 ),
	m_PageSize( 1 ),
	m_MinChickSize( 1 ),
	MinPadding( 0 ),
	MaxPadding( 0 )
{

}

CScrollMgr::~CScrollMgr()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ѥǥ󥰤
void CScrollMgr::SetPadding( unsigned int argMin, unsigned int argMax )
{
	MinPadding = argMin;
	MaxPadding = argMax;
	m_Min = m_Min - MinPadding;
	m_Max = m_Max + MaxPadding;
}

// СΥ٥ȥϥɥ
void CScrollMgr::SetEventHandler( CScrEventHandler *pArg )
{
	pEventHandler = pArg;
}

// Ǿͤ
void CScrollMgr::SetMin( int argMin )
{
	m_Min = argMin - MinPadding;
	SetResource();
}

// ͤ
void CScrollMgr::SetMax( int argMax )
{
	m_Max = argMax + MaxPadding;
	SetResource();
}

// ڡ
// ڡꤷݡߤ+ڡͤĶϡ
// *pRequireValue˸ߤͤȤꤹ٤֤ͤ
bool CScrollMgr::SetPageSize( int argPageSize, int *pRequireValue )
{
	assert( NULL != this );

	// 1̤ͤꤵ줿顢Ȥꤢ1ˤ롣
	if ( argPageSize < 1 ) argPageSize = 1;

	// ߤƱͤꤵ줿顢ʤˤ⤹뤳ȤϤʤ
	if ( argPageSize == m_PageSize )
		return true;

	int wValue = GetValue();	// ߤͤ

	if ( wValue + argPageSize > m_Max ) {
		if ( pRequireValue ) {
			(*pRequireValue) = m_Max - argPageSize;
			if ( (*pRequireValue) < 0 ) (*pRequireValue) = 0;
			return false;	// ľ
		}
	}

	m_PageSize = argPageSize;
	SetResource();
	return true;	// 
}

// Ǿߤ
void CScrollMgr::SetMinChickSize( int argMinChick )
{
	m_MinChickSize = argMinChick;
	SetResource();
}

// ͤ
void CScrollMgr::SetValue( int argValue )
{
	int ac = 0;
	Arg al[2];

	if ( m_Max - m_PageSize < argValue ) argValue = m_Max - m_PageSize;
	if ( m_Min > argValue ) argValue = m_Min;
	XtSetArg( al[ac], XmNvalue, argValue ); ac++;
	XtSetValues( m_Scr, al, ac );
}

// ߤͤ
int CScrollMgr::GetValue() const
{
	int ac = 0;
	Arg al[2];
	int r = 0;

	XtSetArg( al[ac], XmNvalue, &r ); ac++;
	XtGetValues( m_Scr, al, ac );
	return r;
}

// ̤ɽƤ뤫ݤ
bool CScrollMgr::IsManaged() const
{
	if ( NULL == m_Scr ) return false;
	if ( !XtIsManaged( m_Scr ) ) return false;
	if ( !XtIsRealized( m_Scr ) ) return false;
	return true;
}

// ߤͤ־ͤ
void CScrollMgr::SetToMin()
{
	SetValue( m_Min );
}

void CScrollMgr::OnCreate( Widget argWgt, XtPointer user_data )
{

}

void CScrollMgr::OnDecrement( Widget argWgt, XtPointer user_data )
{
	pEventHandler->OnScrValueChange( this, GetValue(), true );
}

void CScrollMgr::OnIncrement( Widget argWgt, XtPointer user_data )
{
	pEventHandler->OnScrValueChange( this, GetValue(), true );
}

void CScrollMgr::OnPageDown( Widget argWgt, XtPointer user_data )
{
	pEventHandler->OnScrValueChange( this, GetValue(), true );
}

void CScrollMgr::OnPageUp( Widget argWgt, XtPointer user_data )
{
	pEventHandler->OnScrValueChange( this, GetValue(), true );
}

void CScrollMgr::OnDrag( Widget argWgt, XtPointer user_data )
{
	pEventHandler->OnScrValueChange( this, GetValue(), true );
}

void CScrollMgr::ToBottom( Widget argWgt, XtPointer user_data )
{
	pEventHandler->OnScrValueChange( this, GetValue(), true );
}

void CScrollMgr::ToTop( Widget argWgt, XtPointer user_data )
{
	pEventHandler->OnScrValueChange( this, GetValue(), true );
}

void CScrollMgr::OnChangeValue( Widget argWgt, XtPointer user_data )
{
}

// åȤͤ
void CScrollMgr::SetResource() const
{
	int ac = 0;
	Arg al[6];

	if ( m_Max - m_Min <= m_PageSize ) {
		XtSetArg( al[ac], XmNsensitive, false ); ac++;
		XtSetArg( al[ac], XmNminimum, -MinPadding ); ac++;
		XtSetArg( al[ac], XmNmaximum, MaxPadding + 1 ); ac++;
		XtSetArg( al[ac], XmNsliderSize, 1 ); ac++;
		XtSetArg( al[ac], XmNincrement, 1 ); ac++;
		XtSetArg( al[ac], XmNvalue, -MinPadding ); ac++;
	}
	else {
		XtSetArg( al[ac], XmNsensitive, true ); ac++;
		XtSetArg( al[ac], XmNminimum, m_Min ); ac++;
		XtSetArg( al[ac], XmNmaximum, m_Max ); ac++;
		XtSetArg( al[ac], XmNsliderSize, m_PageSize ); ac++;
		XtSetArg( al[ac], XmNpageIncrement, m_PageSize ); ac++;
		XtSetArg( al[ac], XmNincrement, m_MinChickSize ); ac++;
	}

	XtSetValues( m_Scr, al, ac );
}

